/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.BlockDataSource;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.EntityDataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.StorageDataSource;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;

public interface Component
extends Message,
FormattedText,
Iterable<Component> {
    default public Stream<Component> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.m_7360_().stream().flatMap(Component::stream)});
    }

    @Override
    default public Iterator<Component> iterator() {
        return this.stream().iterator();
    }

    public Style m_7383_();

    public ComponentContents m_214077_();

    default public String getString() {
        return super.getString();
    }

    default public String m_130668_(int p_130669_) {
        StringBuilder stringbuilder = new StringBuilder();
        this.m_5651_(p_130673_ -> {
            int i = p_130669_ - stringbuilder.length();
            if (i <= 0) {
                return f_130759_;
            }
            stringbuilder.append(p_130673_.length() <= i ? p_130673_ : p_130673_.substring(0, i));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<Component> m_7360_();

    default public MutableComponent m_6879_() {
        return MutableComponent.m_237204_((ComponentContents)this.m_214077_());
    }

    default public MutableComponent m_6881_() {
        return new MutableComponent(this.m_214077_(), new ArrayList<Component>(this.m_7360_()), this.m_7383_());
    }

    public FormattedCharSequence m_7532_();

    default public <T> Optional<T> m_7451_(FormattedText.StyledContentConsumer<T> p_130679_, Style p_130680_) {
        Style style = this.m_7383_().m_131146_(p_130680_);
        Optional optional = this.m_214077_().m_213724_(p_130679_, style);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.m_7360_()) {
            Optional<T> optional1 = component.m_7451_(p_130679_, style);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public <T> Optional<T> m_5651_(FormattedText.ContentConsumer<T> p_130677_) {
        Optional optional = this.m_214077_().m_213874_(p_130677_);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.m_7360_()) {
            Optional<T> optional1 = component.m_5651_(p_130677_);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public List<Component> m_240407_() {
        return this.m_178405_(Style.f_131099_);
    }

    default public List<Component> m_178405_(Style p_178406_) {
        ArrayList list = Lists.newArrayList();
        this.m_7451_((p_178403_, p_178404_) -> {
            if (!p_178404_.isEmpty()) {
                list.add(Component.m_237113_(p_178404_).m_130948_(p_178403_));
            }
            return Optional.empty();
        }, p_178406_);
        return list;
    }

    default public boolean m_240452_(Component p_240571_) {
        List<Component> list1;
        if (this.equals(p_240571_)) {
            return true;
        }
        List<Component> list = this.m_240407_();
        return Collections.indexOfSubList(list, list1 = p_240571_.m_178405_(this.m_7383_())) != -1;
    }

    public static Component m_130674_(@Nullable String p_130675_) {
        return p_130675_ != null ? Component.m_237113_(p_130675_) : CommonComponents.f_237098_;
    }

    public static MutableComponent m_237113_(String p_237114_) {
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(p_237114_));
    }

    public static MutableComponent m_237115_(String p_237116_) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(p_237116_));
    }

    public static MutableComponent m_237110_(String p_237111_, Object ... p_237112_) {
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(p_237111_, p_237112_));
    }

    public static MutableComponent m_237119_() {
        return MutableComponent.m_237204_((ComponentContents)ComponentContents.f_237124_);
    }

    public static MutableComponent m_237117_(String p_237118_) {
        return MutableComponent.m_237204_((ComponentContents)new KeybindContents(p_237118_));
    }

    public static MutableComponent m_237105_(String p_237106_, boolean p_237107_, Optional<Component> p_237108_, DataSource p_237109_) {
        return MutableComponent.m_237204_((ComponentContents)new NbtContents(p_237106_, p_237107_, p_237108_, p_237109_));
    }

    public static MutableComponent m_237099_(String p_237100_, String p_237101_) {
        return MutableComponent.m_237204_((ComponentContents)new ScoreContents(p_237100_, p_237101_));
    }

    public static MutableComponent m_237102_(String p_237103_, Optional<Component> p_237104_) {
        return MutableComponent.m_237204_((ComponentContents)new SelectorContents(p_237103_, p_237104_));
    }

    public static class Serializer
    implements JsonDeserializer<MutableComponent>,
    JsonSerializer<Component> {
        private static final Gson f_130685_ = Util.m_137537_(() -> {
            GsonBuilder gsonbuilder = new GsonBuilder();
            gsonbuilder.disableHtmlEscaping();
            gsonbuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Serializer());
            gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
            return gsonbuilder.create();
        });
        private static final Field f_130686_ = Util.m_137537_(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", nosuchfieldexception);
            }
        });
        private static final Field f_130687_ = Util.m_137537_(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", nosuchfieldexception);
            }
        });

        public MutableComponent deserialize(JsonElement p_130694_, Type p_130695_, JsonDeserializationContext p_130696_) throws JsonParseException {
            MutableComponent mutablecomponent;
            if (p_130694_.isJsonPrimitive()) {
                return Component.m_237113_(p_130694_.getAsString());
            }
            if (!p_130694_.isJsonObject()) {
                if (p_130694_.isJsonArray()) {
                    JsonArray jsonarray1 = p_130694_.getAsJsonArray();
                    MutableComponent mutablecomponent1 = null;
                    for (JsonElement jsonelement : jsonarray1) {
                        MutableComponent mutablecomponent2 = this.deserialize(jsonelement, jsonelement.getClass(), p_130696_);
                        if (mutablecomponent1 == null) {
                            mutablecomponent1 = mutablecomponent2;
                            continue;
                        }
                        mutablecomponent1.m_7220_((Component)mutablecomponent2);
                    }
                    return mutablecomponent1;
                }
                throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
            }
            JsonObject jsonobject = p_130694_.getAsJsonObject();
            if (jsonobject.has("text")) {
                String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"text");
                mutablecomponent = s.isEmpty() ? Component.m_237119_() : Component.m_237113_(s);
            } else if (jsonobject.has("translate")) {
                String s1 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"translate");
                if (jsonobject.has("with")) {
                    JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"with");
                    Object[] aobject = new Object[jsonarray.size()];
                    for (int i = 0; i < aobject.length; ++i) {
                        aobject[i] = Serializer.m_237120_(this.deserialize(jsonarray.get(i), p_130695_, p_130696_));
                    }
                    mutablecomponent = Component.m_237110_(s1, aobject);
                } else {
                    mutablecomponent = Component.m_237115_(s1);
                }
            } else if (jsonobject.has("score")) {
                JsonObject jsonobject1 = GsonHelper.m_13930_((JsonObject)jsonobject, (String)"score");
                if (!jsonobject1.has("name") || !jsonobject1.has("objective")) {
                    throw new JsonParseException("A score component needs a least a name and an objective");
                }
                mutablecomponent = Component.m_237099_(GsonHelper.m_13906_((JsonObject)jsonobject1, (String)"name"), GsonHelper.m_13906_((JsonObject)jsonobject1, (String)"objective"));
            } else if (jsonobject.has("selector")) {
                Optional<Component> optional = this.m_178415_(p_130695_, p_130696_, jsonobject);
                mutablecomponent = Component.m_237102_(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"selector"), optional);
            } else if (jsonobject.has("keybind")) {
                mutablecomponent = Component.m_237117_(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"keybind"));
            } else {
                BlockDataSource datasource;
                if (!jsonobject.has("nbt")) {
                    throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
                }
                String s2 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"nbt");
                Optional<Component> optional1 = this.m_178415_(p_130695_, p_130696_, jsonobject);
                boolean flag = GsonHelper.m_13855_((JsonObject)jsonobject, (String)"interpret", (boolean)false);
                if (jsonobject.has("block")) {
                    datasource = new BlockDataSource(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"block"));
                } else if (jsonobject.has("entity")) {
                    datasource = new EntityDataSource(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"entity"));
                } else {
                    if (!jsonobject.has("storage")) {
                        throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
                    }
                    datasource = new StorageDataSource(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"storage")));
                }
                mutablecomponent = Component.m_237105_(s2, flag, optional1, (DataSource)datasource);
            }
            if (jsonobject.has("extra")) {
                JsonArray jsonarray2 = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"extra");
                if (jsonarray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                for (int j = 0; j < jsonarray2.size(); ++j) {
                    mutablecomponent.m_7220_((Component)this.deserialize(jsonarray2.get(j), p_130695_, p_130696_));
                }
            }
            mutablecomponent.m_6270_((Style)p_130696_.deserialize(p_130694_, Style.class));
            return mutablecomponent;
        }

        private static Object m_237120_(Object p_237121_) {
            ComponentContents componentcontents;
            Component component;
            if (p_237121_ instanceof Component && (component = (Component)p_237121_).m_7383_().m_131179_() && component.m_7360_().isEmpty() && (componentcontents = component.m_214077_()) instanceof LiteralContents) {
                LiteralContents literalcontents = (LiteralContents)componentcontents;
                return literalcontents.f_237368_();
            }
            return p_237121_;
        }

        private Optional<Component> m_178415_(Type p_178416_, JsonDeserializationContext p_178417_, JsonObject p_178418_) {
            return p_178418_.has("separator") ? Optional.of(this.deserialize(p_178418_.get("separator"), p_178416_, p_178417_)) : Optional.empty();
        }

        private void m_130709_(Style p_130710_, JsonObject p_130711_, JsonSerializationContext p_130712_) {
            JsonElement jsonelement = p_130712_.serialize((Object)p_130710_);
            if (jsonelement.isJsonObject()) {
                JsonObject jsonobject = (JsonObject)jsonelement;
                for (Map.Entry entry : jsonobject.entrySet()) {
                    p_130711_.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public JsonElement serialize(Component p_130706_, Type p_130707_, JsonSerializationContext p_130708_) {
            ComponentContents componentcontents;
            JsonObject jsonobject = new JsonObject();
            if (!p_130706_.m_7383_().m_131179_()) {
                this.m_130709_(p_130706_.m_7383_(), jsonobject, p_130708_);
            }
            if (!p_130706_.m_7360_().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Component component : p_130706_.m_7360_()) {
                    jsonarray.add(this.serialize(component, (Type)((Object)Component.class), p_130708_));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if ((componentcontents = p_130706_.m_214077_()) == ComponentContents.f_237124_) {
                jsonobject.addProperty("text", "");
            } else if (componentcontents instanceof LiteralContents) {
                LiteralContents literalcontents = (LiteralContents)componentcontents;
                jsonobject.addProperty("text", literalcontents.f_237368_());
            } else if (componentcontents instanceof TranslatableContents) {
                TranslatableContents translatablecontents = (TranslatableContents)componentcontents;
                jsonobject.addProperty("translate", translatablecontents.m_237508_());
                if (translatablecontents.m_237523_().length > 0) {
                    JsonArray jsonarray1 = new JsonArray();
                    for (Object object : translatablecontents.m_237523_()) {
                        if (object instanceof Component) {
                            jsonarray1.add(this.serialize((Component)object, object.getClass(), p_130708_));
                            continue;
                        }
                        jsonarray1.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                    }
                    jsonobject.add("with", (JsonElement)jsonarray1);
                }
            } else if (componentcontents instanceof ScoreContents) {
                ScoreContents scorecontents = (ScoreContents)componentcontents;
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("name", scorecontents.m_237440_());
                jsonobject1.addProperty("objective", scorecontents.m_237453_());
                jsonobject.add("score", (JsonElement)jsonobject1);
            } else if (componentcontents instanceof SelectorContents) {
                SelectorContents selectorcontents = (SelectorContents)componentcontents;
                jsonobject.addProperty("selector", selectorcontents.m_237466_());
                this.m_178411_(p_130708_, jsonobject, selectorcontents.m_237479_());
            } else if (componentcontents instanceof KeybindContents) {
                KeybindContents keybindcontents = (KeybindContents)componentcontents;
                jsonobject.addProperty("keybind", keybindcontents.m_237348_());
            } else {
                if (!(componentcontents instanceof NbtContents)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                }
                NbtContents nbtcontents = (NbtContents)componentcontents;
                jsonobject.addProperty("nbt", nbtcontents.m_237399_());
                jsonobject.addProperty("interpret", Boolean.valueOf(nbtcontents.m_237426_()));
                this.m_178411_(p_130708_, jsonobject, nbtcontents.m_237427_());
                DataSource datasource = nbtcontents.m_237428_();
                if (datasource instanceof BlockDataSource) {
                    BlockDataSource blockdatasource = (BlockDataSource)datasource;
                    jsonobject.addProperty("block", blockdatasource.f_237309_());
                } else if (datasource instanceof EntityDataSource) {
                    EntityDataSource entitydatasource = (EntityDataSource)datasource;
                    jsonobject.addProperty("entity", entitydatasource.f_237327_());
                } else {
                    if (!(datasource instanceof StorageDataSource)) {
                        throw new IllegalArgumentException("Don't know how to serialize " + componentcontents + " as a Component");
                    }
                    StorageDataSource storagedatasource = (StorageDataSource)datasource;
                    jsonobject.addProperty("storage", storagedatasource.f_237484_().toString());
                }
            }
            return jsonobject;
        }

        private void m_178411_(JsonSerializationContext p_178412_, JsonObject p_178413_, Optional<Component> p_178414_) {
            p_178414_.ifPresent(p_178410_ -> p_178413_.add("separator", this.serialize((Component)p_178410_, (Type)p_178410_.getClass(), p_178412_)));
        }

        public static String m_130703_(Component p_130704_) {
            return f_130685_.toJson((Object)p_130704_);
        }

        public static String m_237122_(Component p_237123_) {
            return GsonHelper.m_216216_((JsonElement)Serializer.m_130716_(p_237123_));
        }

        public static JsonElement m_130716_(Component p_130717_) {
            return f_130685_.toJsonTree((Object)p_130717_);
        }

        @Nullable
        public static MutableComponent m_130701_(String p_130702_) {
            return (MutableComponent)GsonHelper.m_13798_((Gson)f_130685_, (String)p_130702_, MutableComponent.class, (boolean)false);
        }

        @Nullable
        public static MutableComponent m_130691_(JsonElement p_130692_) {
            return (MutableComponent)f_130685_.fromJson(p_130692_, MutableComponent.class);
        }

        @Nullable
        public static MutableComponent m_130714_(String p_130715_) {
            return (MutableComponent)GsonHelper.m_13798_((Gson)f_130685_, (String)p_130715_, MutableComponent.class, (boolean)true);
        }

        public static MutableComponent m_130699_(com.mojang.brigadier.StringReader p_130700_) {
            try {
                JsonReader jsonreader = new JsonReader((Reader)new StringReader(p_130700_.getRemaining()));
                jsonreader.setLenient(false);
                MutableComponent mutablecomponent = (MutableComponent)f_130685_.getAdapter(MutableComponent.class).read(jsonreader);
                p_130700_.setCursor(p_130700_.getCursor() + Serializer.m_130697_(jsonreader));
                return mutablecomponent;
            }
            catch (IOException | StackOverflowError ioexception) {
                throw new JsonParseException(ioexception);
            }
        }

        private static int m_130697_(JsonReader p_130698_) {
            try {
                return f_130686_.getInt(p_130698_) - f_130687_.getInt(p_130698_) + 1;
            }
            catch (IllegalAccessException illegalaccessexception) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalaccessexception);
            }
        }
    }
}

