/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaHopperItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.ItemStack;

public class HopperBlockEntity
extends RandomizableContainerBlockEntity
implements Hopper {
    public static final int f_155547_ = 8;
    public static final int f_155548_ = 5;
    private NonNullList<net.minecraft.world.item.ItemStack> f_59301_ = NonNullList.m_122780_((int)5, (Object)((Object)net.minecraft.world.item.ItemStack.f_41583_));
    private int f_59302_ = -1;
    private long f_59303_;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;

    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.f_59301_;
    }

    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    public int m_6893_() {
        return this.maxStack;
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public HopperBlockEntity(BlockPos p_155550_, BlockState p_155551_) {
        super(BlockEntityType.f_58933_, p_155550_, p_155551_);
    }

    public void m_142466_(CompoundTag p_155588_) {
        super.m_142466_(p_155588_);
        this.f_59301_ = NonNullList.m_122780_((int)this.m_6643_(), (Object)((Object)net.minecraft.world.item.ItemStack.f_41583_));
        if (!this.m_59631_(p_155588_)) {
            ContainerHelper.m_18980_((CompoundTag)p_155588_, this.f_59301_);
        }
        this.f_59302_ = p_155588_.m_128451_("TransferCooldown");
    }

    protected void m_183515_(CompoundTag p_187502_) {
        super.m_183515_(p_187502_);
        if (!this.m_59634_(p_187502_)) {
            ContainerHelper.m_18973_((CompoundTag)p_187502_, this.f_59301_);
        }
        p_187502_.m_128405_("TransferCooldown", this.f_59302_);
    }

    public int m_6643_() {
        return this.f_59301_.size();
    }

    public net.minecraft.world.item.ItemStack m_7407_(int p_59309_, int p_59310_) {
        this.m_59640_(null);
        return ContainerHelper.m_18969_(this.m_7086_(), (int)p_59309_, (int)p_59310_);
    }

    public void m_6836_(int p_59315_, net.minecraft.world.item.ItemStack p_59316_) {
        this.m_59640_(null);
        this.m_7086_().set(p_59315_, (Object)p_59316_);
        if (p_59316_.m_41613_() > this.m_6893_()) {
            p_59316_.m_41764_(this.m_6893_());
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_("container.hopper");
    }

    public static void m_155573_(Level p_155574_, BlockPos p_155575_, BlockState p_155576_, HopperBlockEntity p_155577_) {
        --p_155577_.f_59302_;
        p_155577_.f_59303_ = p_155574_.m_46467_();
        if (!p_155577_.m_59407_()) {
            p_155577_.m_59395_(0);
            HopperBlockEntity.m_155578_(p_155574_, p_155575_, p_155576_, p_155577_, () -> HopperBlockEntity.m_155552_(p_155574_, p_155577_));
        }
    }

    private static boolean m_155578_(Level p_155579_, BlockPos p_155580_, BlockState p_155581_, HopperBlockEntity p_155582_, BooleanSupplier p_155583_) {
        if (p_155579_.f_46443_) {
            return false;
        }
        if (!p_155582_.m_59407_() && ((Boolean)p_155581_.m_61143_((Property)HopperBlock.f_54022_)).booleanValue()) {
            boolean flag = false;
            if (!p_155582_.m_7983_()) {
                flag = HopperBlockEntity.ejectItems(p_155579_, p_155580_, p_155581_, p_155582_);
            }
            if (!p_155582_.m_59404_()) {
                flag |= p_155583_.getAsBoolean();
            }
            if (flag) {
                p_155582_.m_59395_(8);
                HopperBlockEntity.m_155232_((Level)p_155579_, (BlockPos)p_155580_, (BlockState)p_155581_);
                return true;
            }
        }
        return false;
    }

    private boolean m_59404_() {
        for (net.minecraft.world.item.ItemStack itemstack : this.f_59301_) {
            if (!itemstack.m_41619_() && itemstack.m_41613_() == itemstack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private static boolean ejectItems(Level p_155563_, BlockPos p_155564_, BlockState p_155565_, HopperBlockEntity p_155566_) {
        if (VanillaInventoryCodeHooks.insertHook((HopperBlockEntity)p_155566_)) {
            return true;
        }
        Container container = HopperBlockEntity.m_155592_(p_155563_, p_155564_, p_155565_);
        if (container == null) {
            return false;
        }
        Direction direction = ((Direction)p_155565_.m_61143_((Property)HopperBlock.f_54021_)).m_122424_();
        if (HopperBlockEntity.m_59385_(container, direction)) {
            return false;
        }
        for (int i = 0; i < p_155566_.m_6643_(); ++i) {
            if (p_155566_.m_8020_(i).m_41619_()) continue;
            net.minecraft.world.item.ItemStack itemstack = p_155566_.m_8020_(i).m_41777_();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)p_155566_.m_7407_(i, 1));
            Object destinationInventory = container instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)container) : container.getOwner().getInventory();
            InventoryMoveItemEvent event = new InventoryMoveItemEvent(p_155566_.getOwner().getInventory(), (ItemStack)oitemstack.clone(), destinationInventory, true);
            p_155563_.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                p_155566_.m_6836_(i, itemstack);
                p_155566_.m_59395_(8);
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = HopperBlockEntity.m_59326_((Container)((Object)p_155566_), container, CraftItemStack.asNMSCopy((ItemStack)event.getItem()), direction);
            if (itemstack1.m_41619_()) {
                container.m_6596_();
                return true;
            }
            p_155566_.m_6836_(i, itemstack);
        }
        return false;
    }

    private static IntStream m_59339_(Container p_59340_, Direction p_59341_) {
        return p_59340_ instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)p_59340_).m_7071_(p_59341_)) : IntStream.range(0, p_59340_.m_6643_());
    }

    private static boolean m_59385_(Container p_59386_, Direction p_59387_) {
        return HopperBlockEntity.m_59339_(p_59386_, p_59387_).allMatch(p_59379_ -> {
            net.minecraft.world.item.ItemStack itemstack = p_59386_.m_8020_(p_59379_);
            return itemstack.m_41613_() >= itemstack.m_41741_();
        });
    }

    private static boolean m_59397_(Container p_59398_, Direction p_59399_) {
        return HopperBlockEntity.m_59339_(p_59398_, p_59399_).allMatch(p_59319_ -> p_59398_.m_8020_(p_59319_).m_41619_());
    }

    public static boolean m_155552_(Level p_155553_, Hopper p_155554_) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((Level)p_155553_, (Hopper)p_155554_);
        if (ret != null) {
            return ret;
        }
        Container container = HopperBlockEntity.m_155596_(p_155553_, p_155554_);
        if (container != null) {
            Direction direction = Direction.DOWN;
            return HopperBlockEntity.m_59397_(container, direction) ? false : HopperBlockEntity.m_59339_(container, direction).anyMatch(p_59363_ -> HopperBlockEntity.m_59354_(p_155554_, container, p_59363_, direction));
        }
        for (ItemEntity itementity : HopperBlockEntity.m_155589_(p_155553_, p_155554_)) {
            if (!HopperBlockEntity.m_59331_((Container)p_155554_, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean m_59354_(Hopper p_59355_, Container p_59356_, int p_59357_, Direction p_59358_) {
        net.minecraft.world.item.ItemStack itemstack = p_59356_.m_8020_(p_59357_);
        if (!itemstack.m_41619_() && HopperBlockEntity.m_59380_(p_59356_, itemstack, p_59357_, p_59358_)) {
            net.minecraft.world.item.ItemStack itemstack1 = itemstack.m_41777_();
            CraftItemStack oitemstack = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)p_59356_.m_7407_(p_59357_, 1));
            Object sourceInventory = p_59356_ instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)p_59356_) : p_59356_.getOwner().getInventory();
            InventoryMoveItemEvent event = new InventoryMoveItemEvent(sourceInventory, (ItemStack)oitemstack.clone(), p_59355_.getOwner().getInventory(), false);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                p_59356_.m_6836_(p_59357_, itemstack1);
                if (p_59355_ instanceof HopperBlockEntity) {
                    ((HopperBlockEntity)p_59355_).m_59395_(8);
                } else if (p_59355_ instanceof MinecartHopper) {
                    ((MinecartHopper)p_59355_).m_38610_(4);
                }
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack2 = HopperBlockEntity.m_59326_(p_59356_, (Container)p_59355_, CraftItemStack.asNMSCopy((ItemStack)event.getItem()), null);
            if (itemstack2.m_41619_()) {
                p_59356_.m_6596_();
                return true;
            }
            p_59356_.m_6836_(p_59357_, itemstack1);
        }
        return false;
    }

    public static boolean m_59331_(Container p_59332_, ItemEntity p_59333_) {
        boolean flag = false;
        InventoryPickupItemEvent event = new InventoryPickupItemEvent(p_59332_.getOwner().getInventory(), (Item)p_59333_.getBukkitEntity());
        p_59333_.f_19853_.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = p_59333_.m_32055_().m_41777_();
        net.minecraft.world.item.ItemStack itemstack1 = HopperBlockEntity.m_59326_(null, p_59332_, itemstack, null);
        if (itemstack1.m_41619_()) {
            flag = true;
            p_59333_.m_146870_();
        } else {
            p_59333_.m_32045_(itemstack1);
        }
        return flag;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static net.minecraft.world.item.ItemStack m_59326_(@Nullable Container p_59327_, Container p_59328_, net.minecraft.world.item.ItemStack p_59329_, @Nullable Direction p_59330_) {
        if (p_59328_ instanceof WorldlyContainer) {
            WorldlyContainer worldlycontainer = (WorldlyContainer)p_59328_;
            if (p_59330_ != null) {
                int[] aint = worldlycontainer.m_7071_(p_59330_);
                int k = 0;
                while (k < aint.length) {
                    if (p_59329_.m_41619_()) return p_59329_;
                    p_59329_ = HopperBlockEntity.m_59320_(p_59327_, p_59328_, p_59329_, aint[k], p_59330_);
                    ++k;
                }
                return p_59329_;
            }
        }
        int i = p_59328_.m_6643_();
        int j = 0;
        while (j < i) {
            if (p_59329_.m_41619_()) return p_59329_;
            p_59329_ = HopperBlockEntity.m_59320_(p_59327_, p_59328_, p_59329_, j, p_59330_);
            ++j;
        }
        return p_59329_;
    }

    private static boolean m_59334_(Container p_59335_, net.minecraft.world.item.ItemStack p_59336_, int p_59337_, @Nullable Direction p_59338_) {
        if (!p_59335_.m_7013_(p_59337_, p_59336_)) {
            return false;
        }
        return !(p_59335_ instanceof WorldlyContainer) || ((WorldlyContainer)p_59335_).m_7155_(p_59337_, p_59336_, p_59338_);
    }

    private static boolean m_59380_(Container p_59381_, net.minecraft.world.item.ItemStack p_59382_, int p_59383_, Direction p_59384_) {
        return !(p_59381_ instanceof WorldlyContainer) || ((WorldlyContainer)p_59381_).m_7157_(p_59383_, p_59382_, p_59384_);
    }

    private static net.minecraft.world.item.ItemStack m_59320_(@Nullable Container p_59321_, Container p_59322_, net.minecraft.world.item.ItemStack p_59323_, int p_59324_, @Nullable Direction p_59325_) {
        net.minecraft.world.item.ItemStack itemstack = p_59322_.m_8020_(p_59324_);
        if (HopperBlockEntity.m_59334_(p_59322_, p_59323_, p_59324_, p_59325_)) {
            boolean flag = false;
            boolean flag1 = p_59322_.m_7983_();
            if (itemstack.m_41619_()) {
                p_59322_.m_6836_(p_59324_, p_59323_);
                p_59323_ = net.minecraft.world.item.ItemStack.f_41583_;
                flag = true;
            } else if (HopperBlockEntity.m_59344_(itemstack, p_59323_)) {
                int i = p_59323_.m_41741_() - itemstack.m_41613_();
                int j = Math.min(p_59323_.m_41613_(), i);
                p_59323_.m_41774_(j);
                itemstack.m_41769_(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                HopperBlockEntity hopperblockentity1;
                if (flag1 && p_59322_ instanceof HopperBlockEntity && !(hopperblockentity1 = (HopperBlockEntity)((Object)p_59322_)).m_59409_()) {
                    int k = 0;
                    if (p_59321_ instanceof HopperBlockEntity) {
                        HopperBlockEntity hopperblockentity = (HopperBlockEntity)((Object)p_59321_);
                        if (hopperblockentity1.f_59303_ >= hopperblockentity.f_59303_) {
                            k = 1;
                        }
                    }
                    hopperblockentity1.m_59395_(8 - k);
                }
                p_59322_.m_6596_();
            }
        }
        return p_59323_;
    }

    @Nullable
    private static Container m_155592_(Level p_155593_, BlockPos p_155594_, BlockState p_155595_) {
        Direction direction = (Direction)p_155595_.m_61143_((Property)HopperBlock.f_54021_);
        return HopperBlockEntity.m_59390_(p_155593_, p_155594_.m_121945_(direction));
    }

    @Nullable
    private static Container m_155596_(Level p_155597_, Hopper p_155598_) {
        return HopperBlockEntity.m_59347_(p_155597_, p_155598_.m_6343_(), p_155598_.m_6358_() + 1.0, p_155598_.m_6446_());
    }

    public static List<ItemEntity> m_155589_(Level p_155590_, Hopper p_155591_) {
        return p_155591_.m_59300_().m_83299_().stream().flatMap(p_155558_ -> p_155590_.m_6443_(ItemEntity.class, p_155558_.m_82386_(p_155591_.m_6343_() - 0.5, p_155591_.m_6358_() - 0.5, p_155591_.m_6446_() - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static Container m_59390_(Level p_59391_, BlockPos p_59392_) {
        return HopperBlockEntity.m_59347_(p_59391_, (double)p_59392_.m_123341_() + 0.5, (double)p_59392_.m_123342_() + 0.5, (double)p_59392_.m_123343_() + 0.5);
    }

    @Nullable
    private static Container m_59347_(Level p_59348_, double p_59349_, double p_59350_, double p_59351_) {
        List<Entity> list;
        BlockEntity blockentity;
        Object container = null;
        BlockPos blockpos = new BlockPos(p_59349_, p_59350_, p_59351_);
        BlockState blockstate = p_59348_.m_8055_(blockpos);
        Block block = blockstate.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            container = ((WorldlyContainerHolder)block).m_5840_(blockstate, (LevelAccessor)p_59348_, blockpos);
        } else if (blockstate.m_155947_() && (blockentity = p_59348_.m_7702_(blockpos)) instanceof Container && (container = (Container)((Object)blockentity)) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            container = ChestBlock.m_51511_((ChestBlock)((Object)block), blockstate, p_59348_, blockpos, true);
        }
        if (container == null && !(list = p_59348_.m_6249_(null, new AABB(p_59349_ - 0.5, p_59350_ - 0.5, p_59351_ - 0.5, p_59349_ + 0.5, p_59350_ + 0.5, p_59351_ + 0.5), EntitySelector.f_20405_)).isEmpty()) {
            container = (Container)((Object)list.get(p_59348_.f_46441_.m_188503_(list.size())));
        }
        return container;
    }

    private static boolean m_59344_(net.minecraft.world.item.ItemStack p_59345_, net.minecraft.world.item.ItemStack p_59346_) {
        if (!p_59345_.m_150930_(p_59346_.m_41720_())) {
            return false;
        }
        if (p_59345_.m_41773_() != p_59346_.m_41773_()) {
            return false;
        }
        if (p_59345_.m_41613_() > p_59345_.m_41741_()) {
            return false;
        }
        return net.minecraft.world.item.ItemStack.m_41658_(p_59345_, p_59346_);
    }

    public double m_6343_() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    public double m_6358_() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    public double m_6446_() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public void m_59395_(int p_59396_) {
        this.f_59302_ = p_59396_;
    }

    private boolean m_59407_() {
        return this.f_59302_ > 0;
    }

    public boolean m_59409_() {
        return this.f_59302_ > 8;
    }

    protected NonNullList<net.minecraft.world.item.ItemStack> m_7086_() {
        return this.f_59301_;
    }

    protected void m_6520_(NonNullList<net.minecraft.world.item.ItemStack> p_59371_) {
        this.f_59301_ = p_59371_;
    }

    public static void m_155567_(Level p_155568_, BlockPos p_155569_, BlockState p_155570_, Entity p_155571_, HopperBlockEntity p_155572_) {
        if (p_155571_ instanceof ItemEntity && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)p_155571_.m_20191_().m_82386_((double)(-p_155569_.m_123341_()), (double)(-p_155569_.m_123342_()), (double)(-p_155569_.m_123343_()))), (VoxelShape)p_155572_.m_59300_(), (BooleanOp)BooleanOp.f_82689_)) {
            HopperBlockEntity.m_155578_(p_155568_, p_155569_, p_155570_, p_155572_, () -> HopperBlockEntity.m_59331_((Container)((Object)p_155572_), (ItemEntity)p_155571_));
        }
    }

    protected AbstractContainerMenu m_6555_(int p_59312_, Inventory p_59313_) {
        return new HopperMenu(p_59312_, p_59313_, (Container)((Object)this));
    }

    protected IItemHandler createUnSidedHandler() {
        return new VanillaHopperItemHandler(this);
    }

    public long getLastUpdateTime() {
        return this.f_59303_;
    }
}

