/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;

public class ChunkSerializer {
    public static final Codec<PalettedContainer<BlockState>> f_188227_ = PalettedContainer.m_238371_(Block.f_49791_, BlockState.f_61039_, PalettedContainer.Strategy.f_188137_, Blocks.f_50016_.m_49966_());
    private static final Logger f_63449_ = LogUtils.getLogger();
    private static final String f_156511_ = "UpgradeData";
    private static final String f_188228_ = "block_ticks";
    private static final String f_188229_ = "fluid_ticks";
    public static final String f_223441_ = "xPos";
    public static final String f_223442_ = "zPos";
    public static final String f_223443_ = "Heightmaps";
    public static final String f_223444_ = "isLightOn";
    public static final String f_223445_ = "sections";
    public static final String f_223446_ = "BlockLight";
    public static final String f_223447_ = "SkyLight";

    public static ProtoChunk m_188230_(ServerLevel p_188231_, PoiManager p_188232_, ChunkPos p_188233_, CompoundTag p_188234_) {
        ChunkAccess chunkaccess;
        ChunkPos chunkpos = new ChunkPos(p_188234_.m_128451_(f_223441_), p_188234_.m_128451_(f_223442_));
        if (!Objects.equals(p_188233_, chunkpos)) {
            f_63449_.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{p_188233_, p_188233_, chunkpos});
        }
        UpgradeData upgradedata = p_188234_.m_128425_(f_156511_, 10) ? new UpgradeData(p_188234_.m_128469_(f_156511_), (LevelHeightAccessor)p_188231_) : UpgradeData.f_63320_;
        boolean flag = p_188234_.m_128471_(f_223444_);
        ListTag listtag = p_188234_.m_128437_(f_223445_, 10);
        int i = p_188231_.m_151559_();
        LevelChunkSection[] alevelchunksection = new LevelChunkSection[i];
        boolean flag1 = p_188231_.m_6042_().f_223549_();
        ServerChunkCache chunksource = p_188231_.m_7726_();
        LevelLightEngine levellightengine = chunksource.m_7827_();
        Registry registry = p_188231_.m_8891_().m_175515_(Registries.f_256952_);
        Codec<PalettedContainerRO<Holder<Biome>>> codec = ChunkSerializer.m_188260_((Registry<Biome>)registry);
        boolean flag2 = false;
        for (int j = 0; j < listtag.size(); ++j) {
            boolean flag5;
            CompoundTag compoundtag = listtag.m_128728_(j);
            byte k = compoundtag.m_128445_("Y");
            int l = p_188231_.m_151566_(k);
            if (l >= 0 && l < alevelchunksection.length) {
                LevelChunkSection levelchunksection;
                PalettedContainer palettedcontainer = compoundtag.m_128425_("block_states", 10) ? (PalettedContainer)f_188227_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundtag.m_128469_("block_states")).promotePartial(p_188283_ -> ChunkSerializer.m_188239_(p_188233_, k, p_188283_)).getOrThrow(false, arg_0 -> ((Logger)f_63449_).error(arg_0)) : new PalettedContainer(Block.f_49791_, Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
                PalettedContainer palettedcontainerro = compoundtag.m_128425_("biomes", 10) ? (PalettedContainer)codec.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundtag.m_128469_("biomes")).promotePartial(p_188274_ -> ChunkSerializer.m_188239_(p_188233_, k, p_188274_)).getOrThrow(false, arg_0 -> ((Logger)f_63449_).error(arg_0)) : new PalettedContainer(registry.m_206115_(), registry.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_);
                alevelchunksection[l] = levelchunksection = new LevelChunkSection(k, palettedcontainer, palettedcontainerro);
                p_188232_.m_27047_(p_188233_, levelchunksection);
            }
            boolean flag4 = compoundtag.m_128425_(f_223446_, 7);
            boolean bl = flag5 = flag1 && compoundtag.m_128425_(f_223447_, 7);
            if (!flag4 && !flag5) continue;
            if (!flag2) {
                levellightengine.m_6462_(p_188233_, true);
                flag2 = true;
            }
            if (flag4) {
                levellightengine.m_5687_(LightLayer.BLOCK, SectionPos.m_123196_((ChunkPos)p_188233_, (int)k), new DataLayer(compoundtag.m_128463_(f_223446_)), true);
            }
            if (!flag5) continue;
            levellightengine.m_5687_(LightLayer.SKY, SectionPos.m_123196_((ChunkPos)p_188233_, (int)k), new DataLayer(compoundtag.m_128463_(f_223447_)), true);
        }
        long j1 = p_188234_.m_128454_("InhabitedTime");
        ChunkStatus.ChunkType chunkstatus$chunktype = ChunkSerializer.m_63485_(p_188234_);
        BlendingData blendingdata = p_188234_.m_128425_("blending_data", 10) ? BlendingData.f_190254_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_188234_.m_128469_("blending_data"))).resultOrPartial(arg_0 -> ((Logger)f_63449_).error(arg_0)).orElse(null) : null;
        if (chunkstatus$chunktype == ChunkStatus.ChunkType.LEVELCHUNK) {
            LevelChunkTicks levelchunkticks = LevelChunkTicks.m_193185_((ListTag)p_188234_.m_128437_(f_188228_, 10), p_258988_ -> BuiltInRegistries.f_256975_.m_6612_(ResourceLocation.m_135820_(p_258988_)), (ChunkPos)p_188233_);
            LevelChunkTicks levelchunkticks1 = LevelChunkTicks.m_193185_((ListTag)p_188234_.m_128437_(f_188229_, 10), p_258990_ -> BuiltInRegistries.f_257020_.m_6612_(ResourceLocation.m_135820_(p_258990_)), (ChunkPos)p_188233_);
            chunkaccess = new LevelChunk(p_188231_.m_6018_(), p_188233_, upgradedata, (LevelChunkTicks<Block>)levelchunkticks, (LevelChunkTicks<Fluid>)levelchunkticks1, j1, alevelchunksection, ChunkSerializer.m_196890_(p_188231_, p_188234_), blendingdata);
            if (p_188234_.m_128441_("ForgeCaps")) {
                ((LevelChunk)chunkaccess).readCapsFromNBT(p_188234_.m_128469_("ForgeCaps"));
            }
        } else {
            boolean flag3;
            ProtoChunkTicks protochunkticks = ProtoChunkTicks.m_193302_((ListTag)p_188234_.m_128437_(f_188228_, 10), p_258992_ -> BuiltInRegistries.f_256975_.m_6612_(ResourceLocation.m_135820_(p_258992_)), (ChunkPos)p_188233_);
            ProtoChunkTicks protochunkticks1 = ProtoChunkTicks.m_193302_((ListTag)p_188234_.m_128437_(f_188229_, 10), p_258991_ -> BuiltInRegistries.f_257020_.m_6612_(ResourceLocation.m_135820_(p_258991_)), (ChunkPos)p_188233_);
            ProtoChunk protochunk = new ProtoChunk(p_188233_, upgradedata, alevelchunksection, (ProtoChunkTicks<Block>)protochunkticks, (ProtoChunkTicks<Fluid>)protochunkticks1, p_188231_, (Registry<Biome>)registry, blendingdata);
            chunkaccess = protochunk;
            protochunk.m_6141_(j1);
            if (p_188234_.m_128425_("below_zero_retrogen", 10)) {
                BelowZeroRetrogen.f_188455_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_188234_.m_128469_("below_zero_retrogen"))).resultOrPartial(arg_0 -> ((Logger)f_63449_).error(arg_0)).ifPresent(protochunk::m_188183_);
            }
            ChunkStatus chunkstatus = ChunkStatus.m_62397_((String)p_188234_.m_128461_("Status"));
            protochunk.m_7150_(chunkstatus);
            if (chunkstatus.m_62427_(ChunkStatus.f_62322_)) {
                protochunk.m_63209_(levellightengine);
            }
            BelowZeroRetrogen belowzeroretrogen = protochunk.m_183376_();
            boolean bl = flag3 = chunkstatus.m_62427_(ChunkStatus.f_62323_) || belowzeroretrogen != null && belowzeroretrogen.m_188466_().m_62427_(ChunkStatus.f_62323_);
            if (!flag && flag3) {
                for (BlockPos blockpos : BlockPos.m_121976_((int)p_188233_.m_45604_(), (int)p_188231_.m_141937_(), (int)p_188233_.m_45605_(), (int)p_188233_.m_45608_(), (int)(p_188231_.m_151558_() - 1), (int)p_188233_.m_45609_())) {
                    if (chunkaccess.m_8055_(blockpos).getLightEmission(chunkaccess, blockpos) == 0) continue;
                    protochunk.m_63277_(blockpos);
                }
            }
        }
        chunkaccess.m_8094_(flag);
        CompoundTag compoundtag2 = p_188234_.m_128469_(f_223443_);
        EnumSet<Heightmap.Types> enumset = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types heightmap$types : chunkaccess.m_6415_().m_62500_()) {
            String s = heightmap$types.m_64294_();
            if (compoundtag2.m_128425_(s, 12)) {
                chunkaccess.m_6511_(heightmap$types, compoundtag2.m_128467_(s));
                continue;
            }
            enumset.add(heightmap$types);
        }
        Heightmap.m_64256_((ChunkAccess)chunkaccess, enumset);
        CompoundTag compoundtag3 = p_188234_.m_128469_("structures");
        chunkaccess.m_8040_(ChunkSerializer.m_188254_(StructurePieceSerializationContext.m_192770_((ServerLevel)p_188231_), compoundtag3, p_188231_.m_7328_()));
        chunkaccess.m_62737_(ChunkSerializer.m_208154_(p_188231_.m_8891_(), p_188233_, compoundtag3));
        if (p_188234_.m_128471_("shouldSave")) {
            chunkaccess.m_8092_(true);
        }
        ListTag listtag2 = p_188234_.m_128437_("PostProcessing", 9);
        for (int k1 = 0; k1 < listtag2.size(); ++k1) {
            ListTag listtag3 = listtag2.m_128744_(k1);
            for (int l1 = 0; l1 < listtag3.size(); ++l1) {
                chunkaccess.m_6561_(listtag3.m_128757_(l1), k1);
            }
        }
        if (chunkstatus$chunktype == ChunkStatus.ChunkType.LEVELCHUNK) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load(chunkaccess, p_188234_, chunkstatus$chunktype));
            return new ImposterProtoChunk((LevelChunk)chunkaccess, false);
        }
        ProtoChunk protochunk1 = (ProtoChunk)chunkaccess;
        ListTag listtag4 = p_188234_.m_128437_("entities", 10);
        for (int i2 = 0; i2 < listtag4.size(); ++i2) {
            protochunk1.m_63242_(listtag4.m_128728_(i2));
        }
        ListTag listtag5 = p_188234_.m_128437_("block_entities", 10);
        for (int j2 = 0; j2 < listtag5.size(); ++j2) {
            CompoundTag compoundtag1 = listtag5.m_128728_(j2);
            chunkaccess.m_5604_(compoundtag1);
        }
        ListTag listtag6 = p_188234_.m_128437_("Lights", 9);
        for (int k2 = 0; k2 < listtag6.size(); ++k2) {
            LevelChunkSection levelchunksection1 = alevelchunksection[k2];
            if (levelchunksection1 == null || levelchunksection1.m_188008_()) continue;
            ListTag listtag1 = listtag6.m_128744_(k2);
            for (int i1 = 0; i1 < listtag1.size(); ++i1) {
                protochunk1.m_63244_(listtag1.m_128757_(i1), k2);
            }
        }
        CompoundTag compoundtag4 = p_188234_.m_128469_("CarvingMasks");
        for (String s1 : compoundtag4.m_128431_()) {
            GenerationStep.Carving generationstep$carving = GenerationStep.Carving.valueOf((String)s1);
            protochunk1.m_188186_(generationstep$carving, new CarvingMask(compoundtag4.m_128467_(s1), chunkaccess.m_141937_()));
        }
        MinecraftForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load(chunkaccess, p_188234_, chunkstatus$chunktype));
        return protochunk1;
    }

    private static void m_188239_(ChunkPos p_188240_, int p_188241_, String p_188242_) {
        f_63449_.error("Recoverable errors when loading section [" + p_188240_.f_45578_ + ", " + p_188241_ + ", " + p_188240_.f_45579_ + "]: " + p_188242_);
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> m_188260_(Registry<Biome> p_188261_) {
        return PalettedContainer.m_238418_(p_188261_.m_206115_(), p_188261_.m_206110_(), PalettedContainer.Strategy.f_188138_, p_188261_.m_246971_(Biomes.f_48202_));
    }

    public static CompoundTag m_63454_(ServerLevel p_63455_, ChunkAccess p_63456_) {
        UpgradeData upgradedata;
        BelowZeroRetrogen belowzeroretrogen;
        ChunkPos chunkpos = p_63456_.m_7697_();
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128405_("DataVersion", SharedConstants.m_183709_().getWorldVersion());
        compoundtag.m_128405_(f_223441_, chunkpos.f_45578_);
        compoundtag.m_128405_("yPos", p_63456_.m_151560_());
        compoundtag.m_128405_(f_223442_, chunkpos.f_45579_);
        compoundtag.m_128356_("LastUpdate", p_63455_.m_46467_());
        compoundtag.m_128356_("InhabitedTime", p_63456_.m_6319_());
        compoundtag.m_128359_("Status", p_63456_.m_6415_().m_62467_());
        BlendingData blendingdata = p_63456_.m_183407_();
        if (blendingdata != null) {
            BlendingData.f_190254_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)blendingdata).resultOrPartial(arg_0 -> ((Logger)f_63449_).error(arg_0)).ifPresent(p_196909_ -> compoundtag.m_128365_("blending_data", (Tag)p_196909_));
        }
        if ((belowzeroretrogen = p_63456_.m_183376_()) != null) {
            BelowZeroRetrogen.f_188455_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)belowzeroretrogen).resultOrPartial(arg_0 -> ((Logger)f_63449_).error(arg_0)).ifPresent(p_188279_ -> compoundtag.m_128365_("below_zero_retrogen", (Tag)p_188279_));
        }
        if (!(upgradedata = p_63456_.m_7387_()).m_63331_()) {
            compoundtag.m_128365_(f_156511_, upgradedata.m_63346_());
        }
        LevelChunkSection[] alevelchunksection = p_63456_.m_7103_();
        ListTag listtag = new ListTag();
        ThreadedLevelLightEngine levellightengine = p_63455_.m_7726_().m_7827_();
        Registry registry = p_63455_.m_8891_().m_175515_(Registries.f_256952_);
        Codec<PalettedContainerRO<Holder<Biome>>> codec = ChunkSerializer.m_188260_((Registry<Biome>)registry);
        boolean flag = p_63456_.m_6332_();
        for (int i = levellightengine.m_164447_(); i < levellightengine.m_164448_(); ++i) {
            int j = p_63456_.m_151566_(i);
            boolean flag1 = j >= 0 && j < alevelchunksection.length;
            DataLayer datalayer = levellightengine.m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)i));
            DataLayer datalayer1 = levellightengine.m_75814_(LightLayer.SKY).m_8079_(SectionPos.m_123196_((ChunkPos)chunkpos, (int)i));
            if (!flag1 && datalayer == null && datalayer1 == null) continue;
            CompoundTag compoundtag1 = new CompoundTag();
            if (flag1) {
                LevelChunkSection levelchunksection = alevelchunksection[j];
                compoundtag1.m_128365_("block_states", (Tag)f_188227_.encodeStart((DynamicOps)NbtOps.f_128958_, levelchunksection.m_63019_()).getOrThrow(false, arg_0 -> ((Logger)f_63449_).error(arg_0)));
                compoundtag1.m_128365_("biomes", (Tag)codec.encodeStart((DynamicOps)NbtOps.f_128958_, levelchunksection.m_187996_()).getOrThrow(false, arg_0 -> ((Logger)f_63449_).error(arg_0)));
            }
            if (datalayer != null && !datalayer.m_62575_()) {
                compoundtag1.m_128382_(f_223446_, datalayer.m_7877_());
            }
            if (datalayer1 != null && !datalayer1.m_62575_()) {
                compoundtag1.m_128382_(f_223447_, datalayer1.m_7877_());
            }
            if (compoundtag1.m_128456_()) continue;
            compoundtag1.m_128344_("Y", (byte)i);
            listtag.add((Object)compoundtag1);
        }
        compoundtag.m_128365_(f_223445_, (Tag)listtag);
        if (flag) {
            compoundtag.m_128379_(f_223444_, true);
        }
        ListTag listtag1 = new ListTag();
        for (BlockPos blockpos : p_63456_.m_5928_()) {
            CompoundTag compoundtag3 = p_63456_.m_8051_(blockpos);
            if (compoundtag3 == null) continue;
            listtag1.add((Object)compoundtag3);
        }
        compoundtag.m_128365_("block_entities", (Tag)listtag1);
        if (p_63456_.m_6415_().m_62494_() == ChunkStatus.ChunkType.PROTOCHUNK) {
            ProtoChunk protochunk = (ProtoChunk)p_63456_;
            ListTag listtag2 = new ListTag();
            listtag2.addAll(protochunk.m_63293_());
            compoundtag.m_128365_("entities", (Tag)listtag2);
            compoundtag.m_128365_("Lights", (Tag)ChunkSerializer.m_63490_(protochunk.m_63291_()));
            CompoundTag compoundtag4 = new CompoundTag();
            for (GenerationStep.Carving generationstep$carving : GenerationStep.Carving.values()) {
                CarvingMask carvingmask = protochunk.m_183612_(generationstep$carving);
                if (carvingmask == null) continue;
                compoundtag4.m_128388_(generationstep$carving.toString(), carvingmask.m_187584_());
            }
            compoundtag.m_128365_("CarvingMasks", compoundtag4);
        } else {
            LevelChunk levelChunk = (LevelChunk)p_63456_;
            try {
                CompoundTag capTag = levelChunk.writeCapsToNBT();
                if (capTag != null) {
                    compoundtag.m_128365_("ForgeCaps", capTag);
                }
            }
            catch (Exception exception) {
                f_63449_.error("A capability provider has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Throwable)exception);
            }
        }
        ChunkSerializer.m_188235_(p_63455_, compoundtag, p_63456_.m_183568_());
        compoundtag.m_128365_("PostProcessing", (Tag)ChunkSerializer.m_63490_(p_63456_.m_6720_()));
        CompoundTag compoundtag2 = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> entry : p_63456_.m_6890_()) {
            if (!p_63456_.m_6415_().m_62500_().contains(entry.getKey())) continue;
            compoundtag2.m_128365_(entry.getKey().m_64294_(), (Tag)new LongArrayTag(entry.getValue().m_64239_()));
        }
        compoundtag.m_128365_(f_223443_, compoundtag2);
        compoundtag.m_128365_("structures", ChunkSerializer.m_188249_(StructurePieceSerializationContext.m_192770_((ServerLevel)p_63455_), chunkpos, p_63456_.m_6633_(), p_63456_.m_62769_()));
        return compoundtag;
    }

    private static void m_188235_(ServerLevel p_188236_, CompoundTag p_188237_, ChunkAccess.TicksToSave p_188238_) {
        long i = p_188236_.m_6106_().m_6793_();
        p_188237_.m_128365_(f_188228_, p_188238_.f_187680_().m_183237_(i, p_258987_ -> BuiltInRegistries.f_256975_.m_7981_(p_258987_).toString()));
        p_188237_.m_128365_(f_188229_, p_188238_.f_187681_().m_183237_(i, p_258989_ -> BuiltInRegistries.f_257020_.m_7981_(p_258989_).toString()));
    }

    public static ChunkStatus.ChunkType m_63485_(@Nullable CompoundTag p_63486_) {
        return p_63486_ != null ? ChunkStatus.m_62397_((String)p_63486_.m_128461_("Status")).m_62494_() : ChunkStatus.ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor m_196890_(ServerLevel p_196891_, CompoundTag p_196892_) {
        ListTag listtag = ChunkSerializer.m_196897_(p_196892_, "entities");
        ListTag listtag1 = ChunkSerializer.m_196897_(p_196892_, "block_entities");
        return listtag == null && listtag1 == null ? null : p_196904_ -> {
            if (listtag != null) {
                p_196891_.m_143311_(EntityType.m_147045_((List<? extends Tag>)listtag, p_196891_));
            }
            if (listtag1 != null) {
                for (int i = 0; i < listtag1.size(); ++i) {
                    CompoundTag compoundtag = listtag1.m_128728_(i);
                    boolean flag = compoundtag.m_128471_("keepPacked");
                    if (flag) {
                        p_196904_.m_5604_(compoundtag);
                        continue;
                    }
                    BlockPos blockpos = BlockEntity.m_187472_(compoundtag);
                    BlockEntity blockentity = BlockEntity.m_155241_(blockpos, p_196904_.m_8055_(blockpos), compoundtag);
                    if (blockentity == null) continue;
                    p_196904_.m_142169_(blockentity);
                }
            }
        };
    }

    @Nullable
    private static ListTag m_196897_(CompoundTag p_196898_, String p_196899_) {
        ListTag listtag = p_196898_.m_128437_(p_196899_, 10);
        return listtag.isEmpty() ? null : listtag;
    }

    private static CompoundTag m_188249_(StructurePieceSerializationContext p_188250_, ChunkPos p_188251_, Map<Structure, StructureStart> p_188252_, Map<Structure, LongSet> p_188253_) {
        CompoundTag compoundtag = new CompoundTag();
        CompoundTag compoundtag1 = new CompoundTag();
        Registry registry = p_188250_.f_192763_().m_175515_(Registries.f_256944_);
        for (Map.Entry<Structure, StructureStart> entry : p_188252_.entrySet()) {
            ResourceLocation resourcelocation = registry.m_7981_((Object)entry.getKey());
            compoundtag1.m_128365_(resourcelocation.toString(), entry.getValue().m_192660_(p_188250_, p_188251_));
        }
        compoundtag.m_128365_("starts", compoundtag1);
        CompoundTag compoundtag2 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> entry1 : p_188253_.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            ResourceLocation resourcelocation1 = registry.m_7981_((Object)entry1.getKey());
            compoundtag2.m_128365_(resourcelocation1.toString(), (Tag)new LongArrayTag(entry1.getValue()));
        }
        compoundtag.m_128365_("References", compoundtag2);
        return compoundtag;
    }

    private static Map<Structure, StructureStart> m_188254_(StructurePieceSerializationContext p_188255_, CompoundTag p_188256_, long p_188257_) {
        HashMap map = Maps.newHashMap();
        Registry registry = p_188255_.f_192763_().m_175515_(Registries.f_256944_);
        CompoundTag compoundtag = p_188256_.m_128469_("starts");
        for (String s : compoundtag.m_128431_()) {
            ResourceLocation resourcelocation = ResourceLocation.m_135820_(s);
            Structure structure = (Structure)registry.m_7745_(resourcelocation);
            if (structure == null) {
                f_63449_.error("Unknown structure start: {}", (Object)resourcelocation);
                continue;
            }
            StructureStart structurestart = StructureStart.m_226857_(p_188255_, compoundtag.m_128469_(s), p_188257_);
            if (structurestart == null) continue;
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> m_208154_(RegistryAccess p_208155_, ChunkPos p_208156_, CompoundTag p_208157_) {
        HashMap map = Maps.newHashMap();
        Registry registry = p_208155_.m_175515_(Registries.f_256944_);
        CompoundTag compoundtag = p_208157_.m_128469_("References");
        for (String s : compoundtag.m_128431_()) {
            ResourceLocation resourcelocation = ResourceLocation.m_135820_(s);
            Structure structure = (Structure)registry.m_7745_(resourcelocation);
            if (structure == null) {
                f_63449_.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)resourcelocation, (Object)p_208156_);
                continue;
            }
            long[] along = compoundtag.m_128467_(s);
            if (along.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(along).filter(p_208153_ -> {
                ChunkPos chunkpos = new ChunkPos(p_208153_);
                if (chunkpos.m_45594_(p_208156_) > 8) {
                    f_63449_.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{resourcelocation, chunkpos, p_208156_});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    public static ListTag m_63490_(ShortList[] p_63491_) {
        ListTag listtag = new ListTag();
        for (ShortList shortlist : p_63491_) {
            ListTag listtag1 = new ListTag();
            if (shortlist != null) {
                for (Short oshort : shortlist) {
                    listtag1.add((Object)ShortTag.m_129258_((short)oshort));
                }
            }
            listtag.add((Object)listtag1);
        }
        return listtag;
    }
}

