/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_19_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.slf4j.Logger;

public class LootTable {
    static final Logger f_79107_ = LogUtils.getLogger();
    public static final LootTable f_79105_ = new LootTable(LootContextParamSets.f_81410_, new LootPool[0], new LootItemFunction[0]);
    public static final LootContextParamSet f_79106_ = LootContextParamSets.f_81420_;
    final LootContextParamSet f_79108_;
    private final List<LootPool> f_79109_;
    final LootItemFunction[] f_79110_;
    private final BiFunction<ItemStack, LootContext, ItemStack> f_79111_;
    public AtomicBoolean isPlugin = new AtomicBoolean(false);
    private boolean isFrozen = false;
    private ResourceLocation lootTableId;

    LootTable(LootContextParamSet p_79114_, LootPool[] p_79115_, LootItemFunction[] p_79116_) {
        this.f_79108_ = p_79114_;
        this.f_79109_ = Lists.newArrayList((Object[])p_79115_);
        this.f_79110_ = p_79116_;
        this.f_79111_ = LootItemFunctions.m_80770_((BiFunction[])p_79116_);
    }

    public static Consumer<ItemStack> m_246283_(LootContext p_249570_, Consumer<ItemStack> p_251308_) {
        return p_248509_ -> {
            if (p_248509_.m_246617_(p_249570_.m_78952_().m_246046_())) {
                if (p_248509_.m_41613_() < p_248509_.m_41741_()) {
                    p_251308_.accept((ItemStack)((Object)p_248509_));
                } else {
                    ItemStack itemstack;
                    for (int i = p_248509_.m_41613_(); i > 0; i -= itemstack.m_41613_()) {
                        itemstack = p_248509_.m_41777_();
                        itemstack.m_41764_(Math.min(p_248509_.m_41741_(), i));
                        p_251308_.accept(itemstack);
                    }
                }
            }
        };
    }

    public void m_79131_(LootContext p_79132_, Consumer<ItemStack> p_79133_) {
        if (p_79132_.m_78934_(this)) {
            Consumer consumer = LootItemFunction.m_80724_(this.f_79111_, p_79133_, (LootContext)p_79132_);
            for (LootPool lootpool : this.f_79109_) {
                lootpool.m_79053_(consumer, p_79132_);
            }
            p_79132_.m_78946_(this);
        } else {
            f_79107_.warn("Detected infinite loop in loot tables");
        }
    }

    @Deprecated
    public void m_79148_(LootContext p_79149_, Consumer<ItemStack> p_79150_) {
        this.m_79131_(p_79149_, LootTable.m_246283_(p_79149_, p_79150_));
    }

    public ObjectArrayList<ItemStack> m_230922_(LootContext p_230923_) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        this.m_79148_(p_230923_, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        objectarraylist = ForgeHooks.modifyLoot((ResourceLocation)this.getLootTableId(), (ObjectArrayList)objectarraylist, (LootContext)p_230923_);
        return objectarraylist;
    }

    public LootContextParamSet m_79122_() {
        return this.f_79108_;
    }

    public void m_79136_(ValidationContext p_79137_) {
        for (int i = 0; i < this.f_79109_.size(); ++i) {
            this.f_79109_.get(i).m_79051_(p_79137_.m_79365_(".pools[" + i + "]"));
        }
        for (int j = 0; j < this.f_79110_.length; ++j) {
            this.f_79110_[j].m_6169_(p_79137_.m_79365_(".functions[" + j + "]"));
        }
    }

    public void fillInventory(Container p_79124_, LootContext p_79125_, boolean plugin) {
        this.isPlugin.set(plugin);
        this.m_79123_(p_79124_, p_79125_);
    }

    public void m_79123_(Container p_79124_, LootContext p_79125_) {
        ObjectArrayList objectarraylist = this.m_230922_(p_79125_);
        RandomSource randomsource = p_79125_.m_230907_();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent((Container)p_79124_, (LootTable)this, (LootContext)p_79125_, objectarraylist, (boolean)this.isPlugin.getAndSet(false));
        if (event.isCancelled()) {
            return;
        }
        objectarraylist = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        List<Integer> list = this.m_230919_(p_79124_, randomsource);
        this.m_230924_((ObjectArrayList<ItemStack>)objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                f_79107_.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.m_41619_()) {
                p_79124_.m_6836_(list.remove(list.size() - 1), ItemStack.f_41583_);
                continue;
            }
            p_79124_.m_6836_(list.remove(list.size() - 1), itemstack);
        }
    }

    private void m_230924_(ObjectArrayList<ItemStack> p_230925_, int p_230926_, RandomSource p_230927_) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = p_230925_.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)((Object)iterator.next());
            if (itemstack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (p_230926_ - p_230925_.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)((Object)list.remove(Mth.m_216271_((RandomSource)p_230927_, (int)0, (int)(list.size() - 1))));
            int i = Mth.m_216271_((RandomSource)p_230927_, (int)1, (int)(itemstack2.m_41613_() / 2));
            ItemStack itemstack1 = itemstack2.m_41620_(i);
            if (itemstack2.m_41613_() > 1 && p_230927_.m_188499_()) {
                list.add(itemstack2);
            } else {
                p_230925_.add((Object)itemstack2);
            }
            if (itemstack1.m_41613_() > 1 && p_230927_.m_188499_()) {
                list.add(itemstack1);
                continue;
            }
            p_230925_.add((Object)itemstack1);
        }
        p_230925_.addAll((Collection)list);
        Util.m_214673_(p_230925_, p_230927_);
    }

    private List<Integer> m_230919_(Container p_230920_, RandomSource p_230921_) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        for (int i = 0; i < p_230920_.m_6643_(); ++i) {
            if (!p_230920_.m_8020_(i).m_41619_()) continue;
            objectarraylist.add((Object)i);
        }
        Util.m_214673_(objectarraylist, p_230921_);
        return objectarraylist;
    }

    public static Builder m_79147_() {
        return new Builder();
    }

    public void freeze() {
        this.isFrozen = true;
        this.f_79109_.forEach(LootPool::freeze);
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootTable after being finalized!");
        }
    }

    public void setLootTableId(ResourceLocation id) {
        if (this.lootTableId != null) {
            throw new IllegalStateException("Attempted to rename loot table from '" + this.lootTableId + "' to '" + id + "': this is not supported");
        }
        this.lootTableId = Objects.requireNonNull(id);
    }

    public ResourceLocation getLootTableId() {
        return this.lootTableId;
    }

    public LootPool getPool(String name) {
        return this.f_79109_.stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
    }

    public LootPool removePool(String name) {
        this.checkFrozen();
        for (LootPool pool : this.f_79109_) {
            if (!name.equals(pool.getName())) continue;
            this.f_79109_.remove(pool);
            return pool;
        }
        return null;
    }

    public void addPool(LootPool pool) {
        this.checkFrozen();
        if (this.f_79109_.stream().anyMatch(e -> e == pool || e.getName() != null && e.getName().equals(pool.getName()))) {
            throw new RuntimeException("Attempted to add a duplicate pool to loot table: " + pool.getName());
        }
        this.f_79109_.add(pool);
    }

    public static class Builder
    implements FunctionUserBuilder<Builder> {
        private final List<LootPool> f_79156_ = Lists.newArrayList();
        private final List<LootItemFunction> f_79157_ = Lists.newArrayList();
        private LootContextParamSet f_79158_ = f_79106_;

        public Builder m_79161_(LootPool.Builder p_79162_) {
            this.f_79156_.add(p_79162_.m_79082_());
            return this;
        }

        public Builder m_79165_(LootContextParamSet p_79166_) {
            this.f_79158_ = p_79166_;
            return this;
        }

        public Builder m_79078_(LootItemFunction.Builder p_79164_) {
            this.f_79157_.add(p_79164_.m_7453_());
            return this;
        }

        public Builder m_79073_() {
            return this;
        }

        public LootTable m_79167_() {
            return new LootTable(this.f_79158_, this.f_79156_.toArray(new LootPool[0]), this.f_79157_.toArray(new LootItemFunction[0]));
        }
    }

    public static class Serializer
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable deserialize(JsonElement p_79173_, Type p_79174_, JsonDeserializationContext p_79175_) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_79173_, (String)"loot table");
            LootPool[] alootpool = (LootPool[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"pools", (Object)new LootPool[0], (JsonDeserializationContext)p_79175_, LootPool[].class);
            LootContextParamSet lootcontextparamset = null;
            if (jsonobject.has("type")) {
                String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type");
                lootcontextparamset = LootContextParamSets.m_81431_(new ResourceLocation(s));
            }
            LootItemFunction[] alootitemfunction = (LootItemFunction[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"functions", (Object)new LootItemFunction[0], (JsonDeserializationContext)p_79175_, LootItemFunction[].class);
            return new LootTable(lootcontextparamset != null ? lootcontextparamset : LootContextParamSets.f_81420_, alootpool, alootitemfunction);
        }

        public JsonElement serialize(LootTable p_79177_, Type p_79178_, JsonSerializationContext p_79179_) {
            JsonObject jsonobject = new JsonObject();
            if (p_79177_.f_79108_ != f_79106_) {
                ResourceLocation resourcelocation = LootContextParamSets.m_81426_(p_79177_.f_79108_);
                if (resourcelocation != null) {
                    jsonobject.addProperty("type", resourcelocation.toString());
                } else {
                    f_79107_.warn("Failed to find id for param set {}", (Object)p_79177_.f_79108_);
                }
            }
            if (!p_79177_.f_79109_.isEmpty()) {
                jsonobject.add("pools", p_79179_.serialize(p_79177_.f_79109_));
            }
            if (!ArrayUtils.isEmpty((Object[])p_79177_.f_79110_)) {
                jsonobject.add("functions", p_79179_.serialize((Object)p_79177_.f_79110_));
            }
            return jsonobject;
        }
    }
}

