/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.util.i18n.i18n;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    CHINA("http://s1.devicloud.cn:25119/"),
    GITHUB("https://mavenmirror.mohistmc.com/");

    public static final DownloadSource defaultSource;
    final String url;

    public static DownloadSource get() {
        String ds = MohistConfigUtil.yml.getString("mohist.libraries_downloadsource", defaultSource.name());
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            return me;
        }
        return defaultSource;
    }

    public String toString() {
        return "DownloadSource." + this.name() + "(url=" + this.getUrl() + ")";
    }

    private DownloadSource(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    static {
        defaultSource = i18n.isCN() ? CHINA : MOHIST;
    }
}

