/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.util.Stack;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SignatureRemapper;
import org.objectweb.asm.signature.SignatureVisitor;

public abstract class CustomRemapper
extends Remapper {
    public String mapMethodName(String owner, String name, String desc) {
        return this.mapMethodName(owner, name, desc, 0);
    }

    public String mapMethodName(String owner, String name, String desc, int access) {
        return name;
    }

    public String mapFieldName(String owner, String name, String desc) {
        return this.mapFieldName(owner, name, desc, 0);
    }

    public String mapFieldName(String owner, String name, String desc, int access) {
        return name;
    }

    public String mapSignature(String signature, boolean typeSignature) {
        if (signature != null && signature.contains("!*")) {
            return null;
        }
        return super.mapSignature(signature, typeSignature);
    }

    protected SignatureVisitor createSignatureRemapper(SignatureVisitor v) {
        return new ProguardSignatureFixer(v, this);
    }

    static class ProguardSignatureFixer
    extends SignatureRemapper {
        private final Stack<String> classNames = new Stack();

        ProguardSignatureFixer(SignatureVisitor sv, Remapper m) {
            super(sv, m);
        }

        public void visitClassType(String name) {
            this.classNames.push(name);
            super.visitClassType(name);
        }

        public void visitInnerClassType(String name) {
            String outerClassName = this.classNames.pop();
            if (name.startsWith(outerClassName + '$')) {
                name = name.substring(outerClassName.length() + 1);
            }
            String className = outerClassName + '$' + name;
            this.classNames.push(className);
            super.visitInnerClassType(name);
        }

        public void visitEnd() {
            this.classNames.pop();
            super.visitEnd();
        }
    }
}

