/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.MavenVersionAdapter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;

public class VersionSupportMatrix {
    private static final HashMap<String, List<ArtifactVersion>> overrideVersions = new HashMap();

    private static void add(String key, String value) {
        overrideVersions.computeIfAbsent(key, k -> new ArrayList()).add(new DefaultArtifactVersion(value));
    }

    public static <T> boolean testVersionSupportMatrix(VersionRange declaredRange, String lookupId, String type, BiPredicate<String, VersionRange> standardLookup) {
        if (standardLookup.test(lookupId, declaredRange)) {
            return true;
        }
        List<ArtifactVersion> custom = overrideVersions.get(type + "." + lookupId);
        return custom == null ? false : custom.stream().anyMatch(arg_0 -> ((VersionRange)declaredRange).containsVersion(arg_0));
    }

    static {
        DefaultArtifactVersion version = new DefaultArtifactVersion(FMLLoader.versionInfo().mcVersion());
        if (MavenVersionAdapter.createFromVersionSpec((String)"[1.19.3]").containsVersion((ArtifactVersion)version)) {
            VersionSupportMatrix.add("languageloader.javafml", "42");
            VersionSupportMatrix.add("mod.minecraft", "1.19.1");
            VersionSupportMatrix.add("mod.forge", "42.0.9");
        }
    }
}

