/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.JarComparer;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.Ownable;
import net.md_5.specialsource.ProgressMeter;
import net.md_5.specialsource.SpecialSource;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.transformer.ChainingTransformer;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MavenShade;
import net.md_5.specialsource.transformer.MethodDescriptor;
import net.md_5.specialsource.transformer.MinecraftCodersPack;
import net.md_5.specialsource.util.FileLocator;
import net.md_5.specialsource.writer.CompactSearge;
import net.md_5.specialsource.writer.MappingWriter;
import net.md_5.specialsource.writer.Searge;
import org.objectweb.asm.commons.Remapper;

public class JarMapping {
    public final LinkedHashMap<String, String> packages = new LinkedHashMap();
    public final Map<String, String> classes = new HashMap<String, String>();
    public final Map<String, String> fields = new HashMap<String, String>();
    public final Map<String, String> methods = new HashMap<String, String>();
    private InheritanceMap inheritanceMap = new InheritanceMap();
    private InheritanceProvider fallbackInheritanceProvider = null;
    private Set<String> excludedPackages = new HashSet<String>();
    private String currentClass = null;
    private static final Pattern MEMBER_PATTERN = Pattern.compile("(?:\\d+:\\d+:)?(.*?) (.*?) \\-> (.*)");
    public JarComparer newJar;

    public JarMapping() {
    }

    public void setInheritanceMap(InheritanceMap inheritanceMap) {
        this.inheritanceMap = inheritanceMap;
    }

    public void setFallbackInheritanceProvider(InheritanceProvider fallbackInheritanceProvider) {
        this.fallbackInheritanceProvider = fallbackInheritanceProvider;
    }

    public void addExcludedPackage(String packageName) {
        SpecialSource.log("Protecting Package: " + packageName);
        this.excludedPackages.add(packageName);
    }

    private boolean isExcludedPackage(String desc) {
        for (String packageName : this.excludedPackages) {
            if (!desc.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public String tryClimb(Map<String, String> map, NodeType type, String owner, String name, String desc, int access) {
        String mapped;
        String key = owner + "/" + name;
        String string = mapped = desc != null ? map.get(key + "/" + desc) : null;
        if (mapped == null) {
            mapped = map.get(key);
        }
        if (mapped == null && (access == -1 || !Modifier.isPrivate(access) && !Modifier.isStatic(access))) {
            Collection<String> parents = null;
            if (this.inheritanceMap.hasParents(owner)) {
                parents = this.inheritanceMap.getParents(owner);
            } else if (this.fallbackInheritanceProvider != null) {
                parents = this.fallbackInheritanceProvider.getParents(owner);
                this.inheritanceMap.setParents(owner, parents);
            }
            if (parents != null) {
                for (String parent : parents) {
                    mapped = this.tryClimb(map, type, parent, name, desc, access);
                    if (mapped == null) continue;
                    return mapped;
                }
            }
        }
        return mapped;
    }

    private void loadMappingsDir(String dirname, boolean reverse, boolean ignoreCsv, boolean numericSrgNames) throws IOException {
        ChainingTransformer inputTransformer;
        File dir = new File(dirname);
        if (!FileLocator.isHTTPURL(dirname) && !dir.isDirectory()) {
            throw new IllegalArgumentException("loadMappingsDir(" + dir + "): not a directory");
        }
        String sep = System.getProperty("file.separator");
        ArrayList<File> srgFiles = new ArrayList<File>();
        File joinedSrg = FileLocator.getFile(dirname + sep + "joined.srg");
        if (joinedSrg.exists()) {
            srgFiles.add(joinedSrg);
        } else {
            File serverSrg = FileLocator.getFile(dirname + sep + "server.srg");
            File clientSrg = FileLocator.getFile(dirname + sep + "client.srg");
            if (serverSrg.exists()) {
                srgFiles.add(serverSrg);
            }
            if (clientSrg.exists()) {
                srgFiles.add(clientSrg);
            }
        }
        if (srgFiles.size() == 0) {
            throw new IOException("loadMappingsDir(" + dirname + "): no joined.srg, client.srg, or server.srg found");
        }
        File fieldsCsv = FileLocator.getFile(dirname + sep + "fields.csv");
        File methodsCsv = FileLocator.getFile(dirname + sep + "methods.csv");
        File packagesCsv = FileLocator.getFile(dirname + sep + "packages.csv");
        if (numericSrgNames) {
            JarMapping chainMappings = new JarMapping();
            chainMappings.loadMappingsDir(dirname, reverse, false, false);
            inputTransformer = new ChainingTransformer(new JarRemapper(chainMappings));
            ignoreCsv = true;
        } else {
            inputTransformer = null;
        }
        MinecraftCodersPack outputTransformer = fieldsCsv.exists() && methodsCsv.exists() ? new MinecraftCodersPack(ignoreCsv ? null : fieldsCsv, ignoreCsv ? null : methodsCsv, packagesCsv) : null;
        for (File srg : srgFiles) {
            this.loadMappings(new BufferedReader(new FileReader(srg)), inputTransformer, outputTransformer, reverse);
        }
    }

    public void loadMappings(File file) throws IOException {
        this.loadMappings(new FileInputStream(file));
    }

    public void loadMappings(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            this.loadMappings(reader, null, null, false);
        }
    }

    public void loadMappings(String filename, boolean reverse, boolean numericSrgNames, String inShadeRelocation, String outShadeRelocation) throws IOException {
        MavenShade inputTransformer = null;
        MavenShade outputTransformer = null;
        if (inShadeRelocation != null) {
            inputTransformer = new MavenShade(inShadeRelocation);
        }
        if (outShadeRelocation != null) {
            outputTransformer = new MavenShade(outShadeRelocation);
        }
        if (new File(filename).isDirectory() || filename.endsWith("/")) {
            if (inputTransformer != null || outputTransformer != null) {
                throw new IllegalArgumentException("loadMappings(" + filename + "): shade relocation not supported on directories");
            }
            this.loadMappingsDir(filename, reverse, false, numericSrgNames);
        } else {
            if (numericSrgNames) {
                throw new IllegalArgumentException("loadMappings(" + filename + "): numeric only supported on directories, not files");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(FileLocator.getFile(filename)));){
                this.loadMappings(reader, inputTransformer, outputTransformer, reverse);
            }
        }
    }

    public void loadMappings(BufferedReader reader, MappingTransformer inputTransformer, MappingTransformer outputTransformer, boolean reverse) throws IOException {
        String line;
        if (inputTransformer == null) {
            inputTransformer = MavenShade.IDENTITY;
        }
        if (outputTransformer == null) {
            outputTransformer = MavenShade.IDENTITY;
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            int commentIndex = line.indexOf(35);
            if (commentIndex != -1) {
                line = line.substring(0, commentIndex);
            }
            if (line.isEmpty()) continue;
            lines.add(line);
        }
        ProgressMeter meter = new ProgressMeter(lines.size() * 2, "Loading mappings... %2.0f%%");
        final HashMap<String, String> clsMap = new HashMap<String, String>();
        HashMap<String, String> prgMap = new HashMap<String, String>();
        for (String l : lines) {
            String[] tokens;
            if (l.endsWith(":")) {
                String[] parts = l.split(" -> ");
                String orig = parts[0].replace('.', '/');
                String obf = parts[1].substring(0, parts[1].length() - 1).replace('.', '/');
                clsMap.put(obf, orig);
                prgMap.put(orig, obf);
            } else if (l.contains(":")) {
                if (!l.startsWith("CL:")) continue;
                tokens = l.split(" ");
                clsMap.put(tokens[0], tokens[1]);
            } else {
                if (l.startsWith("\t")) continue;
                tokens = l.split(" ");
                if (tokens.length == 2) {
                    clsMap.put(tokens[0], tokens[1]);
                }
            }
            meter.makeProgress();
        }
        Remapper reverseMapper = new Remapper(){

            public String map(String cls) {
                return clsMap.getOrDefault(cls, cls);
            }
        };
        for (String l : lines) {
            if (l.startsWith("tsrg2")) continue;
            if (l.contains(" -> ")) {
                this.parseProguardLine(l, inputTransformer, outputTransformer, reverse, reverseMapper, prgMap);
            } else if (l.contains(":")) {
                this.parseSrgLine(l, inputTransformer, outputTransformer, reverse);
            } else {
                this.parseCsrgLine(l, inputTransformer, outputTransformer, reverse, reverseMapper);
            }
            meter.makeProgress();
        }
        this.currentClass = null;
    }

    private void parseProguardLine(String line, MappingTransformer inputTransformer, MappingTransformer outputTransformer, boolean reverse, Remapper reverseMap, Map<String, String> prgMap) throws IOException {
        if (line.startsWith("    ")) {
            if (this.currentClass == null) {
                throw new IOException("Invalid proguard file, tsrg field/method line before class line: " + line);
            }
            line = line.trim();
        }
        if (line.endsWith(":")) {
            String[] parts = line.split(" -> ");
            String orig = parts[0].replace('.', '/');
            String obf = parts[1].substring(0, parts[1].length() - 1).replace('.', '/');
            String oldClassName = inputTransformer.transformClassName(obf);
            String newClassName = outputTransformer.transformClassName(orig);
            if (oldClassName.endsWith("/")) {
                if (reverse) {
                    this.packages.put(newClassName, oldClassName.substring(0, oldClassName.length() - 1));
                } else {
                    this.packages.put(oldClassName.substring(0, oldClassName.length() - 1), newClassName);
                }
            } else {
                if (reverse) {
                    this.classes.put(newClassName, oldClassName);
                } else {
                    this.classes.put(oldClassName, newClassName);
                }
                this.currentClass = obf;
            }
        } else {
            Matcher matcher = MEMBER_PATTERN.matcher(line);
            matcher.find();
            String obfName = matcher.group(3);
            String nameDesc = matcher.group(2);
            if (nameDesc.contains("(")) {
                String desc = ProguardUtil.csrgDesc(prgMap, nameDesc.substring(nameDesc.indexOf(40)), matcher.group(1));
                String newName = nameDesc.substring(0, nameDesc.indexOf(40));
                String oldClassName = inputTransformer.transformClassName(this.currentClass);
                String oldMethodName = inputTransformer.transformMethodName(this.currentClass, obfName, desc);
                String oldMethodDescriptor = inputTransformer.transformMethodDescriptor(desc);
                String newMethodName = outputTransformer.transformMethodName(this.currentClass, newName, desc);
                if (reverse) {
                    String newClassName = reverseMap.map(oldClassName);
                    if (newClassName.equals(oldClassName)) {
                        // empty if block
                    }
                    oldClassName = newClassName;
                    oldMethodDescriptor = reverseMap.mapMethodDesc(oldMethodDescriptor);
                    String temp = newMethodName;
                    newMethodName = oldMethodName;
                    oldMethodName = temp;
                }
                this.methods.put(oldClassName + "/" + oldMethodName + " " + oldMethodDescriptor, newMethodName);
            } else {
                String desc = ProguardUtil.toJVMType(prgMap, matcher.group(1));
                String oldClassName = inputTransformer.transformClassName(this.currentClass);
                String oldFieldName = inputTransformer.transformFieldName(this.currentClass, obfName);
                String oldFieldDescriptor = inputTransformer.transformMethodDescriptor(desc);
                String newFieldName = outputTransformer.transformFieldName(this.currentClass, nameDesc);
                if (reverse) {
                    String newClassName = reverseMap.map(oldClassName);
                    if (newClassName.equals(oldClassName)) {
                        // empty if block
                    }
                    oldClassName = newClassName;
                    oldFieldDescriptor = reverseMap.mapDesc(oldFieldDescriptor);
                    String temp = newFieldName;
                    newFieldName = oldFieldName;
                    oldFieldName = temp;
                }
                this.fields.put(oldClassName + "/" + oldFieldName + "/" + oldFieldDescriptor, newFieldName);
            }
        }
    }

    private void parseCsrgLine(String line, MappingTransformer inputTransformer, MappingTransformer outputTransformer, boolean reverse, Remapper reverseMap) throws IOException {
        String[] tokens;
        if (line.startsWith("\t\t")) {
            return;
        }
        if (line.startsWith("\t")) {
            if (this.currentClass == null) {
                throw new IOException("Invalid tsrg file, tsrg field/method line before class line: " + line);
            }
            line = this.currentClass + " " + line.substring(1);
        }
        if ((tokens = line.split(" ")).length == 2) {
            String oldClassName = inputTransformer.transformClassName(tokens[0]);
            String newClassName = outputTransformer.transformClassName(tokens[1]);
            if (oldClassName.endsWith("/")) {
                if (!newClassName.equals(".") && !newClassName.endsWith("/")) {
                    newClassName = newClassName + "/";
                }
                if (!oldClassName.equals(".") && !oldClassName.endsWith("/")) {
                    oldClassName = oldClassName + "/";
                }
                if (reverse) {
                    this.packages.put(newClassName, oldClassName);
                } else {
                    this.packages.put(oldClassName, newClassName);
                }
            } else {
                if (reverse) {
                    this.classes.put(newClassName, oldClassName);
                } else {
                    this.classes.put(oldClassName, newClassName);
                }
                this.currentClass = tokens[0];
            }
        } else if (tokens.length == 3) {
            String oldClassName = inputTransformer.transformClassName(tokens[0]);
            String oldFieldName = inputTransformer.transformFieldName(tokens[0], tokens[1]);
            String newFieldName = outputTransformer.transformFieldName(tokens[0], tokens[2]);
            if (reverse) {
                String newClassName = reverseMap.map(oldClassName);
                if (newClassName.equals(oldClassName)) {
                    // empty if block
                }
                oldClassName = newClassName;
                String temp = newFieldName;
                newFieldName = oldFieldName;
                oldFieldName = temp;
            }
            this.fields.put(oldClassName + "/" + oldFieldName, newFieldName);
        } else if (tokens.length == 4) {
            String oldClassName = inputTransformer.transformClassName(tokens[0]);
            String oldMethodName = inputTransformer.transformMethodName(tokens[0], tokens[1], tokens[2]);
            String oldMethodDescriptor = inputTransformer.transformMethodDescriptor(tokens[2]);
            String newMethodName = outputTransformer.transformMethodName(tokens[0], tokens[3], tokens[2]);
            if (reverse) {
                String newClassName = reverseMap.map(oldClassName);
                if (newClassName.equals(oldClassName)) {
                    // empty if block
                }
                oldClassName = newClassName;
                oldMethodDescriptor = reverseMap.mapMethodDesc(oldMethodDescriptor);
                String temp = newMethodName;
                newMethodName = oldMethodName;
                oldMethodName = temp;
            }
            this.methods.put(oldClassName + "/" + oldMethodName + " " + oldMethodDescriptor, newMethodName);
        } else {
            throw new IOException("Invalid csrg file line, token count " + tokens.length + " unexpected in " + line);
        }
    }

    private void parseSrgLine(String line, MappingTransformer inputTransformer, MappingTransformer outputTransformer, boolean reverse) throws IOException {
        String[] tokens = line.split(" ");
        String kind = tokens[0];
        if (kind.equals("CL:")) {
            String oldClassName = inputTransformer.transformClassName(tokens[1]);
            String newClassName = outputTransformer.transformClassName(tokens[2]);
            if (reverse) {
                String temp = newClassName;
                newClassName = oldClassName;
                oldClassName = temp;
            }
            if (this.isExcludedPackage(oldClassName)) {
                SpecialSource.log("Ignored CL: " + oldClassName + " " + newClassName);
                return;
            }
            if (this.classes.containsKey(oldClassName) && !newClassName.equals(this.classes.get(oldClassName))) {
                throw new IllegalArgumentException("Duplicate class mapping: " + oldClassName + " -> " + newClassName + " but already mapped to " + this.classes.get(oldClassName) + " in line=" + line);
            }
            if (oldClassName.endsWith("/*") && newClassName.endsWith("/*")) {
                oldClassName = oldClassName.substring(0, oldClassName.length() - 1);
                newClassName = newClassName.substring(0, newClassName.length() - 1);
                this.packages.put(oldClassName, newClassName);
            } else {
                this.classes.put(oldClassName, newClassName);
                this.currentClass = tokens[0];
            }
        } else if (kind.equals("PK:")) {
            String oldPackageName = inputTransformer.transformClassName(tokens[1]);
            String newPackageName = outputTransformer.transformClassName(tokens[2]);
            if (reverse) {
                String temp = newPackageName;
                newPackageName = oldPackageName;
                oldPackageName = temp;
            }
            if (this.isExcludedPackage(oldPackageName)) {
                SpecialSource.log("Ignored PK: " + oldPackageName + " -> " + newPackageName);
                return;
            }
            if (!newPackageName.equals(".") && !newPackageName.endsWith("/")) {
                newPackageName = newPackageName + "/";
            }
            if (!oldPackageName.equals(".") && !oldPackageName.endsWith("/")) {
                oldPackageName = oldPackageName + "/";
            }
            if (this.packages.containsKey(oldPackageName) && !newPackageName.equals(this.packages.get(oldPackageName))) {
                throw new IllegalArgumentException("Duplicate package mapping: " + oldPackageName + " ->" + newPackageName + " but already mapped to " + this.packages.get(oldPackageName) + " in line=" + line);
            }
            this.packages.put(oldPackageName, newPackageName);
        } else if (kind.equals("FD:")) {
            String oldFull = tokens[1];
            String newFull = tokens[2];
            int splitOld = oldFull.lastIndexOf(47);
            int splitNew = newFull.lastIndexOf(47);
            if (splitOld == -1 || splitNew == -1) {
                throw new IllegalArgumentException("Field name is invalid, not fully-qualified: " + oldFull + " -> " + newFull + " in line=" + line);
            }
            String oldClassName = inputTransformer.transformClassName(oldFull.substring(0, splitOld));
            String oldFieldName = inputTransformer.transformFieldName(oldFull.substring(0, splitOld), oldFull.substring(splitOld + 1));
            String newClassName = outputTransformer.transformClassName(newFull.substring(0, splitNew));
            String newFieldName = outputTransformer.transformFieldName(oldFull.substring(0, splitOld), newFull.substring(splitNew + 1));
            if (reverse) {
                oldClassName = newClassName;
                String temp = newFieldName;
                newFieldName = oldFieldName;
                oldFieldName = temp;
            }
            if (this.isExcludedPackage(oldClassName)) {
                SpecialSource.log("Ignored FD: " + oldClassName + "/" + oldFieldName + " -> " + newFieldName);
                return;
            }
            String oldEntry = oldClassName + "/" + oldFieldName;
            if (this.fields.containsKey(oldEntry) && !newFieldName.equals(this.fields.get(oldEntry))) {
                throw new IllegalArgumentException("Duplicate field mapping: " + oldEntry + " ->" + newFieldName + " but already mapped to " + this.fields.get(oldEntry) + " in line=" + line);
            }
            this.fields.put(oldEntry, newFieldName);
        } else if (kind.equals("MD:")) {
            String oldFull = tokens[1];
            String newFull = tokens[3];
            int splitOld = oldFull.lastIndexOf(47);
            int splitNew = newFull.lastIndexOf(47);
            if (splitOld == -1 || splitNew == -1) {
                throw new IllegalArgumentException("Field name is invalid, not fully-qualified: " + oldFull + " -> " + newFull + " in line=" + line);
            }
            String oldClassName = inputTransformer.transformClassName(oldFull.substring(0, splitOld));
            String oldMethodName = inputTransformer.transformMethodName(oldFull.substring(0, splitOld), oldFull.substring(splitOld + 1), tokens[2]);
            String oldMethodDescriptor = inputTransformer.transformMethodDescriptor(tokens[2]);
            String newClassName = outputTransformer.transformClassName(newFull.substring(0, splitNew));
            String newMethodName = outputTransformer.transformMethodName(oldFull.substring(0, splitOld), newFull.substring(splitNew + 1), tokens[2]);
            String newMethodDescriptor = outputTransformer.transformMethodDescriptor(tokens[4]);
            if (reverse) {
                oldClassName = newClassName;
                oldMethodDescriptor = newMethodDescriptor;
                String temp = newMethodName;
                newMethodName = oldMethodName;
                oldMethodName = temp;
            }
            if (this.isExcludedPackage(oldClassName)) {
                SpecialSource.log("Ignored MD: " + oldClassName + "/" + oldMethodName + " -> " + newMethodName);
                return;
            }
            String oldEntry = oldClassName + "/" + oldMethodName + " " + oldMethodDescriptor;
            if (this.methods.containsKey(oldEntry) && !newMethodName.equals(this.methods.get(oldEntry))) {
                throw new IllegalArgumentException("Duplicate method mapping: " + oldEntry + " ->" + newMethodName + " but already mapped to " + this.methods.get(oldEntry) + " in line=" + line);
            }
            this.methods.put(oldEntry, newMethodName);
        } else {
            throw new IllegalArgumentException("Unable to parse srg file, unrecognized mapping type in line=" + line);
        }
    }

    public JarMapping(JarComparer oldJar, JarComparer newJar, File logFile, boolean compact) throws IOException {
        this(oldJar, newJar, logFile, compact, false);
    }

    public JarMapping(JarComparer oldJar, JarComparer newJar, File logfile, boolean compact, boolean full) throws IOException {
        String key;
        int i;
        SpecialSource.validate(oldJar, newJar);
        this.newJar = newJar;
        MappingWriter srgWriter = compact ? new CompactSearge(oldJar.jar.getFilename(), newJar.jar.getFilename()) : new Searge(oldJar.jar.getFilename(), newJar.jar.getFilename());
        for (i = 0; i < oldJar.classes.size(); ++i) {
            String oldClass = oldJar.classes.get(i);
            String newClass = newJar.classes.get(i);
            if (!full && oldClass.equals(newClass)) continue;
            this.classes.put(oldClass, newClass);
            srgWriter.addClassMap(oldClass, newClass);
        }
        for (i = 0; i < oldJar.fields.size(); ++i) {
            Ownable oldField = oldJar.fields.get(i);
            Ownable newField = newJar.fields.get(i);
            key = oldField.owner + "/" + oldField.name;
            this.fields.put(key, newField.name);
            if (!full && oldField.name.equals(newField.name)) continue;
            srgWriter.addFieldMap(oldField, newField);
        }
        for (i = 0; i < oldJar.methods.size(); ++i) {
            Ownable oldMethod = oldJar.methods.get(i);
            Ownable newMethod = newJar.methods.get(i);
            key = oldMethod.owner + "/" + oldMethod.name + " " + oldMethod.descriptor;
            this.methods.put(key, newMethod.name);
            MethodDescriptor methodDescriptorTransformer = new MethodDescriptor(null, this.classes);
            String oldDescriptor = methodDescriptorTransformer.transform(oldMethod.descriptor);
            if (!full && (oldMethod.name + " " + oldDescriptor).equals(newMethod.name + " " + newMethod.descriptor)) continue;
            srgWriter.addMethodMap(oldMethod, newMethod);
        }
        try (PrintWriter out = logfile == null ? new PrintWriter(System.out) : new PrintWriter(logfile);){
            srgWriter.write(out);
        }
    }

    private static class ProguardUtil {
        private ProguardUtil() {
        }

        private static String csrgDesc(Map<String, String> data, String args, String ret) {
            String[] parts = args.substring(1, args.length() - 1).split(",");
            StringBuilder desc = new StringBuilder("(");
            for (String part : parts) {
                if (part.isEmpty()) continue;
                desc.append(ProguardUtil.toJVMType(data, part));
            }
            desc.append(")");
            desc.append(ProguardUtil.toJVMType(data, ret));
            return desc.toString();
        }

        private static String toJVMType(Map<String, String> data, String type) {
            switch (type) {
                case "byte": {
                    return "B";
                }
                case "char": {
                    return "C";
                }
                case "double": {
                    return "D";
                }
                case "float": {
                    return "F";
                }
                case "int": {
                    return "I";
                }
                case "long": {
                    return "J";
                }
                case "short": {
                    return "S";
                }
                case "boolean": {
                    return "Z";
                }
                case "void": {
                    return "V";
                }
            }
            if (type.endsWith("[]")) {
                return "[" + ProguardUtil.toJVMType(data, type.substring(0, type.length() - 2));
            }
            String clazzType = type.replace('.', '/');
            String mappedType = data.get(clazzType);
            return "L" + (mappedType != null ? mappedType : clazzType) + ";";
        }
    }
}

