/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.client;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.dto.WorldDownload;
import com.mojang.realmsclient.exception.RealmsDefaultUncaughtExceptionHandler;
import com.mojang.realmsclient.gui.screens.RealmsDownloadLatestWorldScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class FileDownload {
    static final Logger f_86953_ = LogUtils.getLogger();
    volatile boolean f_86954_;
    volatile boolean f_86955_;
    volatile boolean f_86956_;
    volatile boolean f_86957_;
    @Nullable
    private volatile File f_86958_;
    volatile File f_86959_;
    @Nullable
    private volatile HttpGet f_86960_;
    @Nullable
    private Thread f_86961_;
    private final RequestConfig f_86962_ = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).build();
    private static final String[] f_86963_ = new String[]{"CON", "COM", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long m_86989_(String p_86990_) {
        long i;
        CloseableHttpClient closeablehttpclient = null;
        HttpGet httpget = null;
        try {
            httpget = new HttpGet(p_86990_);
            closeablehttpclient = HttpClientBuilder.create().setDefaultRequestConfig(this.f_86962_).build();
            CloseableHttpResponse closeablehttpresponse = closeablehttpclient.execute((HttpUriRequest)httpget);
            long l = Long.parseLong(closeablehttpresponse.getFirstHeader("Content-Length").getValue());
            return l;
        }
        catch (Throwable throwable) {
            f_86953_.error("Unable to get content length for download");
            i = 0L;
        }
        finally {
            if (httpget != null) {
                httpget.releaseConnection();
            }
            if (closeablehttpclient != null) {
                try {
                    closeablehttpclient.close();
                }
                catch (IOException ioexception) {
                    f_86953_.error("Could not close http client", (Throwable)ioexception);
                }
            }
        }
        return i;
    }

    public void m_86982_(WorldDownload p_86983_, String p_86984_, RealmsDownloadLatestWorldScreen.DownloadStatus p_86985_, LevelStorageSource p_86986_) {
        if (this.f_86961_ == null) {
            this.f_86961_ = new Thread(() -> {
                CloseableHttpClient closeablehttpclient = null;
                try {
                    this.f_86958_ = File.createTempFile("backup", ".tar.gz");
                    this.f_86960_ = new HttpGet(p_86978_.f_87718_);
                    closeablehttpclient = HttpClientBuilder.create().setDefaultRequestConfig(this.f_86962_).build();
                    CloseableHttpResponse httpresponse = closeablehttpclient.execute((HttpUriRequest)this.f_86960_);
                    p_86979_.f_88661_ = Long.parseLong(httpresponse.getFirstHeader("Content-Length").getValue());
                    if (httpresponse.getStatusLine().getStatusCode() == 200) {
                        FileOutputStream outputstream = new FileOutputStream(this.f_86958_);
                        ProgressListener filedownload$progresslistener = new ProgressListener(p_86984_.trim(), this.f_86958_, p_86986_, p_86985_);
                        DownloadCountingOutputStream filedownload$downloadcountingoutputstream = new DownloadCountingOutputStream(outputstream);
                        filedownload$downloadcountingoutputstream.m_87016_(filedownload$progresslistener);
                        IOUtils.copy((InputStream)httpresponse.getEntity().getContent(), (OutputStream)((Object)filedownload$downloadcountingoutputstream));
                        return;
                    }
                    this.f_86956_ = true;
                    this.f_86960_.abort();
                    return;
                }
                catch (Exception exception1) {
                    f_86953_.error("Caught exception while downloading: {}", (Object)exception1.getMessage());
                    this.f_86956_ = true;
                    return;
                }
                finally {
                    block40: {
                        block41: {
                            CloseableHttpResponse httpresponse1;
                            this.f_86960_.releaseConnection();
                            if (this.f_86958_ != null) {
                                this.f_86958_.delete();
                            }
                            if (this.f_86956_) break block40;
                            if (p_86978_.f_87719_.isEmpty() || p_86978_.f_87720_.isEmpty()) break block41;
                            try {
                                this.f_86958_ = File.createTempFile("resources", ".tar.gz");
                                this.f_86960_ = new HttpGet(p_86978_.f_87719_);
                                httpresponse1 = closeablehttpclient.execute((HttpUriRequest)this.f_86960_);
                                p_86979_.f_88661_ = Long.parseLong(httpresponse1.getFirstHeader("Content-Length").getValue());
                                if (httpresponse1.getStatusLine().getStatusCode() != 200) {
                                    this.f_86956_ = true;
                                    this.f_86960_.abort();
                                    return;
                                }
                            }
                            catch (Exception exception) {
                                f_86953_.error("Caught exception while downloading: {}", (Object)exception.getMessage());
                                this.f_86956_ = true;
                            }
                            FileOutputStream outputstream1 = new FileOutputStream(this.f_86958_);
                            ResourcePackProgressListener filedownload$resourcepackprogresslistener = new ResourcePackProgressListener(this.f_86958_, p_86985_, p_86983_);
                            DownloadCountingOutputStream filedownload$downloadcountingoutputstream1 = new DownloadCountingOutputStream(outputstream1);
                            filedownload$downloadcountingoutputstream1.m_87016_(filedownload$resourcepackprogresslistener);
                            IOUtils.copy((InputStream)httpresponse1.getEntity().getContent(), (OutputStream)((Object)filedownload$downloadcountingoutputstream1));
                            break block40;
                            finally {
                                this.f_86960_.releaseConnection();
                                if (this.f_86958_ != null) {
                                    this.f_86958_.delete();
                                }
                            }
                        }
                        this.f_86955_ = true;
                    }
                    if (closeablehttpclient != null) {
                        try {
                            closeablehttpclient.close();
                        }
                        catch (IOException ioexception) {
                            f_86953_.error("Failed to close Realms download client");
                        }
                    }
                }
            });
            this.f_86961_.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new RealmsDefaultUncaughtExceptionHandler(f_86953_));
            this.f_86961_.start();
        }
    }

    public void m_86966_() {
        if (this.f_86960_ != null) {
            this.f_86960_.abort();
        }
        if (this.f_86958_ != null) {
            this.f_86958_.delete();
        }
        this.f_86954_ = true;
    }

    public boolean m_86995_() {
        return this.f_86955_;
    }

    public boolean m_87003_() {
        return this.f_86956_;
    }

    public boolean m_87009_() {
        return this.f_86957_;
    }

    public static String m_87001_(String p_87002_) {
        p_87002_ = ((String)p_87002_).replaceAll("[\\./\"]", "_");
        for (String s : f_86963_) {
            if (!((String)p_87002_).equalsIgnoreCase(s)) continue;
            p_87002_ = "_" + (String)p_87002_ + "_";
        }
        return p_87002_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void m_86991_(String p_86992_, @Nullable File p_86993_, LevelStorageSource p_86994_) throws IOException {
        Object s;
        Pattern pattern = Pattern.compile(".*-([0-9]+)$");
        int i = 1;
        for (char c0 : SharedConstants.f_136184_) {
            p_86992_ = p_86992_.replace(c0, '_');
        }
        if (StringUtils.isEmpty((CharSequence)p_86992_)) {
            p_86992_ = "Realm";
        }
        p_86992_ = FileDownload.m_87001_(p_86992_);
        try {
            Object object = p_86994_.m_230833_().iterator();
            while (object.hasNext()) {
                LevelStorageSource.LevelDirectory levelstoragesource$leveldirectory = (LevelStorageSource.LevelDirectory)object.next();
                String s1 = levelstoragesource$leveldirectory.m_230853_();
                if (!s1.toLowerCase(Locale.ROOT).startsWith(p_86992_.toLowerCase(Locale.ROOT))) continue;
                Matcher matcher = pattern.matcher(s1);
                if (matcher.matches()) {
                    int j = Integer.parseInt(matcher.group(1));
                    if (j <= i) continue;
                    i = j;
                    continue;
                }
                ++i;
            }
        }
        catch (Exception exception1) {
            f_86953_.error("Error getting level list", (Throwable)exception1);
            this.f_86956_ = true;
            return;
        }
        if (p_86994_.m_78240_(p_86992_) && i <= 1) {
            s = p_86992_;
        } else {
            s = p_86992_ + (String)(i == 1 ? "" : "-" + i);
            if (!p_86994_.m_78240_((String)s)) {
                boolean flag = false;
                while (!flag) {
                    if (!p_86994_.m_78240_((String)(s = p_86992_ + (String)(++i == 1 ? "" : "-" + i)))) continue;
                    flag = true;
                }
            }
        }
        TarArchiveInputStream tararchiveinputstream = null;
        File file1 = new File(Minecraft.m_91087_().f_91069_.getAbsolutePath(), "saves");
        try {
            file1.mkdir();
            tararchiveinputstream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(p_86993_))));
            TarArchiveEntry tararchiveentry = tararchiveinputstream.getNextTarEntry();
            while (tararchiveentry != null) {
                File file2 = new File(file1, tararchiveentry.getName().replace("world", (CharSequence)s));
                if (tararchiveentry.isDirectory()) {
                    file2.mkdirs();
                } else {
                    file2.createNewFile();
                    try (FileOutputStream fileoutputstream = new FileOutputStream(file2);){
                        IOUtils.copy((InputStream)tararchiveinputstream, (OutputStream)fileoutputstream);
                    }
                }
                tararchiveentry = tararchiveinputstream.getNextTarEntry();
            }
        }
        catch (Exception exception) {
            f_86953_.error("Error extracting world", (Throwable)exception);
            this.f_86956_ = true;
        }
        finally {
            if (tararchiveinputstream != null) {
                tararchiveinputstream.close();
            }
            if (p_86993_ != null) {
                p_86993_.delete();
            }
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = p_86994_.m_78260_((String)s);){
                levelstoragesource$levelstorageaccess.m_78297_(((String)s).trim());
                Path path = levelstoragesource$levelstorageaccess.m_78283_(LevelResource.f_78178_);
                FileDownload.m_86987_(path.toFile());
            }
            catch (IOException ioexception) {
                f_86953_.error("Failed to rename unpacked realms level {}", s, (Object)ioexception);
            }
            this.f_86959_ = new File(file1, (String)s + File.separator + "resources.zip");
        }
    }

    private static void m_86987_(File p_86988_) {
        if (p_86988_.exists()) {
            try {
                CompoundTag compoundtag = NbtIo.m_128937_(p_86988_);
                CompoundTag compoundtag1 = compoundtag.m_128469_("Data");
                compoundtag1.m_128473_("Player");
                NbtIo.m_128944_(compoundtag, p_86988_);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ProgressListener
    implements ActionListener {
        private final String f_87021_;
        private final File f_87022_;
        private final LevelStorageSource f_87023_;
        private final RealmsDownloadLatestWorldScreen.DownloadStatus f_87024_;

        ProgressListener(String p_87027_, File p_87028_, LevelStorageSource p_87029_, RealmsDownloadLatestWorldScreen.DownloadStatus p_87030_) {
            this.f_87021_ = p_87027_;
            this.f_87022_ = p_87028_;
            this.f_87023_ = p_87029_;
            this.f_87024_ = p_87030_;
        }

        @Override
        public void actionPerformed(ActionEvent p_87039_) {
            this.f_87024_.f_88660_ = ((DownloadCountingOutputStream)((Object)p_87039_.getSource())).getByteCount();
            if (this.f_87024_.f_88660_ >= this.f_87024_.f_88661_ && !FileDownload.this.f_86954_ && !FileDownload.this.f_86956_) {
                try {
                    FileDownload.this.f_86957_ = true;
                    FileDownload.this.m_86991_(this.f_87021_, this.f_87022_, this.f_87023_);
                }
                catch (IOException ioexception) {
                    f_86953_.error("Error extracting archive", (Throwable)ioexception);
                    FileDownload.this.f_86956_ = true;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DownloadCountingOutputStream
    extends CountingOutputStream {
        @Nullable
        private ActionListener f_87012_;

        public DownloadCountingOutputStream(OutputStream p_193509_) {
            super(p_193509_);
        }

        public void m_87016_(ActionListener p_87017_) {
            this.f_87012_ = p_87017_;
        }

        protected void afterWrite(int p_87019_) throws IOException {
            super.afterWrite(p_87019_);
            if (this.f_87012_ != null) {
                this.f_87012_.actionPerformed(new ActionEvent((Object)this, 0, null));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class ResourcePackProgressListener
    implements ActionListener {
        private final File f_87041_;
        private final RealmsDownloadLatestWorldScreen.DownloadStatus f_87042_;
        private final WorldDownload f_87043_;

        ResourcePackProgressListener(File p_87046_, RealmsDownloadLatestWorldScreen.DownloadStatus p_87047_, WorldDownload p_87048_) {
            this.f_87041_ = p_87046_;
            this.f_87042_ = p_87047_;
            this.f_87043_ = p_87048_;
        }

        @Override
        public void actionPerformed(ActionEvent p_87056_) {
            this.f_87042_.f_88660_ = ((DownloadCountingOutputStream)((Object)p_87056_.getSource())).getByteCount();
            if (this.f_87042_.f_88660_ >= this.f_87042_.f_88661_ && !FileDownload.this.f_86954_) {
                try {
                    String s = Hashing.sha1().hashBytes(Files.toByteArray((File)this.f_87041_)).toString();
                    if (s.equals(this.f_87043_.f_87720_)) {
                        FileUtils.copyFile((File)this.f_87041_, (File)FileDownload.this.f_86959_);
                        FileDownload.this.f_86955_ = true;
                    } else {
                        f_86953_.error("Resourcepack had wrong hash (expected {}, found {}). Deleting it.", (Object)this.f_87043_.f_87720_, (Object)s);
                        FileUtils.deleteQuietly((File)this.f_87041_);
                        FileDownload.this.f_86956_ = true;
                    }
                }
                catch (IOException ioexception) {
                    f_86953_.error("Error copying resourcepack file: {}", (Object)ioexception.getMessage());
                    FileDownload.this.f_86956_ = true;
                }
            }
        }
    }
}

