/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class DebugScreenOverlay
extends GuiComponent {
    private static final int f_168988_ = 0xE0E0E0;
    private static final int f_168989_ = 2;
    private static final int f_168990_ = 2;
    private static final int f_168991_ = 2;
    private static final Map<Heightmap.Types, String> f_94029_ = Util.m_137469_(new EnumMap(Heightmap.Types.class), p_94070_ -> {
        p_94070_.put(Heightmap.Types.WORLD_SURFACE_WG, "SW");
        p_94070_.put(Heightmap.Types.WORLD_SURFACE, "S");
        p_94070_.put(Heightmap.Types.OCEAN_FLOOR_WG, "OW");
        p_94070_.put(Heightmap.Types.OCEAN_FLOOR, "O");
        p_94070_.put(Heightmap.Types.MOTION_BLOCKING, "M");
        p_94070_.put(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft f_94030_;
    private final AllocationRateCalculator f_232506_;
    private final Font f_94031_;
    protected HitResult f_94032_;
    protected HitResult f_94033_;
    @Nullable
    private ChunkPos f_94034_;
    @Nullable
    private LevelChunk f_94035_;
    @Nullable
    private CompletableFuture<LevelChunk> f_94036_;
    private static final int f_168992_ = -65536;
    private static final int f_168993_ = -256;
    private static final int f_168994_ = -16711936;

    public DebugScreenOverlay(Minecraft p_94039_) {
        this.f_94030_ = p_94039_;
        this.f_232506_ = new AllocationRateCalculator();
        this.f_94031_ = p_94039_.f_91062_;
    }

    public void m_94040_() {
        this.f_94036_ = null;
        this.f_94035_ = null;
    }

    public void m_94056_(PoseStack p_94057_) {
        this.f_94030_.m_91307_().m_6180_("debug");
        Entity entity = this.f_94030_.m_91288_();
        this.f_94032_ = entity.m_19907_(20.0, 0.0f, false);
        this.f_94033_ = entity.m_19907_(20.0, 0.0f, true);
        this.m_94076_(p_94057_);
        this.m_94079_(p_94057_);
        if (this.f_94030_.f_91066_.f_92065_) {
            int i = this.f_94030_.m_91268_().m_85445_();
            this.m_94058_(p_94057_, this.f_94030_.m_91293_(), 0, i / 2, true);
            IntegratedServer integratedserver = this.f_94030_.m_91092_();
            if (integratedserver != null) {
                this.m_94058_(p_94057_, integratedserver.m_129904_(), i - Math.min(i / 2, 240), i / 2, false);
            }
        }
        this.f_94030_.m_91307_().m_7238_();
    }

    protected void m_94076_(PoseStack p_94077_) {
        List<String> list = this.m_94075_();
        list.add("");
        boolean flag = this.f_94030_.m_91092_() != null;
        list.add("Debug: Pie [shift]: " + (this.f_94030_.f_91066_.f_92064_ ? "visible" : "hidden") + (flag ? " FPS + TPS" : " FPS") + " [alt]: " + (this.f_94030_.f_91066_.f_92065_ ? "visible" : "hidden"));
        list.add("For help: press F3 + Q");
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int j = 9;
            int k = this.f_94031_.m_92895_(s);
            int l = 2;
            int i1 = 2 + j * i;
            DebugScreenOverlay.m_93172_((PoseStack)p_94077_, (int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + j - 1), (int)-1873784752);
            this.f_94031_.m_92883_(p_94077_, s, 2.0f, i1, 0xE0E0E0);
        }
    }

    protected void m_94079_(PoseStack p_94080_) {
        List<String> list = this.m_94078_();
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int j = 9;
            int k = this.f_94031_.m_92895_(s);
            int l = this.f_94030_.m_91268_().m_85445_() - 2 - k;
            int i1 = 2 + j * i;
            DebugScreenOverlay.m_93172_((PoseStack)p_94080_, (int)(l - 1), (int)(i1 - 1), (int)(l + k + 1), (int)(i1 + j - 1), (int)-1873784752);
            this.f_94031_.m_92883_(p_94080_, s, l, i1, 0xE0E0E0);
        }
    }

    protected List<String> m_94075_() {
        PostChain postchain;
        Level level;
        IntegratedServer integratedserver = this.f_94030_.m_91092_();
        Connection connection = this.f_94030_.m_91403_().m_104910_();
        float f = connection.m_129543_();
        float f1 = connection.m_129542_();
        String s = integratedserver != null ? String.format(Locale.ROOT, "Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf(integratedserver.m_129903_()), Float.valueOf(f), Float.valueOf(f1)) : String.format(Locale.ROOT, "\"%s\" server, %.0f tx, %.0f rx", this.f_94030_.f_91074_.m_108629_(), Float.valueOf(f), Float.valueOf(f1));
        BlockPos blockpos = this.f_94030_.m_91288_().m_20183_();
        if (this.f_94030_.m_91299_()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.m_183709_().m_132493_() + " (" + this.f_94030_.m_91388_() + "/" + ClientBrandRetriever.m_129629_() + ")", this.f_94030_.f_90977_, s, this.f_94030_.f_91060_.m_109820_(), this.f_94030_.f_91060_.m_109822_(), "P: " + this.f_94030_.f_91061_.m_107403_() + ". T: " + this.f_94030_.f_91073_.m_104813_(), this.f_94030_.f_91073_.m_46464_(), "", String.format(Locale.ROOT, "Chunk-relative: %d %d %d", blockpos.m_123341_() & 0xF, blockpos.m_123342_() & 0xF, blockpos.m_123343_() & 0xF)});
        }
        Entity entity = this.f_94030_.m_91288_();
        Direction direction = entity.m_6350_();
        String s1 = switch (direction) {
            case Direction.NORTH -> "Towards negative Z";
            case Direction.SOUTH -> "Towards positive Z";
            case Direction.WEST -> "Towards negative X";
            case Direction.EAST -> "Towards positive X";
            default -> "Invalid";
        };
        ChunkPos chunkpos = new ChunkPos(blockpos);
        if (!Objects.equals(this.f_94034_, chunkpos)) {
            this.f_94034_ = chunkpos;
            this.m_94040_();
        }
        LongSets.EmptySet longset = (level = this.m_94083_()) instanceof ServerLevel ? ((ServerLevel)level).m_8902_() : LongSets.EMPTY_SET;
        ArrayList list = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.m_183709_().m_132493_() + " (" + this.f_94030_.m_91388_() + "/" + ClientBrandRetriever.m_129629_() + (String)("release".equalsIgnoreCase(this.f_94030_.m_91389_()) ? "" : "/" + this.f_94030_.m_91389_()) + ")", this.f_94030_.f_90977_, s, this.f_94030_.f_91060_.m_109820_(), this.f_94030_.f_91060_.m_109822_(), "P: " + this.f_94030_.f_91061_.m_107403_() + ". T: " + this.f_94030_.f_91073_.m_104813_(), this.f_94030_.f_91073_.m_46464_()});
        String s2 = this.m_94082_();
        if (s2 != null) {
            list.add(s2);
        }
        list.add(this.f_94030_.f_91073_.m_46472_().m_135782_() + " FC: " + longset.size());
        list.add("");
        list.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.f_94030_.m_91288_().m_20185_(), this.f_94030_.m_91288_().m_20186_(), this.f_94030_.m_91288_().m_20189_()));
        list.add(String.format(Locale.ROOT, "Block: %d %d %d [%d %d %d]", blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), blockpos.m_123341_() & 0xF, blockpos.m_123342_() & 0xF, blockpos.m_123343_() & 0xF));
        list.add(String.format(Locale.ROOT, "Chunk: %d %d %d [%d %d in r.%d.%d.mca]", chunkpos.f_45578_, SectionPos.m_123171_((int)blockpos.m_123342_()), chunkpos.f_45579_, chunkpos.m_45613_(), chunkpos.m_45614_(), chunkpos.m_45610_(), chunkpos.m_45612_()));
        list.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", direction, s1, Float.valueOf(Mth.m_14177_((float)entity.m_146908_())), Float.valueOf(Mth.m_14177_((float)entity.m_146909_()))));
        LevelChunk levelchunk = this.m_94085_();
        if (levelchunk.m_6430_()) {
            list.add("Waiting for chunk...");
        } else {
            int i = this.f_94030_.f_91073_.m_7726_().m_7827_().m_75831_(blockpos, 0);
            int j = this.f_94030_.f_91073_.m_45517_(LightLayer.SKY, blockpos);
            int k = this.f_94030_.f_91073_.m_45517_(LightLayer.BLOCK, blockpos);
            list.add("Client Light: " + i + " (" + j + " sky, " + k + " block)");
            LevelChunk levelchunk1 = this.m_94084_();
            StringBuilder stringbuilder = new StringBuilder("CH");
            for (Heightmap.Types heightmap$types : Heightmap.Types.values()) {
                if (!heightmap$types.m_64297_()) continue;
                stringbuilder.append(" ").append(f_94029_.get(heightmap$types)).append(": ").append(levelchunk.m_5885_(heightmap$types, blockpos.m_123341_(), blockpos.m_123343_()));
            }
            list.add(stringbuilder.toString());
            stringbuilder.setLength(0);
            stringbuilder.append("SH");
            for (Heightmap.Types heightmap$types1 : Heightmap.Types.values()) {
                if (!heightmap$types1.m_64298_()) continue;
                stringbuilder.append(" ").append(f_94029_.get(heightmap$types1)).append(": ");
                if (levelchunk1 != null) {
                    stringbuilder.append(levelchunk1.m_5885_(heightmap$types1, blockpos.m_123341_(), blockpos.m_123343_()));
                    continue;
                }
                stringbuilder.append("??");
            }
            list.add(stringbuilder.toString());
            if (blockpos.m_123342_() >= this.f_94030_.f_91073_.m_141937_() && blockpos.m_123342_() < this.f_94030_.f_91073_.m_151558_()) {
                list.add("Biome: " + DebugScreenOverlay.m_205374_(this.f_94030_.f_91073_.m_204166_(blockpos)));
                long l = 0L;
                float f2 = 0.0f;
                if (levelchunk1 != null) {
                    f2 = level.m_46940_();
                    l = levelchunk1.m_6319_();
                }
                DifficultyInstance difficultyinstance = new DifficultyInstance(level.m_46791_(), level.m_46468_(), l, f2);
                list.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(difficultyinstance.m_19056_()), Float.valueOf(difficultyinstance.m_19057_()), this.f_94030_.f_91073_.m_46468_() / 24000L));
            }
            if (levelchunk1 != null && levelchunk1.m_187675_()) {
                list.add("Blending: Old");
            }
        }
        ServerLevel serverlevel = this.m_94081_();
        if (serverlevel != null) {
            ServerChunkCache serverchunkcache = serverlevel.m_7726_();
            ChunkGenerator chunkgenerator = serverchunkcache.m_8481_();
            RandomState randomstate = serverchunkcache.m_214994_();
            chunkgenerator.m_213600_(list, randomstate, blockpos);
            Climate.Sampler climate$sampler = randomstate.m_224579_();
            BiomeSource biomesource = chunkgenerator.m_62218_();
            biomesource.m_207301_((List)list, blockpos, climate$sampler);
            NaturalSpawner.SpawnState naturalspawner$spawnstate = serverchunkcache.m_8485_();
            if (naturalspawner$spawnstate != null) {
                Object2IntMap<MobCategory> object2intmap = naturalspawner$spawnstate.m_47148_();
                int i1 = naturalspawner$spawnstate.m_47126_();
                list.add("SC: " + i1 + ", " + Stream.of(MobCategory.values()).map(p_94068_ -> Character.toUpperCase(p_94068_.m_21607_().charAt(0)) + ": " + object2intmap.getInt((Object)p_94068_)).collect(Collectors.joining(", ")));
            } else {
                list.add("SC: N/A");
            }
        }
        if ((postchain = this.f_94030_.f_91063_.m_109149_()) != null) {
            list.add("Shader: " + postchain.m_110022_());
        }
        list.add(this.f_94030_.m_91106_().m_120408_() + String.format(Locale.ROOT, " (Mood %d%%)", Math.round(this.f_94030_.f_91074_.m_108762_() * 100.0f)));
        return list;
    }

    private static String m_205374_(Holder<Biome> p_205375_) {
        return (String)p_205375_.m_203439_().map(p_205377_ -> p_205377_.m_135782_().toString(), p_205367_ -> "[unregistered " + p_205367_ + "]");
    }

    @Nullable
    private ServerLevel m_94081_() {
        IntegratedServer integratedserver = this.f_94030_.m_91092_();
        return integratedserver != null ? integratedserver.m_129880_(this.f_94030_.f_91073_.m_46472_()) : null;
    }

    @Nullable
    private String m_94082_() {
        ServerLevel serverlevel = this.m_94081_();
        return serverlevel != null ? serverlevel.m_46464_() : null;
    }

    private Level m_94083_() {
        return (Level)DataFixUtils.orElse(Optional.ofNullable(this.f_94030_.m_91092_()).flatMap(p_269612_ -> Optional.ofNullable(p_269612_.m_129880_(this.f_94030_.f_91073_.m_46472_()))), (Object)this.f_94030_.f_91073_);
    }

    @Nullable
    private LevelChunk m_94084_() {
        if (this.f_94036_ == null) {
            ServerLevel serverlevel = this.m_94081_();
            if (serverlevel != null) {
                this.f_94036_ = serverlevel.m_7726_().m_8431_(this.f_94034_.f_45578_, this.f_94034_.f_45579_, ChunkStatus.f_62326_, false).thenApply(p_205369_ -> (LevelChunk)p_205369_.map(p_205371_ -> (LevelChunk)p_205371_, p_205363_ -> null));
            }
            if (this.f_94036_ == null) {
                this.f_94036_ = CompletableFuture.completedFuture(this.m_94085_());
            }
        }
        return this.f_94036_.getNow(null);
    }

    private LevelChunk m_94085_() {
        if (this.f_94035_ == null) {
            this.f_94035_ = this.f_94030_.f_91073_.m_6325_(this.f_94034_.f_45578_, this.f_94034_.f_45579_);
        }
        return this.f_94035_;
    }

    protected List<String> m_94078_() {
        Entity entity;
        long i = Runtime.getRuntime().maxMemory();
        long j = Runtime.getRuntime().totalMemory();
        long k = Runtime.getRuntime().freeMemory();
        long l = j - k;
        ArrayList list = Lists.newArrayList((Object[])new String[]{String.format(Locale.ROOT, "Java: %s %dbit", System.getProperty("java.version"), this.f_94030_.m_91103_() ? 64 : 32), String.format(Locale.ROOT, "Mem: % 2d%% %03d/%03dMB", l * 100L / i, DebugScreenOverlay.m_94050_(l), DebugScreenOverlay.m_94050_(i)), String.format(Locale.ROOT, "Allocation rate: %03dMB /s", DebugScreenOverlay.m_94050_(this.f_232506_.m_232516_(l))), String.format(Locale.ROOT, "Allocated: % 2d%% %03dMB", j * 100L / i, DebugScreenOverlay.m_94050_(j)), "", String.format(Locale.ROOT, "CPU: %s", GlUtil.m_84819_()), "", String.format(Locale.ROOT, "Display: %dx%d (%s)", Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_(), GlUtil.m_84818_()), GlUtil.m_84820_(), GlUtil.m_84821_()});
        if (this.f_94030_.m_91299_()) {
            return list;
        }
        if (this.f_94032_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)this.f_94032_).m_82425_();
            BlockState blockstate = this.f_94030_.f_91073_.m_8055_(blockpos);
            list.add("");
            list.add(ChatFormatting.UNDERLINE + "Targeted Block: " + blockpos.m_123341_() + ", " + blockpos.m_123342_() + ", " + blockpos.m_123343_());
            list.add(String.valueOf(BuiltInRegistries.f_256975_.m_7981_((Object)blockstate.m_60734_())));
            for (Map.Entry entry : blockstate.m_61148_().entrySet()) {
                list.add(this.m_94071_(entry));
            }
            blockstate.m_204343_().map(p_205379_ -> "#" + p_205379_.f_203868_()).forEach(list::add);
        }
        if (this.f_94033_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos1 = ((BlockHitResult)this.f_94033_).m_82425_();
            FluidState fluidstate = this.f_94030_.f_91073_.m_6425_(blockpos1);
            list.add("");
            list.add(ChatFormatting.UNDERLINE + "Targeted Fluid: " + blockpos1.m_123341_() + ", " + blockpos1.m_123342_() + ", " + blockpos1.m_123343_());
            list.add(String.valueOf(BuiltInRegistries.f_257020_.m_7981_((Object)fluidstate.m_76152_())));
            for (Map.Entry entry1 : fluidstate.m_61148_().entrySet()) {
                list.add(this.m_94071_(entry1));
            }
            fluidstate.m_205075_().map(p_205365_ -> "#" + p_205365_.f_203868_()).forEach(list::add);
        }
        if ((entity = this.f_94030_.f_91076_) != null) {
            list.add("");
            list.add(ChatFormatting.UNDERLINE + "Targeted Entity");
            list.add(String.valueOf(BuiltInRegistries.f_256780_.m_7981_(entity.m_6095_())));
            entity.m_6095_().m_204041_().m_203616_().forEach(t -> list.add("#" + t.f_203868_()));
        }
        return list;
    }

    private String m_94071_(Map.Entry<Property<?>, Comparable<?>> p_94072_) {
        Property<?> property = p_94072_.getKey();
        Comparable<?> comparable = p_94072_.getValue();
        Object s = Util.m_137453_(property, comparable);
        if (Boolean.TRUE.equals(comparable)) {
            s = ChatFormatting.GREEN + (String)s;
        } else if (Boolean.FALSE.equals(comparable)) {
            s = ChatFormatting.RED + (String)s;
        }
        return property.m_61708_() + ": " + (String)s;
    }

    private void m_94058_(PoseStack p_94059_, FrameTimer p_94060_, int p_94061_, int p_94062_, boolean p_94063_) {
        RenderSystem.m_69465_();
        int i = p_94060_.m_13754_();
        int j = p_94060_.m_13761_();
        long[] along = p_94060_.m_13764_();
        int l = p_94061_;
        int i1 = Math.max(0, along.length - p_94062_);
        int j1 = along.length - i1;
        int $$8 = p_94060_.m_13762_(i + i1);
        long k1 = 0L;
        int l1 = Integer.MAX_VALUE;
        int i2 = Integer.MIN_VALUE;
        for (int j2 = 0; j2 < j1; ++j2) {
            int k2 = (int)(along[p_94060_.m_13762_($$8 + j2)] / 1000000L);
            l1 = Math.min(l1, k2);
            i2 = Math.max(i2, k2);
            k1 += (long)k2;
        }
        int k4 = this.f_94030_.m_91268_().m_85446_();
        DebugScreenOverlay.m_93172_((PoseStack)p_94059_, (int)p_94061_, (int)(k4 - 60), (int)(p_94061_ + j1), (int)k4, (int)-1873784752);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = Transformation.m_121093_().m_252783_();
        while ($$8 != j) {
            int l2 = p_94060_.m_13757_(along[$$8], p_94063_ ? 30 : 60, p_94063_ ? 60 : 20);
            int i3 = p_94063_ ? 100 : 60;
            int j3 = this.m_94045_(Mth.m_14045_((int)l2, (int)0, (int)i3), 0, i3 / 2, i3);
            int k3 = j3 >> 24 & 0xFF;
            int l3 = j3 >> 16 & 0xFF;
            int i4 = j3 >> 8 & 0xFF;
            int j4 = j3 & 0xFF;
            bufferbuilder.m_252986_(matrix4f, l + 1, k4, 0.0f).m_6122_(l3, i4, j4, k3).m_5752_();
            bufferbuilder.m_252986_(matrix4f, l + 1, k4 - l2 + 1, 0.0f).m_6122_(l3, i4, j4, k3).m_5752_();
            bufferbuilder.m_252986_(matrix4f, l, k4 - l2 + 1, 0.0f).m_6122_(l3, i4, j4, k3).m_5752_();
            bufferbuilder.m_252986_(matrix4f, l, k4, 0.0f).m_6122_(l3, i4, j4, k3).m_5752_();
            ++l;
            $$8 = p_94060_.m_13762_($$8 + 1);
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.m_69461_();
        if (p_94063_) {
            DebugScreenOverlay.m_93172_((PoseStack)p_94059_, (int)(p_94061_ + 1), (int)(k4 - 30 + 1), (int)(p_94061_ + 14), (int)(k4 - 30 + 10), (int)-1873784752);
            this.f_94031_.m_92883_(p_94059_, "60 FPS", p_94061_ + 2, k4 - 30 + 2, 0xE0E0E0);
            DebugScreenOverlay.m_93154_((PoseStack)p_94059_, (int)p_94061_, (int)(p_94061_ + j1 - 1), (int)(k4 - 30), (int)-1);
            DebugScreenOverlay.m_93172_((PoseStack)p_94059_, (int)(p_94061_ + 1), (int)(k4 - 60 + 1), (int)(p_94061_ + 14), (int)(k4 - 60 + 10), (int)-1873784752);
            this.f_94031_.m_92883_(p_94059_, "30 FPS", p_94061_ + 2, k4 - 60 + 2, 0xE0E0E0);
            DebugScreenOverlay.m_93154_((PoseStack)p_94059_, (int)p_94061_, (int)(p_94061_ + j1 - 1), (int)(k4 - 60), (int)-1);
        } else {
            DebugScreenOverlay.m_93172_((PoseStack)p_94059_, (int)(p_94061_ + 1), (int)(k4 - 60 + 1), (int)(p_94061_ + 14), (int)(k4 - 60 + 10), (int)-1873784752);
            this.f_94031_.m_92883_(p_94059_, "20 TPS", p_94061_ + 2, k4 - 60 + 2, 0xE0E0E0);
            DebugScreenOverlay.m_93154_((PoseStack)p_94059_, (int)p_94061_, (int)(p_94061_ + j1 - 1), (int)(k4 - 60), (int)-1);
        }
        DebugScreenOverlay.m_93154_((PoseStack)p_94059_, (int)p_94061_, (int)(p_94061_ + j1 - 1), (int)(k4 - 1), (int)-1);
        DebugScreenOverlay.m_93222_((PoseStack)p_94059_, (int)p_94061_, (int)(k4 - 60), (int)k4, (int)-1);
        DebugScreenOverlay.m_93222_((PoseStack)p_94059_, (int)(p_94061_ + j1 - 1), (int)(k4 - 60), (int)k4, (int)-1);
        int l4 = (Integer)this.f_94030_.f_91066_.m_232035_().m_231551_();
        if (p_94063_ && l4 > 0 && l4 <= 250) {
            DebugScreenOverlay.m_93154_((PoseStack)p_94059_, (int)p_94061_, (int)(p_94061_ + j1 - 1), (int)(k4 - 1 - (int)(1800.0 / (double)l4)), (int)-16711681);
        }
        String s = l1 + " ms min";
        String s1 = k1 / (long)j1 + " ms avg";
        String s2 = i2 + " ms max";
        this.f_94031_.m_92750_(p_94059_, s, p_94061_ + 2, k4 - 60 - 9, 0xE0E0E0);
        this.f_94031_.m_92750_(p_94059_, s1, p_94061_ + j1 / 2 - this.f_94031_.m_92895_(s1) / 2, k4 - 60 - 9, 0xE0E0E0);
        this.f_94031_.m_92750_(p_94059_, s2, p_94061_ + j1 - this.f_94031_.m_92895_(s2), k4 - 60 - 9, 0xE0E0E0);
        RenderSystem.m_69482_();
    }

    private int m_94045_(int p_94046_, int p_94047_, int p_94048_, int p_94049_) {
        return p_94046_ < p_94048_ ? this.m_94041_(-16711936, -256, (float)p_94046_ / (float)p_94048_) : this.m_94041_(-256, -65536, (float)(p_94046_ - p_94048_) / (float)(p_94049_ - p_94048_));
    }

    private int m_94041_(int p_94042_, int p_94043_, float p_94044_) {
        int i = p_94042_ >> 24 & 0xFF;
        int j = p_94042_ >> 16 & 0xFF;
        int k = p_94042_ >> 8 & 0xFF;
        int l = p_94042_ & 0xFF;
        int i1 = p_94043_ >> 24 & 0xFF;
        int j1 = p_94043_ >> 16 & 0xFF;
        int k1 = p_94043_ >> 8 & 0xFF;
        int l1 = p_94043_ & 0xFF;
        int i2 = Mth.m_14045_((int)((int)Mth.m_14179_((float)p_94044_, (float)i, (float)i1)), (int)0, (int)255);
        int j2 = Mth.m_14045_((int)((int)Mth.m_14179_((float)p_94044_, (float)j, (float)j1)), (int)0, (int)255);
        int k2 = Mth.m_14045_((int)((int)Mth.m_14179_((float)p_94044_, (float)k, (float)k1)), (int)0, (int)255);
        int l2 = Mth.m_14045_((int)((int)Mth.m_14179_((float)p_94044_, (float)l, (float)l1)), (int)0, (int)255);
        return i2 << 24 | j2 << 16 | k2 << 8 | l2;
    }

    private static long m_94050_(long p_94051_) {
        return p_94051_ / 1024L / 1024L;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AllocationRateCalculator {
        private static final int f_232507_ = 500;
        private static final List<GarbageCollectorMXBean> f_232508_ = ManagementFactory.getGarbageCollectorMXBeans();
        private long f_232509_ = 0L;
        private long f_232510_ = -1L;
        private long f_232511_ = -1L;
        private long f_232512_ = 0L;

        AllocationRateCalculator() {
        }

        long m_232516_(long p_232517_) {
            long i = System.currentTimeMillis();
            if (i - this.f_232509_ < 500L) {
                return this.f_232512_;
            }
            long j = AllocationRateCalculator.m_232515_();
            if (this.f_232509_ != 0L && j == this.f_232511_) {
                double d0 = (double)TimeUnit.SECONDS.toMillis(1L) / (double)(i - this.f_232509_);
                long k = p_232517_ - this.f_232510_;
                this.f_232512_ = Math.round((double)k * d0);
            }
            this.f_232509_ = i;
            this.f_232510_ = p_232517_;
            this.f_232511_ = j;
            return this.f_232512_;
        }

        private static long m_232515_() {
            long i = 0L;
            for (GarbageCollectorMXBean garbagecollectormxbean : f_232508_) {
                i += garbagecollectormxbean.getCollectionCount();
            }
            return i;
        }
    }
}

