/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.OptimizeWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EditWorldScreen
extends Screen {
    private static final Logger f_101243_ = LogUtils.getLogger();
    private static final Component f_101245_ = Component.m_237115_("selectWorld.enterName");
    private Button f_101246_;
    private final BooleanConsumer f_101247_;
    private EditBox f_101248_;
    private final LevelStorageSource.LevelStorageAccess f_101249_;

    public EditWorldScreen(BooleanConsumer p_101252_, LevelStorageSource.LevelStorageAccess p_101253_) {
        super((Component)Component.m_237115_("selectWorld.edit.title"));
        this.f_101247_ = p_101252_;
        this.f_101249_ = p_101253_;
    }

    @Override
    public void m_86600_() {
        this.f_101248_.m_94120_();
    }

    @Override
    protected void m_7856_() {
        this.f_101246_ = Button.m_253074_((Component)Component.m_237115_("selectWorld.edit.save"), p_101280_ -> this.m_101295_()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 144 + 5, 98, 20).m_253136_();
        this.f_101248_ = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 38, 200, 20, (Component)Component.m_237115_("selectWorld.enterName"));
        LevelSummary levelsummary = this.f_101249_.m_78308_();
        String s = levelsummary == null ? "" : levelsummary.m_78361_();
        this.f_101248_.m_94144_(s);
        this.f_101248_.m_94151_(p_275877_ -> {
            this.f_101246_.f_93623_ = !p_275877_.trim().isEmpty();
        });
        this.m_7787_(this.f_101248_);
        Button button = this.m_142416_(Button.m_253074_((Component)Component.m_237115_("selectWorld.edit.resetIcon"), p_275878_ -> {
            this.f_101249_.m_182514_().ifPresent(p_182594_ -> FileUtils.deleteQuietly((File)p_182594_.toFile()));
            p_275878_.f_93623_ = false;
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 0 + 5, 200, 20).m_253136_());
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_("selectWorld.edit.openFolder"), p_101294_ -> Util.m_137581_().m_137644_(this.f_101249_.m_78283_(LevelResource.f_78182_).toFile())).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 24 + 5, 200, 20).m_253136_());
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_("selectWorld.edit.backup"), p_101292_ -> {
            boolean flag = EditWorldScreen.m_101258_(this.f_101249_);
            this.f_101247_.accept(!flag);
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 48 + 5, 200, 20).m_253136_());
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_("selectWorld.edit.backupFolder"), p_101290_ -> {
            LevelStorageSource levelstoragesource = this.f_96541_.m_91392_();
            Path path = levelstoragesource.m_78262_();
            try {
                FileUtil.m_257659_((Path)path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Util.m_137581_().m_137644_(path.toFile());
        }).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 72 + 5, 200, 20).m_253136_());
        this.m_142416_(Button.m_253074_((Component)Component.m_237115_("selectWorld.edit.optimize"), p_101287_ -> this.f_96541_.m_91152_((Screen)new BackupConfirmScreen((Screen)this, (p_170235_, p_170236_) -> {
            if (p_170235_) {
                EditWorldScreen.m_101258_(this.f_101249_);
            }
            this.f_96541_.m_91152_((Screen)OptimizeWorldScreen.m_101315_((Minecraft)this.f_96541_, (BooleanConsumer)this.f_101247_, (DataFixer)this.f_96541_.m_91295_(), (LevelStorageSource.LevelStorageAccess)this.f_101249_, (boolean)p_170236_));
        }, (Component)Component.m_237115_("optimizeWorld.confirm.title"), (Component)Component.m_237115_("optimizeWorld.confirm.description"), true))).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 96 + 5, 200, 20).m_253136_());
        this.m_142416_(this.f_101246_);
        this.m_142416_(Button.m_253074_(CommonComponents.f_130656_, p_101273_ -> this.f_101247_.accept(false)).m_252987_(this.f_96543_ / 2 + 2, this.f_96544_ / 4 + 144 + 5, 98, 20).m_253136_());
        button.f_93623_ = this.f_101249_.m_182514_().filter(p_182587_ -> Files.isRegularFile(p_182587_, new LinkOption[0])).isPresent();
        this.m_264313_((GuiEventListener)this.f_101248_);
    }

    @Override
    public void m_6574_(Minecraft p_101269_, int p_101270_, int p_101271_) {
        String s = this.f_101248_.m_94155_();
        this.m_6575_(p_101269_, p_101270_, p_101271_);
        this.f_101248_.m_94144_(s);
    }

    @Override
    public void m_7379_() {
        this.f_101247_.accept(false);
    }

    private void m_101295_() {
        try {
            this.f_101249_.m_78297_(this.f_101248_.m_94155_().trim());
            this.f_101247_.accept(true);
        }
        catch (IOException ioexception) {
            f_101243_.error("Failed to access world '{}'", (Object)this.f_101249_.m_78277_(), (Object)ioexception);
            SystemToast.m_94852_((Minecraft)this.f_96541_, (String)this.f_101249_.m_78277_());
            this.f_101247_.accept(true);
        }
    }

    public static void m_101260_(LevelStorageSource p_101261_, String p_101262_) {
        boolean flag = false;
        try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = p_101261_.m_78260_(p_101262_);){
            flag = true;
            EditWorldScreen.m_101258_(levelstoragesource$levelstorageaccess);
        }
        catch (IOException ioexception) {
            if (!flag) {
                SystemToast.m_94852_((Minecraft)Minecraft.m_91087_(), (String)p_101262_);
            }
            f_101243_.warn("Failed to create backup of level {}", (Object)p_101262_, (Object)ioexception);
        }
    }

    public static boolean m_101258_(LevelStorageSource.LevelStorageAccess p_101259_) {
        long i = 0L;
        IOException ioexception = null;
        try {
            i = p_101259_.m_78312_();
        }
        catch (IOException ioexception1) {
            ioexception = ioexception1;
        }
        if (ioexception != null) {
            MutableComponent component2 = Component.m_237115_("selectWorld.edit.backupFailed");
            MutableComponent component3 = Component.m_237113_(ioexception.getMessage());
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, (Component)component2, (Component)component3));
            return false;
        }
        MutableComponent component = Component.m_237110_("selectWorld.edit.backupCreated", p_101259_.m_78277_());
        MutableComponent component1 = Component.m_237110_("selectWorld.edit.backupSize", Mth.m_14165_((double)((double)i / 1048576.0)));
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, (Component)component, (Component)component1));
        return true;
    }

    @Override
    public void m_86412_(PoseStack p_101264_, int p_101265_, int p_101266_, float p_101267_) {
        this.m_7333_(p_101264_);
        EditWorldScreen.m_93215_((PoseStack)p_101264_, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        EditWorldScreen.m_93243_((PoseStack)p_101264_, (Font)this.f_96547_, (Component)f_101245_, (int)(this.f_96543_ / 2 - 100), (int)24, (int)0xA0A0A0);
        this.f_101248_.m_86412_(p_101264_, p_101265_, p_101266_, p_101267_);
        super.m_86412_(p_101264_, p_101265_, p_101266_, p_101267_);
    }
}

