/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.DatapackLoadFailureScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class WorldOpenFlows {
    private static final Logger f_233088_ = LogUtils.getLogger();
    private final Minecraft f_233089_;
    private final LevelStorageSource f_233090_;

    public WorldOpenFlows(Minecraft p_233093_, LevelStorageSource p_233094_) {
        this.f_233089_ = p_233093_;
        this.f_233090_ = p_233094_;
    }

    public void m_233133_(Screen p_233134_, String p_233135_) {
        this.m_233145_(p_233134_, p_233135_, false, true);
    }

    public void m_233157_(String p_233158_, LevelSettings p_233159_, WorldOptions p_249243_, Function<RegistryAccess, WorldDimensions> p_249252_) {
        LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.m_233155_(p_233158_);
        if (levelstoragesource$levelstorageaccess != null) {
            PackRepository packrepository = ServerPacksSource.m_247728_(levelstoragesource$levelstorageaccess);
            WorldDataConfiguration worlddataconfiguration = p_233159_.m_246291_();
            try {
                WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(packrepository, worlddataconfiguration, false, false);
                WorldStem worldstem = this.m_246486_(worldloader$packconfig, p_258145_ -> {
                    WorldDimensions.Complete worlddimensions$complete = ((WorldDimensions)p_249252_.apply((RegistryAccess)p_258145_.f_244104_())).m_245300_(p_258145_.f_243759_().m_175515_(Registries.f_256862_));
                    return new WorldLoader.DataLoadOutput<PrimaryLevelData>(new PrimaryLevelData(p_233159_, p_249243_, worlddimensions$complete.f_244634_(), worlddimensions$complete.m_245945_()), worlddimensions$complete.m_245593_());
                }, WorldStem::new);
                this.f_233089_.m_261031_(p_233158_, levelstoragesource$levelstorageaccess, packrepository, worldstem, true);
            }
            catch (Exception exception) {
                f_233088_.warn("Failed to load datapacks, can't proceed with server load", (Throwable)exception);
                WorldOpenFlows.m_233116_(levelstoragesource$levelstorageaccess, p_233158_);
            }
        }
    }

    @Nullable
    private LevelStorageSource.LevelStorageAccess m_233155_(String p_233156_) {
        try {
            return this.f_233090_.m_78260_(p_233156_);
        }
        catch (IOException ioexception) {
            f_233088_.warn("Failed to read level {} data", (Object)p_233156_, (Object)ioexception);
            SystemToast.m_94852_((Minecraft)this.f_233089_, (String)p_233156_);
            this.f_233089_.m_91152_(null);
            return null;
        }
    }

    public void m_245064_(LevelStorageSource.LevelStorageAccess p_250919_, ReloadableServerResources p_248897_, LayeredRegistryAccess<RegistryLayer> p_250801_, WorldData p_251654_) {
        PackRepository packrepository = ServerPacksSource.m_247728_(p_250919_);
        CloseableResourceManager closeableresourcemanager = (CloseableResourceManager)new WorldLoader.PackConfig(packrepository, p_251654_.m_6645_(), false, false).m_214399_().getSecond();
        this.f_233089_.m_261031_(p_250919_.m_78277_(), p_250919_, packrepository, new WorldStem(closeableresourcemanager, p_248897_, p_250801_, p_251654_), true);
    }

    private WorldStem m_233122_(LevelStorageSource.LevelStorageAccess p_233123_, boolean p_233124_, PackRepository p_233125_) throws Exception {
        WorldLoader.PackConfig worldloader$packconfig = this.m_247188_(p_233123_, p_233124_, p_233125_);
        return this.m_246486_(worldloader$packconfig, p_247851_ -> {
            RegistryOps dynamicops = RegistryOps.m_255058_(NbtOps.f_128958_, (HolderLookup.Provider)p_247851_.f_244104_());
            Registry registry = p_247851_.f_243759_().m_175515_(Registries.f_256862_);
            Pair<WorldData, WorldDimensions.Complete> pair = p_233123_.m_246049_((DynamicOps<Tag>)dynamicops, p_247851_.f_244127_(), (Registry<LevelStem>)registry, p_247851_.f_244104_().m_211816_());
            if (pair == null) {
                throw new IllegalStateException("Failed to load world");
            }
            return new WorldLoader.DataLoadOutput<WorldData>((WorldData)pair.getFirst(), ((WorldDimensions.Complete)pair.getSecond()).m_245593_());
        }, WorldStem::new);
    }

    public Pair<LevelSettings, WorldCreationContext> m_246225_(LevelStorageSource.LevelStorageAccess p_249540_) throws Exception {
        @OnlyIn(value=Dist.CLIENT)
        record Data(LevelSettings f_244166_, WorldOptions f_244534_, Registry<LevelStem> f_244151_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "levelSettings;options;existingDimensions", "f_244166_", "f_244534_", "f_244151_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "levelSettings;options;existingDimensions", "f_244166_", "f_244534_", "f_244151_"}, this);
            }

            @Override
            public final boolean equals(Object p_249359_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "levelSettings;options;existingDimensions", "f_244166_", "f_244534_", "f_244151_"}, this, p_249359_);
            }
        }
        PackRepository packrepository = ServerPacksSource.m_247728_(p_249540_);
        WorldLoader.PackConfig worldloader$packconfig = this.m_247188_(p_249540_, false, packrepository);
        return this.m_246486_(worldloader$packconfig, p_247857_ -> {
            RegistryOps dynamicops = RegistryOps.m_255058_(NbtOps.f_128958_, (HolderLookup.Provider)p_247857_.f_244104_());
            Registry registry = new MappedRegistry(Registries.f_256862_, Lifecycle.stable()).m_203521_();
            Pair<WorldData, WorldDimensions.Complete> pair = p_249540_.m_246049_((DynamicOps<Tag>)dynamicops, p_247857_.f_244127_(), (Registry<LevelStem>)registry, p_247857_.f_244104_().m_211816_());
            if (pair == null) {
                throw new IllegalStateException("Failed to load world");
            }
            return new WorldLoader.DataLoadOutput<Data>(new Data(((WorldData)pair.getFirst()).m_5926_(), ((WorldData)pair.getFirst()).m_246337_(), (Registry<LevelStem>)((WorldDimensions.Complete)pair.getSecond()).f_244049_()), p_247857_.f_243759_());
        }, (p_247840_, p_247841_, p_247842_, p_247843_) -> {
            p_247840_.close();
            return Pair.of((Object)p_247843_.f_244166_, (Object)new WorldCreationContext(p_247843_.f_244534_, new WorldDimensions(p_247843_.f_244151_), (LayeredRegistryAccess<RegistryLayer>)p_247842_, p_247841_, p_247843_.f_244166_.m_246291_()));
        });
    }

    private WorldLoader.PackConfig m_247188_(LevelStorageSource.LevelStorageAccess p_249986_, boolean p_248615_, PackRepository p_249167_) {
        WorldDataConfiguration worlddataconfiguration = p_249986_.m_247706_();
        if (worlddataconfiguration == null) {
            throw new IllegalStateException("Failed to load data pack config");
        }
        return new WorldLoader.PackConfig(p_249167_, worlddataconfiguration, p_248615_, false);
    }

    public WorldStem m_233119_(LevelStorageSource.LevelStorageAccess p_233120_, boolean p_233121_) throws Exception {
        PackRepository packrepository = ServerPacksSource.m_247728_(p_233120_);
        return this.m_233122_(p_233120_, p_233121_, packrepository);
    }

    private <D, R> R m_246486_(WorldLoader.PackConfig p_250997_, WorldLoader.WorldDataSupplier<D> p_251759_, WorldLoader.ResultFactory<D, R> p_249635_) throws Exception {
        WorldLoader.InitConfig worldloader$initconfig = new WorldLoader.InitConfig(p_250997_, Commands.CommandSelection.INTEGRATED, 2);
        CompletableFuture<R> completablefuture = WorldLoader.m_214362_(worldloader$initconfig, p_251759_, p_249635_, Util.m_183991_(), (Executor)((Object)this.f_233089_));
        this.f_233089_.m_18701_(completablefuture::isDone);
        return completablefuture.get();
    }

    private void m_233145_(Screen p_233146_, String p_233147_, boolean p_233148_, boolean p_233149_) {
        this.doLoadLevel(p_233146_, p_233147_, p_233148_, p_233149_, false);
    }

    private void doLoadLevel(Screen p_233146_, String p_233147_, boolean p_233148_, boolean p_233149_, boolean confirmExperimentalWarning) {
        LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.m_233155_(p_233147_);
        if (levelstoragesource$levelstorageaccess != null) {
            PrimaryLevelData pld;
            boolean skipConfirmation;
            WorldStem worldstem;
            PackRepository packrepository = ServerPacksSource.m_247728_(levelstoragesource$levelstorageaccess);
            try {
                WorldData worldData;
                levelstoragesource$levelstorageaccess.readAdditionalLevelSaveData();
                worldstem = this.m_233122_(levelstoragesource$levelstorageaccess, p_233148_, packrepository);
                if (confirmExperimentalWarning && (worldData = worldstem.f_206895_()) instanceof PrimaryLevelData) {
                    PrimaryLevelData pld2 = (PrimaryLevelData)worldData;
                    pld2.withConfirmedWarning(true);
                }
            }
            catch (Exception exception) {
                f_233088_.warn("Failed to load level data or datapacks, can't proceed with server load", (Throwable)exception);
                if (!p_233148_) {
                    this.f_233089_.m_91152_((Screen)new DatapackLoadFailureScreen(() -> this.m_233145_(p_233146_, p_233147_, true, p_233149_)));
                } else {
                    this.f_233089_.m_91152_((Screen)new AlertScreen(() -> this.f_233089_.m_91152_(null), (Component)Component.m_237115_("datapackFailure.safeMode.failed.title"), (Component)Component.m_237115_("datapackFailure.safeMode.failed.description"), CommonComponents.f_275759_, true));
                }
                WorldOpenFlows.m_233116_(levelstoragesource$levelstorageaccess, p_233147_);
                return;
            }
            WorldData worlddata = worldstem.f_206895_();
            boolean flag = worlddata.m_246337_().m_247070_();
            boolean flag1 = worlddata.m_5754_() != Lifecycle.stable();
            boolean bl = skipConfirmation = worlddata instanceof PrimaryLevelData && (pld = (PrimaryLevelData)worlddata).hasConfirmedExperimentalWarning();
            if (skipConfirmation || !p_233149_ || !flag && !flag1) {
                ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.f_233089_.m_247489_().m_247400_(levelstoragesource$levelstorageaccess).thenApply(p_233177_ -> true)).exceptionallyComposeAsync(p_233183_ -> {
                    f_233088_.warn("Failed to load pack: ", p_233183_);
                    return this.m_233095_();
                }, (Executor)((Object)this.f_233089_))).thenAcceptAsync(p_233168_ -> {
                    if (p_233168_.booleanValue()) {
                        this.f_233089_.m_261031_(p_233147_, levelstoragesource$levelstorageaccess, packrepository, worldstem, false);
                    } else {
                        worldstem.close();
                        WorldOpenFlows.m_233116_(levelstoragesource$levelstorageaccess, p_233147_);
                        this.f_233089_.m_247489_().m_246151_().thenRunAsync(() -> this.f_233089_.m_91152_(p_233146_), (Executor)((Object)this.f_233089_));
                    }
                }, (Executor)((Object)this.f_233089_))).exceptionally(p_233175_ -> {
                    this.f_233089_.m_231412_(CrashReport.m_127521_(p_233175_, "Load world"));
                    return null;
                });
            } else {
                if (flag) {
                    this.m_233140_(p_233146_, p_233147_, flag, () -> this.m_233145_(p_233146_, p_233147_, p_233148_, false));
                } else {
                    ForgeHooksClient.createWorldConfirmationScreen(() -> this.doLoadLevel(p_233146_, p_233147_, p_233148_, false, true));
                }
                worldstem.close();
                WorldOpenFlows.m_233116_(levelstoragesource$levelstorageaccess, p_233147_);
            }
        }
    }

    private CompletableFuture<Boolean> m_233095_() {
        CompletableFuture<Boolean> completablefuture = new CompletableFuture<Boolean>();
        this.f_233089_.m_91152_((Screen)new ConfirmScreen(completablefuture::complete, (Component)Component.m_237115_("multiplayer.texturePrompt.failure.line1"), (Component)Component.m_237115_("multiplayer.texturePrompt.failure.line2"), CommonComponents.f_130659_, CommonComponents.f_130656_));
        return completablefuture;
    }

    private static void m_233116_(LevelStorageSource.LevelStorageAccess p_233117_, String p_233118_) {
        try {
            p_233117_.close();
        }
        catch (IOException ioexception) {
            f_233088_.warn("Failed to unlock access to level {}", (Object)p_233118_, (Object)ioexception);
        }
    }

    private void m_233140_(Screen p_233141_, String p_233142_, boolean p_233143_, Runnable p_233144_) {
        MutableComponent component1;
        MutableComponent component;
        if (p_233143_) {
            component = Component.m_237115_("selectWorld.backupQuestion.customized");
            component1 = Component.m_237115_("selectWorld.backupWarning.customized");
        } else {
            component = Component.m_237115_("selectWorld.backupQuestion.experimental");
            component1 = Component.m_237115_("selectWorld.backupWarning.experimental");
        }
        this.f_233089_.m_91152_((Screen)new BackupConfirmScreen(p_233141_, (p_233172_, p_233173_) -> {
            if (p_233172_) {
                EditWorldScreen.m_101260_(this.f_233090_, p_233142_);
            }
            p_233144_.run();
        }, (Component)component, (Component)component1, false));
    }

    public static void m_269260_(Minecraft p_270593_, CreateWorldScreen p_270733_, Lifecycle p_270539_, Runnable p_270158_, boolean p_270709_) {
        BooleanConsumer booleanconsumer = p_233154_ -> {
            if (p_233154_) {
                p_270158_.run();
            } else {
                p_270593_.m_91152_(p_270733_);
            }
        };
        if (!p_270709_ && p_270539_ != Lifecycle.stable()) {
            if (p_270539_ == Lifecycle.experimental()) {
                p_270593_.m_91152_((Screen)new ConfirmScreen(booleanconsumer, (Component)Component.m_237115_("selectWorld.warning.experimental.title"), (Component)Component.m_237115_("selectWorld.warning.experimental.question")));
            } else {
                p_270593_.m_91152_((Screen)new ConfirmScreen(booleanconsumer, (Component)Component.m_237115_("selectWorld.warning.deprecated.title"), (Component)Component.m_237115_("selectWorld.warning.deprecated.question")));
            }
        } else {
            p_270158_.run();
        }
    }
}

