/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.LiquidBlockRenderer;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.lighting.ForgeModelBlockRenderer;

@OnlyIn(value=Dist.CLIENT)
public class BlockRenderDispatcher
implements ResourceManagerReloadListener {
    private final BlockModelShaper f_110899_;
    private final ModelBlockRenderer f_110900_;
    private final BlockEntityWithoutLevelRenderer f_173397_;
    private final LiquidBlockRenderer f_110901_;
    private final RandomSource f_110902_ = RandomSource.m_216327_();
    private final BlockColors f_110903_;

    public BlockRenderDispatcher(BlockModelShaper p_173399_, BlockEntityWithoutLevelRenderer p_173400_, BlockColors p_173401_) {
        this.f_110899_ = p_173399_;
        this.f_173397_ = p_173400_;
        this.f_110903_ = p_173401_;
        this.f_110900_ = new ForgeModelBlockRenderer(this.f_110903_);
        this.f_110901_ = new LiquidBlockRenderer();
    }

    public BlockModelShaper m_110907_() {
        return this.f_110899_;
    }

    @Deprecated
    public void m_110918_(BlockState p_110919_, BlockPos p_110920_, BlockAndTintGetter p_110921_, PoseStack p_110922_, VertexConsumer p_110923_) {
        this.renderBreakingTexture(p_110919_, p_110920_, p_110921_, p_110922_, p_110923_, ModelData.EMPTY);
    }

    public void renderBreakingTexture(BlockState p_110919_, BlockPos p_110920_, BlockAndTintGetter p_110921_, PoseStack p_110922_, VertexConsumer p_110923_, ModelData modelData) {
        if (p_110919_.m_60799_() == RenderShape.MODEL) {
            BakedModel bakedmodel = this.f_110899_.m_110893_(p_110919_);
            long i = p_110919_.m_60726_(p_110920_);
            this.f_110900_.tesselateBlock(p_110921_, bakedmodel, p_110919_, p_110920_, p_110922_, p_110923_, true, this.f_110902_, i, OverlayTexture.f_118083_, modelData, null);
        }
    }

    @Deprecated
    public void m_234355_(BlockState p_234356_, BlockPos p_234357_, BlockAndTintGetter p_234358_, PoseStack p_234359_, VertexConsumer p_234360_, boolean p_234361_, RandomSource p_234362_) {
        this.renderBatched(p_234356_, p_234357_, p_234358_, p_234359_, p_234360_, p_234361_, p_234362_, ModelData.EMPTY, null);
    }

    public void renderBatched(BlockState p_234356_, BlockPos p_234357_, BlockAndTintGetter p_234358_, PoseStack p_234359_, VertexConsumer p_234360_, boolean p_234361_, RandomSource p_234362_, ModelData modelData, RenderType renderType) {
        this.renderBatched(p_234356_, p_234357_, p_234358_, p_234359_, p_234360_, p_234361_, p_234362_, modelData, renderType, true);
    }

    public void renderBatched(BlockState p_234356_, BlockPos p_234357_, BlockAndTintGetter p_234358_, PoseStack p_234359_, VertexConsumer p_234360_, boolean p_234361_, RandomSource p_234362_, ModelData modelData, RenderType renderType, boolean queryModelSpecificData) {
        try {
            RenderShape rendershape = p_234356_.m_60799_();
            if (rendershape == RenderShape.MODEL) {
                this.f_110900_.tesselateBlock(p_234358_, this.m_110910_(p_234356_), p_234356_, p_234357_, p_234359_, p_234360_, p_234361_, p_234362_, p_234356_.m_60726_(p_234357_), OverlayTexture.f_118083_, modelData, renderType, queryModelSpecificData);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tesselated");
            CrashReportCategory.m_178950_(crashreportcategory, p_234358_, p_234357_, p_234356_);
            throw new ReportedException(crashreport);
        }
    }

    public void m_234363_(BlockPos p_234364_, BlockAndTintGetter p_234365_, VertexConsumer p_234366_, BlockState p_234367_, FluidState p_234368_) {
        try {
            this.f_110901_.m_234369_(p_234365_, p_234364_, p_234366_, p_234367_, p_234368_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Tesselating liquid in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tesselated");
            CrashReportCategory.m_178950_(crashreportcategory, p_234365_, p_234364_, null);
            throw new ReportedException(crashreport);
        }
    }

    public ModelBlockRenderer m_110937_() {
        return this.f_110900_;
    }

    public BakedModel m_110910_(BlockState p_110911_) {
        return this.f_110899_.m_110893_(p_110911_);
    }

    @Deprecated
    public void m_110912_(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_) {
        this.renderSingleBlock(p_110913_, p_110914_, p_110915_, p_110916_, p_110917_, ModelData.EMPTY, null);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, RenderType renderType) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BakedModel bakedmodel = this.m_110910_(p_110913_);
                    int i = this.f_110903_.m_92577_(p_110913_, null, null, 0);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    for (RenderType rt : bakedmodel.getRenderTypes(p_110913_, RandomSource.m_216335_((long)42L), modelData)) {
                        this.f_110900_.renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, rt);
                    }
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack(p_110913_.m_60734_());
                    IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }

    public void m_6213_(ResourceManager p_110909_) {
        this.f_110901_.m_110944_();
    }
}

