/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ForgeFaceData;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class BlockElement {
    private static final boolean f_173411_ = false;
    private static final float f_173412_ = -16.0f;
    private static final float f_173413_ = 32.0f;
    public final Vector3f f_111308_;
    public final Vector3f f_111309_;
    public final Map<Direction, BlockElementFace> f_111310_;
    public final BlockElementRotation f_111311_;
    public final boolean f_111312_;
    @Deprecated
    public ForgeFaceData faceData;

    public BlockElement(Vector3f p_253626_, Vector3f p_254426_, Map<Direction, BlockElementFace> p_254454_, @Nullable BlockElementRotation p_254229_, boolean p_253661_) {
        this(p_253626_, p_254426_, p_254454_, p_254229_, p_253661_, ForgeFaceData.DEFAULT);
    }

    public BlockElement(Vector3f p_253626_, Vector3f p_254426_, Map<Direction, BlockElementFace> p_254454_, @Nullable BlockElementRotation p_254229_, boolean p_253661_, ForgeFaceData faceData) {
        this.f_111308_ = p_253626_;
        this.f_111309_ = p_254426_;
        this.f_111310_ = p_254454_;
        this.f_111311_ = p_254229_;
        this.f_111312_ = p_253661_;
        this.m_111319_();
        this.setFaceData(faceData);
        this.f_111310_.values().forEach(face -> {
            face.parent = this;
        });
    }

    private void m_111319_() {
        for (Map.Entry<Direction, BlockElementFace> entry : this.f_111310_.entrySet()) {
            float[] afloat = this.m_111320_(entry.getKey());
            entry.getValue().f_111357_.m_111394_(afloat);
        }
    }

    public float[] m_111320_(Direction p_111321_) {
        switch (p_111321_) {
            case DOWN: {
                return new float[]{this.f_111308_.x(), 16.0f - this.f_111309_.z(), this.f_111309_.x(), 16.0f - this.f_111308_.z()};
            }
            case UP: {
                return new float[]{this.f_111308_.x(), this.f_111308_.z(), this.f_111309_.x(), this.f_111309_.z()};
            }
            default: {
                return new float[]{16.0f - this.f_111309_.x(), 16.0f - this.f_111309_.y(), 16.0f - this.f_111308_.x(), 16.0f - this.f_111308_.y()};
            }
            case SOUTH: {
                return new float[]{this.f_111308_.x(), 16.0f - this.f_111309_.y(), this.f_111309_.x(), 16.0f - this.f_111308_.y()};
            }
            case WEST: {
                return new float[]{this.f_111308_.z(), 16.0f - this.f_111309_.y(), this.f_111309_.z(), 16.0f - this.f_111308_.y()};
            }
            case EAST: 
        }
        return new float[]{16.0f - this.f_111309_.z(), 16.0f - this.f_111309_.y(), 16.0f - this.f_111308_.z(), 16.0f - this.f_111308_.y()};
    }

    public ForgeFaceData getFaceData() {
        return this.faceData;
    }

    public void setFaceData(ForgeFaceData faceData) {
        this.faceData = Objects.requireNonNull(faceData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<BlockElement> {
        private static final boolean f_173414_ = true;

        public BlockElement deserialize(JsonElement p_111329_, Type p_111330_, JsonDeserializationContext p_111331_) throws JsonParseException {
            JsonObject jsonobject = p_111329_.getAsJsonObject();
            Vector3f vector3f = this.m_111346_(jsonobject);
            Vector3f vector3f1 = this.m_111352_(jsonobject);
            BlockElementRotation blockelementrotation = this.m_111332_(jsonobject);
            Map<Direction, BlockElementFace> map = this.m_111325_(p_111331_, jsonobject);
            if (jsonobject.has("shade") && !GsonHelper.m_13880_((JsonObject)jsonobject, (String)"shade")) {
                throw new JsonParseException("Expected shade to be a Boolean");
            }
            boolean flag = GsonHelper.m_13855_((JsonObject)jsonobject, (String)"shade", (boolean)true);
            ForgeFaceData faceData = ForgeFaceData.read((JsonElement)jsonobject.get("forge_data"), (ForgeFaceData)ForgeFaceData.DEFAULT);
            return new BlockElement(vector3f, vector3f1, map, blockelementrotation, flag, faceData);
        }

        @Nullable
        private BlockElementRotation m_111332_(JsonObject p_111333_) {
            BlockElementRotation blockelementrotation = null;
            if (p_111333_.has("rotation")) {
                JsonObject jsonobject = GsonHelper.m_13930_((JsonObject)p_111333_, (String)"rotation");
                Vector3f vector3f = this.m_111334_(jsonobject, "origin");
                vector3f.mul(0.0625f);
                Direction.Axis direction$axis = this.m_111344_(jsonobject);
                float f = this.m_111342_(jsonobject);
                boolean flag = GsonHelper.m_13855_((JsonObject)jsonobject, (String)"rescale", (boolean)false);
                blockelementrotation = new BlockElementRotation(vector3f, direction$axis, f, flag);
            }
            return blockelementrotation;
        }

        private float m_111342_(JsonObject p_111343_) {
            float f = GsonHelper.m_13915_((JsonObject)p_111343_, (String)"angle");
            if (f != 0.0f && Mth.m_14154_((float)f) != 22.5f && Mth.m_14154_((float)f) != 45.0f) {
                throw new JsonParseException("Invalid rotation " + f + " found, only -45/-22.5/0/22.5/45 allowed");
            }
            return f;
        }

        private Direction.Axis m_111344_(JsonObject p_111345_) {
            String s = GsonHelper.m_13906_((JsonObject)p_111345_, (String)"axis");
            Direction.Axis direction$axis = Direction.Axis.m_122473_((String)s.toLowerCase(Locale.ROOT));
            if (direction$axis == null) {
                throw new JsonParseException("Invalid rotation axis: " + s);
            }
            return direction$axis;
        }

        private Map<Direction, BlockElementFace> m_111325_(JsonDeserializationContext p_111326_, JsonObject p_111327_) {
            Map<Direction, BlockElementFace> map = this.m_111339_(p_111326_, p_111327_);
            if (map.isEmpty()) {
                throw new JsonParseException("Expected between 1 and 6 unique faces, got 0");
            }
            return map;
        }

        private Map<Direction, BlockElementFace> m_111339_(JsonDeserializationContext p_111340_, JsonObject p_111341_) {
            EnumMap map = Maps.newEnumMap(Direction.class);
            JsonObject jsonobject = GsonHelper.m_13930_((JsonObject)p_111341_, (String)"faces");
            for (Map.Entry entry : jsonobject.entrySet()) {
                Direction direction = this.m_111337_((String)entry.getKey());
                map.put(direction, (BlockElementFace)p_111340_.deserialize((JsonElement)entry.getValue(), BlockElementFace.class));
            }
            return map;
        }

        private Direction m_111337_(String p_111338_) {
            Direction direction = Direction.m_122402_((String)p_111338_);
            if (direction == null) {
                throw new JsonParseException("Unknown facing: " + p_111338_);
            }
            return direction;
        }

        private Vector3f m_111352_(JsonObject p_111353_) {
            Vector3f vector3f = this.m_111334_(p_111353_, "to");
            if (!(vector3f.x() < -16.0f || vector3f.y() < -16.0f || vector3f.z() < -16.0f || vector3f.x() > 32.0f || vector3f.y() > 32.0f || vector3f.z() > 32.0f)) {
                return vector3f;
            }
            throw new JsonParseException("'to' specifier exceeds the allowed boundaries: " + vector3f);
        }

        private Vector3f m_111346_(JsonObject p_111347_) {
            Vector3f vector3f = this.m_111334_(p_111347_, "from");
            if (!(vector3f.x() < -16.0f || vector3f.y() < -16.0f || vector3f.z() < -16.0f || vector3f.x() > 32.0f || vector3f.y() > 32.0f || vector3f.z() > 32.0f)) {
                return vector3f;
            }
            throw new JsonParseException("'from' specifier exceeds the allowed boundaries: " + vector3f);
        }

        private Vector3f m_111334_(JsonObject p_111335_, String p_111336_) {
            JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)p_111335_, (String)p_111336_);
            if (jsonarray.size() != 3) {
                throw new JsonParseException("Expected 3 " + p_111336_ + " values, found: " + jsonarray.size());
            }
            float[] afloat = new float[3];
            for (int i = 0; i < afloat.length; ++i) {
                afloat[i] = GsonHelper.m_13888_((JsonElement)jsonarray.get(i), (String)(p_111336_ + "[" + i + "]"));
            }
            return new Vector3f(afloat[0], afloat[1], afloat[2]);
        }
    }
}

