/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.MatrixUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ItemDecoratorHandler;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.ForgeItemModelShaper;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ItemRenderer
implements ResourceManagerReloadListener {
    public static final ResourceLocation f_273897_ = new ResourceLocation("textures/misc/enchanted_glint_entity.png");
    public static final ResourceLocation f_273833_ = new ResourceLocation("textures/misc/enchanted_glint_item.png");
    private static final Set<Item> f_115094_ = Sets.newHashSet((Object[])new Item[]{Items.f_41852_});
    private static final int f_174221_ = 8;
    private static final int f_174222_ = 8;
    public static final int f_174218_ = 200;
    public static final float f_174219_ = 0.5f;
    public static final float f_174220_ = 0.75f;
    public static final float f_256734_ = 0.0078125f;
    private static final ModelResourceLocation f_244324_ = ModelResourceLocation.m_245263_((String)"trident", (String)"inventory");
    public static final ModelResourceLocation f_244055_ = ModelResourceLocation.m_245263_((String)"trident_in_hand", (String)"inventory");
    private static final ModelResourceLocation f_244537_ = ModelResourceLocation.m_245263_((String)"spyglass", (String)"inventory");
    public static final ModelResourceLocation f_243706_ = ModelResourceLocation.m_245263_((String)"spyglass_in_hand", (String)"inventory");
    private final Minecraft f_265848_;
    private final ItemModelShaper f_115095_;
    private final TextureManager f_115096_;
    private final ItemColors f_115097_;
    private final BlockEntityWithoutLevelRenderer f_174223_;

    public ItemRenderer(Minecraft p_266926_, TextureManager p_266774_, ModelManager p_266850_, ItemColors p_267016_, BlockEntityWithoutLevelRenderer p_267049_) {
        this.f_265848_ = p_266926_;
        this.f_115096_ = p_266774_;
        this.f_115095_ = new ForgeItemModelShaper(p_266850_);
        this.f_174223_ = p_267049_;
        for (Item item : BuiltInRegistries.f_257033_) {
            if (f_115094_.contains(item)) continue;
            this.f_115095_.m_109396_(item, new ModelResourceLocation(BuiltInRegistries.f_257033_.m_7981_((Object)item), "inventory"));
        }
        this.f_115097_ = p_267016_;
    }

    public ItemModelShaper m_115103_() {
        return this.f_115095_;
    }

    public void m_115189_(BakedModel p_115190_, ItemStack p_115191_, int p_115192_, int p_115193_, PoseStack p_115194_, VertexConsumer p_115195_) {
        RandomSource randomsource = RandomSource.m_216327_();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            this.m_115162_(p_115194_, p_115195_, p_115190_.m_213637_(null, direction, randomsource), p_115191_, p_115192_, p_115193_);
        }
        randomsource.m_188584_(42L);
        this.m_115162_(p_115194_, p_115195_, p_115190_.m_213637_(null, null, randomsource), p_115191_, p_115192_, p_115193_);
    }

    public void m_115143_(ItemStack p_115144_, ItemDisplayContext p_270188_, boolean p_115146_, PoseStack p_115147_, MultiBufferSource p_115148_, int p_115149_, int p_115150_, BakedModel p_115151_) {
        if (!p_115144_.m_41619_()) {
            boolean flag;
            p_115147_.m_85836_();
            boolean bl = flag = p_270188_ == ItemDisplayContext.GUI || p_270188_ == ItemDisplayContext.GROUND || p_270188_ == ItemDisplayContext.FIXED;
            if (flag) {
                if (p_115144_.m_150930_(Items.f_42713_)) {
                    p_115151_ = this.f_115095_.m_109393_().m_119422_(f_244324_);
                } else if (p_115144_.m_150930_(Items.f_151059_)) {
                    p_115151_ = this.f_115095_.m_109393_().m_119422_(f_244537_);
                }
            }
            p_115151_ = ForgeHooksClient.handleCameraTransforms((PoseStack)p_115147_, (BakedModel)p_115151_, (ItemDisplayContext)p_270188_, (boolean)p_115146_);
            p_115147_.m_252880_(-0.5f, -0.5f, -0.5f);
            if (!(p_115151_.m_7521_() || p_115144_.m_150930_(Items.f_42713_) && !flag)) {
                Block block;
                boolean flag1 = p_270188_ != ItemDisplayContext.GUI && !p_270188_.m_269069_() && p_115144_.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)p_115144_.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                for (BakedModel model : p_115151_.getRenderPasses(p_115144_, flag1)) {
                    for (RenderType rendertype : model.getRenderTypes(p_115144_, flag1)) {
                        VertexConsumer vertexconsumer;
                        if (p_115144_.m_204117_(ItemTags.f_215866_) && p_115144_.m_41790_()) {
                            p_115147_.m_85836_();
                            PoseStack.Pose posestack$pose = p_115147_.m_85850_();
                            if (p_270188_ == ItemDisplayContext.GUI) {
                                MatrixUtil.m_253023_((Matrix4f)posestack$pose.m_252922_(), (float)0.5f);
                            } else if (p_270188_.m_269069_()) {
                                MatrixUtil.m_253023_((Matrix4f)posestack$pose.m_252922_(), (float)0.75f);
                            }
                            vertexconsumer = flag1 ? ItemRenderer.m_115207_(p_115148_, rendertype, posestack$pose) : ItemRenderer.m_115180_(p_115148_, rendertype, posestack$pose);
                            p_115147_.m_85849_();
                        } else {
                            vertexconsumer = flag1 ? ItemRenderer.m_115222_(p_115148_, rendertype, true, p_115144_.m_41790_()) : ItemRenderer.m_115211_(p_115148_, rendertype, true, p_115144_.m_41790_());
                        }
                        this.m_115189_(model, p_115144_, p_115149_, p_115150_, p_115147_, vertexconsumer);
                    }
                }
            } else {
                IClientItemExtensions.of((ItemStack)p_115144_).getCustomRenderer().m_108829_(p_115144_, p_270188_, p_115147_, p_115148_, p_115149_, p_115150_);
            }
            p_115147_.m_85849_();
        }
    }

    public static VertexConsumer m_115184_(MultiBufferSource p_115185_, RenderType p_115186_, boolean p_115187_, boolean p_115188_) {
        return p_115188_ ? VertexMultiConsumer.m_86168_((VertexConsumer)p_115185_.m_6299_(p_115187_ ? RenderType.m_110481_() : RenderType.m_110484_()), (VertexConsumer)p_115185_.m_6299_(p_115186_)) : p_115185_.m_6299_(p_115186_);
    }

    public static VertexConsumer m_115180_(MultiBufferSource p_115181_, RenderType p_115182_, PoseStack.Pose p_115183_) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(p_115181_.m_6299_(RenderType.m_110490_()), p_115183_.m_252922_(), p_115183_.m_252943_(), 0.0078125f), (VertexConsumer)p_115181_.m_6299_(p_115182_));
    }

    public static VertexConsumer m_115207_(MultiBufferSource p_115208_, RenderType p_115209_, PoseStack.Pose p_115210_) {
        return VertexMultiConsumer.m_86168_((VertexConsumer)new SheetedDecalTextureGenerator(p_115208_.m_6299_(RenderType.m_110493_()), p_115210_.m_252922_(), p_115210_.m_252943_(), 0.0078125f), (VertexConsumer)p_115208_.m_6299_(p_115209_));
    }

    public static VertexConsumer m_115211_(MultiBufferSource p_115212_, RenderType p_115213_, boolean p_115214_, boolean p_115215_) {
        if (p_115215_) {
            return Minecraft.m_91085_() && p_115213_ == Sheets.m_110791_() ? VertexMultiConsumer.m_86168_((VertexConsumer)p_115212_.m_6299_(RenderType.m_110487_()), (VertexConsumer)p_115212_.m_6299_(p_115213_)) : VertexMultiConsumer.m_86168_((VertexConsumer)p_115212_.m_6299_(p_115214_ ? RenderType.m_110490_() : RenderType.m_110496_()), (VertexConsumer)p_115212_.m_6299_(p_115213_));
        }
        return p_115212_.m_6299_(p_115213_);
    }

    public static VertexConsumer m_115222_(MultiBufferSource p_115223_, RenderType p_115224_, boolean p_115225_, boolean p_115226_) {
        return p_115226_ ? VertexMultiConsumer.m_86168_((VertexConsumer)p_115223_.m_6299_(p_115225_ ? RenderType.m_110493_() : RenderType.m_110499_()), (VertexConsumer)p_115223_.m_6299_(p_115224_)) : p_115223_.m_6299_(p_115224_);
    }

    public void m_115162_(PoseStack p_115163_, VertexConsumer p_115164_, List<BakedQuad> p_115165_, ItemStack p_115166_, int p_115167_, int p_115168_) {
        boolean flag = !p_115166_.m_41619_();
        PoseStack.Pose posestack$pose = p_115163_.m_85850_();
        for (BakedQuad bakedquad : p_115165_) {
            int i = -1;
            if (flag && bakedquad.m_111304_()) {
                i = this.f_115097_.m_92676_(p_115166_, bakedquad.m_111305_());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            p_115164_.putBulkData(posestack$pose, bakedquad, f, f1, f2, 1.0f, p_115167_, p_115168_, true);
        }
    }

    public BakedModel m_174264_(ItemStack p_174265_, @Nullable Level p_174266_, @Nullable LivingEntity p_174267_, int p_174268_) {
        BakedModel bakedmodel = p_174265_.m_150930_(Items.f_42713_) ? this.f_115095_.m_109393_().m_119422_(f_244055_) : (p_174265_.m_150930_(Items.f_151059_) ? this.f_115095_.m_109393_().m_119422_(f_243706_) : this.f_115095_.m_109406_(p_174265_));
        ClientLevel clientlevel = p_174266_ instanceof ClientLevel ? (ClientLevel)p_174266_ : null;
        BakedModel bakedmodel1 = bakedmodel.m_7343_().m_173464_(bakedmodel, p_174265_, clientlevel, p_174267_, p_174268_);
        return bakedmodel1 == null ? this.f_115095_.m_109393_().m_119409_() : bakedmodel1;
    }

    public void m_269128_(ItemStack p_270761_, ItemDisplayContext p_270648_, int p_270410_, int p_270894_, PoseStack p_270430_, MultiBufferSource p_270457_, @Nullable Level p_270149_, int p_270509_) {
        this.m_269491_(null, p_270761_, p_270648_, false, p_270430_, p_270457_, p_270149_, p_270410_, p_270894_, p_270509_);
    }

    public void m_269491_(@Nullable LivingEntity p_270101_, ItemStack p_270637_, ItemDisplayContext p_270437_, boolean p_270434_, PoseStack p_270230_, MultiBufferSource p_270411_, @Nullable Level p_270641_, int p_270595_, int p_270927_, int p_270845_) {
        if (!p_270637_.m_41619_()) {
            BakedModel bakedmodel = this.m_174264_(p_270637_, p_270641_, p_270101_, p_270845_);
            this.m_115143_(p_270637_, p_270437_, p_270434_, p_270230_, p_270411_, p_270595_, p_270927_, bakedmodel);
        }
    }

    public void m_274569_(PoseStack p_275410_, ItemStack p_275575_, int p_275265_, int p_275235_) {
        this.m_274490_(p_275410_, p_275575_, p_275265_, p_275235_, this.m_174264_(p_275575_, null, null, 0));
    }

    protected void m_274490_(PoseStack p_275246_, ItemStack p_275195_, int p_275214_, int p_275658_, BakedModel p_275740_) {
        boolean flag;
        p_275246_.m_85836_();
        p_275246_.m_252880_(p_275214_, p_275658_, 100.0f);
        p_275246_.m_252880_(8.0f, 8.0f, 0.0f);
        p_275246_.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        p_275246_.m_85841_(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource multibuffersource$buffersource = this.f_265848_.m_91269_().m_110104_();
        boolean bl = flag = !p_275740_.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_252931_(p_275246_.m_85850_().m_252922_());
        RenderSystem.m_157182_();
        this.m_115143_(p_275195_, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, p_275740_);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.m_69482_();
        if (flag) {
            Lighting.m_84931_();
        }
        p_275246_.m_85849_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
    }

    public void m_274369_(PoseStack p_275197_, ItemStack p_275552_, int p_275198_, int p_275738_) {
        this.m_274303_(p_275197_, this.f_265848_.f_91074_, this.f_265848_.f_91073_, p_275552_, p_275198_, p_275738_, 0);
    }

    public void m_274407_(PoseStack p_275539_, ItemStack p_275685_, int p_275360_, int p_275448_, int p_275456_) {
        this.m_274303_(p_275539_, this.f_265848_.f_91074_, this.f_265848_.f_91073_, p_275685_, p_275360_, p_275448_, p_275456_);
    }

    public void m_274350_(PoseStack p_275305_, ItemStack p_275612_, int p_275743_, int p_275591_, int p_275231_, int p_275345_) {
        this.m_274616_(p_275305_, this.f_265848_.f_91074_, this.f_265848_.f_91073_, p_275612_, p_275743_, p_275591_, p_275231_, p_275345_);
    }

    public void m_274336_(PoseStack p_275285_, ItemStack p_275595_, int p_275671_, int p_275526_) {
        this.m_274303_(p_275285_, null, this.f_265848_.f_91073_, p_275595_, p_275671_, p_275526_, 0);
    }

    public void m_274301_(PoseStack p_275668_, LivingEntity p_275691_, ItemStack p_275472_, int p_275283_, int p_275239_, int p_275587_) {
        this.m_274303_(p_275668_, p_275691_, p_275691_.f_19853_, p_275472_, p_275283_, p_275239_, p_275587_);
    }

    private void m_274303_(PoseStack p_275571_, @Nullable LivingEntity p_275317_, @Nullable Level p_275599_, ItemStack p_275500_, int p_275679_, int p_275377_, int p_275380_) {
        this.m_274616_(p_275571_, p_275317_, p_275599_, p_275500_, p_275679_, p_275377_, p_275380_, 0);
    }

    private void m_274616_(PoseStack p_275419_, @Nullable LivingEntity p_275405_, @Nullable Level p_275402_, ItemStack p_275431_, int p_275347_, int p_275504_, int p_275678_, int p_275555_) {
        if (!p_275431_.m_41619_()) {
            BakedModel bakedmodel = this.m_174264_(p_275431_, p_275402_, p_275405_, p_275678_);
            p_275419_.m_85836_();
            p_275419_.m_252880_(0.0f, 0.0f, 50 + (bakedmodel.m_7539_() ? p_275555_ : 0));
            try {
                this.m_274490_(p_275419_, p_275431_, p_275347_, p_275504_, bakedmodel);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_(throwable, "Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", (CrashReportDetail<String>)((CrashReportDetail)() -> String.valueOf(p_275431_.m_41720_())));
                crashreportcategory.m_128165_("Registry Name", (CrashReportDetail<String>)((CrashReportDetail)() -> String.valueOf(ForgeRegistries.ITEMS.getKey((Object)p_275431_.m_41720_()))));
                crashreportcategory.m_128165_("Item Damage", (CrashReportDetail<String>)((CrashReportDetail)() -> String.valueOf(p_275431_.m_41773_())));
                crashreportcategory.m_128165_("Item NBT", (CrashReportDetail<String>)((CrashReportDetail)() -> String.valueOf(p_275431_.m_41783_())));
                crashreportcategory.m_128165_("Item Foil", (CrashReportDetail<String>)((CrashReportDetail)() -> String.valueOf(p_275431_.m_41790_())));
                throw new ReportedException(crashreport);
            }
            p_275419_.m_85849_();
        }
    }

    public void m_274412_(PoseStack p_275553_, Font p_275636_, ItemStack p_275514_, int p_275695_, int p_275460_) {
        this.m_274364_(p_275553_, p_275636_, p_275514_, p_275695_, p_275460_, null);
    }

    public void m_274364_(PoseStack p_275269_, Font p_275652_, ItemStack p_275590_, int p_275202_, int p_275508_, @Nullable String p_275302_) {
        if (!p_275590_.m_41619_()) {
            LocalPlayer localplayer;
            float f;
            p_275269_.m_85836_();
            if (p_275590_.m_41613_() != 1 || p_275302_ != null) {
                String s = p_275302_ == null ? String.valueOf(p_275590_.m_41613_()) : p_275302_;
                p_275269_.m_252880_(0.0f, 0.0f, 200.0f);
                MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                p_275652_.m_271703_(s, p_275202_ + 19 - 2 - p_275652_.m_92895_(s), p_275508_ + 6 + 3, 0xFFFFFF, true, p_275269_.m_85850_().m_252922_(), (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                multibuffersource$buffersource.m_109911_();
            }
            if (p_275590_.m_150947_()) {
                RenderSystem.m_69465_();
                int k = p_275590_.m_150948_();
                int l = p_275590_.m_150949_();
                int i = p_275202_ + 2;
                int j = p_275508_ + 13;
                GuiComponent.m_93172_((PoseStack)p_275269_, (int)i, (int)j, (int)(i + 13), (int)(j + 2), (int)-16777216);
                GuiComponent.m_93172_((PoseStack)p_275269_, (int)i, (int)j, (int)(i + k), (int)(j + 1), (int)(l | 0xFF000000));
                RenderSystem.m_69482_();
            }
            float f2 = f = (localplayer = this.f_265848_.f_91074_) == null ? 0.0f : localplayer.m_36335_().m_41521_(p_275590_.m_41720_(), this.f_265848_.m_91296_());
            if (f > 0.0f) {
                RenderSystem.m_69465_();
                int i1 = p_275508_ + Mth.m_14143_((float)(16.0f * (1.0f - f)));
                int j1 = i1 + Mth.m_14167_((float)(16.0f * f));
                GuiComponent.m_93172_((PoseStack)p_275269_, (int)p_275202_, (int)i1, (int)(p_275202_ + 16), (int)j1, (int)Integer.MAX_VALUE);
                RenderSystem.m_69482_();
            }
            p_275269_.m_85849_();
            ItemDecoratorHandler.of((ItemStack)p_275590_).render(p_275269_, p_275652_, p_275590_, p_275202_, p_275508_);
        }
    }

    public void m_6213_(ResourceManager p_115105_) {
        this.f_115095_.m_109403_();
    }

    public BlockEntityWithoutLevelRenderer getBlockEntityRenderer() {
        return this.f_174223_;
    }
}

