/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.handshake;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ServerHandshakePacketListener;
import net.minecraftforge.network.NetworkHooks;
import org.spigotmc.SpigotConfig;

public class ClientIntentionPacket
implements Packet<ServerHandshakePacketListener> {
    private static final int f_179799_ = 255;
    private final int f_134720_;
    public final String f_134721_;
    public String original_ip;
    public final int f_134722_;
    private final ConnectionProtocol f_134723_;
    private String fmlVersion = "FML3";
    private static final String EXTRA_DATA = "extraData";
    private static final Gson GSON = new Gson();

    public ClientIntentionPacket(String p_134726_, int p_134727_, ConnectionProtocol p_134728_) {
        this.f_134720_ = SharedConstants.m_183709_().m_132495_();
        this.f_134721_ = p_134726_;
        this.f_134722_ = p_134727_;
        this.f_134723_ = p_134728_;
    }

    public ClientIntentionPacket(FriendlyByteBuf p_179801_) {
        String[] split;
        this.f_134720_ = p_179801_.m_130242_();
        String hostName = p_179801_.m_130136_(Short.MAX_VALUE);
        this.f_134722_ = p_179801_.readUnsignedShort();
        this.f_134723_ = ConnectionProtocol.m_129583_((int)p_179801_.m_130242_());
        this.fmlVersion = NetworkHooks.getFMLVersion((String)hostName);
        if (SpigotConfig.bungee && !Objects.equals(this.fmlVersion, "FML3") && (split = hostName.split("\u0000")).length == 4) {
            Property[] properties;
            for (Property property : properties = (Property[])GSON.fromJson(split[3], Property[].class)) {
                if (!Objects.equals(property.getName(), EXTRA_DATA)) continue;
                String extraData = property.getValue().replace("\u0001", "\u0000");
                this.fmlVersion = NetworkHooks.getFMLVersion((String)(split[0] + extraData));
            }
        }
        this.original_ip = hostName;
        this.f_134721_ = hostName.split("\u0000")[0];
    }

    public void m_5779_(FriendlyByteBuf p_134737_) {
        p_134737_.m_130130_(this.f_134720_);
        p_134737_.m_130070_(this.f_134721_ + "\u0000FML3\u0000");
        p_134737_.writeShort(this.f_134722_);
        p_134737_.m_130130_(this.f_134723_.m_129582_());
    }

    public void m_5797_(ServerHandshakePacketListener p_134734_) {
        p_134734_.m_7322_(this);
    }

    public ConnectionProtocol m_134735_() {
        return this.f_134723_;
    }

    public int m_134738_() {
        return this.f_134720_;
    }

    public String m_179802_() {
        return this.f_134721_;
    }

    public int m_179803_() {
        return this.f_134722_;
    }

    public String getFMLVersion() {
        return this.fmlVersion;
    }
}

