/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger f_243935_ = LogUtils.getLogger();
    public static final List<RegistryData<?>> f_243803_ = List.of(new RegistryData<DimensionType>(Registries.f_256787_, DimensionType.f_63843_), new RegistryData<Biome>(Registries.f_256952_, Biome.f_47429_), new RegistryData<ChatType>(Registries.f_256873_, ChatType.f_237005_), new RegistryData(Registries.f_257003_, ConfiguredWorldCarver.f_64846_), new RegistryData(Registries.f_256911_, ConfiguredFeature.f_65373_), new RegistryData(Registries.f_256988_, PlacedFeature.f_191772_), new RegistryData<Structure>(Registries.f_256944_, Structure.f_226553_), new RegistryData(Registries.f_256998_, StructureSet.f_210001_), new RegistryData(Registries.f_257011_, StructureProcessorType.f_74467_), new RegistryData(Registries.f_256948_, StructureTemplatePool.f_210554_), new RegistryData(Registries.f_256932_, NoiseGeneratorSettings.f_64430_), new RegistryData(Registries.f_256865_, NormalNoise.NoiseParameters.f_192851_), new RegistryData(Registries.f_257040_, DensityFunction.f_208216_), new RegistryData(Registries.f_256729_, WorldPreset.f_226414_), new RegistryData(Registries.f_256724_, FlatLevelGeneratorPreset.f_226243_), new RegistryData(Registries.f_266063_, TrimPattern.f_266050_), new RegistryData(Registries.f_266076_, TrimMaterial.f_266095_), new RegistryData(Registries.f_268580_, DamageType.f_268510_), new RegistryData(Registries.f_273919_, MultiNoiseBiomeSourceParameterList.f_273907_));
    public static final List<RegistryData<?>> f_244547_ = List.of(new RegistryData(Registries.f_256862_, LevelStem.f_63970_));

    public static RegistryAccess.Frozen m_247207_(ResourceManager p_252046_, RegistryAccess p_249916_, List<RegistryData<?>> p_250344_) {
        HashMap map = new HashMap();
        List<Pair<WritableRegistry<?>, Loader>> list = p_250344_.stream().map(p_250249_ -> p_250249_.m_245364_(Lifecycle.stable(), map)).toList();
        RegistryOps.RegistryInfoLookup registryops$registryinfolookup = RegistryDataLoader.m_255261_(p_249916_, list);
        list.forEach(p_255508_ -> ((Loader)p_255508_.getSecond()).m_245441_(p_252046_, registryops$registryinfolookup));
        list.forEach(p_258223_ -> {
            Registry registry = (Registry)p_258223_.getFirst();
            try {
                registry.m_203521_();
            }
            catch (Exception exception) {
                map.put(registry.m_123023_(), exception);
            }
        });
        if (!map.isEmpty()) {
            RegistryDataLoader.m_245896_(map);
            throw new IllegalStateException("Failed to load registries due to above errors");
        }
        return new RegistryAccess.ImmutableRegistryAccess(list.stream().map(Pair::getFirst).toList()).m_203557_();
    }

    private static RegistryOps.RegistryInfoLookup m_255261_(RegistryAccess p_256568_, List<Pair<WritableRegistry<?>, Loader>> p_255821_) {
        final HashMap map = new HashMap();
        p_256568_.m_206193_().forEach(p_255505_ -> map.put(p_255505_.f_206233_(), RegistryDataLoader.m_255016_(p_255505_.f_206234_())));
        p_255821_.forEach(p_258221_ -> map.put(((WritableRegistry)p_258221_.getFirst()).m_123023_(), RegistryDataLoader.m_255259_((WritableRegistry)p_258221_.getFirst())));
        return new RegistryOps.RegistryInfoLookup(){

            @Override
            public <T> Optional<RegistryOps.RegistryInfo<T>> m_254838_(ResourceKey<? extends Registry<? extends T>> p_256014_) {
                return Optional.ofNullable((RegistryOps.RegistryInfo)map.get(p_256014_));
            }
        };
    }

    private static <T> RegistryOps.RegistryInfo<T> m_255259_(WritableRegistry<T> p_256020_) {
        return new RegistryOps.RegistryInfo(p_256020_.m_255303_(), p_256020_.m_203505_(), p_256020_.m_203658_());
    }

    private static <T> RegistryOps.RegistryInfo<T> m_255016_(Registry<T> p_256230_) {
        return new RegistryOps.RegistryInfo(p_256230_.m_255303_(), p_256230_.m_255014_(), p_256230_.m_203658_());
    }

    private static void m_245896_(Map<ResourceKey<?>, Exception> p_252325_) {
        StringWriter stringwriter = new StringWriter();
        PrintWriter printwriter = new PrintWriter(stringwriter);
        Map<ResourceLocation, Map<ResourceLocation, Exception>> map = p_252325_.entrySet().stream().collect(Collectors.groupingBy(p_249353_ -> ((ResourceKey)p_249353_.getKey()).m_211136_(), Collectors.toMap(p_251444_ -> ((ResourceKey)p_251444_.getKey()).m_135782_(), Map.Entry::getValue)));
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_249838_ -> {
            printwriter.printf("> Errors in registry %s:%n", p_249838_.getKey());
            ((Map)p_249838_.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_250688_ -> {
                printwriter.printf(">> Errors in element %s:%n", p_250688_.getKey());
                ((Exception)p_250688_.getValue()).printStackTrace(printwriter);
            });
        });
        printwriter.flush();
        f_243935_.error("Registry loading errors:\n{}", (Object)stringwriter);
    }

    private static String m_246502_(ResourceLocation p_252033_) {
        return ForgeHooks.prefixNamespace((ResourceLocation)p_252033_);
    }

    static <E> void m_255048_(RegistryOps.RegistryInfoLookup p_256369_, ResourceManager p_256349_, ResourceKey<? extends Registry<E>> p_255792_, WritableRegistry<E> p_256211_, Decoder<E> p_256232_, Map<ResourceKey<?>, Exception> p_255884_) {
        String s = RegistryDataLoader.m_246502_(p_255792_.m_135782_());
        FileToIdConverter filetoidconverter = FileToIdConverter.m_246568_((String)s);
        RegistryOps registryops = RegistryOps.m_255060_(JsonOps.INSTANCE, p_256369_);
        for (Map.Entry entry : filetoidconverter.m_247457_(p_256349_).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceKey resourcekey = ResourceKey.m_135785_(p_255792_, filetoidconverter.m_245273_(resourcelocation));
            Resource resource = (Resource)entry.getValue();
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    JsonElement jsonelement = JsonParser.parseReader((Reader)reader);
                    DataResult dataresult = p_256232_.parse(registryops, (Object)jsonelement);
                    if (!ICondition.shouldRegisterEntry((JsonElement)jsonelement)) continue;
                    Object e = dataresult.getOrThrow(false, p_248715_ -> {});
                    p_256211_.m_255290_(resourcekey, e, resource.m_247137_() ? Lifecycle.stable() : dataresult.lifecycle());
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {
                p_255884_.put(resourcekey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", resourcelocation, resource.m_215506_()), exception));
            }
        }
    }

    static interface Loader {
        public void m_245441_(ResourceManager var1, RegistryOps.RegistryInfoLookup var2);
    }

    public record RegistryData<T>(ResourceKey<? extends Registry<T>> f_243794_, Codec<T> f_244580_) {
        Pair<WritableRegistry<?>, Loader> m_245364_(Lifecycle p_251662_, Map<ResourceKey<?>, Exception> p_251565_) {
            MappedRegistry writableregistry = new MappedRegistry(this.f_243794_, p_251662_);
            Loader registrydataloader$loader = (p_255511_, p_255512_) -> RegistryDataLoader.m_255048_(p_255512_, p_255511_, this.f_243794_, writableregistry, this.f_244580_, p_251565_);
            return Pair.of(writableregistry, (Object)registrydataloader$loader);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryData.class, "key;elementCodec", "f_243794_", "f_244580_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryData.class, "key;elementCodec", "f_243794_", "f_244580_"}, this);
        }

        @Override
        public final boolean equals(Object p_249596_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryData.class, "key;elementCodec", "f_243794_", "f_244580_"}, this, p_249596_);
        }
    }
}

