/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.slf4j.Logger;

public class WorldUpgrader {
    private static final Logger f_18797_ = LogUtils.getLogger();
    private static final ThreadFactory f_18798_ = new ThreadFactoryBuilder().setDaemon(true).build();
    private final Registry<LevelStem> f_243889_;
    private final Set<ResourceKey<Level>> f_243666_;
    private final boolean f_18800_;
    private final LevelStorageSource.LevelStorageAccess f_18801_;
    private final Thread f_18802_;
    private final DataFixer f_18803_;
    private volatile boolean f_18804_ = true;
    private volatile boolean f_18805_;
    private volatile float f_18806_;
    private volatile int f_18807_;
    private volatile int f_18808_;
    private volatile int f_18809_;
    private final Object2FloatMap<ResourceKey<Level>> f_18810_ = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.m_137583_()));
    private volatile Component f_18811_ = Component.m_237115_("optimizeWorld.stage.counting");
    private static final Pattern f_18812_ = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final DimensionDataStorage f_18813_;

    public WorldUpgrader(LevelStorageSource.LevelStorageAccess p_249922_, DataFixer p_250273_, Registry<LevelStem> p_252191_, boolean p_250738_) {
        this.f_243889_ = p_252191_;
        this.f_243666_ = p_252191_.m_214010_().stream().map(Registries::m_257551_).collect(Collectors.toUnmodifiableSet());
        this.f_18800_ = p_250738_;
        this.f_18803_ = p_250273_;
        this.f_18801_ = p_249922_;
        this.f_18813_ = new DimensionDataStorage(this.f_18801_.m_197394_(Level.f_46428_).resolve("data").toFile(), p_250273_);
        this.f_18802_ = f_18798_.newThread(this::m_18838_);
        this.f_18802_.setUncaughtExceptionHandler((p_18825_, p_18826_) -> {
            f_18797_.error("Error upgrading world", p_18826_);
            this.f_18811_ = Component.m_237115_("optimizeWorld.stage.failed");
            this.f_18805_ = true;
        });
        this.f_18802_.start();
    }

    public void m_18820_() {
        this.f_18804_ = false;
        try {
            this.f_18802_.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void m_18838_() {
        this.f_18807_ = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceKey<Level> resourcekey : this.f_243666_) {
            List<ChunkPos> list = this.m_18830_(resourcekey);
            builder.put(resourcekey, list.listIterator());
            this.f_18807_ += list.size();
        }
        if (this.f_18807_ == 0) {
            this.f_18805_ = true;
        } else {
            float f1 = this.f_18807_;
            ImmutableMap immutablemap = builder.build();
            ImmutableMap.Builder builder1 = ImmutableMap.builder();
            for (ResourceKey<Level> resourcekey1 : this.f_243666_) {
                Path path = this.f_18801_.m_197394_(resourcekey1);
                builder1.put(resourcekey1, (Object)new ChunkStorage(path.resolve("region"), this.f_18803_, true));
            }
            ImmutableMap immutablemap1 = builder1.build();
            long j = Util.m_137550_();
            this.f_18811_ = Component.m_237115_("optimizeWorld.stage.upgrading");
            while (this.f_18804_) {
                boolean flag = false;
                float f = 0.0f;
                for (ResourceKey<Level> resourcekey2 : this.f_243666_) {
                    ListIterator listiterator = (ListIterator)immutablemap.get(resourcekey2);
                    ChunkStorage chunkstorage = (ChunkStorage)immutablemap1.get(resourcekey2);
                    if (listiterator.hasNext()) {
                        ChunkPos chunkpos = (ChunkPos)listiterator.next();
                        boolean flag1 = false;
                        try {
                            CompoundTag compoundtag = chunkstorage.m_223454_(chunkpos).join().orElse(null);
                            if (compoundtag != null) {
                                boolean flag2;
                                int k = ChunkStorage.m_63505_(compoundtag);
                                ChunkGenerator chunkgenerator = ((LevelStem)this.f_243889_.m_123013_(Registries.m_257452_(resourcekey2))).f_63976_();
                                CompoundTag compoundtag1 = chunkstorage.m_188288_(resourcekey2, () -> this.f_18813_, compoundtag, chunkgenerator.m_187743_());
                                ChunkPos chunkpos1 = new ChunkPos(compoundtag1.m_128451_("xPos"), compoundtag1.m_128451_("zPos"));
                                if (!chunkpos1.equals((Object)chunkpos)) {
                                    f_18797_.warn("Chunk {} has invalid position {}", (Object)chunkpos, (Object)chunkpos1);
                                }
                                boolean bl = flag2 = k < SharedConstants.m_183709_().m_183476_().m_193006_();
                                if (this.f_18800_) {
                                    flag2 = flag2 || compoundtag1.m_128441_("Heightmaps");
                                    compoundtag1.m_128473_("Heightmaps");
                                    flag2 = flag2 || compoundtag1.m_128441_("isLightOn");
                                    compoundtag1.m_128473_("isLightOn");
                                    ListTag listtag = compoundtag1.m_128437_("sections", 10);
                                    for (int i = 0; i < listtag.size(); ++i) {
                                        CompoundTag compoundtag2 = listtag.m_128728_(i);
                                        flag2 = flag2 || compoundtag2.m_128441_("BlockLight");
                                        compoundtag2.m_128473_("BlockLight");
                                        flag2 = flag2 || compoundtag2.m_128441_("SkyLight");
                                        compoundtag2.m_128473_("SkyLight");
                                    }
                                }
                                if (flag2) {
                                    chunkstorage.m_63502_(chunkpos, compoundtag1);
                                    flag1 = true;
                                }
                            }
                        }
                        catch (CompletionException | ReportedException reportedexception) {
                            Throwable throwable = reportedexception.getCause();
                            if (!(throwable instanceof IOException)) {
                                throw reportedexception;
                            }
                            f_18797_.error("Error upgrading chunk {}", (Object)chunkpos, (Object)throwable);
                        }
                        if (flag1) {
                            ++this.f_18808_;
                        } else {
                            ++this.f_18809_;
                        }
                        flag = true;
                    }
                    float f2 = (float)listiterator.nextIndex() / f1;
                    this.f_18810_.put(resourcekey2, f2);
                    f += f2;
                }
                this.f_18806_ = f;
                if (flag) continue;
                this.f_18804_ = false;
            }
            this.f_18811_ = Component.m_237115_("optimizeWorld.stage.finished");
            for (ChunkStorage chunkstorage1 : immutablemap1.values()) {
                try {
                    chunkstorage1.close();
                }
                catch (IOException ioexception) {
                    f_18797_.error("Error upgrading chunk", (Throwable)ioexception);
                }
            }
            this.f_18813_.m_78151_();
            j = Util.m_137550_() - j;
            f_18797_.info("World optimizaton finished after {} ms", (Object)j);
            this.f_18805_ = true;
        }
    }

    private List<ChunkPos> m_18830_(ResourceKey<Level> p_18831_) {
        File file1 = this.f_18801_.m_197394_(p_18831_).toFile();
        File file2 = new File(file1, "region");
        File[] afile = file2.listFiles((p_18822_, p_18823_) -> p_18823_.endsWith(".mca"));
        if (afile == null) {
            return ImmutableList.of();
        }
        ArrayList list = Lists.newArrayList();
        for (File file3 : afile) {
            Matcher matcher = f_18812_.matcher(file3.getName());
            if (!matcher.matches()) continue;
            int i = Integer.parseInt(matcher.group(1)) << 5;
            int j = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionfile = new RegionFile(file3.toPath(), file2.toPath(), true);){
                for (int k = 0; k < 32; ++k) {
                    for (int l = 0; l < 32; ++l) {
                        ChunkPos chunkpos = new ChunkPos(k + i, l + j);
                        if (!regionfile.m_63673_(chunkpos)) continue;
                        list.add(chunkpos);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return list;
    }

    public boolean m_18829_() {
        return this.f_18805_;
    }

    public Set<ResourceKey<Level>> m_246941_() {
        return this.f_243666_;
    }

    public float m_18827_(ResourceKey<Level> p_18828_) {
        return this.f_18810_.getFloat(p_18828_);
    }

    public float m_18833_() {
        return this.f_18806_;
    }

    public int m_18834_() {
        return this.f_18807_;
    }

    public int m_18835_() {
        return this.f_18808_;
    }

    public int m_18836_() {
        return this.f_18809_;
    }

    public Component m_18837_() {
        return this.f_18811_;
    }
}

