/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mohistmc.inventory.InventoryOwner;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public interface Container
extends Clearable {
    public static final int f_146642_ = 64;
    public static final int f_271421_ = 8;
    public static final int MAX_STACK = 64;

    public int m_6643_();

    public boolean m_7983_();

    public ItemStack m_8020_(int var1);

    public ItemStack m_7407_(int var1, int var2);

    public ItemStack m_8016_(int var1);

    public void m_6836_(int var1, ItemStack var2);

    default public int m_6893_() {
        return 64;
    }

    public void m_6596_();

    public boolean m_6542_(Player var1);

    default public void m_5856_(Player p_18955_) {
    }

    default public void m_5785_(Player p_18954_) {
    }

    default public boolean m_7013_(int p_18952_, ItemStack p_18953_) {
        return true;
    }

    default public boolean m_271862_(Container p_273520_, int p_272681_, ItemStack p_273702_) {
        return true;
    }

    default public int m_18947_(Item p_18948_) {
        int i = 0;
        for (int j = 0; j < this.m_6643_(); ++j) {
            ItemStack itemstack = this.m_8020_(j);
            if (!itemstack.m_41720_().equals(p_18948_)) continue;
            i += itemstack.m_41613_();
        }
        return i;
    }

    default public boolean m_18949_(Set<Item> p_18950_) {
        return this.m_216874_(p_216873_ -> !p_216873_.m_41619_() && p_18950_.contains(p_216873_.m_41720_()));
    }

    default public boolean m_216874_(Predicate<ItemStack> p_216875_) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (!p_216875_.test(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean m_272074_(BlockEntity p_273154_, Player p_273222_) {
        return Container.m_271806_(p_273154_, p_273222_, 8);
    }

    public static boolean m_271806_(BlockEntity p_272877_, Player p_272670_, int p_273411_) {
        Level level = p_272877_.m_58904_();
        BlockPos blockpos = p_272877_.m_58899_();
        if (level == null) {
            return false;
        }
        if (level.m_7702_(blockpos) != p_272877_) {
            return false;
        }
        return p_272670_.m_20275_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5) <= (double)(p_273411_ * p_273411_);
    }

    default public List<ItemStack> getContents() {
        return Collections.emptyList();
    }

    default public void onOpen(CraftHumanEntity who) {
    }

    default public void onClose(CraftHumanEntity who) {
    }

    default public List<HumanEntity> getViewers() {
        return Collections.emptyList();
    }

    default public InventoryHolder getOwner() {
        InventoryHolder inventoryHolder;
        Container container = this;
        if (container instanceof BlockEntity) {
            BlockEntity blockEntity = (BlockEntity)((Object)container);
            inventoryHolder = InventoryOwner.get((BlockEntity)blockEntity);
        } else {
            inventoryHolder = null;
        }
        return inventoryHolder;
    }

    default public void setMaxStackSize(int size) {
    }

    default public Location getLocation() {
        Container container = this;
        if (container instanceof BlockEntity) {
            BlockEntity entity = (BlockEntity)((Object)container);
            BlockPos blockPos = entity.m_58899_();
            return new Location((World)entity.m_58904_().getWorld(), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        }
        return null;
    }

    default public Recipe getCurrentRecipe() {
        return null;
    }

    default public void setCurrentRecipe(Recipe recipe) {
    }
}

