/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;

public class Sniffer
extends Animal {
    private static final int f_271109_ = 1700;
    private static final int f_271252_ = 6000;
    private static final int f_271435_ = 30;
    private static final int f_271151_ = 120;
    private static final int f_271533_ = 10;
    private static final int f_271414_ = 48000;
    private static final EntityDataAccessor<State> f_271416_ = SynchedEntityData.m_135353_(Sniffer.class, EntityDataSerializers.f_271344_);
    private static final EntityDataAccessor<Integer> f_271498_ = SynchedEntityData.m_135353_(Sniffer.class, EntityDataSerializers.f_135028_);
    public final AnimationState f_271242_ = new AnimationState();
    public final AnimationState f_271525_ = new AnimationState();
    public final AnimationState f_271434_ = new AnimationState();
    public final AnimationState f_271092_ = new AnimationState();
    public final AnimationState f_271278_ = new AnimationState();
    public final AnimationState f_271155_ = new AnimationState();
    public final AnimationState f_271472_ = new AnimationState();
    public final AnimationState f_271318_ = new AnimationState();

    public static AttributeSupplier.Builder m_271876_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.1f).m_22268_(Attributes.f_22276_, 14.0);
    }

    public Sniffer(EntityType<? extends Animal> p_273717_, Level p_273562_) {
        super(p_273717_, p_273562_);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.WATER, -2.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_271416_, State.IDLING);
        this.f_19804_.m_135372_(f_271498_, 0);
    }

    @Override
    protected float m_6431_(Pose p_272721_, EntityDimensions p_273353_) {
        return this.m_6972_((Pose)p_272721_).f_20378_ * 0.6f;
    }

    private boolean m_271936_() {
        boolean flag = this.f_19861_ || this.m_20072_();
        return flag && this.m_20184_().m_165925_() > 1.0E-6;
    }

    private boolean m_274344_() {
        return this.m_271936_() && this.m_20069_() && !this.m_5842_() && this.m_20184_().m_165925_() > 9.999999999999999E-6;
    }

    private boolean m_274343_() {
        return this.m_271936_() && !this.m_5842_() && !this.m_20069_();
    }

    public boolean m_272223_() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_217768_).isPresent();
    }

    public boolean m_272076_() {
        return this.m_271917_() == State.DIGGING || this.m_271917_() == State.SEARCHING;
    }

    private BlockPos m_271877_() {
        Vec3 vec3 = this.m_20182_().m_82549_(this.m_20156_().m_82490_(2.25));
        return BlockPos.m_274561_((double)vec3.m_7096_(), (double)this.m_20186_(), (double)vec3.m_7094_());
    }

    public State m_271917_() {
        return this.f_19804_.m_135370_(f_271416_);
    }

    private Sniffer m_271705_(State p_273359_) {
        this.f_19804_.m_135381_(f_271416_, p_273359_);
        return this;
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_272936_) {
        if (f_271416_.equals(p_272936_)) {
            State sniffer$state = this.m_271917_();
            this.m_271845_();
            switch (sniffer$state) {
                case SCENTING: {
                    this.f_271092_.m_216982_(this.f_19797_);
                    break;
                }
                case SNIFFING: {
                    this.f_271278_.m_216982_(this.f_19797_);
                    break;
                }
                case SEARCHING: {
                    this.f_271155_.m_216982_(this.f_19797_);
                    break;
                }
                case DIGGING: {
                    this.f_271472_.m_216982_(this.f_19797_);
                    break;
                }
                case RISING: {
                    this.f_271318_.m_216982_(this.f_19797_);
                    break;
                }
                case FEELING_HAPPY: {
                    this.f_271434_.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_272936_);
    }

    private void m_271845_() {
        this.f_271155_.m_216973_();
        this.f_271472_.m_216973_();
        this.f_271278_.m_216973_();
        this.f_271318_.m_216973_();
        this.f_271434_.m_216973_();
        this.f_271092_.m_216973_();
    }

    public Sniffer m_272034_(State p_273096_) {
        switch (p_273096_) {
            case SCENTING: {
                this.m_5496_(SoundEvents.f_271121_, 1.0f, 1.0f);
                this.m_271705_(State.SCENTING);
                break;
            }
            case SNIFFING: {
                this.m_5496_(SoundEvents.f_271283_, 1.0f, 1.0f);
                this.m_271705_(State.SNIFFING);
                break;
            }
            case SEARCHING: {
                this.m_271705_(State.SEARCHING);
                break;
            }
            case DIGGING: {
                this.m_271705_(State.DIGGING).m_271851_();
                break;
            }
            case RISING: {
                this.m_5496_(SoundEvents.f_271405_, 1.0f, 1.0f);
                this.m_271705_(State.RISING);
                break;
            }
            case FEELING_HAPPY: {
                this.m_5496_(SoundEvents.f_271300_, 1.0f, 1.0f);
                this.m_271705_(State.FEELING_HAPPY);
                break;
            }
            case IDLING: {
                this.m_271705_(State.IDLING);
            }
        }
        return this;
    }

    private Sniffer m_271851_() {
        this.f_19804_.m_135381_(f_271498_, this.f_19797_ + 120);
        this.f_19853_.m_7605_(this, (byte)63);
        return this;
    }

    public Sniffer m_271943_(boolean p_272677_) {
        if (p_272677_) {
            this.m_271874_(this.m_20097_());
        }
        return this;
    }

    public Optional<BlockPos> m_271905_() {
        return IntStream.range(0, 5).mapToObj(p_273771_ -> LandRandomPos.m_148488_((PathfinderMob)this, (int)(10 + 2 * p_273771_), (int)3)).filter(Objects::nonNull).map(BlockPos::m_274446_).map(BlockPos::m_7495_).filter(this::m_271898_).findFirst();
    }

    @Override
    protected boolean m_7341_(Entity p_273768_) {
        return false;
    }

    public boolean m_272270_() {
        return !this.m_272223_() && !this.m_6162_() && !this.m_20069_() && this.m_271898_(this.m_271877_().m_7495_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean m_271898_(BlockPos p_272757_) {
        if (!this.f_19853_.m_8055_(p_272757_).m_204336_(BlockTags.f_271391_)) return false;
        if (!this.f_19853_.m_8055_(p_272757_.m_7494_()).m_60795_()) return false;
        if (!this.m_272217_().noneMatch(arg_0 -> ((BlockPos)p_272757_).equals(arg_0))) return false;
        return true;
    }

    private void m_271740_() {
        if (!this.f_19853_.m_5776_() && this.f_19804_.m_135370_(f_271498_) == this.f_19797_) {
            ItemStack itemstack = new ItemStack(Items.f_271133_);
            BlockPos blockpos = this.m_271877_();
            ItemEntity itementity = new ItemEntity(this.f_19853_, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), itemstack);
            EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itementity.getBukkitEntity());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            itementity.m_32060_();
            this.f_19853_.m_7967_(itementity);
            this.m_5496_(SoundEvents.f_271330_, 1.0f, 1.0f);
        }
    }

    private Sniffer m_272274_(AnimationState p_273528_) {
        boolean flag;
        boolean bl = flag = p_273528_.m_216981_() > 1700L && p_273528_.m_216981_() < 6000L;
        if (flag) {
            BlockState blockstate = this.m_20075_();
            BlockPos blockpos = this.m_271877_();
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vec3 = Vec3.m_82512_((Vec3i)blockpos);
                    this.f_19853_.m_7106_(new BlockParticleOption((ParticleType<BlockParticleOption>)ParticleTypes.f_123794_, blockstate), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
                }
                if (this.f_19797_ % 10 == 0) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), blockstate.m_60827_().m_56778_(), this.m_5720_(), 0.5f, 0.5f, false);
                }
            }
        }
        return this;
    }

    public Sniffer m_271874_(BlockPos p_273015_) {
        List list = this.m_272217_().limit(20L).collect(Collectors.toList());
        list.add(0, p_273015_);
        this.m_6274_().m_21879_(MemoryModuleType.f_271415_, list);
        return this;
    }

    public Stream<BlockPos> m_272217_() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_271415_).stream().flatMap(Collection::stream);
    }

    @Override
    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void m_8119_() {
        boolean flag = this.m_20069_() && !this.m_5842_();
        this.m_21051_(Attributes.f_22279_).m_22100_(flag ? (double)0.2f : (double)0.1f);
        if (!this.m_274343_() && !this.m_274344_()) {
            this.f_271525_.m_216973_();
            this.f_271242_.m_216973_();
        } else if (this.m_272223_()) {
            this.f_271242_.m_216973_();
            this.f_271525_.m_216982_(this.f_19797_);
        } else {
            this.f_271525_.m_216973_();
            this.f_271242_.m_216982_(this.f_19797_);
        }
        switch (this.m_271917_()) {
            case SEARCHING: {
                this.m_272136_();
                break;
            }
            case DIGGING: {
                this.m_272274_(this.f_271472_).m_271740_();
            }
        }
        super.m_8119_();
    }

    @Override
    public InteractionResult m_6071_(Player p_273046_, InteractionHand p_272687_) {
        ItemStack itemstack = p_273046_.m_21120_(p_272687_);
        InteractionResult interactionresult = super.m_6071_(p_273046_, p_272687_);
        if (interactionresult.m_19077_() && this.m_6898_(itemstack)) {
            this.f_19853_.m_6269_(null, this, this.m_7866_(itemstack), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.f_19853_.f_46441_, (float)0.8f, (float)1.2f));
        }
        return interactionresult;
    }

    private void m_272136_() {
        if (this.f_19853_.m_5776_() && this.f_19797_ % 20 == 0) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_271418_, this.m_5720_(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void m_7355_(BlockPos p_272953_, BlockState p_273729_) {
        this.m_5496_(SoundEvents.f_271325_, 0.15f, 1.0f);
    }

    @Override
    public SoundEvent m_7866_(ItemStack p_272747_) {
        return SoundEvents.f_271147_;
    }

    @Override
    protected SoundEvent m_7515_() {
        return Set.of(State.DIGGING, State.SEARCHING).contains((Object)this.m_271917_()) ? null : SoundEvents.f_271535_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_273718_) {
        return SoundEvents.f_271520_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_271214_;
    }

    @Override
    public int m_8085_() {
        return 50;
    }

    @Override
    public void m_6863_(boolean p_272995_) {
        this.m_146762_(p_272995_ ? -48000 : 0);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_273401_, AgeableMob p_273310_) {
        return EntityType.f_271264_.m_20615_(p_273401_);
    }

    @Override
    public boolean m_7848_(Animal p_272966_) {
        if (!(p_272966_ instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)p_272966_;
        Set<State> set = Set.of(State.IDLING, State.SCENTING, State.FEELING_HAPPY);
        return set.contains((Object)this.m_271917_()) && set.contains((Object)sniffer.m_271917_()) && super.m_7848_(p_272966_);
    }

    @Override
    public AABB m_6921_() {
        return super.m_6921_().m_82400_((double)0.6f);
    }

    @Override
    public boolean m_6898_(ItemStack p_273659_) {
        return p_273659_.m_204117_(ItemTags.f_271449_);
    }

    @Override
    protected Brain<?> m_8075_(Dynamic<?> p_273174_) {
        return SnifferAi.m_272207_((Brain)this.m_5490_().m_22073_(p_273174_));
    }

    public Brain<Sniffer> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<Sniffer> m_5490_() {
        return Brain.m_21923_((Collection)SnifferAi.f_271430_, (Collection)SnifferAi.f_271288_);
    }

    @Override
    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("snifferBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        this.f_19853_.m_46473_().m_6182_("snifferActivityUpdate");
        SnifferAi.m_271706_((Sniffer)this);
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    @Override
    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State IDLING = new State();
        public static final /* enum */ State FEELING_HAPPY = new State();
        public static final /* enum */ State SCENTING = new State();
        public static final /* enum */ State SNIFFING = new State();
        public static final /* enum */ State SEARCHING = new State();
        public static final /* enum */ State DIGGING = new State();
        public static final /* enum */ State RISING = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String p_272910_) {
            return Enum.valueOf(State.class, p_272910_);
        }

        private static /* synthetic */ State[] m_271975_() {
            return new State[]{IDLING, FEELING_HAPPY, SCENTING, SNIFFING, SEARCHING, DIGGING, RISING};
        }

        static {
            $VALUES = State.m_271975_();
        }
    }
}

