/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.flag;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlagUniverse;
import org.slf4j.Logger;

public class FeatureFlagRegistry {
    private static final Logger f_244528_ = LogUtils.getLogger();
    private final FeatureFlagUniverse f_244444_;
    public final Map<ResourceLocation, FeatureFlag> f_244560_;
    private final FeatureFlagSet f_243770_;

    FeatureFlagRegistry(FeatureFlagUniverse p_249715_, FeatureFlagSet p_249277_, Map<ResourceLocation, FeatureFlag> p_249557_) {
        this.f_244444_ = p_249715_;
        this.f_244560_ = p_249557_;
        this.f_243770_ = p_249277_;
    }

    public boolean m_246363_(FeatureFlagSet p_251939_) {
        return p_251939_.m_247715_(this.f_243770_);
    }

    public FeatureFlagSet m_247355_() {
        return this.f_243770_;
    }

    public FeatureFlagSet m_247416_(Iterable<ResourceLocation> p_250759_) {
        return this.m_247021_(p_250759_, p_251224_ -> f_244528_.warn("Unknown feature flag: {}", p_251224_));
    }

    public FeatureFlagSet m_245769_(FeatureFlag ... p_252295_) {
        return FeatureFlagSet.m_247438_((FeatureFlagUniverse)this.f_244444_, Arrays.asList(p_252295_));
    }

    public FeatureFlagSet m_247021_(Iterable<ResourceLocation> p_251769_, Consumer<ResourceLocation> p_251521_) {
        Set set = Sets.newIdentityHashSet();
        for (ResourceLocation resourcelocation : p_251769_) {
            FeatureFlag featureflag = this.f_244560_.get(resourcelocation);
            if (featureflag == null) {
                p_251521_.accept(resourcelocation);
                continue;
            }
            set.add(featureflag);
        }
        return FeatureFlagSet.m_247438_((FeatureFlagUniverse)this.f_244444_, (Collection)set);
    }

    public Set<ResourceLocation> m_245829_(FeatureFlagSet p_251153_) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        this.f_244560_.forEach((p_252018_, p_250772_) -> {
            if (p_251153_.m_245372_(p_250772_)) {
                set.add((ResourceLocation)p_252018_);
            }
        });
        return set;
    }

    public Codec<FeatureFlagSet> m_245213_() {
        return ResourceLocation.f_135803_.listOf().comapFlatMap(p_275144_ -> {
            HashSet set = new HashSet();
            FeatureFlagSet featureflagset = this.m_247021_((Iterable<ResourceLocation>)p_275144_, set::add);
            return !set.isEmpty() ? DataResult.error(() -> "Unknown feature ids: " + set, (Object)featureflagset) : DataResult.success((Object)featureflagset);
        }, p_249796_ -> List.copyOf(this.m_245829_((FeatureFlagSet)p_249796_)));
    }

    public static class Builder {
        private final FeatureFlagUniverse f_243698_;
        private int f_244365_;
        private final Map<ResourceLocation, FeatureFlag> f_244349_ = new LinkedHashMap<ResourceLocation, FeatureFlag>();

        public Builder(String p_251576_) {
            this.f_243698_ = new FeatureFlagUniverse(p_251576_);
        }

        public FeatureFlag m_246015_(String p_251782_) {
            return this.m_247497_(new ResourceLocation("minecraft", p_251782_));
        }

        public FeatureFlag m_247497_(ResourceLocation p_250098_) {
            FeatureFlag featureflag;
            FeatureFlag featureflag1;
            if (this.f_244365_ >= 64) {
                throw new IllegalStateException("Too many feature flags");
            }
            if ((featureflag1 = this.f_244349_.put(p_250098_, featureflag = new FeatureFlag(this.f_243698_, this.f_244365_++))) != null) {
                throw new IllegalStateException("Duplicate feature flag " + p_250098_);
            }
            return featureflag;
        }

        public FeatureFlagRegistry m_245707_() {
            FeatureFlagSet featureflagset = FeatureFlagSet.m_247438_((FeatureFlagUniverse)this.f_243698_, this.f_244349_.values());
            return new FeatureFlagRegistry(this.f_243698_, featureflagset, Map.copyOf(this.f_244349_));
        }
    }
}

