/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.slf4j.Logger;

public class AnvilMenu
extends ItemCombinerMenu {
    public static final int f_265994_ = 0;
    public static final int f_265986_ = 1;
    public static final int f_266102_ = 2;
    private static final Logger f_38999_ = LogUtils.getLogger();
    private static final boolean f_150469_ = false;
    public static final int f_150468_ = 50;
    public int f_39000_;
    public String f_39001_;
    public final DataSlot f_39002_ = DataSlot.m_39401_();
    private static final int f_150470_ = 0;
    private static final int f_150471_ = 1;
    private static final int f_150472_ = 1;
    private static final int f_150464_ = 1;
    private static final int f_150465_ = 2;
    private static final int f_150466_ = 1;
    private static final int f_150467_ = 1;
    private static final int f_265898_ = 27;
    private static final int f_265878_ = 76;
    private static final int f_265992_ = 134;
    private static final int f_266013_ = 47;
    public static final int DEFAULT_DENIED_COST = -1;
    public int maximumRepairCost = 40;
    private CraftInventoryView bukkitEntity;

    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.f_39770_.getLocation(), this.f_39769_, (Container)this.f_39768_, this);
        this.bukkitEntity = new CraftInventoryView((HumanEntity)this.f_39771_.getBukkitEntity(), (Inventory)inventory, (AbstractContainerMenu)this);
        return this.bukkitEntity;
    }

    public AnvilMenu(int p_39005_, net.minecraft.world.entity.player.Inventory p_39006_) {
        this(p_39005_, p_39006_, ContainerLevelAccess.f_39287_);
    }

    public AnvilMenu(int p_39008_, net.minecraft.world.entity.player.Inventory p_39009_, ContainerLevelAccess p_39010_) {
        super(MenuType.f_39964_, p_39008_, p_39009_, p_39010_);
        this.m_38895_(this.f_39002_);
    }

    @Override
    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 27, 47, p_266635_ -> true).m_266197_(1, 76, 47, p_266634_ -> true).m_266198_(2, 134, 47).m_266441_();
    }

    @Override
    protected boolean m_8039_(BlockState p_39019_) {
        return p_39019_.m_204336_(BlockTags.f_13033_);
    }

    @Override
    protected boolean m_6560_(Player p_39023_, boolean p_39024_) {
        return (p_39023_.m_150110_().f_35937_ || p_39023_.f_36078_ >= this.f_39002_.m_6501_()) && this.f_39002_.m_6501_() > -1 && p_39024_;
    }

    @Override
    protected void m_142365_(Player p_150474_, ItemStack p_150475_) {
        if (!p_150474_.m_150110_().f_35937_) {
            p_150474_.m_6749_(-this.f_39002_.m_6501_());
        }
        float breakChance = ForgeHooks.onAnvilRepair((Player)p_150474_, (ItemStack)p_150475_, (ItemStack)this.f_39769_.m_8020_(0), (ItemStack)this.f_39769_.m_8020_(1));
        this.f_39769_.m_6836_(0, ItemStack.f_41583_);
        if (this.f_39000_ > 0) {
            ItemStack itemstack = this.f_39769_.m_8020_(1);
            if (!itemstack.m_41619_() && itemstack.m_41613_() > this.f_39000_) {
                itemstack.m_41774_(this.f_39000_);
                this.f_39769_.m_6836_(1, itemstack);
            } else {
                this.f_39769_.m_6836_(1, ItemStack.f_41583_);
            }
        } else {
            this.f_39769_.m_6836_(1, ItemStack.f_41583_);
        }
        this.f_39002_.m_6422_(-1);
        this.f_39770_.m_39292_((p_150479_, p_150480_) -> {
            BlockState blockstate = p_150479_.m_8055_((BlockPos)p_150480_);
            if (!p_150474_.m_150110_().f_35937_ && blockstate.m_204336_(BlockTags.f_13033_) && p_150474_.m_217043_().m_188501_() < breakChance) {
                BlockState blockstate1 = AnvilBlock.m_48824_((BlockState)blockstate);
                if (blockstate1 == null) {
                    p_150479_.m_7471_((BlockPos)p_150480_, false);
                    p_150479_.m_46796_(1029, p_150480_, 0);
                } else {
                    p_150479_.m_7731_((BlockPos)p_150480_, blockstate1, 2);
                    p_150479_.m_46796_(1030, p_150480_, 0);
                }
            } else {
                p_150479_.m_46796_(1030, p_150480_, 0);
            }
        });
    }

    @Override
    public void m_6640_() {
        ItemStack itemstack = this.f_39769_.m_8020_(0);
        this.f_39002_.m_6422_(1);
        int i = 0;
        int j = 0;
        int k = 0;
        if (itemstack.m_41619_()) {
            CraftEventFactory.callPrepareAnvilEvent((InventoryView)this.getBukkitView(), (ItemStack)ItemStack.f_41583_);
            this.f_39002_.m_6422_(-1);
        } else {
            ItemStack itemstack1 = itemstack.m_41777_();
            ItemStack itemstack2 = this.f_39769_.m_8020_(1);
            Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_(itemstack1);
            int n = itemstack2.m_41619_() ? 0 : itemstack2.m_41610_();
            this.f_39000_ = 0;
            boolean flag = false;
            if (!ForgeHooks.onAnvilChange((AnvilMenu)this, (ItemStack)itemstack, (ItemStack)itemstack2, (Container)this.f_39768_, (String)this.f_39001_, (int)(j += itemstack.m_41610_() + n), (Player)this.f_39771_)) {
                return;
            }
            if (!itemstack2.m_41619_()) {
                boolean bl = flag = itemstack2.m_41720_() == Items.f_42690_ && !EnchantedBookItem.m_41163_((ItemStack)itemstack2).isEmpty();
                if (itemstack1.m_41763_() && itemstack1.m_41720_().m_6832_(itemstack, itemstack2)) {
                    int i3;
                    int l2 = Math.min(itemstack1.m_41773_(), itemstack1.m_41776_() / 4);
                    if (l2 <= 0) {
                        CraftEventFactory.callPrepareAnvilEvent((InventoryView)this.getBukkitView(), (ItemStack)ItemStack.f_41583_);
                        this.f_39002_.m_6422_(-1);
                        return;
                    }
                    for (i3 = 0; l2 > 0 && i3 < itemstack2.m_41613_(); ++i3) {
                        int j3 = itemstack1.m_41773_() - l2;
                        itemstack1.m_41721_(j3);
                        ++i;
                        l2 = Math.min(itemstack1.m_41773_(), itemstack1.m_41776_() / 4);
                    }
                    this.f_39000_ = i3;
                } else {
                    if (!(flag || itemstack1.m_150930_(itemstack2.m_41720_()) && itemstack1.m_41763_())) {
                        CraftEventFactory.callPrepareAnvilEvent((InventoryView)this.getBukkitView(), (ItemStack)ItemStack.f_41583_);
                        this.f_39002_.m_6422_(-1);
                        return;
                    }
                    if (itemstack1.m_41763_() && !flag) {
                        int l = itemstack.m_41776_() - itemstack.m_41773_();
                        int i1 = itemstack2.m_41776_() - itemstack2.m_41773_();
                        int j1 = i1 + itemstack1.m_41776_() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = itemstack1.m_41776_() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < itemstack1.m_41773_()) {
                            itemstack1.m_41721_(l1);
                            i += 2;
                        }
                    }
                    Map<Enchantment, Integer> map1 = EnchantmentHelper.m_44831_(itemstack2);
                    boolean flag2 = false;
                    boolean flag3 = false;
                    for (Enchantment enchantment1 : map1.keySet()) {
                        int j2;
                        if (enchantment1 == null) continue;
                        int i2 = map.getOrDefault(enchantment1, 0);
                        j2 = i2 == (j2 = map1.get(enchantment1).intValue()) ? j2 + 1 : Math.max(j2, i2);
                        boolean flag1 = enchantment1.m_6081_(itemstack);
                        if (this.f_39771_.m_150110_().f_35937_ || itemstack.m_150930_(Items.f_42690_)) {
                            flag1 = true;
                        }
                        for (Enchantment enchantment : map.keySet()) {
                            if (enchantment == enchantment1 || enchantment1.m_44695_(enchantment)) continue;
                            flag1 = false;
                            ++i;
                        }
                        if (!flag1) {
                            flag3 = true;
                            continue;
                        }
                        flag2 = true;
                        if (j2 > enchantment1.m_6586_()) {
                            j2 = enchantment1.m_6586_();
                        }
                        map.put(enchantment1, j2);
                        int k3 = 0;
                        switch (enchantment1.m_44699_()) {
                            case COMMON: {
                                k3 = 1;
                                break;
                            }
                            case UNCOMMON: {
                                k3 = 2;
                                break;
                            }
                            case RARE: {
                                k3 = 4;
                                break;
                            }
                            case VERY_RARE: {
                                k3 = 8;
                            }
                        }
                        if (flag) {
                            k3 = Math.max(1, k3 / 2);
                        }
                        i += k3 * j2;
                        if (itemstack.m_41613_() <= 1) continue;
                        i = 40;
                    }
                    if (flag3 && !flag2) {
                        CraftEventFactory.callPrepareAnvilEvent((InventoryView)this.getBukkitView(), (ItemStack)ItemStack.f_41583_);
                        this.f_39002_.m_6422_(-1);
                        return;
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)this.f_39001_)) {
                if (itemstack.m_41788_()) {
                    k = 1;
                    i += k;
                    itemstack1.m_41787_();
                }
            } else if (!this.f_39001_.equals(itemstack.m_41786_().getString())) {
                k = 1;
                i += k;
                itemstack1.m_41714_((Component)Component.m_237113_(this.f_39001_));
            }
            if (flag && !itemstack1.isBookEnchantable(itemstack2)) {
                itemstack1 = ItemStack.f_41583_;
            }
            this.f_39002_.m_6422_(j + i);
            if (i <= 0) {
                itemstack1 = ItemStack.f_41583_;
            }
            if (k == i && k > 0 && this.f_39002_.m_6501_() >= this.maximumRepairCost) {
                this.f_39002_.m_6422_(this.maximumRepairCost - 1);
            }
            if (this.f_39002_.m_6501_() >= this.maximumRepairCost && !this.f_39771_.m_150110_().f_35937_) {
                itemstack1 = ItemStack.f_41583_;
            }
            if (!itemstack1.m_41619_()) {
                int k2 = itemstack1.m_41610_();
                if (!itemstack2.m_41619_() && k2 < itemstack2.m_41610_()) {
                    k2 = itemstack2.m_41610_();
                }
                if (k != i || k == 0) {
                    k2 = AnvilMenu.m_39025_(k2);
                }
                itemstack1.m_41742_(k2);
                EnchantmentHelper.m_44865_(map, itemstack1);
            }
            CraftEventFactory.callPrepareAnvilEvent((InventoryView)this.getBukkitView(), (ItemStack)itemstack1);
            this.m_150429_();
            this.m_38946_();
        }
    }

    public static int m_39025_(int p_39026_) {
        return p_39026_ * 2 + 1;
    }

    public void m_39020_(String p_39021_) {
        this.f_39001_ = p_39021_;
        if (this.m_38853_(2).m_6657_()) {
            ItemStack itemstack = this.m_38853_(2).m_7993_();
            if (StringUtils.isBlank((CharSequence)p_39021_)) {
                itemstack.m_41787_();
            } else {
                itemstack.m_41714_((Component)Component.m_237113_(this.f_39001_));
            }
        }
        this.m_6640_();
    }

    public int m_39028_() {
        return this.f_39002_.m_6501_();
    }

    public void setMaximumCost(int value) {
        this.f_39002_.m_6422_(value);
    }
}

