/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModeCheck;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
extends CapabilityProvider<ItemStack>
implements IForgeItemStack {
    public static final Codec<ItemStack> f_41582_ = RecordCodecBuilder.create(p_258963_ -> p_258963_.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("id").forGetter(p_150946_ -> p_150946_.f_41589_), (App)Codec.INT.fieldOf("Count").forGetter(p_150941_ -> p_150941_.f_41587_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(p_150939_ -> Optional.ofNullable(p_150939_.f_41590_))).apply((Applicative)p_258963_, ItemStack::new));
    private Holder.Reference<Item> delegate;
    private CompoundTag capNBT;
    private static final Logger f_41585_ = LogUtils.getLogger();
    public static final ItemStack f_41583_ = new ItemStack((ItemLike)null);
    public static final DecimalFormat f_41584_ = Util.m_137469_(new DecimalFormat("#.##"), p_41704_ -> p_41704_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final String f_150906_ = "Enchantments";
    public static final String f_150909_ = "display";
    public static final String f_150910_ = "Name";
    public static final String f_150911_ = "Lore";
    public static final String f_150912_ = "Damage";
    public static final String f_150913_ = "color";
    private static final String f_150914_ = "Unbreakable";
    private static final String f_150915_ = "RepairCost";
    private static final String f_150916_ = "CanDestroy";
    private static final String f_150917_ = "CanPlaceOn";
    private static final String f_150918_ = "HideFlags";
    private static final Component f_243862_ = Component.m_237115_("item.disabled").m_130940_(ChatFormatting.RED);
    private static final int f_150919_ = 0;
    private static final Style f_41586_ = Style.f_131099_.m_131140_(ChatFormatting.DARK_PURPLE).m_131155_(Boolean.valueOf(true));
    private int f_41587_;
    private int f_41588_;
    @Deprecated
    private Item f_41589_;
    @Nullable
    private CompoundTag f_41590_;
    private boolean f_41591_;
    @Nullable
    private Entity f_41592_;
    @Nullable
    private AdventureModeCheck f_186360_;
    @Nullable
    private AdventureModeCheck f_186361_;

    public Optional<TooltipComponent> m_150921_() {
        return this.m_41720_().m_142422_(this);
    }

    public ItemStack(ItemLike p_41599_) {
        this(p_41599_, 1);
    }

    public ItemStack(Holder<Item> p_204116_) {
        this(p_204116_.m_203334_(), 1);
    }

    private ItemStack(ItemLike p_41604_, int p_41605_, Optional<CompoundTag> p_41606_) {
        this(p_41604_, p_41605_);
        p_41606_.ifPresent(this::m_41751_);
    }

    public ItemStack(Holder<Item> p_220155_, int p_220156_) {
        this(p_220155_.m_203334_(), p_220156_);
    }

    public ItemStack(ItemLike p_41601_, int p_41602_) {
        this(p_41601_, p_41602_, (CompoundTag)null);
    }

    public ItemStack(ItemLike p_41604_, int p_41605_, @Nullable CompoundTag p_41606_) {
        super(ItemStack.class, true);
        this.capNBT = p_41606_;
        this.f_41589_ = p_41604_ == null ? null : p_41604_.m_5456_();
        this.delegate = p_41604_ == null ? null : ForgeRegistries.ITEMS.getDelegateOrThrow((Object)p_41604_.m_5456_());
        this.f_41587_ = p_41605_;
        this.forgeInit();
        if (this.f_41589_ != null && this.f_41589_.isDamageable(this)) {
            this.m_41721_(this.m_41773_());
        }
        this.m_41617_();
    }

    private void m_41617_() {
        this.f_41591_ = false;
        this.f_41591_ = this.m_41619_();
    }

    public void convertStack(int version) {
        if (0 < version && version < CraftMagicNumbers.INSTANCE.getDataVersion()) {
            CompoundTag savedStack = new CompoundTag();
            this.m_41739_(savedStack);
            savedStack = (CompoundTag)MinecraftServer.getServer().m_129933_().update(References.f_16782_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)savedStack), version, CraftMagicNumbers.INSTANCE.getDataVersion()).getValue();
            this.load(savedStack);
        }
    }

    private void load(CompoundTag compound) {
        this.capNBT = compound.m_128441_("ForgeCaps") ? compound.m_128469_("ForgeCaps") : null;
        Item rawItem = this.f_41589_ = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(compound.m_128461_("id")));
        this.delegate = ForgeRegistries.ITEMS.getDelegateOrThrow((Object)rawItem);
        this.f_41587_ = compound.m_128445_("Count");
        if (compound.m_128425_("tag", 10)) {
            this.f_41590_ = compound.m_128469_("tag").m_6426_();
            this.m_41720_().m_142312_(this.f_41590_);
        }
        this.forgeInit();
        if (this.m_41720_().isDamageable(this)) {
            this.m_41721_(this.m_41773_());
        }
    }

    private ItemStack(CompoundTag p_41608_) {
        super(ItemStack.class, true);
        this.capNBT = p_41608_.m_128441_("ForgeCaps") ? p_41608_.m_128469_("ForgeCaps") : null;
        Item rawItem = this.f_41589_ = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(p_41608_.m_128461_("id")));
        this.delegate = ForgeRegistries.ITEMS.getDelegateOrThrow((Object)rawItem);
        this.f_41587_ = p_41608_.m_128445_("Count");
        if (p_41608_.m_128425_("tag", 10)) {
            this.f_41590_ = p_41608_.m_128469_("tag");
            this.m_41720_().m_142312_(this.f_41590_);
        }
        this.forgeInit();
        if (this.m_41720_().m_41465_()) {
            this.m_41721_(this.m_41773_());
        }
        this.m_41617_();
    }

    public CompoundTag getForgeCaps() {
        return this.serializeCaps();
    }

    public void setForgeCaps(CompoundTag nbt) {
        this.capNBT = nbt;
        if (nbt != null) {
            this.deserializeCaps(nbt);
        }
    }

    public static ItemStack m_41712_(CompoundTag p_41713_) {
        try {
            return new ItemStack(p_41713_);
        }
        catch (RuntimeException runtimeexception) {
            f_41585_.debug("Tried to load invalid item: {}", (Object)p_41713_, (Object)runtimeexception);
            return f_41583_;
        }
    }

    public boolean m_41619_() {
        if (this == f_41583_) {
            return true;
        }
        if (this.m_41720_() != null && !this.m_150930_(Items.f_41852_)) {
            return this.f_41587_ <= 0;
        }
        return true;
    }

    public boolean m_246617_(FeatureFlagSet p_250869_) {
        return this.m_41619_() || this.m_41720_().m_245993_(p_250869_);
    }

    public ItemStack m_41620_(int p_41621_) {
        int i = Math.min(p_41621_, this.f_41587_);
        ItemStack itemstack = this.m_41777_();
        itemstack.m_41764_(i);
        this.m_41774_(i);
        return itemstack;
    }

    public Item m_41720_() {
        return this.f_41591_ || this.delegate == null ? Items.f_41852_ : (Item)this.delegate.get();
    }

    public Holder<Item> m_220173_() {
        return this.m_41720_().m_204114_();
    }

    public boolean m_204117_(TagKey<Item> p_204118_) {
        return this.m_41720_().m_204114_().m_203656_(p_204118_);
    }

    public boolean m_150930_(Item p_150931_) {
        return this.m_41720_() == p_150931_;
    }

    public boolean m_220167_(Predicate<Holder<Item>> p_220168_) {
        return p_220168_.test(this.m_41720_().m_204114_());
    }

    public boolean m_220165_(Holder<Item> p_220166_) {
        return this.m_41720_().m_204114_() == p_220166_;
    }

    public Stream<TagKey<Item>> m_204131_() {
        return this.m_41720_().m_204114_().m_203616_();
    }

    public InteractionResult m_41661_(UseOnContext p_41662_) {
        if (!p_41662_.m_43725_().f_46443_) {
            return ForgeHooks.onPlaceItemIntoWorld((UseOnContext)p_41662_);
        }
        return this.onItemUse(p_41662_, c -> this.m_41720_().m_6225_(p_41662_));
    }

    public InteractionResult onItemUseFirst(UseOnContext p_41662_) {
        return this.onItemUse(p_41662_, c -> this.m_41720_().onItemUseFirst(this, p_41662_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InteractionResult onItemUse(UseOnContext p_41662_, Function<UseOnContext, InteractionResult> callback) {
        Player player = p_41662_.m_43723_();
        BlockPos blockpos = p_41662_.m_8083_();
        BlockInWorld blockinworld = new BlockInWorld((LevelReader)p_41662_.m_43725_(), blockpos, false);
        if (player != null && !player.m_150110_().f_35938_ && !this.m_204121_((Registry<Block>)p_41662_.m_43725_().m_9598_().m_175515_(Registries.f_256747_), blockinworld)) {
            return InteractionResult.PASS;
        }
        CompoundTag oldData = this.getTagClone();
        int oldCount = this.m_41613_();
        ServerLevel world = (ServerLevel)p_41662_.m_43725_();
        if (!(this.m_41720_() instanceof BucketItem) && !(this.m_41720_() instanceof SolidBucketItem)) {
            world.captureBlockStates = true;
            if (this.m_41720_() == Items.f_42499_) {
                world.captureTreeGeneration = true;
            }
        }
        Item item = this.m_41720_();
        InteractionResult interactionresult = callback.apply(p_41662_);
        CompoundTag newData = this.getTagClone();
        int newCount = this.m_41613_();
        this.m_41764_(oldCount);
        this.setTagClone(oldData);
        world.captureBlockStates = false;
        if (interactionresult.m_19077_() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit((BlockPos)blockpos, (World)world.getWorld());
            TreeType treeType = SaplingBlock.treeType;
            ArrayList blocks = new ArrayList(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.m_41720_() == Items.f_42499_;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (org.bukkit.entity.Player)player.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at((LevelAccessor)world, (BlockPos)blockpos), (org.bukkit.entity.Player)player.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.m_41613_() == oldCount && Objects.equals(this.f_41590_, oldData)) {
                    this.m_41751_(newData);
                    this.m_41764_(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    world.m_7731_(blockstate.getPosition(), blockstate.getHandle(), blockstate.getFlag());
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            }
            SignItem.openSign = null;
            return interactionresult;
        }
        world.captureTreeGeneration = false;
        if (player != null && interactionresult.m_146666_()) {
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList blocks = new ArrayList(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent((ServerLevel)world, (Player)player, (InteractionHand)p_41662_.m_43724_(), blocks, (int)blockpos.m_123341_(), (int)blockpos.m_123342_(), (int)blockpos.m_123343_());
            } else if (blocks.size() == 1) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent((ServerLevel)world, (Player)player, (InteractionHand)p_41662_.m_43724_(), (BlockState)((BlockState)blocks.get(0)), (int)blockpos.m_123341_(), (int)blockpos.m_123342_(), (int)blockpos.m_123343_());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                interactionresult = InteractionResult.FAIL;
                placeEvent.getPlayer().updateInventory();
                world.preventPoiUpdated = true;
                for (Direction[] blockstate : blocks) {
                    blockstate.update(true, false);
                }
                world.preventPoiUpdated = false;
                BlockPos placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
                for (Direction dir : Direction.values()) {
                    ((ServerPlayer)player).f_8906_.m_9829_((Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)world, placedPos.m_121945_(dir)));
                }
                SignItem.openSign = null;
            } else {
                BlockPos position;
                net.minecraft.world.level.block.state.BlockState blockData;
                if (this.m_41613_() == oldCount && Objects.equals(this.f_41590_, oldData)) {
                    this.m_41751_(newData);
                    this.m_41764_(newCount);
                }
                for (Map.Entry e : world.capturedTileEntities.entrySet()) {
                    world.m_151523_((BlockEntity)((Object)e.getValue()));
                }
                for (BlockState blockstate : blocks) {
                    int updateFlag = ((CraftBlockState)blockstate).getFlag();
                    net.minecraft.world.level.block.state.BlockState oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPos newblockposition = ((CraftBlockState)blockstate).getPosition();
                    net.minecraft.world.level.block.state.BlockState block = world.m_8055_(newblockposition);
                    if (!(block.m_60734_() instanceof BaseEntityBlock)) {
                        block.m_60734_().m_6807_(block, world, newblockposition, oldBlock, true);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.m_8055_(newblockposition), updateFlag, 512);
                }
                if (this.f_41589_ instanceof RecordItem) {
                    BlockEntity tileentity = world.m_7702_(blockpos);
                    if (tileentity instanceof JukeboxBlockEntity) {
                        JukeboxBlockEntity tileentityjukebox = (JukeboxBlockEntity)tileentity;
                        ItemStack record = this.m_41777_();
                        if (!record.m_41619_()) {
                            record.m_41764_(1);
                        }
                        tileentityjukebox.m_272287_(record);
                        world.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (net.minecraft.world.level.block.state.BlockState)world.m_8055_(blockpos)));
                    }
                    this.m_41774_(1);
                    player.m_36220_(Stats.f_12965_);
                }
                if (this.f_41589_ == Items.f_42679_) {
                    BlockEntity te;
                    Object bp = blockpos;
                    if (!world.m_8055_(blockpos).m_60767_().m_76336_()) {
                        bp = !world.m_8055_(blockpos).m_60767_().m_76333_() ? null : bp.m_121945_(p_41662_.m_43719_());
                    }
                    if (bp != null && (te = world.m_7702_((BlockPos)bp)) instanceof SkullBlockEntity) {
                        WitherSkullBlock.m_58255_(world, bp, (SkullBlockEntity)te);
                    }
                }
                if (this.f_41589_ instanceof SignItem && SignItem.openSign != null) {
                    try {
                        player.m_7739_((SignBlockEntity)world.m_7702_(SignItem.openSign));
                    }
                    finally {
                        SignItem.openSign = null;
                    }
                }
                if (placeEvent != null && this.f_41589_ instanceof BedItem && (blockData = world.m_8055_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).m_60734_() instanceof BedBlock) {
                    world.m_6289_(position, Blocks.f_50016_);
                    blockData.m_60701_(world, position, 3);
                }
                if (this.f_41589_ instanceof BlockItem) {
                    SoundType soundeffecttype = ((BlockItem)this.f_41589_).m_40614_().m_49962_(null);
                    world.m_5594_(player, blockpos, soundeffecttype.m_56777_(), SoundSource.BLOCKS, (soundeffecttype.m_56773_() + 1.0f) / 2.0f, soundeffecttype.m_56774_() * 0.8f);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return interactionresult;
    }

    public float m_41691_(net.minecraft.world.level.block.state.BlockState p_41692_) {
        return this.m_41720_().m_8102_(this, p_41692_);
    }

    public InteractionResultHolder<ItemStack> m_41682_(Level p_41683_, Player p_41684_, InteractionHand p_41685_) {
        return this.m_41720_().m_7203_(p_41683_, p_41684_, p_41685_);
    }

    public ItemStack m_41671_(Level p_41672_, LivingEntity p_41673_) {
        return this.m_41720_().m_5922_(this, p_41672_, p_41673_);
    }

    public CompoundTag m_41739_(CompoundTag p_41740_) {
        CompoundTag cnbt;
        ResourceLocation resourcelocation = BuiltInRegistries.f_257033_.m_7981_((Object)this.m_41720_());
        p_41740_.m_128359_("id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        p_41740_.m_128344_("Count", (byte)this.f_41587_);
        if (this.f_41590_ != null) {
            p_41740_.m_128365_("tag", this.f_41590_.m_6426_());
        }
        if ((cnbt = this.serializeCaps()) != null && !cnbt.m_128456_()) {
            p_41740_.m_128365_("ForgeCaps", cnbt);
        }
        return p_41740_;
    }

    public int m_41741_() {
        return this.m_41720_().getMaxStackSize(this);
    }

    public boolean m_41753_() {
        return this.m_41741_() > 1 && (!this.m_41763_() || !this.m_41768_());
    }

    public boolean m_41763_() {
        if (!this.f_41591_ && this.m_41720_().isDamageable(this)) {
            CompoundTag compoundtag = this.m_41783_();
            return compoundtag == null || !compoundtag.m_128471_(f_150914_);
        }
        return false;
    }

    public boolean m_41768_() {
        return this.m_41763_() && this.m_41720_().isDamaged(this);
    }

    public int m_41773_() {
        return this.m_41720_().getDamage(this);
    }

    public void m_41721_(int p_41722_) {
        this.m_41720_().setDamage(this, p_41722_);
    }

    public int m_41776_() {
        return this.m_41720_().getMaxDamage(this);
    }

    public boolean m_220157_(int p_220158_, RandomSource p_220159_, @Nullable ServerPlayer p_220160_) {
        if (!this.m_41763_()) {
            return false;
        }
        if (p_220158_ > 0) {
            int i = EnchantmentHelper.m_44843_(Enchantments.f_44986_, this);
            int j = 0;
            for (int k = 0; i > 0 && k < p_220158_; ++k) {
                if (!DigDurabilityEnchantment.m_220282_((ItemStack)this, (int)i, (RandomSource)p_220159_)) continue;
                ++j;
            }
            p_220158_ -= j;
            if (p_220160_ != null) {
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((org.bukkit.entity.Player)p_220160_.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror((ItemStack)this), p_220158_);
                event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                if (p_220158_ != event.getDamage() || event.isCancelled()) {
                    event.getPlayer().updateInventory();
                }
                if (event.isCancelled()) {
                    return false;
                }
                p_220158_ = event.getDamage();
            }
            if (p_220158_ <= 0) {
                return false;
            }
        }
        if (p_220160_ != null && p_220158_ != 0) {
            CriteriaTriggers.f_10586_.m_43669_(p_220160_, this, this.m_41773_() + p_220158_);
        }
        int l = this.m_41773_() + p_220158_;
        this.m_41721_(l);
        return l >= this.m_41776_();
    }

    public <T extends LivingEntity> void m_41622_(int p_41623_, T p_41624_, Consumer<T> p_41625_) {
        if (!(p_41624_.f_19853_.f_46443_ || p_41624_ instanceof Player && ((Player)p_41624_).m_150110_().f_35937_ || !this.m_41763_() || !this.m_220157_(p_41623_ = this.m_41720_().damageItem(this, p_41623_, p_41624_, p_41625_), p_41624_.m_217043_(), p_41624_ instanceof ServerPlayer ? (ServerPlayer)p_41624_ : null))) {
            p_41625_.accept(p_41624_);
            Item item = this.m_41720_();
            if (this.f_41587_ == 1 && p_41624_ instanceof Player) {
                CraftEventFactory.callPlayerItemBreakEvent((Player)((Player)p_41624_), (ItemStack)this);
            }
            this.m_41774_(1);
            if (p_41624_ instanceof Player) {
                ((Player)p_41624_).m_36246_(Stats.f_12983_.m_12902_((Object)item));
            }
            this.m_41721_(0);
        }
    }

    public boolean m_150947_() {
        return this.f_41589_.m_142522_(this);
    }

    public int m_150948_() {
        return this.f_41589_.m_142158_(this);
    }

    public int m_150949_() {
        return this.f_41589_.m_142159_(this);
    }

    public boolean m_150926_(Slot p_150927_, ClickAction p_150928_, Player p_150929_) {
        return this.m_41720_().m_142207_(this, p_150927_, p_150928_, p_150929_);
    }

    public boolean m_150932_(ItemStack p_150933_, Slot p_150934_, ClickAction p_150935_, Player p_150936_, SlotAccess p_150937_) {
        return this.m_41720_().m_142305_(this, p_150933_, p_150934_, p_150935_, p_150936_, p_150937_);
    }

    public void m_41640_(LivingEntity p_41641_, Player p_41642_) {
        Item item = this.m_41720_();
        if (item.m_7579_(this, p_41641_, p_41642_)) {
            p_41642_.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        }
    }

    public void m_41686_(Level p_41687_, net.minecraft.world.level.block.state.BlockState p_41688_, BlockPos p_41689_, Player p_41690_) {
        Item item = this.m_41720_();
        if (item.m_6813_(this, p_41687_, p_41688_, p_41689_, p_41690_)) {
            p_41690_.m_36246_(Stats.f_12982_.m_12902_((Object)item));
        }
    }

    public boolean m_41735_(net.minecraft.world.level.block.state.BlockState p_41736_) {
        return this.m_41720_().isCorrectToolForDrops(this, p_41736_);
    }

    public InteractionResult m_41647_(Player p_41648_, LivingEntity p_41649_, InteractionHand p_41650_) {
        return this.m_41720_().m_6880_(this, p_41648_, p_41649_, p_41650_);
    }

    public ItemStack m_41777_() {
        if (this.m_41619_()) {
            return f_41583_;
        }
        ItemStack itemstack = new ItemStack((ItemLike)this.m_41720_(), this.f_41587_, this.serializeCaps());
        itemstack.m_41754_(this.m_41612_());
        if (this.f_41590_ != null) {
            itemstack.f_41590_ = this.f_41590_.m_6426_();
        }
        return itemstack;
    }

    public ItemStack m_255036_(int p_256354_) {
        ItemStack itemstack = this.m_41777_();
        itemstack.m_41764_(p_256354_);
        return itemstack;
    }

    public static boolean m_41658_(ItemStack p_41659_, ItemStack p_41660_) {
        if (p_41659_.m_41619_() && p_41660_.m_41619_()) {
            return true;
        }
        if (!p_41659_.m_41619_() && !p_41660_.m_41619_()) {
            if (p_41659_.f_41590_ == null && p_41660_.f_41590_ != null) {
                return false;
            }
            return (p_41659_.f_41590_ == null || p_41659_.f_41590_.equals(p_41660_.f_41590_)) && p_41659_.areCapsCompatible(p_41660_);
        }
        return false;
    }

    public static boolean m_41728_(ItemStack p_41729_, ItemStack p_41730_) {
        if (p_41729_.m_41619_() && p_41730_.m_41619_()) {
            return true;
        }
        return !p_41729_.m_41619_() && !p_41730_.m_41619_() ? p_41729_.m_41744_(p_41730_) : false;
    }

    private boolean m_41744_(ItemStack p_41745_) {
        if (this.f_41587_ != p_41745_.f_41587_) {
            return false;
        }
        if (!this.m_150930_(p_41745_.m_41720_())) {
            return false;
        }
        if (this.f_41590_ == null && p_41745_.f_41590_ != null) {
            return false;
        }
        return (this.f_41590_ == null || this.f_41590_.equals(p_41745_.f_41590_)) && this.areCapsCompatible(p_41745_);
    }

    public static boolean m_41746_(ItemStack p_41747_, ItemStack p_41748_) {
        if (p_41747_ == p_41748_) {
            return true;
        }
        return !p_41747_.m_41619_() && !p_41748_.m_41619_() ? p_41747_.m_41656_(p_41748_) : false;
    }

    public boolean m_41656_(ItemStack p_41657_) {
        return !p_41657_.m_41619_() && this.m_150930_(p_41657_.m_41720_());
    }

    public static boolean m_150942_(ItemStack p_150943_, ItemStack p_150944_) {
        return p_150943_.m_150930_(p_150944_.m_41720_()) && ItemStack.m_41658_(p_150943_, p_150944_);
    }

    public String m_41778_() {
        return this.m_41720_().m_5671_(this);
    }

    public String toString() {
        return this.f_41587_ + " " + this.m_41720_();
    }

    public void m_41666_(Level p_41667_, Entity p_41668_, int p_41669_, boolean p_41670_) {
        if (this.f_41588_ > 0) {
            --this.f_41588_;
        }
        if (this.m_41720_() != null) {
            this.m_41720_().m_6883_(this, p_41667_, p_41668_, p_41669_, p_41670_);
        }
    }

    public void m_41678_(Level p_41679_, Player p_41680_, int p_41681_) {
        p_41680_.m_6278_(Stats.f_12981_.m_12902_((Object)this.m_41720_()), p_41681_);
        this.m_41720_().m_7836_(this, p_41679_, p_41680_);
    }

    public int m_41779_() {
        return this.m_41720_().m_8105_(this);
    }

    public UseAnim m_41780_() {
        return this.m_41720_().m_6164_(this);
    }

    public void m_41674_(Level p_41675_, LivingEntity p_41676_, int p_41677_) {
        this.m_41720_().m_5551_(this, p_41675_, p_41676_, p_41677_);
    }

    public boolean m_41781_() {
        return this.m_41720_().m_41463_(this);
    }

    public boolean m_41782_() {
        return !this.f_41591_ && this.f_41590_ != null && !this.f_41590_.m_128456_();
    }

    @Nullable
    public CompoundTag m_41783_() {
        return this.f_41590_;
    }

    @Nullable
    private CompoundTag getTagClone() {
        return this.f_41590_ == null ? null : this.f_41590_.m_6426_();
    }

    private void setTagClone(@Nullable CompoundTag nbtttagcompound) {
        this.m_41751_(nbtttagcompound == null ? null : nbtttagcompound.m_6426_());
    }

    public CompoundTag m_41784_() {
        if (this.f_41590_ == null) {
            this.m_41751_(new CompoundTag());
        }
        return this.f_41590_;
    }

    public CompoundTag m_41698_(String p_41699_) {
        if (this.f_41590_ != null && this.f_41590_.m_128425_(p_41699_, 10)) {
            return this.f_41590_.m_128469_(p_41699_);
        }
        CompoundTag compoundtag = new CompoundTag();
        this.m_41700_(p_41699_, compoundtag);
        return compoundtag;
    }

    @Nullable
    public CompoundTag m_41737_(String p_41738_) {
        return this.f_41590_ != null && this.f_41590_.m_128425_(p_41738_, 10) ? this.f_41590_.m_128469_(p_41738_) : null;
    }

    public void m_41749_(String p_41750_) {
        if (this.f_41590_ != null && this.f_41590_.m_128441_(p_41750_)) {
            this.f_41590_.m_128473_(p_41750_);
            if (this.f_41590_.m_128456_()) {
                this.f_41590_ = null;
            }
        }
    }

    public ListTag m_41785_() {
        return this.f_41590_ != null ? this.f_41590_.m_128437_(f_150906_, 10) : new ListTag();
    }

    public void m_41751_(@Nullable CompoundTag p_41752_) {
        this.f_41590_ = p_41752_;
        if (this.m_41720_().isDamageable(this)) {
            this.m_41721_(this.m_41773_());
        }
        if (p_41752_ != null) {
            this.m_41720_().m_142312_(p_41752_);
        }
    }

    public Component m_41786_() {
        CompoundTag compoundtag = this.m_41737_(f_150909_);
        if (compoundtag != null && compoundtag.m_128425_(f_150910_, 8)) {
            try {
                MutableComponent component = Component.Serializer.m_130701_(compoundtag.m_128461_(f_150910_));
                if (component != null) {
                    return component;
                }
                compoundtag.m_128473_(f_150910_);
            }
            catch (Exception exception) {
                compoundtag.m_128473_(f_150910_);
            }
        }
        return this.m_41720_().m_7626_(this);
    }

    public ItemStack m_41714_(@Nullable Component p_41715_) {
        CompoundTag compoundtag = this.m_41698_(f_150909_);
        if (p_41715_ != null) {
            compoundtag.m_128359_(f_150910_, Component.Serializer.m_130703_(p_41715_));
        } else {
            compoundtag.m_128473_(f_150910_);
        }
        return this;
    }

    public void m_41787_() {
        CompoundTag compoundtag = this.m_41737_(f_150909_);
        if (compoundtag != null) {
            compoundtag.m_128473_(f_150910_);
            if (compoundtag.m_128456_()) {
                this.m_41749_(f_150909_);
            }
        }
        if (this.f_41590_ != null && this.f_41590_.m_128456_()) {
            this.f_41590_ = null;
        }
    }

    public boolean m_41788_() {
        CompoundTag compoundtag = this.m_41737_(f_150909_);
        return compoundtag != null && compoundtag.m_128425_(f_150910_, 8);
    }

    public List<Component> m_41651_(@Nullable Player p_41652_, TooltipFlag p_41653_) {
        int j;
        Integer integer;
        ArrayList list = Lists.newArrayList();
        MutableComponent mutablecomponent = Component.m_237119_().m_7220_(this.m_41786_()).m_130938_(this.m_41791_().getStyleModifier());
        if (this.m_41788_()) {
            mutablecomponent.m_130940_(ChatFormatting.ITALIC);
        }
        list.add(mutablecomponent);
        if (!p_41653_.m_7050_() && !this.m_41788_() && this.m_150930_(Items.f_42573_) && (integer = MapItem.m_151131_(this)) != null) {
            list.add(Component.m_237113_("#" + integer).m_130940_(ChatFormatting.GRAY));
        }
        if (ItemStack.m_41626_(j = this.m_41618_(), TooltipPart.ADDITIONAL)) {
            this.m_41720_().m_7373_(this, p_41652_ == null ? null : p_41652_.f_19853_, list, p_41653_);
        }
        if (this.m_41782_()) {
            if (ItemStack.m_41626_(j, TooltipPart.UPGRADES) && p_41652_ != null) {
                ArmorTrim.m_266563_((ItemStack)this, (RegistryAccess)p_41652_.f_19853_.m_9598_(), (List)list);
            }
            if (ItemStack.m_41626_(j, TooltipPart.ENCHANTMENTS)) {
                ItemStack.m_41709_(list, this.m_41785_());
            }
            if (this.f_41590_.m_128425_(f_150909_, 10)) {
                CompoundTag compoundtag = this.f_41590_.m_128469_(f_150909_);
                if (ItemStack.m_41626_(j, TooltipPart.DYE) && compoundtag.m_128425_(f_150913_, 99)) {
                    if (p_41653_.m_7050_()) {
                        list.add(Component.m_237110_("item.color", String.format(Locale.ROOT, "#%06X", compoundtag.m_128451_(f_150913_))).m_130940_(ChatFormatting.GRAY));
                    } else {
                        list.add(Component.m_237115_("item.dyed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    }
                }
                if (compoundtag.m_128435_(f_150911_) == 9) {
                    ListTag listtag = compoundtag.m_128437_(f_150911_, 8);
                    for (int i = 0; i < listtag.size(); ++i) {
                        String s = listtag.m_128778_(i);
                        try {
                            MutableComponent mutablecomponent1 = Component.Serializer.m_130701_(s);
                            if (mutablecomponent1 == null) continue;
                            list.add(ComponentUtils.m_130750_((MutableComponent)mutablecomponent1, (Style)f_41586_));
                            continue;
                        }
                        catch (Exception exception) {
                            compoundtag.m_128473_(f_150911_);
                        }
                    }
                }
            }
        }
        if (ItemStack.m_41626_(j, TooltipPart.MODIFIERS)) {
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                Multimap<Attribute, AttributeModifier> multimap = this.m_41638_(equipmentslot);
                if (multimap.isEmpty()) continue;
                list.add(CommonComponents.f_237098_);
                list.add(Component.m_237115_("item.modifiers." + equipmentslot.m_20751_()).m_130940_(ChatFormatting.GRAY));
                for (Map.Entry entry : multimap.entries()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    double d0 = attributemodifier.m_22218_();
                    boolean flag = false;
                    if (p_41652_ != null) {
                        if (attributemodifier.m_22209_() == Item.f_41374_) {
                            d0 += p_41652_.m_21172_(Attributes.f_22281_);
                            d0 += (double)EnchantmentHelper.m_44833_(this, MobType.f_21640_);
                            flag = true;
                        } else if (attributemodifier.m_22209_() == Item.f_41375_) {
                            d0 += p_41652_.m_21172_(Attributes.f_22283_);
                            flag = true;
                        }
                    }
                    double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
                    if (flag) {
                        list.add(CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_("attribute.modifier.equals." + attributemodifier.m_22217_().m_22235_(), f_41584_.format(d1), Component.m_237115_(((Attribute)entry.getKey()).m_22087_()))).m_130940_(ChatFormatting.DARK_GREEN));
                        continue;
                    }
                    if (d0 > 0.0) {
                        list.add(Component.m_237110_("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_(), f_41584_.format(d1), Component.m_237115_(((Attribute)entry.getKey()).m_22087_())).m_130940_(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add(Component.m_237110_("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_(), f_41584_.format(d1 *= -1.0), Component.m_237115_(((Attribute)entry.getKey()).m_22087_())).m_130940_(ChatFormatting.RED));
                }
            }
        }
        if (this.m_41782_()) {
            ListTag listtag2;
            ListTag listtag1;
            if (ItemStack.m_41626_(j, TooltipPart.UNBREAKABLE) && this.f_41590_.m_128471_(f_150914_)) {
                list.add(Component.m_237115_("item.unbreakable").m_130940_(ChatFormatting.BLUE));
            }
            if (ItemStack.m_41626_(j, TooltipPart.CAN_DESTROY) && this.f_41590_.m_128425_(f_150916_, 9) && !(listtag1 = this.f_41590_.m_128437_(f_150916_, 8)).isEmpty()) {
                list.add(CommonComponents.f_237098_);
                list.add(Component.m_237115_("item.canBreak").m_130940_(ChatFormatting.GRAY));
                for (int k = 0; k < listtag1.size(); ++k) {
                    list.addAll(ItemStack.m_41761_(listtag1.m_128778_(k)));
                }
            }
            if (ItemStack.m_41626_(j, TooltipPart.CAN_PLACE) && this.f_41590_.m_128425_(f_150917_, 9) && !(listtag2 = this.f_41590_.m_128437_(f_150917_, 8)).isEmpty()) {
                list.add(CommonComponents.f_237098_);
                list.add(Component.m_237115_("item.canPlace").m_130940_(ChatFormatting.GRAY));
                for (int l = 0; l < listtag2.size(); ++l) {
                    list.addAll(ItemStack.m_41761_(listtag2.m_128778_(l)));
                }
            }
        }
        if (p_41653_.m_7050_()) {
            if (this.m_41768_()) {
                list.add(Component.m_237110_("item.durability", this.m_41776_() - this.m_41773_(), this.m_41776_()));
            }
            list.add(Component.m_237113_(BuiltInRegistries.f_257033_.m_7981_((Object)this.m_41720_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            if (this.m_41782_()) {
                list.add(Component.m_237110_("item.nbt_tags", this.f_41590_.m_128431_().size()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if (p_41652_ != null && !this.m_41720_().m_245993_(p_41652_.m_9236_().m_246046_())) {
            list.add(f_243862_);
        }
        ForgeEventFactory.onItemTooltip((ItemStack)this, (Player)p_41652_, (List)list, (TooltipFlag)p_41653_);
        return list;
    }

    private static boolean m_41626_(int p_41627_, TooltipPart p_41628_) {
        return (p_41627_ & p_41628_.m_41809_()) == 0;
    }

    private int m_41618_() {
        return this.m_41782_() && this.f_41590_.m_128425_(f_150918_, 99) ? this.f_41590_.m_128451_(f_150918_) : this.m_41720_().getDefaultTooltipHideFlags(this);
    }

    public void m_41654_(TooltipPart p_41655_) {
        CompoundTag compoundtag = this.m_41784_();
        compoundtag.m_128405_(f_150918_, compoundtag.m_128451_(f_150918_) | p_41655_.m_41809_());
    }

    public static void m_41709_(List<Component> p_41710_, ListTag p_41711_) {
        for (int i = 0; i < p_41711_.size(); ++i) {
            CompoundTag compoundtag = p_41711_.m_128728_(i);
            BuiltInRegistries.f_256876_.m_6612_(EnchantmentHelper.m_182446_(compoundtag)).ifPresent(p_41708_ -> p_41710_.add(p_41708_.m_44700_(EnchantmentHelper.m_182438_(compoundtag))));
        }
    }

    private static Collection<Component> m_41761_(String p_41762_) {
        try {
            return (Collection)BlockStateParser.m_247724_((HolderLookup<Block>)BuiltInRegistries.f_256975_.m_255303_(), p_41762_, true).map(p_220162_ -> Lists.newArrayList((Iterable)p_220162_.f_234748_().m_60734_().m_49954_().m_130940_(ChatFormatting.DARK_GRAY)), p_220164_ -> p_220164_.f_234762_().m_203614_().map(p_220172_ -> ((Block)p_220172_.m_203334_()).m_49954_().m_130940_(ChatFormatting.DARK_GRAY)).collect(Collectors.toList()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            return Lists.newArrayList((Iterable)Component.m_237113_("missingno").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean m_41790_() {
        return this.m_41720_().m_5812_(this);
    }

    public Rarity m_41791_() {
        return this.m_41720_().m_41460_(this);
    }

    public boolean m_41792_() {
        if (!this.m_41720_().m_8120_(this)) {
            return false;
        }
        return !this.m_41793_();
    }

    public void m_41663_(Enchantment p_41664_, int p_41665_) {
        this.m_41784_();
        if (!this.f_41590_.m_128425_(f_150906_, 9)) {
            this.f_41590_.m_128365_(f_150906_, (Tag)new ListTag());
        }
        ListTag listtag = this.f_41590_.m_128437_(f_150906_, 10);
        listtag.add(EnchantmentHelper.m_182443_(EnchantmentHelper.m_182432_(p_41664_), (byte)p_41665_));
    }

    public boolean m_41793_() {
        if (this.f_41590_ != null && this.f_41590_.m_128425_(f_150906_, 9)) {
            return !this.f_41590_.m_128437_(f_150906_, 10).isEmpty();
        }
        return false;
    }

    public void m_41700_(String p_41701_, Tag p_41702_) {
        this.m_41784_().m_128365_(p_41701_, p_41702_);
    }

    public boolean m_41794_() {
        return this.f_41592_ instanceof ItemFrame;
    }

    public void m_41636_(@Nullable Entity p_41637_) {
        this.f_41592_ = p_41637_;
    }

    @Nullable
    public ItemFrame m_41795_() {
        return this.f_41592_ instanceof ItemFrame ? (ItemFrame)this.m_41609_() : null;
    }

    @Nullable
    public Entity m_41609_() {
        return !this.f_41591_ ? this.f_41592_ : null;
    }

    public int m_41610_() {
        return this.m_41782_() && this.f_41590_.m_128425_(f_150915_, 3) ? this.f_41590_.m_128451_(f_150915_) : 0;
    }

    public void m_41742_(int p_41743_) {
        if (p_41743_ == 0) {
            this.m_41749_(f_150915_);
            return;
        }
        this.m_41784_().m_128405_(f_150915_, p_41743_);
    }

    public Multimap<Attribute, AttributeModifier> m_41638_(EquipmentSlot p_41639_) {
        Multimap multimap;
        if (this.m_41782_() && this.f_41590_.m_128425_("AttributeModifiers", 9)) {
            multimap = HashMultimap.create();
            ListTag listtag = this.f_41590_.m_128437_("AttributeModifiers", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                AttributeModifier attributemodifier;
                Optional optional;
                CompoundTag compoundtag = listtag.m_128728_(i);
                if (compoundtag.m_128425_("Slot", 8) && !compoundtag.m_128461_("Slot").equals(p_41639_.m_20751_()) || !(optional = BuiltInRegistries.f_256951_.m_6612_(ResourceLocation.m_135820_(compoundtag.m_128461_("AttributeName")))).isPresent() || (attributemodifier = AttributeModifier.m_22212_((CompoundTag)compoundtag)) == null || attributemodifier.m_22209_().getLeastSignificantBits() == 0L || attributemodifier.m_22209_().getMostSignificantBits() == 0L) continue;
                multimap.put((Object)((Attribute)optional.get()), (Object)attributemodifier);
            }
        } else {
            multimap = this.m_41720_().getAttributeModifiers(p_41639_, this);
        }
        multimap = ForgeHooks.getAttributeModifiers((ItemStack)this, (EquipmentSlot)p_41639_, (Multimap)multimap);
        return multimap;
    }

    public void m_41643_(Attribute p_41644_, AttributeModifier p_41645_, @Nullable EquipmentSlot p_41646_) {
        this.m_41784_();
        if (!this.f_41590_.m_128425_("AttributeModifiers", 9)) {
            this.f_41590_.m_128365_("AttributeModifiers", (Tag)new ListTag());
        }
        ListTag listtag = this.f_41590_.m_128437_("AttributeModifiers", 10);
        CompoundTag compoundtag = p_41645_.m_22219_();
        compoundtag.m_128359_("AttributeName", BuiltInRegistries.f_256951_.m_7981_((Object)p_41644_).toString());
        if (p_41646_ != null) {
            compoundtag.m_128359_("Slot", p_41646_.m_20751_());
        }
        listtag.add(compoundtag);
    }

    public Component m_41611_() {
        MutableComponent mutablecomponent = Component.m_237119_().m_7220_(this.m_41786_());
        if (this.m_41788_()) {
            mutablecomponent.m_130940_(ChatFormatting.ITALIC);
        }
        MutableComponent mutablecomponent1 = ComponentUtils.m_130748_((Component)mutablecomponent);
        if (!this.f_41591_) {
            mutablecomponent1.m_130938_(this.m_41791_().getStyleModifier()).m_130938_(p_220170_ -> p_220170_.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(this))));
        }
        return mutablecomponent1;
    }

    public boolean m_204121_(Registry<Block> p_204122_, BlockInWorld p_204123_) {
        if (this.f_186361_ == null) {
            this.f_186361_ = new AdventureModeCheck(f_150917_);
        }
        return this.f_186361_.m_204085_(this, p_204122_, p_204123_);
    }

    public boolean m_204128_(Registry<Block> p_204129_, BlockInWorld p_204130_) {
        if (this.f_186360_ == null) {
            this.f_186360_ = new AdventureModeCheck(f_150916_);
        }
        return this.f_186360_.m_204085_(this, p_204129_, p_204130_);
    }

    public int m_41612_() {
        return this.f_41588_;
    }

    public void m_41754_(int p_41755_) {
        this.f_41588_ = p_41755_;
    }

    public int m_41613_() {
        return this.f_41591_ ? 0 : this.f_41587_;
    }

    public void m_41764_(int p_41765_) {
        this.f_41587_ = p_41765_;
        this.m_41617_();
    }

    public void m_41769_(int p_41770_) {
        this.m_41764_(this.f_41587_ + p_41770_);
    }

    public void m_41774_(int p_41775_) {
        this.m_41769_(-p_41775_);
    }

    public void m_41731_(Level p_41732_, LivingEntity p_41733_, int p_41734_) {
        this.m_41720_().m_5929_(p_41732_, p_41733_, this, p_41734_);
    }

    @Deprecated
    public void m_150924_(ItemEntity p_150925_) {
        this.m_41720_().m_142023_(p_150925_);
    }

    public boolean m_41614_() {
        return this.m_41720_().m_41472_();
    }

    public void deserializeNBT(CompoundTag nbt) {
        ItemStack itemStack = ItemStack.m_41712_(nbt);
        this.m_41751_(itemStack.m_41783_());
        if (itemStack.capNBT != null) {
            this.deserializeCaps(itemStack.capNBT);
        }
    }

    private void forgeInit() {
        if (this.delegate != null) {
            this.gatherCapabilities(() -> this.f_41589_.initCapabilities(this, this.capNBT));
            if (this.capNBT != null) {
                this.deserializeCaps(this.capNBT);
            }
        }
    }

    public SoundEvent m_41615_() {
        return this.m_41720_().m_6023_();
    }

    public SoundEvent m_41616_() {
        return this.m_41720_().m_6061_();
    }

    @Deprecated
    public void setItem(Item item) {
        this.f_41589_ = item;
        this.delegate = ForgeRegistries.ITEMS.getDelegateOrThrow((Object)item.m_5456_());
    }

    public static final class TooltipPart
    extends Enum<TooltipPart> {
        public static final /* enum */ TooltipPart ENCHANTMENTS = new TooltipPart();
        public static final /* enum */ TooltipPart MODIFIERS = new TooltipPart();
        public static final /* enum */ TooltipPart UNBREAKABLE = new TooltipPart();
        public static final /* enum */ TooltipPart CAN_DESTROY = new TooltipPart();
        public static final /* enum */ TooltipPart CAN_PLACE = new TooltipPart();
        public static final /* enum */ TooltipPart ADDITIONAL = new TooltipPart();
        public static final /* enum */ TooltipPart DYE = new TooltipPart();
        public static final /* enum */ TooltipPart UPGRADES = new TooltipPart();
        private final int f_41803_ = 1 << this.ordinal();
        private static final /* synthetic */ TooltipPart[] $VALUES;

        public static TooltipPart[] values() {
            return (TooltipPart[])$VALUES.clone();
        }

        public static TooltipPart valueOf(String p_41811_) {
            return Enum.valueOf(TooltipPart.class, p_41811_);
        }

        public int m_41809_() {
            return this.f_41803_;
        }

        private static /* synthetic */ TooltipPart[] m_150950_() {
            return new TooltipPart[]{ENCHANTMENTS, MODIFIERS, UNBREAKABLE, CAN_DESTROY, CAN_PLACE, ADDITIONAL, DYE, UPGRADES};
        }

        static {
            $VALUES = TooltipPart.m_150950_();
        }
    }
}

