/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.map.MapView;

public class MapItem
extends ComplexItem {
    public static final int f_151104_ = 128;
    public static final int f_151105_ = 128;
    private static final int f_151106_ = -12173266;
    private static final String f_151107_ = "map";
    public static final String f_257005_ = "map_scale_direction";
    public static final String f_256921_ = "map_to_lock";

    public MapItem(Item.Properties p_42847_) {
        super(p_42847_);
    }

    public static ItemStack m_42886_(Level p_42887_, int p_42888_, int p_42889_, byte p_42890_, boolean p_42891_, boolean p_42892_) {
        ItemStack itemstack = new ItemStack(Items.f_42573_);
        MapItem.m_151111_(itemstack, p_42887_, p_42888_, p_42889_, p_42890_, p_42891_, p_42892_, p_42887_.m_46472_());
        return itemstack;
    }

    @Nullable
    public static MapItemSavedData m_151128_(@Nullable Integer p_151129_, Level p_151130_) {
        return p_151129_ == null ? null : p_151130_.m_7489_(MapItem.m_42848_(p_151129_));
    }

    @Nullable
    public static MapItemSavedData m_42853_(ItemStack p_42854_, Level p_42855_) {
        Item map = p_42854_.m_41720_();
        if (map instanceof MapItem) {
            return ((MapItem)((Object)map)).getCustomMapData(p_42854_, p_42855_);
        }
        return null;
    }

    @Nullable
    protected MapItemSavedData getCustomMapData(ItemStack p_42910_, Level p_42911_) {
        Integer integer = MapItem.m_151131_(p_42910_);
        return MapItem.m_151128_(integer, p_42911_);
    }

    @Nullable
    public static Integer m_151131_(ItemStack p_151132_) {
        CompoundTag compoundtag = p_151132_.m_41783_();
        return compoundtag != null && compoundtag.m_128425_(f_151107_, 99) ? compoundtag.m_128451_(f_151107_) : -1;
    }

    public static int m_151120_(Level p_151121_, int p_151122_, int p_151123_, int p_151124_, boolean p_151125_, boolean p_151126_, ResourceKey<Level> p_151127_) {
        MapItemSavedData mapitemsaveddata = MapItemSavedData.m_164780_(p_151122_, p_151123_, (byte)p_151124_, p_151125_, p_151126_, p_151127_);
        int i = p_151121_.m_7354_();
        p_151121_.m_142325_(MapItem.m_42848_(i), mapitemsaveddata);
        MapInitializeEvent event = new MapInitializeEvent((MapView)mapitemsaveddata.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        return i;
    }

    private static void m_151108_(ItemStack p_151109_, int p_151110_) {
        p_151109_.m_41784_().m_128405_(f_151107_, p_151110_);
    }

    private static void m_151111_(ItemStack p_151112_, Level p_151113_, int p_151114_, int p_151115_, int p_151116_, boolean p_151117_, boolean p_151118_, ResourceKey<Level> p_151119_) {
        int i = MapItem.m_151120_(p_151113_, p_151114_, p_151115_, p_151116_, p_151117_, p_151118_, p_151119_);
        MapItem.m_151108_(p_151112_, i);
    }

    public static String m_42848_(int p_42849_) {
        return "map_" + p_42849_;
    }

    public void m_42893_(Level p_42894_, Entity p_42895_, MapItemSavedData p_42896_) {
        if (p_42894_.m_46472_() == p_42896_.f_77887_ && p_42895_ instanceof Player) {
            int i = 1 << p_42896_.f_77890_;
            int j = p_42896_.f_256718_;
            int k = p_42896_.f_256789_;
            int l = Mth.m_14107_((double)(p_42895_.m_20185_() - (double)j)) / i + 64;
            int i1 = Mth.m_14107_((double)(p_42895_.m_20189_() - (double)k)) / i + 64;
            int j1 = 128 / i;
            if (p_42894_.m_6042_().f_63856_()) {
                j1 /= 2;
            }
            MapItemSavedData.HoldingPlayer mapitemsaveddata$holdingplayer = p_42896_.m_77916_((Player)p_42895_);
            ++mapitemsaveddata$holdingplayer.f_77960_;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            boolean flag = false;
            for (int k1 = l - j1 + 1; k1 < l + j1; ++k1) {
                if ((k1 & 0xF) != (mapitemsaveddata$holdingplayer.f_77960_ & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int l1 = i1 - j1 - 1; l1 < i1 + j1; ++l1) {
                    double d3;
                    double d2;
                    if (k1 < 0 || l1 < -1 || k1 >= 128 || l1 >= 128) continue;
                    int i2 = Mth.m_144944_((int)(k1 - l)) + Mth.m_144944_((int)(l1 - i1));
                    boolean flag1 = i2 > (j1 - 2) * (j1 - 2);
                    int j2 = (j / i + k1 - 64) * i;
                    int k2 = (k / i + l1 - 64) * i;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    LevelChunk levelchunk = p_42894_.m_6325_(SectionPos.m_123171_((int)j2), SectionPos.m_123171_((int)k2));
                    if (levelchunk.m_6430_()) continue;
                    int l2 = 0;
                    double d1 = 0.0;
                    if (p_42894_.m_6042_().f_63856_()) {
                        int i3 = j2 + k2 * 231871;
                        if (((i3 = i3 * i3 * 31287121 + i3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.f_50493_.m_49966_().m_60780_(p_42894_, BlockPos.f_121853_), 10);
                        } else {
                            multiset.add((Object)Blocks.f_50069_.m_49966_().m_60780_(p_42894_, BlockPos.f_121853_), 100);
                        }
                        d1 = 100.0;
                    } else {
                        for (int i4 = 0; i4 < i; ++i4) {
                            for (int j3 = 0; j3 < i; ++j3) {
                                BlockState blockstate;
                                blockpos$mutableblockpos.m_122178_(j2 + i4, 0, k2 + j3);
                                int k3 = levelchunk.m_5885_(Heightmap.Types.WORLD_SURFACE, blockpos$mutableblockpos.m_123341_(), blockpos$mutableblockpos.m_123343_()) + 1;
                                if (k3 <= p_42894_.m_141937_() + 1) {
                                    blockstate = Blocks.f_50752_.m_49966_();
                                } else {
                                    do {
                                        blockpos$mutableblockpos.m_142448_(--k3);
                                    } while ((blockstate = levelchunk.m_8055_((BlockPos)blockpos$mutableblockpos)).m_60780_(p_42894_, (BlockPos)blockpos$mutableblockpos) == MaterialColor.f_76398_ && k3 > p_42894_.m_141937_());
                                    if (k3 > p_42894_.m_141937_() && !blockstate.m_60819_().m_76178_()) {
                                        BlockState blockstate1;
                                        int l3 = k3 - 1;
                                        blockpos$mutableblockpos1.m_122190_((Vec3i)blockpos$mutableblockpos);
                                        do {
                                            blockpos$mutableblockpos1.m_142448_(l3--);
                                            blockstate1 = levelchunk.m_8055_((BlockPos)blockpos$mutableblockpos1);
                                            ++l2;
                                        } while (l3 > p_42894_.m_141937_() && !blockstate1.m_60819_().m_76178_());
                                        blockstate = this.m_42900_(p_42894_, blockstate, (BlockPos)blockpos$mutableblockpos);
                                    }
                                }
                                p_42896_.m_77930_(p_42894_, blockpos$mutableblockpos.m_123341_(), blockpos$mutableblockpos.m_123343_());
                                d1 += (double)k3 / (double)(i * i);
                                multiset.add((Object)blockstate.m_60780_(p_42894_, (BlockPos)blockpos$mutableblockpos));
                            }
                        }
                    }
                    MaterialColor materialcolor = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialColor.f_76398_);
                    MaterialColor.Brightness materialcolor$brightness = materialcolor == MaterialColor.f_76410_ ? ((d2 = (double)(l2 /= i * i) * 0.1 + (double)(k1 + l1 & 1) * 0.2) < 0.5 ? MaterialColor.Brightness.HIGH : (d2 > 0.9 ? MaterialColor.Brightness.LOW : MaterialColor.Brightness.NORMAL)) : ((d3 = (d1 - d0) * 4.0 / (double)(i + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4) > 0.6 ? MaterialColor.Brightness.HIGH : (d3 < -0.6 ? MaterialColor.Brightness.LOW : MaterialColor.Brightness.NORMAL));
                    d0 = d1;
                    if (l1 < 0 || i2 >= j1 * j1 || flag1 && (k1 + l1 & 1) == 0) continue;
                    flag |= p_42896_.m_164792_(k1, l1, materialcolor.m_192925_(materialcolor$brightness));
                }
            }
        }
    }

    private BlockState m_42900_(Level p_42901_, BlockState p_42902_, BlockPos p_42903_) {
        FluidState fluidstate = p_42902_.m_60819_();
        return !fluidstate.m_76178_() && !p_42902_.m_60783_(p_42901_, p_42903_, Direction.UP) ? fluidstate.m_76188_() : p_42902_;
    }

    private static boolean m_212251_(boolean[] p_212252_, int p_212253_, int p_212254_) {
        return p_212252_[p_212254_ * 128 + p_212253_];
    }

    public static void m_42850_(ServerLevel p_42851_, ItemStack p_42852_) {
        MapItemSavedData mapitemsaveddata = MapItem.m_42853_(p_42852_, p_42851_);
        if (mapitemsaveddata != null && p_42851_.m_46472_() == mapitemsaveddata.f_77887_) {
            int i = 1 << mapitemsaveddata.f_77890_;
            int j = mapitemsaveddata.f_256718_;
            int k = mapitemsaveddata.f_256789_;
            boolean[] aboolean = new boolean[16384];
            int l = j / i - 64;
            int i1 = k / i - 64;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = 0; j1 < 128; ++j1) {
                for (int k1 = 0; k1 < 128; ++k1) {
                    Holder holder = p_42851_.m_204166_((BlockPos)blockpos$mutableblockpos.m_122178_((l + k1) * i, 0, (i1 + j1) * i));
                    aboolean[j1 * 128 + k1] = holder.m_203656_(BiomeTags.f_215803_);
                }
            }
            for (int j2 = 1; j2 < 127; ++j2) {
                for (int k2 = 1; k2 < 127; ++k2) {
                    int l2 = 0;
                    for (int l1 = -1; l1 < 2; ++l1) {
                        for (int i2 = -1; i2 < 2; ++i2) {
                            if (l1 == 0 && i2 == 0 || !MapItem.m_212251_(aboolean, j2 + l1, k2 + i2)) continue;
                            ++l2;
                        }
                    }
                    MaterialColor.Brightness materialcolor$brightness = MaterialColor.Brightness.LOWEST;
                    MaterialColor materialcolor = MaterialColor.f_76398_;
                    if (MapItem.m_212251_(aboolean, j2, k2)) {
                        materialcolor = MaterialColor.f_76413_;
                        if (l2 > 7 && k2 % 2 == 0) {
                            switch ((j2 + (int)(Mth.m_14031_((float)((float)k2 + 0.0f)) * 7.0f)) / 8 % 5) {
                                case 0: 
                                case 4: {
                                    materialcolor$brightness = MaterialColor.Brightness.LOW;
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    materialcolor$brightness = MaterialColor.Brightness.NORMAL;
                                    break;
                                }
                                case 2: {
                                    materialcolor$brightness = MaterialColor.Brightness.HIGH;
                                }
                            }
                        } else if (l2 > 7) {
                            materialcolor = MaterialColor.f_76398_;
                        } else if (l2 > 5) {
                            materialcolor$brightness = MaterialColor.Brightness.NORMAL;
                        } else if (l2 > 3) {
                            materialcolor$brightness = MaterialColor.Brightness.LOW;
                        } else if (l2 > 1) {
                            materialcolor$brightness = MaterialColor.Brightness.LOW;
                        }
                    } else if (l2 > 0) {
                        materialcolor = MaterialColor.f_76362_;
                        materialcolor$brightness = l2 > 3 ? MaterialColor.Brightness.NORMAL : MaterialColor.Brightness.LOWEST;
                    }
                    if (materialcolor == MaterialColor.f_76398_) continue;
                    mapitemsaveddata.m_164803_(j2, k2, materialcolor.m_192925_(materialcolor$brightness));
                }
            }
        }
    }

    public void m_6883_(ItemStack p_42870_, Level p_42871_, Entity p_42872_, int p_42873_, boolean p_42874_) {
        MapItemSavedData mapitemsaveddata;
        if (!p_42871_.f_46443_ && (mapitemsaveddata = MapItem.m_42853_(p_42870_, p_42871_)) != null) {
            if (p_42872_ instanceof Player) {
                Player player = (Player)p_42872_;
                mapitemsaveddata.m_77918_(player, p_42870_);
            }
            if (!mapitemsaveddata.f_77892_ && (p_42874_ || p_42872_ instanceof Player && ((Player)p_42872_).m_21206_() == p_42870_)) {
                this.m_42893_(p_42871_, p_42872_, mapitemsaveddata);
            }
        }
    }

    @Nullable
    public Packet<?> m_7233_(ItemStack p_42876_, Level p_42877_, Player p_42878_) {
        Integer integer = MapItem.m_151131_(p_42876_);
        MapItemSavedData mapitemsaveddata = MapItem.m_151128_(integer, p_42877_);
        return mapitemsaveddata != null ? mapitemsaveddata.m_164796_(integer, p_42878_) : null;
    }

    public void m_7836_(ItemStack p_42913_, Level p_42914_, Player p_42915_) {
        CompoundTag compoundtag = p_42913_.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_(f_257005_, 99)) {
            MapItem.m_42856_(p_42913_, p_42914_, compoundtag.m_128451_(f_257005_));
            compoundtag.m_128473_(f_257005_);
        } else if (compoundtag != null && compoundtag.m_128425_(f_256921_, 1) && compoundtag.m_128471_(f_256921_)) {
            MapItem.m_42897_(p_42914_, p_42913_);
            compoundtag.m_128473_(f_256921_);
        }
    }

    private static void m_42856_(ItemStack p_42857_, Level p_42858_, int p_42859_) {
        MapItemSavedData mapitemsaveddata = MapItem.m_42853_(p_42857_, p_42858_);
        if (mapitemsaveddata != null) {
            int i = p_42858_.m_7354_();
            p_42858_.m_142325_(MapItem.m_42848_(i), mapitemsaveddata.m_164787_(p_42859_));
            MapItem.m_151108_(p_42857_, i);
        }
    }

    public static void m_42897_(Level p_42898_, ItemStack p_42899_) {
        MapItemSavedData mapitemsaveddata = MapItem.m_42853_(p_42899_, p_42898_);
        if (mapitemsaveddata != null) {
            int i = p_42898_.m_7354_();
            String s = MapItem.m_42848_(i);
            MapItemSavedData mapitemsaveddata1 = mapitemsaveddata.m_164775_();
            p_42898_.m_142325_(s, mapitemsaveddata1);
            MapItem.m_151108_(p_42899_, i);
        }
    }

    public void m_7373_(ItemStack p_42880_, @Nullable Level p_42881_, List<Component> p_42882_, TooltipFlag p_42883_) {
        byte b0;
        boolean flag;
        Integer integer = MapItem.m_151131_(p_42880_);
        MapItemSavedData mapitemsaveddata = p_42881_ == null ? null : MapItem.m_151128_(integer, p_42881_);
        CompoundTag compoundtag = p_42880_.m_41783_();
        if (compoundtag != null) {
            flag = compoundtag.m_128471_(f_256921_);
            b0 = compoundtag.m_128445_(f_257005_);
        } else {
            flag = false;
            b0 = 0;
        }
        if (mapitemsaveddata != null && (mapitemsaveddata.f_77892_ || flag)) {
            p_42882_.add((Component)Component.m_237110_("filled_map.locked", integer).m_130940_(ChatFormatting.GRAY));
        }
        if (p_42883_.m_7050_()) {
            if (mapitemsaveddata != null) {
                if (!flag && b0 == 0) {
                    p_42882_.add((Component)Component.m_237110_("filled_map.id", integer).m_130940_(ChatFormatting.GRAY));
                }
                int i = Math.min(mapitemsaveddata.f_77890_ + b0, 4);
                p_42882_.add((Component)Component.m_237110_("filled_map.scale", 1 << i).m_130940_(ChatFormatting.GRAY));
                p_42882_.add((Component)Component.m_237110_("filled_map.level", i, 4).m_130940_(ChatFormatting.GRAY));
            } else {
                p_42882_.add((Component)Component.m_237115_("filled_map.unknown").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public static int m_42918_(ItemStack p_42919_) {
        CompoundTag compoundtag = p_42919_.m_41737_("display");
        if (compoundtag != null && compoundtag.m_128425_("MapColor", 99)) {
            int i = compoundtag.m_128451_("MapColor");
            return 0xFF000000 | i & 0xFFFFFF;
        }
        return -12173266;
    }

    public InteractionResult m_6225_(UseOnContext p_42885_) {
        BlockState blockstate = p_42885_.m_43725_().m_8055_(p_42885_.m_8083_());
        if (blockstate.m_204336_(BlockTags.f_13028_)) {
            MapItemSavedData mapitemsaveddata;
            if (!p_42885_.m_43725_().f_46443_ && (mapitemsaveddata = MapItem.m_42853_(p_42885_.m_43722_(), p_42885_.m_43725_())) != null && !mapitemsaveddata.m_77934_(p_42885_.m_43725_(), p_42885_.m_8083_())) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.m_19078_((boolean)p_42885_.m_43725_().f_46443_);
        }
        return super.m_6225_(p_42885_);
    }
}

