/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class FenceGateBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty f_53341_ = BlockStateProperties.f_61446_;
    public static final BooleanProperty f_53342_ = BlockStateProperties.f_61448_;
    public static final BooleanProperty f_53343_ = BlockStateProperties.f_61442_;
    protected static final VoxelShape f_53344_ = Block.m_49796_(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape f_53345_ = Block.m_49796_(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);
    protected static final VoxelShape f_53346_ = Block.m_49796_(0.0, 0.0, 6.0, 16.0, 13.0, 10.0);
    protected static final VoxelShape f_53347_ = Block.m_49796_(6.0, 0.0, 0.0, 10.0, 13.0, 16.0);
    protected static final VoxelShape f_53348_ = Block.m_49796_(0.0, 0.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape f_53349_ = Block.m_49796_(6.0, 0.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape f_252518_ = Block.m_49796_(0.0, 5.0, 6.0, 16.0, 24.0, 10.0);
    protected static final VoxelShape f_252514_ = Block.m_49796_(6.0, 5.0, 0.0, 10.0, 24.0, 16.0);
    protected static final VoxelShape f_53350_ = Shapes.m_83110_((VoxelShape)Block.m_49796_(0.0, 5.0, 7.0, 2.0, 16.0, 9.0), (VoxelShape)Block.m_49796_(14.0, 5.0, 7.0, 16.0, 16.0, 9.0));
    protected static final VoxelShape f_53351_ = Shapes.m_83110_((VoxelShape)Block.m_49796_(7.0, 5.0, 0.0, 9.0, 16.0, 2.0), (VoxelShape)Block.m_49796_(7.0, 5.0, 14.0, 9.0, 16.0, 16.0));
    protected static final VoxelShape f_53352_ = Shapes.m_83110_((VoxelShape)Block.m_49796_(0.0, 2.0, 7.0, 2.0, 13.0, 9.0), (VoxelShape)Block.m_49796_(14.0, 2.0, 7.0, 16.0, 13.0, 9.0));
    protected static final VoxelShape f_53353_ = Shapes.m_83110_((VoxelShape)Block.m_49796_(7.0, 2.0, 0.0, 9.0, 13.0, 2.0), (VoxelShape)Block.m_49796_(7.0, 2.0, 14.0, 9.0, 13.0, 16.0));
    private final SoundEvent openSound;
    private final SoundEvent closeSound;

    public FenceGateBlock(BlockBehaviour.Properties p_273352_, WoodType p_273340_) {
        this(p_273352_.m_60918_(p_273340_.f_271317_()), p_273340_.f_271162_(), p_273340_.f_271365_());
    }

    public FenceGateBlock(BlockBehaviour.Properties props, SoundEvent openSound, SoundEvent closeSound) {
        super(props);
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.m_49959_((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53341_, Boolean.valueOf(false)))).m_61124_((Property)f_53342_, Boolean.valueOf(false)))).m_61124_((Property)f_53343_, Boolean.valueOf(false))));
    }

    public VoxelShape m_5940_(BlockState p_53391_, BlockGetter p_53392_, BlockPos p_53393_, CollisionContext p_53394_) {
        if (((Boolean)p_53391_.m_61143_((Property)f_53343_)).booleanValue()) {
            return ((Direction)p_53391_.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X ? f_53347_ : f_53346_;
        }
        return ((Direction)p_53391_.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X ? f_53345_ : f_53344_;
    }

    public BlockState m_7417_(BlockState p_53382_, Direction p_53383_, BlockState p_53384_, LevelAccessor p_53385_, BlockPos p_53386_, BlockPos p_53387_) {
        Direction.Axis direction$axis = p_53383_.m_122434_();
        if (((Direction)p_53382_.m_61143_((Property)f_54117_)).m_122427_().m_122434_() != direction$axis) {
            return super.m_7417_(p_53382_, p_53383_, p_53384_, p_53385_, p_53386_, p_53387_);
        }
        boolean flag = this.m_53404_(p_53384_) || this.m_53404_(p_53385_.m_8055_(p_53386_.m_121945_(p_53383_.m_122424_())));
        return (BlockState)((Object)p_53382_.m_61124_((Property)f_53343_, Boolean.valueOf(flag)));
    }

    public VoxelShape m_7947_(BlockState p_253862_, BlockGetter p_254569_, BlockPos p_254197_) {
        if (((Boolean)p_253862_.m_61143_((Property)f_53341_)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return ((Direction)p_253862_.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.Z ? f_252518_ : f_252514_;
    }

    public VoxelShape m_5939_(BlockState p_53396_, BlockGetter p_53397_, BlockPos p_53398_, CollisionContext p_53399_) {
        if (((Boolean)p_53396_.m_61143_((Property)f_53341_)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return ((Direction)p_53396_.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.Z ? f_53348_ : f_53349_;
    }

    public VoxelShape m_7952_(BlockState p_53401_, BlockGetter p_53402_, BlockPos p_53403_) {
        if (((Boolean)p_53401_.m_61143_((Property)f_53343_)).booleanValue()) {
            return ((Direction)p_53401_.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X ? f_53353_ : f_53352_;
        }
        return ((Direction)p_53401_.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X ? f_53351_ : f_53350_;
    }

    public boolean m_7357_(BlockState p_53360_, BlockGetter p_53361_, BlockPos p_53362_, PathComputationType p_53363_) {
        switch (p_53363_) {
            case LAND: {
                return (Boolean)p_53360_.m_61143_((Property)f_53341_);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)p_53360_.m_61143_((Property)f_53341_);
            }
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext p_53358_) {
        Level level = p_53358_.m_43725_();
        BlockPos blockpos = p_53358_.m_8083_();
        boolean flag = level.m_46753_(blockpos);
        Direction direction = p_53358_.m_8125_();
        Direction.Axis direction$axis = direction.m_122434_();
        boolean flag1 = direction$axis == Direction.Axis.Z && (this.m_53404_(level.m_8055_(blockpos.m_122024_())) || this.m_53404_(level.m_8055_(blockpos.m_122029_()))) || direction$axis == Direction.Axis.X && (this.m_53404_(level.m_8055_(blockpos.m_122012_())) || this.m_53404_(level.m_8055_(blockpos.m_122019_())));
        return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction))).m_61124_((Property)f_53341_, Boolean.valueOf(flag)))).m_61124_((Property)f_53342_, Boolean.valueOf(flag)))).m_61124_((Property)f_53343_, Boolean.valueOf(flag1)));
    }

    private boolean m_53404_(BlockState p_53405_) {
        return p_53405_.m_204336_(BlockTags.f_13032_);
    }

    public InteractionResult m_6227_(BlockState p_53365_, Level p_53366_, BlockPos p_53367_, Player p_53368_, InteractionHand p_53369_, BlockHitResult p_53370_) {
        if (((Boolean)p_53365_.m_61143_((Property)f_53341_)).booleanValue()) {
            p_53365_ = (BlockState)((Object)p_53365_.m_61124_((Property)f_53341_, Boolean.valueOf(false)));
            p_53366_.m_7731_(p_53367_, p_53365_, 10);
        } else {
            Direction direction = p_53368_.m_6350_();
            if (p_53365_.m_61143_((Property)f_54117_) == direction.m_122424_()) {
                p_53365_ = (BlockState)((Object)p_53365_.m_61124_((Property)f_54117_, (Comparable)direction));
            }
            p_53365_ = (BlockState)((Object)p_53365_.m_61124_((Property)f_53341_, Boolean.valueOf(true)));
            p_53366_.m_7731_(p_53367_, p_53365_, 10);
        }
        boolean flag = (Boolean)p_53365_.m_61143_((Property)f_53341_);
        p_53366_.m_5594_(p_53368_, p_53367_, flag ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, p_53366_.m_213780_().m_188501_() * 0.1f + 0.9f);
        p_53366_.m_142346_(p_53368_, flag ? GameEvent.f_157796_ : GameEvent.f_157793_, p_53367_);
        return InteractionResult.m_19078_((boolean)p_53366_.f_46443_);
    }

    public void m_6861_(BlockState p_53372_, Level p_53373_, BlockPos p_53374_, Block p_53375_, BlockPos p_53376_, boolean p_53377_) {
        if (!p_53373_.f_46443_) {
            boolean flag = p_53373_.m_46753_(p_53374_);
            boolean oldPowered = (Boolean)p_53372_.m_61143_((Property)f_53342_);
            if (oldPowered != flag) {
                int newPower = flag ? 15 : 0;
                int oldPower = oldPowered ? 15 : 0;
                CraftBlock bukkitBlock = CraftBlock.at((LevelAccessor)p_53373_, (BlockPos)p_53374_);
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)bukkitBlock, oldPower, newPower);
                p_53373_.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag = eventRedstone.getNewCurrent() > 0;
            }
            if ((Boolean)p_53372_.m_61143_((Property)f_53342_) != flag) {
                p_53373_.m_7731_(p_53374_, (BlockState)((Object)((BlockState)((Object)p_53372_.m_61124_((Property)f_53342_, Boolean.valueOf(flag)))).m_61124_((Property)f_53341_, Boolean.valueOf(flag))), 2);
                if ((Boolean)p_53372_.m_61143_((Property)f_53341_) != flag) {
                    p_53373_.m_5594_(null, p_53374_, flag ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, p_53373_.m_213780_().m_188501_() * 0.1f + 0.9f);
                    p_53373_.m_142346_(null, flag ? GameEvent.f_157796_ : GameEvent.f_157793_, p_53374_);
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_53389_) {
        p_53389_.m_61104_(new Property[]{f_54117_, f_53341_, f_53342_, f_53343_});
    }

    public static boolean m_53378_(BlockState p_53379_, Direction p_53380_) {
        return ((Direction)p_53379_.m_61143_((Property)f_54117_)).m_122434_() == p_53380_.m_122427_().m_122434_();
    }
}

