/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;

public class NoteBlock
extends Block {
    public static final EnumProperty<NoteBlockInstrument> f_55011_ = BlockStateProperties.f_61395_;
    public static final BooleanProperty f_55012_ = BlockStateProperties.f_61448_;
    public static final IntegerProperty f_55013_ = BlockStateProperties.f_61424_;
    public static final int f_262759_ = 3;

    public NoteBlock(BlockBehaviour.Properties p_55016_) {
        super(p_55016_);
        this.m_49959_((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55011_, (Comparable)NoteBlockInstrument.HARP))).m_61124_((Property)f_55013_, Integer.valueOf(0)))).m_61124_((Property)f_55012_, Boolean.valueOf(false))));
    }

    private static boolean m_260971_(LevelAccessor p_261577_) {
        return p_261577_.m_246046_().m_245372_(FeatureFlags.f_244168_);
    }

    private BlockState m_261136_(LevelAccessor p_262117_, BlockPos p_261908_, BlockState p_262130_) {
        if (NoteBlock.m_260971_(p_262117_)) {
            BlockState blockstate = p_262117_.m_8055_(p_261908_.m_7494_());
            return (BlockState)((Object)p_262130_.m_61124_((Property)f_55011_, (Comparable)NoteBlockInstrument.m_261002_((BlockState)blockstate).orElseGet(() -> NoteBlockInstrument.m_61666_((BlockState)p_262117_.m_8055_(p_261908_.m_7495_())))));
        }
        return (BlockState)((Object)p_262130_.m_61124_((Property)f_55011_, (Comparable)NoteBlockInstrument.m_61666_((BlockState)p_262117_.m_8055_(p_261908_.m_7495_()))));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext p_55018_) {
        return this.m_261136_(p_55018_.m_43725_(), p_55018_.m_8083_(), this.m_49966_());
    }

    @Override
    public BlockState m_7417_(BlockState p_55048_, Direction p_55049_, BlockState p_55050_, LevelAccessor p_55051_, BlockPos p_55052_, BlockPos p_55053_) {
        boolean flag = NoteBlock.m_260971_(p_55051_) ? p_55049_.m_122434_() == Direction.Axis.Y : p_55049_ == Direction.DOWN;
        return flag ? this.m_261136_(p_55051_, p_55052_, p_55048_) : super.m_7417_(p_55048_, p_55049_, p_55050_, p_55051_, p_55052_, p_55053_);
    }

    @Override
    public void m_6861_(BlockState p_55041_, Level p_55042_, BlockPos p_55043_, Block p_55044_, BlockPos p_55045_, boolean p_55046_) {
        boolean flag = p_55042_.m_46753_(p_55043_);
        if (flag != (Boolean)p_55041_.m_61143_((Property)f_55012_)) {
            if (flag) {
                this.m_260916_(null, p_55041_, p_55042_, p_55043_);
                p_55041_ = p_55042_.m_8055_(p_55043_);
            }
            p_55042_.m_7731_(p_55043_, (BlockState)((Object)p_55041_.m_61124_((Property)f_55012_, Boolean.valueOf(flag))), 3);
        }
    }

    private void m_260916_(@Nullable Entity p_261664_, BlockState p_261606_, Level p_261819_, BlockPos p_262042_) {
        if (!((NoteBlockInstrument)p_261606_.m_61143_((Property)f_55011_)).m_262415_() || p_261819_.m_8055_(p_262042_.m_7494_()).m_60795_()) {
            NotePlayEvent event = CraftEventFactory.callNotePlayEvent((Level)p_261819_, (BlockPos)p_262042_, (NoteBlockInstrument)((NoteBlockInstrument)p_261606_.m_61143_((Property)f_55011_)), (int)((Integer)p_261606_.m_61143_((Property)f_55013_)));
            if (event.isCancelled()) {
                return;
            }
            p_261819_.m_7696_(p_262042_, this, 0, 0);
            p_261819_.m_142346_(p_261664_, GameEvent.f_223699_, p_262042_);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState p_55034_, Level p_55035_, BlockPos p_55036_, Player p_55037_, InteractionHand p_55038_, BlockHitResult p_55039_) {
        ItemStack itemstack;
        if (NoteBlock.m_260971_(p_55035_) && (itemstack = p_55037_.m_21120_(p_55038_)).m_204117_(ItemTags.f_263791_) && p_55039_.m_82434_() == Direction.UP) {
            return InteractionResult.PASS;
        }
        if (p_55035_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int _new = ForgeHooks.onNoteChange((Level)p_55035_, (BlockPos)p_55036_, (BlockState)p_55034_, (int)((Integer)p_55034_.m_61143_((Property)f_55013_)), (int)((Integer)((BlockState)((Object)p_55034_.m_61122_((Property)f_55013_))).m_61143_((Property)f_55013_)));
        if (_new == -1) {
            return InteractionResult.FAIL;
        }
        p_55034_ = (BlockState)((Object)p_55034_.m_61124_((Property)f_55013_, Integer.valueOf(_new)));
        p_55035_.m_7731_(p_55036_, p_55034_, 3);
        this.m_260916_(p_55037_, p_55034_, p_55035_, p_55036_);
        p_55037_.m_36220_(Stats.f_12960_);
        return InteractionResult.CONSUME;
    }

    @Override
    public void m_6256_(BlockState p_55029_, Level p_55030_, BlockPos p_55031_, Player p_55032_) {
        if (!p_55030_.f_46443_) {
            this.m_260916_(p_55032_, p_55029_, p_55030_, p_55031_);
            p_55032_.m_36220_(Stats.f_12959_);
        }
    }

    @Override
    public boolean m_8133_(BlockState p_55023_, Level p_55024_, BlockPos p_55025_, int p_55026_, int p_55027_) {
        Holder<SoundEvent> holder;
        float f;
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(p_55024_, p_55025_, p_55023_, ((Integer)p_55023_.m_61143_((Property)f_55013_)).intValue(), (NoteBlockInstrument)p_55023_.m_61143_((Property)f_55011_));
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        NoteBlockInstrument noteblockinstrument = (NoteBlockInstrument)(p_55023_ = (BlockState)((Object)((BlockState)((Object)p_55023_.m_61124_((Property)f_55013_, Integer.valueOf(e.getVanillaNoteId())))).m_61124_((Property)f_55011_, (Comparable)e.getInstrument()))).m_61143_((Property)f_55011_);
        if (noteblockinstrument.m_262503_()) {
            int i = (Integer)p_55023_.m_61143_((Property)f_55013_);
            f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
            p_55024_.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)p_55025_.m_123341_() + 0.5, (double)p_55025_.m_123342_() + 1.2, (double)p_55025_.m_123343_() + 0.5, (double)i / 24.0, 0.0, 0.0);
        } else {
            f = 1.0f;
        }
        if (noteblockinstrument.m_262394_()) {
            ResourceLocation resourcelocation = this.m_262851_(p_55024_, p_55025_);
            if (resourcelocation == null) {
                return false;
            }
            holder = Holder.m_205709_(SoundEvent.m_262824_((ResourceLocation)resourcelocation));
        } else {
            holder = noteblockinstrument.m_263188_();
        }
        p_55024_.m_262808_(null, (double)p_55025_.m_123341_() + 0.5, (double)p_55025_.m_123342_() + 0.5, (double)p_55025_.m_123343_() + 0.5, holder, SoundSource.RECORDS, 3.0f, f, p_55024_.f_46441_.m_188505_());
        return true;
    }

    @Nullable
    private ResourceLocation m_262851_(Level p_263070_, BlockPos p_262999_) {
        BlockEntity blockentity = p_263070_.m_7702_(p_262999_.m_7494_());
        if (blockentity instanceof SkullBlockEntity) {
            SkullBlockEntity skullblockentity = (SkullBlockEntity)blockentity;
            return skullblockentity.m_262374_();
        }
        return null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_55055_) {
        p_55055_.m_61104_(new Property[]{f_55011_, f_55012_, f_55013_});
    }
}

