/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;

public class SculkVeinBlock
extends MultifaceBlock
implements SculkBehaviour,
SimpleWaterloggedBlock {
    private static final BooleanProperty f_222348_ = BlockStateProperties.f_61362_;
    private final MultifaceSpreader f_222349_ = new MultifaceSpreader(new SculkVeinSpreaderConfig(MultifaceSpreader.f_221586_));
    private final MultifaceSpreader f_222350_ = new MultifaceSpreader(new SculkVeinSpreaderConfig(MultifaceSpreader.SpreadType.SAME_POSITION));
    public AtomicReference<BlockPos> sourceBlock = new AtomicReference();

    public SculkVeinBlock(BlockBehaviour.Properties p_222353_) {
        super(p_222353_);
        this.m_49959_((BlockState)((Object)this.m_49966_().m_61124_((Property)f_222348_, Boolean.valueOf(false))));
    }

    public MultifaceSpreader m_213612_() {
        return this.f_222349_;
    }

    public MultifaceSpreader m_222395_() {
        return this.f_222350_;
    }

    public static boolean m_222363_(LevelAccessor p_222364_, BlockPos p_222365_, BlockState p_222366_, Collection<Direction> p_222367_) {
        boolean flag = false;
        BlockState blockstate = Blocks.f_220856_.m_49966_();
        for (Direction direction : p_222367_) {
            BlockPos blockpos;
            if (!SculkVeinBlock.m_153829_((BlockGetter)p_222364_, (Direction)direction, (BlockPos)(blockpos = p_222365_.m_121945_(direction)), (BlockState)p_222364_.m_8055_(blockpos))) continue;
            blockstate = (BlockState)((Object)blockstate.m_61124_((Property)SculkVeinBlock.m_153933_((Direction)direction), Boolean.valueOf(true)));
            flag = true;
        }
        if (!flag) {
            return false;
        }
        if (!p_222366_.m_60819_().m_76178_()) {
            blockstate = (BlockState)((Object)blockstate.m_61124_((Property)f_222348_, Boolean.valueOf(true)));
        }
        p_222364_.m_7731_(p_222365_, blockstate, 3);
        return true;
    }

    public void m_213805_(LevelAccessor p_222359_, BlockState p_222360_, BlockPos p_222361_, RandomSource p_222362_) {
        if (p_222360_.m_60713_((Block)((Object)this))) {
            for (Direction direction : f_153806_) {
                BooleanProperty booleanproperty = SculkVeinBlock.m_153933_((Direction)direction);
                if (!((Boolean)p_222360_.m_61143_((Property)booleanproperty)).booleanValue() || !p_222359_.m_8055_(p_222361_.m_121945_(direction)).m_60713_(Blocks.f_220855_)) continue;
                p_222360_ = (BlockState)((Object)p_222360_.m_61124_((Property)booleanproperty, Boolean.valueOf(false)));
            }
            if (!SculkVeinBlock.m_153960_((BlockState)p_222360_)) {
                FluidState fluidstate = p_222359_.m_6425_(p_222361_);
                p_222360_ = (fluidstate.m_76178_() ? Blocks.f_50016_ : Blocks.f_49990_).m_49966_();
            }
            p_222359_.m_7731_(p_222361_, p_222360_, 3);
            super.m_213805_(p_222359_, p_222360_, p_222361_, p_222362_);
        }
    }

    public int m_213628_(SculkSpreader.ChargeCursor p_222369_, LevelAccessor p_222370_, BlockPos p_222371_, RandomSource p_222372_, SculkSpreader p_222373_, boolean p_222374_) {
        this.sourceBlock.set(p_222371_);
        if (p_222374_ && this.m_222375_(p_222373_, p_222370_, p_222369_.m_222304_(), p_222372_)) {
            return p_222369_.m_222341_() - 1;
        }
        return p_222372_.m_188503_(p_222373_.m_222280_()) == 0 ? Mth.m_14143_((float)((float)p_222369_.m_222341_() * 0.5f)) : p_222369_.m_222341_();
    }

    private boolean attemptPlaceSculk(SculkSpreader p_222376_, LevelAccessor p_222377_, BlockPos p_222378_, RandomSource p_222379_, BlockPos sourceBlock0) {
        this.sourceBlock.set(sourceBlock0);
        return this.m_222375_(p_222376_, p_222377_, p_222378_, p_222379_);
    }

    private boolean m_222375_(SculkSpreader p_222376_, LevelAccessor p_222377_, BlockPos p_222378_, RandomSource p_222379_) {
        BlockState blockstate = p_222377_.m_8055_(p_222378_);
        TagKey tagkey = p_222376_.m_222277_();
        for (Direction direction : Direction.m_235667_((RandomSource)p_222379_)) {
            BlockPos blockpos;
            BlockState blockstate1;
            if (!SculkVeinBlock.m_153900_((BlockState)blockstate, (Direction)direction) || !(blockstate1 = p_222377_.m_8055_(blockpos = p_222378_.m_121945_(direction))).m_204336_((TagKey<Block>)tagkey)) continue;
            BlockState blockstate2 = Blocks.f_220855_.m_49966_();
            if (!CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_222377_, (BlockPos)this.sourceBlock.getAndSet(null), (BlockPos)blockpos, (BlockState)blockstate2, (int)3)) {
                return false;
            }
            Block.m_49897_(blockstate1, blockstate2, p_222377_, blockpos);
            p_222377_.m_5594_(null, blockpos, SoundEvents.f_215753_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.f_222349_.m_221657_(blockstate2, p_222377_, blockpos, p_222376_.m_222282_());
            Direction direction1 = direction.m_122424_();
            for (Direction direction2 : f_153806_) {
                BlockPos blockpos1;
                BlockState blockstate3;
                if (direction2 == direction1 || !(blockstate3 = p_222377_.m_8055_(blockpos1 = blockpos.m_121945_(direction2))).m_60713_((Block)((Object)this))) continue;
                this.m_213805_(p_222377_, blockstate3, blockpos1, p_222379_);
            }
            return true;
        }
        return false;
    }

    public static boolean m_222354_(LevelAccessor p_222355_, BlockState p_222356_, BlockPos p_222357_) {
        if (!p_222356_.m_60713_(Blocks.f_220856_)) {
            return false;
        }
        for (Direction direction : f_153806_) {
            if (!SculkVeinBlock.m_153900_((BlockState)p_222356_, (Direction)direction) || !p_222355_.m_8055_(p_222357_.m_121945_(direction)).m_204336_(BlockTags.f_215823_)) continue;
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState p_222384_, Direction p_222385_, BlockState p_222386_, LevelAccessor p_222387_, BlockPos p_222388_, BlockPos p_222389_) {
        if (((Boolean)p_222384_.m_61143_((Property)f_222348_)).booleanValue()) {
            p_222387_.m_186469_(p_222388_, Fluids.f_76193_, Fluids.f_76193_.m_6718_(p_222387_));
        }
        return super.m_7417_(p_222384_, p_222385_, p_222386_, p_222387_, p_222388_, p_222389_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_222391_) {
        super.m_7926_(p_222391_);
        p_222391_.m_61104_(new Property[]{f_222348_});
    }

    public boolean m_6864_(BlockState p_222381_, BlockPlaceContext p_222382_) {
        return !p_222382_.m_43722_().m_150930_(Items.f_220193_) || super.m_6864_(p_222381_, p_222382_);
    }

    public FluidState m_5888_(BlockState p_222394_) {
        return (Boolean)p_222394_.m_61143_((Property)f_222348_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_222394_);
    }

    public PushReaction m_5537_(BlockState p_222397_) {
        return PushReaction.DESTROY;
    }

    class SculkVeinSpreaderConfig
    extends MultifaceSpreader.DefaultSpreaderConfig {
        private final MultifaceSpreader.SpreadType[] f_222399_;

        public SculkVeinSpreaderConfig(MultifaceSpreader.SpreadType ... p_222402_) {
            super(SculkVeinBlock.this);
            this.f_222399_ = p_222402_;
        }

        @Override
        public boolean m_213938_(BlockGetter p_222405_, BlockPos p_222406_, BlockPos p_222407_, Direction p_222408_, BlockState p_222409_) {
            BlockState blockstate = p_222405_.m_8055_(p_222407_.m_121945_(p_222408_));
            if (!(blockstate.m_60713_(Blocks.f_220855_) || blockstate.m_60713_(Blocks.f_220857_) || blockstate.m_60713_(Blocks.f_50110_))) {
                BlockPos blockpos;
                if (p_222406_.m_123333_((Vec3i)p_222407_) == 2 && p_222405_.m_8055_(blockpos = p_222406_.m_121945_(p_222408_.m_122424_())).m_60783_(p_222405_, blockpos, p_222408_)) {
                    return false;
                }
                FluidState fluidstate = p_222409_.m_60819_();
                if (!fluidstate.m_76178_() && !fluidstate.m_192917_(Fluids.f_76193_)) {
                    return false;
                }
                Material material = p_222409_.m_60767_();
                if (material == Material.f_76309_) {
                    return false;
                }
                return p_222409_.m_247087_() || super.m_213938_(p_222405_, p_222406_, p_222407_, p_222408_, p_222409_);
            }
            return false;
        }

        @Override
        public MultifaceSpreader.SpreadType[] m_214109_() {
            return this.f_222399_;
        }

        @Override
        public boolean m_214107_(BlockState p_222411_) {
            return !p_222411_.m_60713_(Blocks.f_220856_);
        }
    }
}

