/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;

public class VineBlock
extends Block
implements IForgeShearable {
    public static final BooleanProperty f_57833_ = PipeBlock.f_55152_;
    public static final BooleanProperty f_57834_ = PipeBlock.f_55148_;
    public static final BooleanProperty f_57835_ = PipeBlock.f_55149_;
    public static final BooleanProperty f_57836_ = PipeBlock.f_55150_;
    public static final BooleanProperty f_57837_ = PipeBlock.f_55151_;
    public static final Map<Direction, BooleanProperty> f_57838_ = PipeBlock.f_55154_.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != Direction.DOWN).collect(Util.m_137448_());
    protected static final float f_154875_ = 1.0f;
    private static final VoxelShape f_57839_ = Block.m_49796_(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape f_57840_ = Block.m_49796_(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape f_57841_ = Block.m_49796_(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape f_57842_ = Block.m_49796_(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape f_57843_ = Block.m_49796_(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> f_57844_;

    public VineBlock(BlockBehaviour.Properties p_57847_) {
        super(p_57847_);
        this.m_49959_((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_57833_, Boolean.valueOf(false)))).m_61124_((Property)f_57834_, Boolean.valueOf(false)))).m_61124_((Property)f_57835_, Boolean.valueOf(false)))).m_61124_((Property)f_57836_, Boolean.valueOf(false)))).m_61124_((Property)f_57837_, Boolean.valueOf(false))));
        this.f_57844_ = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), VineBlock::m_57905_)));
    }

    private static VoxelShape m_57905_(BlockState p_57906_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        if (((Boolean)p_57906_.m_61143_((Property)f_57833_)).booleanValue()) {
            voxelshape = f_57839_;
        }
        if (((Boolean)p_57906_.m_61143_((Property)f_57834_)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)f_57842_);
        }
        if (((Boolean)p_57906_.m_61143_((Property)f_57836_)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)f_57843_);
        }
        if (((Boolean)p_57906_.m_61143_((Property)f_57835_)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)f_57841_);
        }
        if (((Boolean)p_57906_.m_61143_((Property)f_57837_)).booleanValue()) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)f_57840_);
        }
        return voxelshape.m_83281_() ? Shapes.m_83144_() : voxelshape;
    }

    @Override
    public VoxelShape m_5940_(BlockState p_57897_, BlockGetter p_57898_, BlockPos p_57899_, CollisionContext p_57900_) {
        return this.f_57844_.get((Object)p_57897_);
    }

    @Override
    public boolean m_7420_(BlockState p_181239_, BlockGetter p_181240_, BlockPos p_181241_) {
        return true;
    }

    @Override
    public boolean m_7898_(BlockState p_57861_, LevelReader p_57862_, BlockPos p_57863_) {
        return this.m_57907_(this.m_57901_(p_57861_, p_57862_, p_57863_));
    }

    private boolean m_57907_(BlockState p_57908_) {
        return this.m_57909_(p_57908_) > 0;
    }

    private int m_57909_(BlockState p_57910_) {
        int i = 0;
        for (BooleanProperty booleanproperty : f_57838_.values()) {
            if (!((Boolean)p_57910_.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean m_57887_(BlockGetter p_57888_, BlockPos p_57889_, Direction p_57890_) {
        if (p_57890_ == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = p_57889_.m_121945_(p_57890_);
        if (VineBlock.m_57853_(p_57888_, blockpos, p_57890_)) {
            return true;
        }
        if (p_57890_.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = f_57838_.get(p_57890_);
        BlockState blockstate = p_57888_.m_8055_(p_57889_.m_7494_());
        return blockstate.m_60713_(this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
    }

    public static boolean m_57853_(BlockGetter p_57854_, BlockPos p_57855_, Direction p_57856_) {
        return MultifaceBlock.m_153829_((BlockGetter)p_57854_, (Direction)p_57856_, (BlockPos)p_57855_, (BlockState)p_57854_.m_8055_(p_57855_));
    }

    private BlockState m_57901_(BlockState p_57902_, BlockGetter p_57903_, BlockPos p_57904_) {
        BlockPos blockpos = p_57904_.m_7494_();
        if (((Boolean)p_57902_.m_61143_((Property)f_57833_)).booleanValue()) {
            p_57902_ = (BlockState)((Object)p_57902_.m_61124_((Property)f_57833_, Boolean.valueOf(VineBlock.m_57853_(p_57903_, blockpos, Direction.DOWN))));
        }
        BlockBehaviour.BlockStateBase blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = VineBlock.m_57883_(direction);
            if (!((Boolean)p_57902_.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.m_57887_(p_57903_, p_57904_, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = p_57903_.m_8055_(blockpos);
                }
                flag = blockstate.m_60713_(this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            }
            p_57902_ = (BlockState)((Object)p_57902_.m_61124_((Property)booleanproperty, Boolean.valueOf(flag)));
        }
        return p_57902_;
    }

    @Override
    public BlockState m_7417_(BlockState p_57875_, Direction p_57876_, BlockState p_57877_, LevelAccessor p_57878_, BlockPos p_57879_, BlockPos p_57880_) {
        if (p_57876_ == Direction.DOWN) {
            return super.m_7417_(p_57875_, p_57876_, p_57877_, p_57878_, p_57879_, p_57880_);
        }
        BlockState blockstate = this.m_57901_(p_57875_, p_57878_, p_57879_);
        return !this.m_57907_(blockstate) ? Blocks.f_50016_.m_49966_() : blockstate;
    }

    @Override
    public void m_213898_(BlockState p_222655_, ServerLevel p_222656_, BlockPos p_222657_, RandomSource p_222658_) {
        if (p_222656_.m_46469_().m_46207_(GameRules.f_268705_) && p_222656_.f_46441_.m_188501_() < (float)p_222656_.spigotConfig.vineModifier / 400.0f && p_222656_.isAreaLoaded(p_222657_, 4)) {
            Direction direction = Direction.m_235672_((RandomSource)p_222658_);
            BlockPos blockpos = p_222657_.m_7494_();
            if (direction.m_122434_().m_122479_() && !((Boolean)p_222655_.m_61143_((Property)VineBlock.m_57883_(direction))).booleanValue()) {
                if (this.m_57850_(p_222656_, p_222657_)) {
                    BlockPos blockpos4 = p_222657_.m_121945_(direction);
                    BlockState blockstate4 = p_222656_.m_8055_(blockpos4);
                    if (blockstate4.m_60795_()) {
                        Direction direction3 = direction.m_122427_();
                        Direction direction4 = direction.m_122428_();
                        boolean flag = (Boolean)p_222655_.m_61143_((Property)VineBlock.m_57883_(direction3));
                        boolean flag1 = (Boolean)p_222655_.m_61143_((Property)VineBlock.m_57883_(direction4));
                        BlockPos blockpos2 = blockpos4.m_121945_(direction3);
                        BlockPos blockpos3 = blockpos4.m_121945_(direction4);
                        BlockPos source = p_222657_;
                        if (flag && VineBlock.m_57853_(p_222656_, blockpos2, direction3)) {
                            CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_222656_, (BlockPos)source, (BlockPos)blockpos4, (BlockState)((BlockState)((Object)this.m_49966_().m_61124_((Property)VineBlock.m_57883_(direction3), Boolean.valueOf(true)))), (int)2);
                        } else if (flag1 && VineBlock.m_57853_(p_222656_, blockpos3, direction4)) {
                            CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_222656_, (BlockPos)source, (BlockPos)blockpos4, (BlockState)((BlockState)((Object)this.m_49966_().m_61124_((Property)VineBlock.m_57883_(direction4), Boolean.valueOf(true)))), (int)2);
                        } else {
                            Direction direction1 = direction.m_122424_();
                            if (flag && p_222656_.m_46859_(blockpos2) && VineBlock.m_57853_(p_222656_, p_222657_.m_121945_(direction3), direction1)) {
                                CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_222656_, (BlockPos)source, (BlockPos)blockpos2, (BlockState)((BlockState)((Object)this.m_49966_().m_61124_((Property)VineBlock.m_57883_(direction1), Boolean.valueOf(true)))), (int)2);
                            } else if (flag1 && p_222656_.m_46859_(blockpos3) && VineBlock.m_57853_(p_222656_, p_222657_.m_121945_(direction4), direction1)) {
                                CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_222656_, (BlockPos)source, (BlockPos)blockpos3, (BlockState)((BlockState)((Object)this.m_49966_().m_61124_((Property)VineBlock.m_57883_(direction1), Boolean.valueOf(true)))), (int)2);
                            } else if ((double)p_222658_.m_188501_() < 0.05 && VineBlock.m_57853_(p_222656_, blockpos4.m_7494_(), Direction.UP)) {
                                CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_222656_, (BlockPos)source, (BlockPos)blockpos4, (BlockState)((BlockState)((Object)this.m_49966_().m_61124_((Property)f_57833_, Boolean.valueOf(true)))), (int)2);
                            }
                        }
                    } else if (VineBlock.m_57853_(p_222656_, blockpos4, direction)) {
                        p_222656_.m_7731_(p_222657_, (BlockState)((Object)p_222655_.m_61124_((Property)VineBlock.m_57883_(direction), Boolean.valueOf(true))), 2);
                    }
                }
            } else {
                BlockState blockstate2;
                BlockState blockstate1;
                BlockPos blockpos1;
                BlockState blockstate;
                if (direction == Direction.UP && p_222657_.m_123342_() < p_222656_.m_151558_() - 1) {
                    if (this.m_57887_(p_222656_, p_222657_, direction)) {
                        p_222656_.m_7731_(p_222657_, (BlockState)((Object)p_222655_.m_61124_((Property)f_57833_, Boolean.valueOf(true))), 2);
                        return;
                    }
                    if (p_222656_.m_46859_(blockpos)) {
                        if (!this.m_57850_(p_222656_, p_222657_)) {
                            return;
                        }
                        BlockState blockstate3 = p_222655_;
                        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                            if (!p_222658_.m_188499_() && VineBlock.m_57853_(p_222656_, blockpos.m_121945_(direction2), direction2)) continue;
                            blockstate3 = (BlockState)((Object)blockstate3.m_61124_((Property)VineBlock.m_57883_(direction2), Boolean.valueOf(false)));
                        }
                        if (this.m_57911_(blockstate3)) {
                            CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_222656_, (BlockPos)p_222657_, (BlockPos)blockpos, (BlockState)blockstate3, (int)2);
                        }
                        return;
                    }
                }
                if (p_222657_.m_123342_() > p_222656_.m_141937_() && ((blockstate = p_222656_.m_8055_(blockpos1 = p_222657_.m_7495_())).m_60795_() || blockstate.m_60713_(this)) && (blockstate1 = blockstate.m_60795_() ? this.m_49966_() : blockstate) != (blockstate2 = this.m_222650_(p_222655_, blockstate1, p_222658_)) && this.m_57911_(blockstate2)) {
                    CraftEventFactory.handleBlockSpreadEvent((LevelAccessor)p_222656_, (BlockPos)p_222657_, (BlockPos)blockpos1, (BlockState)blockstate2, (int)2);
                }
            }
        }
    }

    private BlockState m_222650_(BlockState p_222651_, BlockState p_222652_, RandomSource p_222653_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!p_222653_.m_188499_() || !((Boolean)p_222651_.m_61143_((Property)(booleanproperty = VineBlock.m_57883_(direction)))).booleanValue()) continue;
            p_222652_ = (BlockState)((Object)p_222652_.m_61124_((Property)booleanproperty, Boolean.valueOf(true)));
        }
        return p_222652_;
    }

    private boolean m_57911_(BlockState p_57912_) {
        return (Boolean)p_57912_.m_61143_((Property)f_57834_) != false || (Boolean)p_57912_.m_61143_((Property)f_57835_) != false || (Boolean)p_57912_.m_61143_((Property)f_57836_) != false || (Boolean)p_57912_.m_61143_((Property)f_57837_) != false;
    }

    private boolean m_57850_(BlockGetter p_57851_, BlockPos p_57852_) {
        int i = 4;
        Iterable iterable = BlockPos.m_121976_((int)(p_57852_.m_123341_() - 4), (int)(p_57852_.m_123342_() - 1), (int)(p_57852_.m_123343_() - 4), (int)(p_57852_.m_123341_() + 4), (int)(p_57852_.m_123342_() + 1), (int)(p_57852_.m_123343_() + 4));
        int j = 5;
        for (BlockPos blockpos : iterable) {
            if (!p_57851_.m_8055_(blockpos).m_60713_(this) || --j > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean m_6864_(BlockState p_57858_, BlockPlaceContext p_57859_) {
        BlockState blockstate = p_57859_.m_43725_().m_8055_(p_57859_.m_8083_());
        if (blockstate.m_60713_(this)) {
            return this.m_57909_(blockstate) < f_57838_.size();
        }
        return super.m_6864_(p_57858_, p_57859_);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_57849_) {
        BlockState blockstate = p_57849_.m_43725_().m_8055_(p_57849_.m_8083_());
        boolean flag = blockstate.m_60713_(this);
        BlockState blockstate1 = flag ? blockstate : this.m_49966_();
        for (Direction direction : p_57849_.m_6232_()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = VineBlock.m_57883_(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            if (flag1 || !this.m_57887_(p_57849_.m_43725_(), p_57849_.m_8083_(), direction)) continue;
            return (BlockState)((Object)blockstate1.m_61124_((Property)booleanproperty, Boolean.valueOf(true)));
        }
        return flag ? blockstate1 : null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57882_) {
        p_57882_.m_61104_(new Property[]{f_57833_, f_57834_, f_57835_, f_57836_, f_57837_});
    }

    @Override
    public BlockState m_6843_(BlockState p_57868_, Rotation p_57869_) {
        switch (p_57869_) {
            case CLOCKWISE_180: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_57868_.m_61124_((Property)f_57834_, (Boolean)p_57868_.m_61143_((Property)f_57836_)))).m_61124_((Property)f_57835_, (Boolean)p_57868_.m_61143_((Property)f_57837_)))).m_61124_((Property)f_57836_, (Boolean)p_57868_.m_61143_((Property)f_57834_)))).m_61124_((Property)f_57837_, (Boolean)p_57868_.m_61143_((Property)f_57835_)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_57868_.m_61124_((Property)f_57834_, (Boolean)p_57868_.m_61143_((Property)f_57835_)))).m_61124_((Property)f_57835_, (Boolean)p_57868_.m_61143_((Property)f_57836_)))).m_61124_((Property)f_57836_, (Boolean)p_57868_.m_61143_((Property)f_57837_)))).m_61124_((Property)f_57837_, (Boolean)p_57868_.m_61143_((Property)f_57834_)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)p_57868_.m_61124_((Property)f_57834_, (Boolean)p_57868_.m_61143_((Property)f_57837_)))).m_61124_((Property)f_57835_, (Boolean)p_57868_.m_61143_((Property)f_57834_)))).m_61124_((Property)f_57836_, (Boolean)p_57868_.m_61143_((Property)f_57835_)))).m_61124_((Property)f_57837_, (Boolean)p_57868_.m_61143_((Property)f_57836_)));
            }
        }
        return p_57868_;
    }

    @Override
    public BlockState m_6943_(BlockState p_57865_, Mirror p_57866_) {
        switch (p_57866_) {
            case LEFT_RIGHT: {
                return (BlockState)((Object)((BlockState)((Object)p_57865_.m_61124_((Property)f_57834_, (Boolean)p_57865_.m_61143_((Property)f_57836_)))).m_61124_((Property)f_57836_, (Boolean)p_57865_.m_61143_((Property)f_57834_)));
            }
            case FRONT_BACK: {
                return (BlockState)((Object)((BlockState)((Object)p_57865_.m_61124_((Property)f_57835_, (Boolean)p_57865_.m_61143_((Property)f_57837_)))).m_61124_((Property)f_57837_, (Boolean)p_57865_.m_61143_((Property)f_57835_)));
            }
        }
        return super.m_6943_(p_57865_, p_57866_);
    }

    public static BooleanProperty m_57883_(Direction p_57884_) {
        return f_57838_.get(p_57884_);
    }
}

