/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class BeehiveBlockEntity
extends BlockEntity {
    public static final String f_155121_ = "FlowerPos";
    public static final String f_155122_ = "MinOccupationTicks";
    public static final String f_155123_ = "EntityData";
    public static final String f_155124_ = "TicksInHive";
    public static final String f_155125_ = "HasNectar";
    public static final String f_155126_ = "Bees";
    private static final List<String> f_155129_ = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "HivePos", "Passengers", "Leash", "UUID");
    public static final int f_155127_ = 3;
    private static final int f_155130_ = 400;
    private static final int f_155131_ = 2400;
    public static final int f_155128_ = 600;
    private final List<BeeData> f_58732_ = Lists.newArrayList();
    @Nullable
    public BlockPos f_58733_;
    public int maxBees = 3;

    public BeehiveBlockEntity(BlockPos p_155134_, BlockState p_155135_) {
        super(BlockEntityType.f_58912_, p_155134_, p_155135_);
    }

    @Override
    public void m_6596_() {
        if (this.m_58773_()) {
            this.m_58748_(null, this.f_58857_.m_8055_(this.m_58899_()), BeeReleaseStatus.EMERGENCY);
        }
        super.m_6596_();
    }

    public boolean m_58773_() {
        if (this.f_58857_ == null) {
            return false;
        }
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, -1, -1), (BlockPos)this.f_58858_.m_7918_(1, 1, 1))) {
            if (!(this.f_58857_.m_8055_(blockpos).m_60734_() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean m_58774_() {
        return this.f_58732_.isEmpty();
    }

    public boolean m_58775_() {
        return this.f_58732_.size() == this.maxBees;
    }

    public void m_58748_(@Nullable Player p_58749_, BlockState p_58750_, BeeReleaseStatus p_58751_) {
        List<net.minecraft.world.entity.Entity> list = this.m_58759_(p_58750_, p_58751_);
        if (p_58749_ != null) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee bee = (Bee)entity;
                if (!(p_58749_.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                if (!this.m_58777_()) {
                    bee.setTarget(p_58749_, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    continue;
                }
                bee.m_27915_(400);
            }
        }
    }

    private List<net.minecraft.world.entity.Entity> m_58759_(BlockState p_58760_, BeeReleaseStatus p_58761_) {
        ArrayList list = Lists.newArrayList();
        this.f_58732_.removeIf(p_272556_ -> BeehiveBlockEntity.m_155136_(this.f_58857_, this.f_58858_, p_58760_, p_272556_, list, p_58761_, this.f_58733_));
        if (!list.isEmpty()) {
            super.m_6596_();
        }
        return list;
    }

    public void m_58741_(net.minecraft.world.entity.Entity p_58742_, boolean p_58743_) {
        this.m_58744_(p_58742_, p_58743_, 0);
    }

    @VisibleForDebug
    public int m_58776_() {
        return this.f_58732_.size();
    }

    public static int m_58752_(BlockState p_58753_) {
        return (Integer)p_58753_.m_61143_((Property)BeehiveBlock.f_49564_);
    }

    @VisibleForDebug
    public boolean m_58777_() {
        return CampfireBlock.m_51248_(this.f_58857_, this.m_58899_());
    }

    public void m_58744_(net.minecraft.world.entity.Entity p_58745_, boolean p_58746_, int p_58747_) {
        if (this.f_58732_.size() < this.maxBees) {
            if (this.f_58857_ != null) {
                EntityEnterBlockEvent event = new EntityEnterBlockEvent((Entity)p_58745_.getBukkitEntity(), (Block)CraftBlock.at((LevelAccessor)this.f_58857_, (BlockPos)this.m_58899_()));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    if (p_58745_ instanceof Bee) {
                        ((Bee)p_58745_).m_27915_(400);
                    }
                    return;
                }
            }
            p_58745_.m_8127_();
            p_58745_.m_20153_();
            CompoundTag compoundtag = new CompoundTag();
            p_58745_.m_20223_(compoundtag);
            this.m_155157_(compoundtag, p_58747_, p_58746_);
            if (this.f_58857_ != null) {
                Bee bee;
                if (p_58745_ instanceof Bee && (bee = (Bee)p_58745_).m_27852_() && (!this.m_58780_() || this.f_58857_.f_46441_.m_188499_())) {
                    this.f_58733_ = bee.m_27851_();
                }
                BlockPos blockpos = this.m_58899_();
                this.f_58857_.m_6263_(null, blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_(), SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.f_58857_.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((net.minecraft.world.entity.Entity)p_58745_, (BlockState)this.m_58900_()));
            }
            p_58745_.m_146870_();
            super.m_6596_();
        }
    }

    public void m_155157_(CompoundTag p_155158_, int p_155159_, boolean p_155160_) {
        this.f_58732_.add(new BeeData(p_155158_, p_155159_, p_155160_ ? 2400 : 600));
    }

    private static boolean m_155136_(Level p_155137_, BlockPos p_155138_, BlockState p_155139_, BeeData p_155140_, @Nullable List<net.minecraft.world.entity.Entity> p_155141_, BeeReleaseStatus p_155142_, @Nullable BlockPos p_155143_) {
        return BeehiveBlockEntity.releaseBee(p_155137_, p_155138_, p_155139_, p_155140_, p_155141_, p_155142_, p_155143_, false);
    }

    private static boolean releaseBee(Level p_155137_, BlockPos p_155138_, BlockState p_155139_, BeeData p_155140_, @Nullable List<net.minecraft.world.entity.Entity> p_155141_, BeeReleaseStatus p_155142_, @Nullable BlockPos p_155143_, boolean force) {
        boolean flag;
        if (!force && (p_155137_.m_46462_() || p_155137_.m_46471_()) && p_155142_ != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        CompoundTag compoundtag = p_155140_.f_58782_.m_6426_();
        BeehiveBlockEntity.m_155161_(compoundtag);
        compoundtag.m_128365_("HivePos", NbtUtils.m_129224_((BlockPos)p_155138_));
        compoundtag.m_128379_("NoGravity", true);
        Direction direction = (Direction)p_155139_.m_61143_((Property)BeehiveBlock.f_49563_);
        BlockPos blockpos = p_155138_.m_121945_(direction);
        boolean bl = flag = !p_155137_.m_8055_(blockpos).m_60812_(p_155137_, blockpos).m_83281_();
        if (flag && p_155142_ != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = EntityType.m_20645_(compoundtag, p_155137_, p_58740_ -> p_58740_);
        if (entity != null) {
            if (!entity.m_6095_().m_204039_(EntityTypeTags.f_13122_)) {
                return false;
            }
            if (entity instanceof Bee) {
                float f = entity.m_20205_();
                double d0 = flag ? 0.0 : 0.55 + (double)(f / 2.0f);
                double d1 = (double)p_155138_.m_123341_() + 0.5 + d0 * (double)direction.m_122429_();
                double d2 = (double)p_155138_.m_123342_() + 0.5 - (double)(entity.m_20206_() / 2.0f);
                double d3 = (double)p_155138_.m_123343_() + 0.5 + d0 * (double)direction.m_122431_();
                entity.m_7678_(d1, d2, d3, entity.m_146908_(), entity.m_146909_());
            }
            if (!p_155137_.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.BEEHIVE)) {
                return false;
            }
            if (entity instanceof Bee) {
                Bee bee = (Bee)entity;
                if (p_155143_ != null && !bee.m_27852_() && p_155137_.f_46441_.m_188501_() < 0.9f) {
                    bee.m_27876_(p_155143_);
                }
                if (p_155142_ == BeeReleaseStatus.HONEY_DELIVERED) {
                    int i;
                    bee.m_27864_();
                    if (p_155139_.m_204338_(BlockTags.f_13072_, p_202037_ -> p_202037_.m_61138_((Property)BeehiveBlock.f_49564_)) && (i = BeehiveBlockEntity.m_58752_(p_155139_)) < 5) {
                        int j;
                        int n = j = p_155137_.f_46441_.m_188503_(100) == 0 ? 2 : 1;
                        if (i + j > 5) {
                            --j;
                        }
                        p_155137_.m_46597_(p_155138_, (BlockState)((Object)p_155139_.m_61124_((Property)BeehiveBlock.f_49564_, Integer.valueOf(i + j))));
                    }
                }
                BeehiveBlockEntity.m_58736_(p_155140_.f_58783_, bee);
                if (p_155141_ != null) {
                    p_155141_.add(bee);
                }
            }
            p_155137_.m_5594_(null, p_155138_, SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 1.0f);
            p_155137_.m_220407_(GameEvent.f_157792_, p_155138_, GameEvent.Context.m_223719_((net.minecraft.world.entity.Entity)entity, (BlockState)p_155137_.m_8055_(p_155138_)));
            return true;
        }
        return false;
    }

    static void m_155161_(CompoundTag p_155162_) {
        for (String s : f_155129_) {
            p_155162_.m_128473_(s);
        }
    }

    private static void m_58736_(int p_58737_, Bee p_58738_) {
        int i = p_58738_.m_146764_();
        if (i < 0) {
            p_58738_.m_146762_(Math.min(0, i + p_58737_));
        } else if (i > 0) {
            p_58738_.m_146762_(Math.max(0, i - p_58737_));
        }
        p_58738_.m_27601_(Math.max(0, p_58738_.m_27591_() - p_58737_));
    }

    private boolean m_58780_() {
        return this.f_58733_ != null;
    }

    private static void m_155149_(Level p_155150_, BlockPos p_155151_, BlockState p_155152_, List<BeeData> p_155153_, @Nullable BlockPos p_155154_) {
        boolean flag = false;
        Iterator<BeeData> iterator = p_155153_.iterator();
        while (iterator.hasNext()) {
            BeeData beehiveblockentity$beedata = iterator.next();
            if (beehiveblockentity$beedata.f_58783_ > beehiveblockentity$beedata.f_58784_) {
                BeeReleaseStatus beehiveblockentity$beereleasestatus;
                BeeReleaseStatus beeReleaseStatus = beehiveblockentity$beereleasestatus = beehiveblockentity$beedata.f_58782_.m_128471_(f_155125_) ? BeeReleaseStatus.HONEY_DELIVERED : BeeReleaseStatus.BEE_RELEASED;
                if (BeehiveBlockEntity.m_155136_(p_155150_, p_155151_, p_155152_, beehiveblockentity$beedata, null, beehiveblockentity$beereleasestatus, p_155154_)) {
                    flag = true;
                    iterator.remove();
                } else {
                    beehiveblockentity$beedata.f_58783_ = beehiveblockentity$beedata.f_58784_ / 2;
                }
            }
            ++beehiveblockentity$beedata.f_58783_;
        }
        if (flag) {
            BeehiveBlockEntity.m_155232_(p_155150_, p_155151_, p_155152_);
        }
    }

    public static void m_155144_(Level p_155145_, BlockPos p_155146_, BlockState p_155147_, BeehiveBlockEntity p_155148_) {
        BeehiveBlockEntity.m_155149_(p_155145_, p_155146_, p_155147_, p_155148_.f_58732_, p_155148_.f_58733_);
        if (!p_155148_.f_58732_.isEmpty() && p_155145_.m_213780_().m_188500_() < 0.005) {
            double d0 = (double)p_155146_.m_123341_() + 0.5;
            double d1 = p_155146_.m_123342_();
            double d2 = (double)p_155146_.m_123343_() + 0.5;
            p_155145_.m_6263_(null, d0, d1, d2, SoundEvents.f_11698_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        DebugPackets.m_179510_((Level)p_155145_, (BlockPos)p_155146_, (BlockState)p_155147_, (BeehiveBlockEntity)p_155148_);
    }

    @Override
    public void m_142466_(CompoundTag p_155156_) {
        super.m_142466_(p_155156_);
        this.f_58732_.clear();
        ListTag listtag = p_155156_.m_128437_(f_155126_, 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            BeeData beehiveblockentity$beedata = new BeeData(compoundtag.m_128469_(f_155123_), compoundtag.m_128451_(f_155124_), compoundtag.m_128451_(f_155122_));
            this.f_58732_.add(beehiveblockentity$beedata);
        }
        this.f_58733_ = null;
        if (p_155156_.m_128441_(f_155121_)) {
            this.f_58733_ = NbtUtils.m_129239_((CompoundTag)p_155156_.m_128469_(f_155121_));
        }
        if (p_155156_.m_128441_("Bukkit.MaxEntities")) {
            this.maxBees = p_155156_.m_128451_("Bukkit.MaxEntities");
        }
    }

    @Override
    protected void m_183515_(CompoundTag p_187467_) {
        super.m_183515_(p_187467_);
        p_187467_.m_128365_(f_155126_, (Tag)this.m_58779_());
        if (this.m_58780_()) {
            p_187467_.m_128365_(f_155121_, NbtUtils.m_129224_((BlockPos)this.f_58733_));
        }
        p_187467_.m_128405_("Bukkit.MaxEntities", this.maxBees);
    }

    public ListTag m_58779_() {
        ListTag listtag = new ListTag();
        for (BeeData beehiveblockentity$beedata : this.f_58732_) {
            CompoundTag compoundtag = beehiveblockentity$beedata.f_58782_.m_6426_();
            compoundtag.m_128473_("UUID");
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag1.m_128365_(f_155123_, compoundtag);
            compoundtag1.m_128405_(f_155124_, beehiveblockentity$beedata.f_58783_);
            compoundtag1.m_128405_(f_155122_, beehiveblockentity$beedata.f_58784_);
            listtag.add(compoundtag1);
        }
        return listtag;
    }

    public List<net.minecraft.world.entity.Entity> releaseBees(BlockState p_58760_, BeeReleaseStatus p_58761_, boolean force) {
        ArrayList list = Lists.newArrayList();
        this.f_58732_.removeIf(p_58766_ -> BeehiveBlockEntity.releaseBee(this.f_58857_, this.f_58858_, p_58760_, p_58766_, list, p_58761_, this.f_58733_, force));
        if (!list.isEmpty()) {
            super.m_6596_();
        }
        return list;
    }

    public static final class BeeReleaseStatus
    extends Enum<BeeReleaseStatus> {
        public static final /* enum */ BeeReleaseStatus HONEY_DELIVERED = new BeeReleaseStatus();
        public static final /* enum */ BeeReleaseStatus BEE_RELEASED = new BeeReleaseStatus();
        public static final /* enum */ BeeReleaseStatus EMERGENCY = new BeeReleaseStatus();
        private static final /* synthetic */ BeeReleaseStatus[] $VALUES;

        public static BeeReleaseStatus[] values() {
            return (BeeReleaseStatus[])$VALUES.clone();
        }

        public static BeeReleaseStatus valueOf(String p_58811_) {
            return Enum.valueOf(BeeReleaseStatus.class, p_58811_);
        }

        private static /* synthetic */ BeeReleaseStatus[] m_155163_() {
            return new BeeReleaseStatus[]{HONEY_DELIVERED, BEE_RELEASED, EMERGENCY};
        }

        static {
            $VALUES = BeeReleaseStatus.m_155163_();
        }
    }

    static class BeeData {
        final CompoundTag f_58782_;
        int f_58783_;
        final int f_58784_;

        BeeData(CompoundTag p_58786_, int p_58787_, int p_58788_) {
            BeehiveBlockEntity.m_155161_(p_58786_);
            this.f_58782_ = p_58786_;
            this.f_58783_ = p_58787_;
            this.f_58784_ = p_58788_;
        }
    }
}

