/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BrewingStartEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int f_155280_ = 3;
    private static final int f_155281_ = 4;
    private static final int[] f_58972_ = new int[]{3};
    private static final int[] f_58973_ = new int[]{0, 1, 2, 3};
    private static final int[] f_58974_ = new int[]{0, 1, 2, 4};
    public static final int f_155276_ = 20;
    public static final int f_155277_ = 0;
    public static final int f_155278_ = 1;
    public static final int f_155279_ = 2;
    private NonNullList<net.minecraft.world.item.ItemStack> f_58975_ = NonNullList.m_122780_((int)5, (Object)((Object)net.minecraft.world.item.ItemStack.f_41583_));
    public int f_58976_;
    private boolean[] f_58977_;
    private Item f_58978_;
    public int f_58979_;
    protected final ContainerData f_58971_ = new ContainerData(){

        public int m_6413_(int p_59038_) {
            switch (p_59038_) {
                case 0: {
                    return BrewingStandBlockEntity.this.f_58976_;
                }
                case 1: {
                    return BrewingStandBlockEntity.this.f_58979_;
                }
            }
            return 0;
        }

        public void m_8050_(int p_59040_, int p_59041_) {
            switch (p_59040_) {
                case 0: {
                    BrewingStandBlockEntity.this.f_58976_ = p_59041_;
                    break;
                }
                case 1: {
                    BrewingStandBlockEntity.this.f_58979_ = p_59041_;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int lastTick = MinecraftServer.currentTick;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.f_58975_;
    }

    @Override
    public int m_6893_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public BrewingStandBlockEntity(BlockPos p_155283_, BlockState p_155284_) {
        super(BlockEntityType.f_58927_, p_155283_, p_155284_);
    }

    @Override
    protected Component m_6820_() {
        return Component.m_237115_("container.brewing");
    }

    @Override
    public int m_6643_() {
        return this.f_58975_.size();
    }

    @Override
    public boolean m_7983_() {
        for (net.minecraft.world.item.ItemStack itemstack : this.f_58975_) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static void m_155285_(Level p_155286_, BlockPos p_155287_, BlockState p_155288_, BrewingStandBlockEntity p_155289_) {
        net.minecraft.world.item.ItemStack itemstack = (net.minecraft.world.item.ItemStack)((Object)p_155289_.f_58975_.get(4));
        if (p_155289_.f_58979_ <= 0 && itemstack.m_150930_(Items.f_42593_)) {
            BrewingStandFuelEvent event = new BrewingStandFuelEvent((Block)CraftBlock.at((LevelAccessor)p_155286_, (BlockPos)p_155287_), (ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack), 20);
            p_155286_.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            p_155289_.f_58979_ = event.getFuelPower();
            if (p_155289_.f_58979_ > 0 && event.isConsuming()) {
                itemstack.m_41774_(1);
            }
            BrewingStandBlockEntity.m_155232_(p_155286_, p_155287_, p_155288_);
        }
        boolean flag = BrewingStandBlockEntity.m_155294_(p_155289_.f_58975_);
        boolean flag1 = p_155289_.f_58976_ > 0;
        net.minecraft.world.item.ItemStack itemstack1 = (net.minecraft.world.item.ItemStack)((Object)p_155289_.f_58975_.get(3));
        int elapsedTicks = MinecraftServer.currentTick - p_155289_.lastTick;
        p_155289_.lastTick = MinecraftServer.currentTick;
        if (flag1) {
            boolean flag2;
            p_155289_.f_58976_ -= elapsedTicks;
            boolean bl = flag2 = p_155289_.f_58976_ <= 0;
            if (flag2 && flag) {
                BrewingStandBlockEntity.doBrew(p_155286_, p_155287_, p_155289_.f_58975_, p_155289_);
                BrewingStandBlockEntity.m_155232_(p_155286_, p_155287_, p_155288_);
            } else if (!flag || !itemstack1.m_150930_(p_155289_.f_58978_)) {
                p_155289_.f_58976_ = 0;
                BrewingStandBlockEntity.m_155232_(p_155286_, p_155287_, p_155288_);
            }
        } else if (flag && p_155289_.f_58979_ > 0) {
            --p_155289_.f_58979_;
            BrewingStartEvent event = new BrewingStartEvent((Block)CraftBlock.at((LevelAccessor)p_155286_, (BlockPos)p_155287_), (ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1), 400);
            p_155286_.getCraftServer().getPluginManager().callEvent((Event)event);
            p_155289_.f_58976_ = event.getTotalBrewTime();
            p_155289_.f_58978_ = itemstack1.m_41720_();
            BrewingStandBlockEntity.m_155232_(p_155286_, p_155287_, p_155288_);
        }
        boolean[] aboolean = p_155289_.m_59029_();
        if (!Arrays.equals(aboolean, p_155289_.f_58977_)) {
            p_155289_.f_58977_ = aboolean;
            BlockState blockstate = p_155288_;
            if (!(p_155288_.m_60734_() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.f_50905_.length; ++i) {
                blockstate = (BlockState)((Object)blockstate.m_61124_((Property)BrewingStandBlock.f_50905_[i], Boolean.valueOf(aboolean[i])));
            }
            p_155286_.m_7731_(p_155287_, blockstate, 2);
        }
    }

    private boolean[] m_59029_() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((net.minecraft.world.item.ItemStack)((Object)this.f_58975_.get(i))).m_41619_()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private static boolean m_155294_(NonNullList<net.minecraft.world.item.ItemStack> p_155295_) {
        net.minecraft.world.item.ItemStack itemstack = (net.minecraft.world.item.ItemStack)((Object)p_155295_.get(3));
        if (!itemstack.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(p_155295_, (net.minecraft.world.item.ItemStack)itemstack, (int[])f_58974_);
        }
        if (itemstack.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_(itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            net.minecraft.world.item.ItemStack itemstack1 = (net.minecraft.world.item.ItemStack)((Object)p_155295_.get(i));
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_(itemstack1, itemstack)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(Level p_155291_, BlockPos p_155292_, NonNullList<net.minecraft.world.item.ItemStack> p_155293_, BrewingStandBlockEntity brewingStandBlock) {
        if (ForgeEventFactory.onPotionAttemptBrew(p_155293_)) {
            return;
        }
        net.minecraft.world.item.ItemStack itemstack = (net.minecraft.world.item.ItemStack)((Object)p_155293_.get(3));
        InventoryHolder owner = brewingStandBlock.getOwner();
        ArrayList<CraftItemStack> brewResults = new ArrayList<CraftItemStack>(3);
        for (int i = 0; i < 3; ++i) {
            brewResults.add(i, CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)PotionBrewing.m_43529_(itemstack, (net.minecraft.world.item.ItemStack)((Object)p_155293_.get(i)))));
        }
        if (owner != null) {
            BrewEvent event = new BrewEvent((Block)CraftBlock.at((LevelAccessor)p_155291_, (BlockPos)p_155292_), (BrewerInventory)owner.getInventory(), brewResults, brewingStandBlock.f_58979_);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        BrewingRecipeRegistry.brewPotions(p_155293_, (net.minecraft.world.item.ItemStack)itemstack, (int[])f_58974_);
        ForgeEventFactory.onPotionBrewed(p_155293_);
        if (itemstack.hasCraftingRemainingItem()) {
            net.minecraft.world.item.ItemStack itemstack1 = itemstack.getCraftingRemainingItem();
            itemstack.m_41774_(1);
            if (itemstack.m_41619_()) {
                itemstack = itemstack1;
            } else {
                Containers.m_18992_((Level)p_155291_, (double)p_155292_.m_123341_(), (double)p_155292_.m_123342_(), (double)p_155292_.m_123343_(), (net.minecraft.world.item.ItemStack)itemstack1);
            }
        } else {
            itemstack.m_41774_(1);
        }
        p_155293_.set(3, (Object)itemstack);
        p_155291_.m_46796_(1035, p_155292_, 0);
    }

    @Override
    public void m_142466_(CompoundTag p_155297_) {
        super.m_142466_(p_155297_);
        this.f_58975_ = NonNullList.m_122780_((int)this.m_6643_(), (Object)((Object)net.minecraft.world.item.ItemStack.f_41583_));
        ContainerHelper.m_18980_((CompoundTag)p_155297_, this.f_58975_);
        this.f_58976_ = p_155297_.m_128448_("BrewTime");
        this.f_58979_ = p_155297_.m_128445_("Fuel");
    }

    @Override
    protected void m_183515_(CompoundTag p_187484_) {
        super.m_183515_(p_187484_);
        p_187484_.m_128376_("BrewTime", (short)this.f_58976_);
        ContainerHelper.m_18973_((CompoundTag)p_187484_, this.f_58975_);
        p_187484_.m_128344_("Fuel", (byte)this.f_58979_);
    }

    @Override
    public net.minecraft.world.item.ItemStack m_8020_(int p_58985_) {
        return p_58985_ >= 0 && p_58985_ < this.f_58975_.size() ? (net.minecraft.world.item.ItemStack)((Object)this.f_58975_.get(p_58985_)) : net.minecraft.world.item.ItemStack.f_41583_;
    }

    @Override
    public net.minecraft.world.item.ItemStack m_7407_(int p_58987_, int p_58988_) {
        return ContainerHelper.m_18969_(this.f_58975_, (int)p_58987_, (int)p_58988_);
    }

    @Override
    public net.minecraft.world.item.ItemStack m_8016_(int p_59015_) {
        return ContainerHelper.m_18966_(this.f_58975_, (int)p_59015_);
    }

    @Override
    public void m_6836_(int p_58993_, net.minecraft.world.item.ItemStack p_58994_) {
        if (p_58993_ >= 0 && p_58993_ < this.f_58975_.size()) {
            this.f_58975_.set(p_58993_, (Object)p_58994_);
        }
    }

    @Override
    public boolean m_6542_(Player p_59000_) {
        return Container.m_272074_(this, p_59000_);
    }

    @Override
    public boolean m_7013_(int p_59017_, net.minecraft.world.item.ItemStack p_59018_) {
        if (p_59017_ == 3) {
            return BrewingRecipeRegistry.isValidIngredient((net.minecraft.world.item.ItemStack)p_59018_);
        }
        if (p_59017_ == 4) {
            return p_59018_.m_150930_(Items.f_42593_);
        }
        return BrewingRecipeRegistry.isValidInput((net.minecraft.world.item.ItemStack)p_59018_) && this.m_8020_(p_59017_).m_41619_();
    }

    public int[] m_7071_(Direction p_59010_) {
        if (p_59010_ == Direction.UP) {
            return f_58972_;
        }
        return p_59010_ == Direction.DOWN ? f_58973_ : f_58974_;
    }

    public boolean m_7155_(int p_58996_, net.minecraft.world.item.ItemStack p_58997_, @Nullable Direction p_58998_) {
        return this.m_7013_(p_58996_, p_58997_);
    }

    public boolean m_7157_(int p_59020_, net.minecraft.world.item.ItemStack p_59021_, Direction p_59022_) {
        return p_59020_ == 3 ? p_59021_.m_150930_(Items.f_42590_) : true;
    }

    public void m_6211_() {
        this.f_58975_.clear();
    }

    @Override
    protected AbstractContainerMenu m_6555_(int p_58990_, Inventory p_58991_) {
        return new BrewingStandMenu(p_58990_, p_58991_, this, this.f_58971_);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    @Override
    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

