/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class SuspiciousSandBlockEntity
extends BlockEntity {
    private static final Logger f_271536_ = LogUtils.getLogger();
    private static final String f_271256_ = "loot_table";
    private static final String f_271328_ = "loot_table_seed";
    private static final String f_271306_ = "hit_direction";
    private static final String f_271331_ = "item";
    private static final int f_271117_ = 10;
    private static final int f_271104_ = 40;
    private static final int f_271493_ = 10;
    private int f_271157_;
    private long f_271530_;
    private long f_271152_;
    public ItemStack f_271119_ = ItemStack.f_41583_;
    @Nullable
    private Direction f_271286_;
    @Nullable
    public ResourceLocation f_271461_;
    public long f_271354_;

    public SuspiciousSandBlockEntity(BlockPos p_272892_, BlockState p_273759_) {
        super(BlockEntityType.f_271323_, p_272892_, p_273759_);
    }

    public boolean m_272068_(long p_273049_, Player p_273356_, Direction p_272641_) {
        if (this.f_271286_ == null) {
            this.f_271286_ = p_272641_;
        }
        this.f_271530_ = p_273049_ + 40L;
        if (p_273049_ >= this.f_271152_ && this.f_58857_ instanceof ServerLevel) {
            this.f_271152_ = p_273049_ + 10L;
            this.m_271913_(p_273356_);
            int i = this.m_272241_();
            if (++this.f_271157_ >= 10) {
                this.m_271691_(p_273356_);
                return true;
            }
            this.f_58857_.m_186460_(this.m_58899_(), Blocks.f_271439_, 40);
            int j = this.m_272241_();
            if (i != j) {
                BlockState blockstate = this.m_58900_();
                BlockState blockstate1 = (BlockState)((Object)blockstate.m_61124_((Property)BlockStateProperties.f_271112_, Integer.valueOf(j)));
                this.f_58857_.m_7731_(this.m_58899_(), blockstate1, 3);
            }
            return false;
        }
        return false;
    }

    public void m_271913_(Player p_273298_) {
        if (this.f_271461_ != null && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.f_58857_.m_7654_() != null) {
            LootTable loottable = this.f_58857_.m_7654_().m_129898_().m_79217_(this.f_271461_);
            if (p_273298_ instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)p_273298_;
                CriteriaTriggers.f_10563_.m_54597_(serverplayer, this.f_271461_);
            }
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, Vec3.m_82512_((Vec3i)this.f_58858_)).m_78965_(this.f_271354_).m_78963_(p_273298_.m_36336_()).m_78972_(LootContextParams.f_81455_, p_273298_);
            ObjectArrayList<ItemStack> objectarraylist = loottable.m_230922_(lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
            this.f_271119_ = switch (objectarraylist.size()) {
                case 0 -> ItemStack.f_41583_;
                case 1 -> (ItemStack)((Object)objectarraylist.get(0));
                default -> {
                    f_271536_.warn("Expected max 1 loot from loot table " + this.f_271461_ + " got " + objectarraylist.size());
                    yield (ItemStack)((Object)objectarraylist.get(0));
                }
            };
            this.f_271461_ = null;
            this.m_6596_();
        }
    }

    private void m_271691_(Player p_272905_) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.m_271700_(p_272905_);
            this.f_58857_.m_46796_(3008, this.m_58899_(), Block.m_49956_(this.m_58900_()));
            this.f_58857_.m_7731_(this.f_58858_, Blocks.f_49992_.m_49966_(), 3);
        }
    }

    private void m_271700_(Player p_272898_) {
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null) {
            this.m_271913_(p_272898_);
            if (!this.f_271119_.m_41619_()) {
                double d0 = EntityType.f_20461_.m_20678_();
                double d1 = 1.0 - d0;
                double d2 = d0 / 2.0;
                Direction direction = Objects.requireNonNullElse(this.f_271286_, Direction.UP);
                BlockPos blockpos = this.f_58858_.m_5484_(direction, 1);
                double d3 = Math.floor(blockpos.m_123341_()) + 0.5 * d1 + d2;
                double d4 = Math.floor((double)blockpos.m_123342_() + 0.5) + (double)(EntityType.f_20461_.m_20679_() / 2.0f);
                double d5 = Math.floor(blockpos.m_123343_()) + 0.5 * d1 + d2;
                ItemEntity itementity = new ItemEntity(this.f_58857_, d3, d4, d5, this.f_271119_.m_41620_(this.f_58857_.f_46441_.m_188503_(21) + 10));
                itementity.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_(itementity);
                this.f_271119_ = ItemStack.f_41583_;
            }
        }
    }

    public void m_272224_() {
        if (this.f_58857_ != null) {
            if (this.f_271157_ != 0 && this.f_58857_.m_46467_() >= this.f_271530_) {
                int i = this.m_272241_();
                this.f_271157_ = Math.max(0, this.f_271157_ - 2);
                int j = this.m_272241_();
                if (i != j) {
                    this.f_58857_.m_7731_(this.m_58899_(), (BlockState)((Object)this.m_58900_().m_61124_((Property)BlockStateProperties.f_271112_, Integer.valueOf(j))), 3);
                }
                int k = 4;
                this.f_271530_ = this.f_58857_.m_46467_() + 4L;
            }
            if (this.f_271157_ == 0) {
                this.f_271286_ = null;
                this.f_271530_ = 0L;
                this.f_271152_ = 0L;
            } else {
                this.f_58857_.m_186460_(this.m_58899_(), Blocks.f_271439_, (int)(this.f_271530_ - this.f_58857_.m_46467_()));
            }
        }
    }

    private boolean m_272244_(CompoundTag p_272958_) {
        if (p_272958_.m_128425_(f_271256_, 8)) {
            this.f_271461_ = new ResourceLocation(p_272958_.m_128461_(f_271256_));
            this.f_271354_ = p_272958_.m_128454_(f_271328_);
            return true;
        }
        return false;
    }

    private boolean m_272184_(CompoundTag p_273618_) {
        if (this.f_271461_ == null) {
            return false;
        }
        p_273618_.m_128359_(f_271256_, this.f_271461_.toString());
        if (this.f_271354_ != 0L) {
            p_273618_.m_128356_(f_271328_, this.f_271354_);
        }
        return true;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag compoundtag = super.m_5995_();
        if (this.f_271286_ != null) {
            compoundtag.m_128405_(f_271306_, this.f_271286_.ordinal());
        }
        compoundtag.m_128365_(f_271331_, this.f_271119_.m_41739_(new CompoundTag()));
        return compoundtag;
    }

    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag p_272838_) {
        if (!this.m_272244_(p_272838_) && p_272838_.m_128441_(f_271331_)) {
            this.f_271119_ = ItemStack.m_41712_(p_272838_.m_128469_(f_271331_));
        }
        if (p_272838_.m_128441_(f_271306_)) {
            this.f_271286_ = Direction.values()[p_272838_.m_128451_(f_271306_)];
        }
    }

    @Override
    protected void m_183515_(CompoundTag p_273761_) {
        if (!this.m_272184_(p_273761_)) {
            p_273761_.m_128365_(f_271331_, this.f_271119_.m_41739_(new CompoundTag()));
        }
    }

    public void m_272135_(ResourceLocation p_272643_, long p_273491_) {
        this.f_271461_ = p_272643_;
        this.f_271354_ = p_273491_;
    }

    private int m_272241_() {
        if (this.f_271157_ == 0) {
            return 0;
        }
        if (this.f_271157_ < 3) {
            return 1;
        }
        return this.f_271157_ < 6 ? 2 : 3;
    }

    @Nullable
    public Direction m_272057_() {
        return this.f_271286_;
    }

    public ItemStack m_272278_() {
        return this.f_271119_;
    }
}

