/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockReceiveGameEvent;

public class VibrationListener
implements GameEventListener {
    @VisibleForTesting
    public static final Object2IntMap<GameEvent> f_244457_ = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)Util.m_137469_(new Object2IntOpenHashMap(), p_275179_ -> {
        p_275179_.put((Object)GameEvent.f_157785_, 1);
        p_275179_.put((Object)GameEvent.f_223697_, 2);
        p_275179_.put((Object)GameEvent.f_157815_, 2);
        p_275179_.put((Object)GameEvent.f_157786_, 3);
        p_275179_.put((Object)GameEvent.f_223705_, 4);
        p_275179_.put((Object)GameEvent.f_157770_, 5);
        p_275179_.put((Object)GameEvent.f_238175_, 5);
        p_275179_.put((Object)GameEvent.f_157784_, 6);
        p_275179_.put((Object)GameEvent.f_223710_, 6);
        p_275179_.put((Object)GameEvent.f_157792_, 6);
        p_275179_.put((Object)GameEvent.f_223699_, 6);
        p_275179_.put((Object)GameEvent.f_268533_, 6);
        p_275179_.put((Object)GameEvent.f_157778_, 7);
        p_275179_.put((Object)GameEvent.f_223704_, 7);
        p_275179_.put((Object)GameEvent.f_157776_, 7);
        p_275179_.put((Object)GameEvent.f_268500_, 7);
        p_275179_.put((Object)GameEvent.f_157777_, 8);
        p_275179_.put((Object)GameEvent.f_157806_, 8);
        p_275179_.put((Object)GameEvent.f_223708_, 8);
        p_275179_.put((Object)GameEvent.f_223706_, 8);
        p_275179_.put((Object)GameEvent.f_157811_, 9);
        p_275179_.put((Object)GameEvent.f_157781_, 9);
        p_275179_.put((Object)GameEvent.f_223709_, 9);
        p_275179_.put((Object)GameEvent.f_157793_, 10);
        p_275179_.put((Object)GameEvent.f_223703_, 10);
        p_275179_.put((Object)GameEvent.f_157795_, 10);
        p_275179_.put((Object)GameEvent.f_157804_, 10);
        p_275179_.put((Object)GameEvent.f_157796_, 11);
        p_275179_.put((Object)GameEvent.f_223702_, 11);
        p_275179_.put((Object)GameEvent.f_157791_, 11);
        p_275179_.put((Object)GameEvent.f_157810_, 12);
        p_275179_.put((Object)GameEvent.f_157797_, 12);
        p_275179_.put((Object)GameEvent.f_157769_, 12);
        p_275179_.put((Object)GameEvent.f_223707_, 13);
        p_275179_.put((Object)GameEvent.f_157794_, 13);
        p_275179_.put((Object)GameEvent.f_157816_, 13);
        p_275179_.put((Object)GameEvent.f_157802_, 14);
        p_275179_.put((Object)GameEvent.f_157774_, 14);
        p_275179_.put((Object)GameEvent.f_157775_, 15);
        p_275179_.put((Object)GameEvent.f_157803_, 15);
        p_275179_.put((Object)GameEvent.f_157812_, 15);
        p_275179_.put((Object)GameEvent.f_157772_, 15);
        p_275179_.put((Object)GameEvent.f_223696_, 15);
    })));
    protected final PositionSource f_157887_;
    protected final int f_157888_;
    protected final VibrationListenerConfig f_157889_;
    @Nullable
    protected VibrationInfo f_244354_;
    protected int f_157892_;
    private final VibrationSelector f_244208_;

    public static Codec<VibrationListener> m_223781_(VibrationListenerConfig p_223782_) {
        return RecordCodecBuilder.create(p_248464_ -> p_248464_.group((App)PositionSource.f_157868_.fieldOf("source").forGetter(p_223802_ -> p_223802_.f_157887_), (App)ExtraCodecs.f_144628_.fieldOf("range").forGetter(p_223800_ -> p_223800_.f_157888_), (App)VibrationInfo.f_244481_.optionalFieldOf("event").forGetter(p_248473_ -> Optional.ofNullable(p_248473_.f_244354_)), (App)VibrationSelector.f_244309_.fieldOf("selector").forGetter(p_248461_ -> p_248461_.f_244208_), (App)ExtraCodecs.f_144628_.fieldOf("event_delay").orElse((Object)0).forGetter(p_223794_ -> p_223794_.f_157892_)).apply((Applicative)p_248464_, (p_248468_, p_248469_, p_248470_, p_248471_, p_248472_) -> new VibrationListener((PositionSource)p_248468_, (int)p_248469_, p_223782_, p_248470_.orElse(null), (VibrationSelector)p_248471_, (int)p_248472_)));
    }

    private VibrationListener(PositionSource p_252286_, int p_249404_, VibrationListenerConfig p_251761_, @Nullable VibrationInfo p_250360_, VibrationSelector p_250234_, int p_248651_) {
        this.f_157887_ = p_252286_;
        this.f_157888_ = p_249404_;
        this.f_157889_ = p_251761_;
        this.f_244354_ = p_250360_;
        this.f_157892_ = p_248651_;
        this.f_244208_ = p_250234_;
    }

    public VibrationListener(PositionSource p_248645_, int p_250290_, VibrationListenerConfig p_249414_) {
        this(p_248645_, p_250290_, p_249414_, null, new VibrationSelector(), 0);
    }

    public static int m_245569_(GameEvent p_252168_) {
        return f_244457_.getOrDefault((Object)p_252168_, 0);
    }

    public void m_157898_(Level p_157899_) {
        if (p_157899_ instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)p_157899_;
            if (this.f_244354_ == null) {
                this.f_244208_.m_245156_(serverlevel.m_46467_()).ifPresent(p_248466_ -> {
                    this.f_244354_ = p_248466_;
                    Vec3 vec3 = this.f_244354_.f_243906_();
                    this.f_157892_ = Mth.m_14143_((float)this.f_244354_.f_243776_());
                    serverlevel.m_8767_(new VibrationParticleOption(this.f_157887_, this.f_157892_), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    this.f_157889_.m_214037_();
                    this.f_244208_.m_246080_();
                });
            }
            if (this.f_244354_ != null) {
                --this.f_157892_;
                if (this.f_157892_ <= 0) {
                    this.f_157892_ = 0;
                    this.f_157889_.m_213991_(serverlevel, this, BlockPos.m_274446_((Position)this.f_244354_.f_243906_()), this.f_244354_.f_243709_(), this.f_244354_.m_246794_(serverlevel).orElse(null), this.f_244354_.m_247126_(serverlevel).orElse(null), this.f_244354_.f_243776_());
                    this.f_244354_ = null;
                }
            }
        }
    }

    public PositionSource m_142460_() {
        return this.f_157887_;
    }

    public int m_142078_() {
        return this.f_157888_;
    }

    public boolean m_214068_(ServerLevel p_251930_, GameEvent p_250161_, GameEvent.Context p_251443_, Vec3 p_250045_) {
        if (this.f_244354_ != null) {
            return false;
        }
        if (!this.f_157889_.m_223877_(p_250161_, p_251443_)) {
            return false;
        }
        Optional optional = this.f_157887_.m_142502_((Level)p_251930_);
        if (optional.isEmpty()) {
            return false;
        }
        Vec3 vec3 = (Vec3)optional.get();
        boolean defaultCancel = !this.f_157889_.m_213641_(p_251930_, this, BlockPos.m_274446_((Position)p_250045_), p_250161_, p_251443_);
        net.minecraft.world.entity.Entity entity = p_251443_.f_223711_();
        BlockReceiveGameEvent event = new BlockReceiveGameEvent(org.bukkit.GameEvent.getByKey((NamespacedKey)CraftNamespacedKey.fromMinecraft((ResourceLocation)BuiltInRegistries.f_256726_.m_7981_((Object)p_250161_))), (Block)CraftBlock.at((LevelAccessor)p_251930_, (BlockPos)BlockPos.m_274446_((Position)vec3)), (Entity)(entity == null ? null : entity.getBukkitEntity()));
        event.setCancelled(defaultCancel);
        p_251930_.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (VibrationListener.m_223775_(p_251930_, p_250045_, vec3)) {
            return false;
        }
        this.m_246086_(p_251930_, p_250161_, p_251443_, p_250045_, vec3);
        return true;
    }

    public void m_247672_(ServerLevel p_250726_, GameEvent p_251544_, GameEvent.Context p_250365_, Vec3 p_249607_) {
        this.f_157887_.m_142502_((Level)p_250726_).ifPresent(p_248460_ -> this.m_246086_(p_250726_, p_251544_, p_250365_, p_249607_, (Vec3)p_248460_));
    }

    public void m_246086_(ServerLevel p_250210_, GameEvent p_251063_, GameEvent.Context p_249354_, Vec3 p_250310_, Vec3 p_249553_) {
        this.f_244208_.m_247691_(new VibrationInfo(p_251063_, (float)p_250310_.m_82554_(p_249553_), p_250310_, p_249354_.f_223711_()), p_250210_.m_46467_());
    }

    private static boolean m_223775_(Level p_223776_, Vec3 p_223777_, Vec3 p_223778_) {
        Vec3 vec3 = new Vec3((double)Mth.m_14107_((double)p_223777_.f_82479_) + 0.5, (double)Mth.m_14107_((double)p_223777_.f_82480_) + 0.5, (double)Mth.m_14107_((double)p_223777_.f_82481_) + 0.5);
        Vec3 vec31 = new Vec3((double)Mth.m_14107_((double)p_223778_.f_82479_) + 0.5, (double)Mth.m_14107_((double)p_223778_.f_82480_) + 0.5, (double)Mth.m_14107_((double)p_223778_.f_82481_) + 0.5);
        for (Direction direction : Direction.values()) {
            Vec3 vec32 = vec3.m_231075_(direction, (double)1.0E-5f);
            if (p_223776_.m_151353_(new ClipBlockStateContext(vec32, vec31, p_223780_ -> p_223780_.m_204336_(BlockTags.f_144272_))).m_6662_() == HitResult.Type.BLOCK) continue;
            return false;
        }
        return true;
    }

    public static interface VibrationListenerConfig {
        default public TagKey<GameEvent> m_213929_() {
            return GameEventTags.f_144302_;
        }

        default public boolean m_213734_() {
            return false;
        }

        default public boolean m_223877_(GameEvent p_223878_, GameEvent.Context p_223879_) {
            if (!p_223878_.m_204528_(this.m_213929_())) {
                return false;
            }
            net.minecraft.world.entity.Entity entity = p_223879_.f_223711_();
            if (entity != null) {
                if (entity.m_5833_()) {
                    return false;
                }
                if (entity.m_20161_() && p_223878_.m_204528_(GameEventTags.f_144303_)) {
                    if (this.m_213734_() && entity instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)entity;
                        CriteriaTriggers.f_215658_.m_222618_(serverplayer);
                    }
                    return false;
                }
                if (entity.m_213854_()) {
                    return false;
                }
            }
            if (p_223879_.f_223712_() != null) {
                return !p_223879_.f_223712_().m_204336_(BlockTags.f_215836_);
            }
            return true;
        }

        public boolean m_213641_(ServerLevel var1, GameEventListener var2, BlockPos var3, GameEvent var4, GameEvent.Context var5);

        public void m_213991_(ServerLevel var1, GameEventListener var2, BlockPos var3, GameEvent var4, @Nullable net.minecraft.world.entity.Entity var5, @Nullable net.minecraft.world.entity.Entity var6, float var7);

        default public void m_214037_() {
        }
    }
}

