/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class TreeFeature
extends Feature<TreeConfiguration> {
    private static final int f_160509_ = 19;

    public TreeFeature(Codec<TreeConfiguration> p_67201_) {
        super(p_67201_);
    }

    private static boolean m_67277_(LevelSimulatedReader p_67278_, BlockPos p_67279_) {
        return p_67278_.m_7433_(p_67279_, p_225299_ -> p_225299_.m_60713_(Blocks.f_50191_));
    }

    public static boolean m_67282_(LevelSimulatedReader p_67283_, BlockPos p_67284_) {
        return p_67283_.m_7433_(p_67284_, p_225297_ -> p_225297_.m_60713_(Blocks.f_49990_));
    }

    public static boolean m_67267_(LevelSimulatedReader p_67268_, BlockPos p_67269_) {
        return p_67268_.m_7433_(p_67269_, p_225295_ -> p_225295_.m_60795_() || p_225295_.m_204336_(BlockTags.f_13035_));
    }

    private static boolean m_67288_(LevelSimulatedReader p_67289_, BlockPos p_67290_) {
        return p_67289_.m_7433_(p_67290_, p_225293_ -> {
            Material material = p_225293_.m_60767_();
            return material == Material.f_76302_ || material == Material.f_76304_ || material == Material.f_76303_;
        });
    }

    private static void m_67256_(LevelWriter p_67257_, BlockPos p_67258_, BlockState p_67259_) {
        p_67257_.m_7731_(p_67258_, p_67259_, 19);
    }

    public static boolean m_67272_(LevelSimulatedReader p_67273_, BlockPos p_67274_) {
        return TreeFeature.m_67267_(p_67273_, p_67274_) || TreeFeature.m_67288_(p_67273_, p_67274_) || TreeFeature.m_67282_(p_67273_, p_67274_);
    }

    private boolean m_225257_(WorldGenLevel p_225258_, RandomSource p_225259_, BlockPos p_225260_, BiConsumer<BlockPos, BlockState> p_225261_, BiConsumer<BlockPos, BlockState> p_225262_, FoliagePlacer.FoliageSetter p_273670_, TreeConfiguration p_225264_) {
        int i = p_225264_.f_68190_.m_226153_(p_225259_);
        int j = p_225264_.f_68189_.m_214116_(p_225259_, i, p_225264_);
        int k = i - j;
        int l = p_225264_.f_68189_.m_214117_(p_225259_, k);
        BlockPos blockpos = p_225264_.f_225455_.map(p_225286_ -> p_225286_.m_225891_(p_225260_, p_225259_)).orElse(p_225260_);
        int i1 = Math.min(p_225260_.m_123342_(), blockpos.m_123342_());
        int j1 = Math.max(p_225260_.m_123342_(), blockpos.m_123342_()) + i + 1;
        if (i1 >= p_225258_.m_141937_() + 1 && j1 <= p_225258_.m_151558_()) {
            OptionalInt optionalint = p_225264_.f_68191_.m_68295_();
            int k1 = this.m_67215_((LevelSimulatedReader)p_225258_, i, blockpos, p_225264_);
            if (k1 >= i || !optionalint.isEmpty() && k1 >= optionalint.getAsInt()) {
                if (p_225264_.f_225455_.isPresent() && !p_225264_.f_225455_.get().m_213684_((LevelSimulatedReader)p_225258_, p_225261_, p_225259_, p_225260_, blockpos, p_225264_)) {
                    return false;
                }
                List<FoliagePlacer.FoliageAttachment> list = p_225264_.f_68190_.m_213934_((LevelSimulatedReader)p_225258_, p_225262_, p_225259_, k1, blockpos, p_225264_);
                list.forEach(p_272582_ -> p_272575_.f_68189_.m_271927_((LevelSimulatedReader)p_225258_, p_273670_, p_225259_, p_225264_, k1, p_272582_, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int m_67215_(LevelSimulatedReader p_67216_, int p_67217_, BlockPos p_67218_, TreeConfiguration p_67219_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= p_67217_ + 1; ++i) {
            int j = p_67219_.f_68191_.m_6133_(p_67217_, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutableblockpos.m_122154_((Vec3i)p_67218_, k, i, l);
                    if (p_67219_.f_68190_.m_226184_(p_67216_, (BlockPos)blockpos$mutableblockpos) && (p_67219_.f_68193_ || !TreeFeature.m_67277_(p_67216_, (BlockPos)blockpos$mutableblockpos))) continue;
                    return i - 2;
                }
            }
        }
        return p_67217_;
    }

    @Override
    protected void m_5974_(LevelWriter p_67221_, BlockPos p_67222_, BlockState p_67223_) {
        TreeFeature.m_67256_(p_67221_, p_67222_, p_67223_);
    }

    @Override
    public final boolean m_142674_(FeaturePlaceContext<TreeConfiguration> p_160530_) {
        final WorldGenLevel worldgenlevel = p_160530_.m_159774_();
        RandomSource randomsource = p_160530_.m_225041_();
        BlockPos blockpos = p_160530_.m_159777_();
        TreeConfiguration treeconfiguration = (TreeConfiguration)p_160530_.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.m_7949_());
            worldgenlevel.m_7731_(p_160555_, p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.m_7949_());
            worldgenlevel.m_7731_(p_160548_, p_160549_, 19);
        };
        FoliagePlacer.FoliageSetter foliageplacer$foliagesetter = new FoliagePlacer.FoliageSetter(){

            public void m_271838_(BlockPos p_272825_, BlockState p_273311_) {
                set2.add(p_272825_.m_7949_());
                worldgenlevel.m_7731_(p_272825_, p_273311_, 19);
            }

            public boolean m_271808_(BlockPos p_272999_) {
                return set2.contains(p_272999_);
            }
        };
        BiConsumer<BlockPos, BlockState> biconsumer2 = (p_160543_, p_160544_) -> {
            set3.add(p_160543_.m_7949_());
            worldgenlevel.m_7731_(p_160543_, p_160544_, 19);
        };
        boolean flag = this.m_225257_(worldgenlevel, randomsource, blockpos, biconsumer, biconsumer1, foliageplacer$foliagesetter, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.f_68187_.isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)worldgenlevel, biconsumer2, randomsource, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.f_68187_.forEach(p_225282_ -> p_225282_.m_214187_(treedecorator$context));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2, (Iterable)set3)).map(p_225270_ -> {
                DiscreteVoxelShape discretevoxelshape = TreeFeature.m_225251_((LevelAccessor)worldgenlevel, p_225270_, set1, set3, set);
                StructureTemplate.m_74510_((LevelAccessor)worldgenlevel, 3, discretevoxelshape, p_225270_.m_162395_(), p_225270_.m_162396_(), p_225270_.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape m_225251_(LevelAccessor p_225252_, BoundingBox p_225253_, Set<BlockPos> p_225254_, Set<BlockPos> p_225255_, Set<BlockPos> p_225256_) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(p_225253_.m_71056_(), p_225253_.m_71057_(), p_225253_.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList((Iterable)Sets.union(p_225255_, p_225256_))) {
            if (!p_225253_.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - p_225253_.m_162395_(), blockpos.m_123342_() - p_225253_.m_162396_(), blockpos.m_123343_() - p_225253_.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_225254_)) {
            if (p_225253_.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - p_225253_.m_162395_(), blockpos1.m_123342_() - p_225253_.m_162396_(), blockpos1.m_123343_() - p_225253_.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                if (p_225254_.contains(blockpos$mutableblockpos) || !(blockstate = p_225252_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.m_7949_());
                TreeFeature.m_67256_((LevelWriter)((Object)p_225252_), (BlockPos)blockpos$mutableblockpos, (BlockState)((Object)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, Integer.valueOf(1))));
                if (!p_225253_.m_71051_((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_225253_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_225253_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_225253_.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (p_225253_.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - p_225253_.m_162395_(), blockpos2.m_123342_() - p_225253_.m_162396_(), blockpos2.m_123343_() - p_225253_.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_225252_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)((Object)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, Integer.valueOf(l + 1)));
                    TreeFeature.m_67256_((LevelWriter)((Object)p_225252_), (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (p_225253_.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_225253_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_225253_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_225253_.m_162398_());
                    }
                    set1.add(blockpos$mutableblockpos.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }
}

