/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.DummySavedData;
import org.slf4j.Logger;

public class DimensionDataStorage {
    private static final Logger f_78143_ = LogUtils.getLogger();
    public final Map<String, SavedData> f_78144_ = Maps.newHashMap();
    private final DataFixer f_78145_;
    private final File f_78146_;

    public DimensionDataStorage(File p_78149_, DataFixer p_78150_) {
        this.f_78145_ = p_78150_;
        this.f_78146_ = p_78149_;
    }

    private File m_78156_(String p_78157_) {
        return new File(this.f_78146_, p_78157_ + ".dat");
    }

    public <T extends SavedData> T m_164861_(Function<CompoundTag, T> p_164862_, Supplier<T> p_164863_, String p_164864_) {
        T t = this.m_164858_(p_164862_, p_164864_);
        if (t != null) {
            return t;
        }
        SavedData t1 = (SavedData)p_164863_.get();
        this.m_164855_(p_164864_, t1);
        return (T)t1;
    }

    @Nullable
    public <T extends SavedData> T m_164858_(Function<CompoundTag, T> p_164859_, String p_164860_) {
        Object saveddata = this.f_78144_.get(p_164860_);
        if (saveddata == DummySavedData.DUMMY) {
            return null;
        }
        if (saveddata == null && !this.f_78144_.containsKey(p_164860_)) {
            saveddata = this.m_164868_(p_164859_, p_164860_);
            this.f_78144_.put(p_164860_, (SavedData)saveddata);
        } else if (saveddata == null) {
            this.f_78144_.put(p_164860_, (SavedData)DummySavedData.DUMMY);
            return null;
        }
        return (T)saveddata;
    }

    @Nullable
    private <T extends SavedData> T m_164868_(Function<CompoundTag, T> p_164869_, String p_164870_) {
        try {
            File file1 = this.m_78156_(p_164870_);
            if (file1.exists()) {
                CompoundTag compoundtag = this.m_78158_(p_164870_, SharedConstants.m_183709_().m_183476_().m_193006_());
                return (T)((SavedData)p_164869_.apply(compoundtag.m_128469_("data")));
            }
        }
        catch (Exception exception) {
            f_78143_.error("Error loading saved data: {}", (Object)p_164870_, (Object)exception);
        }
        return (T)((SavedData)null);
    }

    public void m_164855_(String p_164856_, SavedData p_164857_) {
        this.f_78144_.put(p_164856_, p_164857_);
    }

    public CompoundTag m_78158_(String p_78159_, int p_78160_) throws IOException {
        CompoundTag compoundtag1;
        File file1 = this.m_78156_(p_78159_);
        try (FileInputStream fileinputstream = new FileInputStream(file1);
             PushbackInputStream pushbackinputstream = new PushbackInputStream(fileinputstream, 2);){
            CompoundTag compoundtag;
            if (this.m_78154_(pushbackinputstream)) {
                compoundtag = NbtIo.m_128939_(pushbackinputstream);
            } else {
                try (DataInputStream datainputstream = new DataInputStream(pushbackinputstream);){
                    compoundtag = NbtIo.m_128928_(datainputstream);
                }
            }
            int i = NbtUtils.m_264487_((CompoundTag)compoundtag, (int)1343);
            compoundtag1 = DataFixTypes.SAVED_DATA.m_264226_(this.f_78145_, compoundtag, i, p_78160_);
        }
        return compoundtag1;
    }

    private boolean m_78154_(PushbackInputStream p_78155_) throws IOException {
        int j;
        byte[] abyte = new byte[2];
        boolean flag = false;
        int i = p_78155_.read(abyte, 0, 2);
        if (i == 2 && (j = (abyte[1] & 0xFF) << 8 | abyte[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i != 0) {
            p_78155_.unread(abyte, 0, i);
        }
        return flag;
    }

    public void m_78151_() {
        this.f_78144_.forEach((p_164866_, p_164867_) -> {
            if (p_164867_ != null) {
                p_164867_.m_77757_(this.m_78156_((String)p_164866_));
            }
        });
    }
}

