/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.google.common.base.Throwables;
import com.mohistmc.command.BackupWorldCommand;
import com.mohistmc.command.DumpCommand;
import com.mohistmc.command.GetPluginListCommand;
import com.mohistmc.command.MohistCommand;
import com.mohistmc.command.PluginCommand;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class MohistConfig {
    private static final List<String> HEADER = Arrays.asList("This is the main configuration file for Mohist.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\nFor a reference for any variable inside this file, check out the Mohist wiki at\nhttps://wiki.mohistmc.com/\n\nIf you need help with the configuration or have any questions related to Spigot,\njoin us at the Discord or drop by our forums and leave a post.\n\nDiscord: https://discord.gg/mohistmc\nForums: https://mohistmc.com/\nForums (CN): https://mohistmc.cn/\n\n".split("\\n"));
    public static YamlConfiguration config;
    static int version;
    static Map<String, Command> commands;
    private static File CONFIG_FILE;
    public static File mohistyml;
    public static YamlConfiguration yml;
    public static boolean show_logo;
    public static String mohist_lang;
    public static String mohist_vanilla_lang;
    public static boolean check_update;

    public static void init(File configFile) {
        CONFIG_FILE = configFile;
        config = new YamlConfiguration();
        try {
            config.load(CONFIG_FILE);
        }
        catch (IOException | InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load mohist.yml, please correct your syntax errors", ex);
            Throwables.throwIfUnchecked((Throwable)ex);
        }
        config.options().setHeader((List)HEADER);
        config.options().copyDefaults(true);
        commands = new HashMap<String, Command>();
        commands.put("mohist", new MohistCommand("mohist"));
        commands.put("getpluginlist", new GetPluginListCommand("getpluginlist"));
        commands.put("dump", new DumpCommand("dump"));
        commands.put("plugin", new PluginCommand("plugin"));
        commands.put("backupworld", new BackupWorldCommand("backupworld"));
        version = MohistConfig.getInt("config-version", 1);
        MohistConfig.set("config-version", 1);
        MohistConfig.readConfig();
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.getServer().server.getCommandMap().register(entry.getKey(), "Mohist", entry.getValue());
        }
    }

    static void readConfig() {
        for (Method method : MohistConfig.class.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwables.throwIfUnchecked((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    private static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List<?> getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, def);
        return config.getString(path, config.getString(path));
    }

    private static double getDouble(String path, double def) {
        config.addDefault(path, def);
        return config.getDouble(path, config.getDouble(path));
    }

    private static void mohist() {
        show_logo = MohistConfig.getBoolean("mohist.show_logo", true);
        mohist_lang = MohistConfig.getString("mohist.lang", "xx_XX");
        mohist_vanilla_lang = MohistConfig.getString("mohist.vanilla_lang", "en_us");
        check_update = MohistConfig.getBoolean("mohist.check_update", true);
    }

    static {
        mohistyml = new File("mohist-config", "mohist.yml");
        yml = YamlConfiguration.loadConfiguration(mohistyml);
    }
}

