/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.pluginfix;

import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class ScriptBlockPlus {
    public static String version = "4.1.82.Final";
    private static final String PROP_VERSION = ".version";
    private static final String PROP_BUILD_DATE = ".buildDate";
    private static final String PROP_COMMIT_DATE = ".commitDate";
    private static final String PROP_SHORT_COMMIT_HASH = ".shortCommitHash";
    private static final String PROP_LONG_COMMIT_HASH = ".longCommitHash";
    private static final String PROP_REPO_STATUS = ".repoStatus";
    private final String artifactId;
    private final String artifactVersion;
    private final long buildTimeMillis;
    private final long commitTimeMillis;
    private final String shortCommitHash;
    private final String longCommitHash;
    private final String repositoryStatus;

    public static Map<String, ScriptBlockPlus> identify() {
        TreeMap<String, ScriptBlockPlus> versions = new TreeMap<String, ScriptBlockPlus>();
        ScriptBlockPlus scriptBlockPlus = new ScriptBlockPlus("netty-common", "4.1.82.Final", ScriptBlockPlus.parseIso8601("2022-09-13 12\\:57\\:54 -0700"), ScriptBlockPlus.parseIso8601("2022-09-13 19\\:12\\:20 +0000"), "4779963514", "47799635143d7a11b56c4a4e9a1e65ca221d28ca", "clean");
        versions.put("netty-common", scriptBlockPlus);
        return versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ScriptBlockPlus> identify(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = PlatformDependent.getContextClassLoader();
        }
        Properties props = new Properties();
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/io.netty.versions.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream inputStream = url.openStream();
                try {
                    props.load(inputStream);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception resources) {
            // empty catch block
        }
        HashSet<String> artifactIds = new HashSet<String>();
        for (Object e : props.keySet()) {
            String artifactId;
            String k = (String)e;
            int dotIndex = k.indexOf(46);
            if (dotIndex <= 0 || !props.containsKey((artifactId = k.substring(0, dotIndex)) + PROP_VERSION) || !props.containsKey(artifactId + PROP_BUILD_DATE) || !props.containsKey(artifactId + PROP_COMMIT_DATE) || !props.containsKey(artifactId + PROP_SHORT_COMMIT_HASH) || !props.containsKey(artifactId + PROP_LONG_COMMIT_HASH) || !props.containsKey(artifactId + PROP_REPO_STATUS)) continue;
            artifactIds.add(artifactId);
        }
        TreeMap<String, ScriptBlockPlus> versions = new TreeMap<String, ScriptBlockPlus>();
        for (String artifactId : artifactIds) {
            versions.put(artifactId, new ScriptBlockPlus(artifactId, props.getProperty(artifactId + PROP_VERSION), ScriptBlockPlus.parseIso8601(props.getProperty(artifactId + PROP_BUILD_DATE)), ScriptBlockPlus.parseIso8601(props.getProperty(artifactId + PROP_COMMIT_DATE)), props.getProperty(artifactId + PROP_SHORT_COMMIT_HASH), props.getProperty(artifactId + PROP_LONG_COMMIT_HASH), props.getProperty(artifactId + PROP_REPO_STATUS)));
        }
        return versions;
    }

    private static long parseIso8601(String value) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z").parse(value).getTime();
        }
        catch (ParseException ignored) {
            return 0L;
        }
    }

    public static void main(String[] args) {
        for (ScriptBlockPlus v : ScriptBlockPlus.identify().values()) {
            System.err.println(v);
        }
    }

    private ScriptBlockPlus(String artifactId, String artifactVersion, long buildTimeMillis, long commitTimeMillis, String shortCommitHash, String longCommitHash, String repositoryStatus) {
        this.artifactId = artifactId;
        this.artifactVersion = artifactVersion;
        this.buildTimeMillis = buildTimeMillis;
        this.commitTimeMillis = commitTimeMillis;
        this.shortCommitHash = shortCommitHash;
        this.longCommitHash = longCommitHash;
        this.repositoryStatus = repositoryStatus;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String artifactVersion() {
        return this.artifactVersion;
    }

    public long buildTimeMillis() {
        return this.buildTimeMillis;
    }

    public long commitTimeMillis() {
        return this.commitTimeMillis;
    }

    public String shortCommitHash() {
        return this.shortCommitHash;
    }

    public String longCommitHash() {
        return this.longCommitHash;
    }

    public String repositoryStatus() {
        return this.repositoryStatus;
    }

    public String toString() {
        return this.artifactId + "-" + this.artifactVersion + "." + this.shortCommitHash + (String)("clean".equals(this.repositoryStatus) ? "" : " (repository: " + this.repositoryStatus + ")");
    }
}

