/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.eventhandler.dispatcher;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;

public class WorldEventDispatcher {
    @SubscribeEvent(receiveCanceled=true)
    public void onWorldLoadEvent(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel handle = (ServerLevel)levelAccessor;
            CraftWorld craftWorld = handle.getWorld();
            Bukkit.getPluginManager().callEvent(new WorldLoadEvent(craftWorld));
            Bukkit.getPluginManager().callEvent(new WorldInitEvent(craftWorld));
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onWorldSaveEvent(LevelEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel handle = (ServerLevel)levelAccessor;
            WorldSaveEvent save = new WorldSaveEvent(handle.getWorld());
            Bukkit.getPluginManager().callEvent(save);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel() instanceof ServerLevel) {
            ((CraftServer)Bukkit.getServer()).removeWorld((ServerLevel)event.getLevel());
        }
    }
}

