/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.forge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.MohistMC;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.dynamicenum.MohistDynamEnum;
import com.mohistmc.entity.MohistModsEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_19_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R3.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_19_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_19_R3.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftSpawnCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.Villager;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ForgeInjectBukkit {
    public static BiMap<ResourceKey<LevelStem>, World.Environment> environment = HashBiMap.create((Map)ImmutableMap.builder().put((Object)LevelStem.f_63971_, (Object)World.Environment.NORMAL).put((Object)LevelStem.f_63972_, (Object)World.Environment.NETHER).put((Object)LevelStem.f_63973_, (Object)World.Environment.THE_END).build());
    public static Map<Villager.Profession, ResourceLocation> profession = new HashMap<Villager.Profession, ResourceLocation>();
    public static Map<Attribute, ResourceLocation> attributemap = new HashMap<Attribute, ResourceLocation>();
    public static Map<StatType<?>, Statistic> statisticMap = new HashMap();
    public static Map<net.minecraft.world.level.biome.Biome, Biome> biomeBiomeMap = new HashMap<net.minecraft.world.level.biome.Biome, Biome>();

    public static void init() {
        ForgeInjectBukkit.addEnumMaterialInItems();
        ForgeInjectBukkit.addEnumMaterialsInBlocks();
        ForgeInjectBukkit.addEnumBiome();
        ForgeInjectBukkit.addEnumEnchantment();
        ForgeInjectBukkit.addEnumEffectAndPotion();
        ForgeInjectBukkit.addFluid();
        ForgeInjectBukkit.addEnumEntity();
        ForgeInjectBukkit.addEnumVillagerProfession();
        ForgeInjectBukkit.addEnumParticle();
        ForgeInjectBukkit.addStatistic();
        ForgeInjectBukkit.loadSpawnCategory();
    }

    public static void addEnumMaterialInItems() {
        IForgeRegistry<Item> registry = ForgeRegistries.ITEMS;
        for (Item item : registry) {
            ResourceLocation resourceLocation = registry.getKey(item);
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String materialName = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int id = Item.m_41393_((Item)item);
            Material material = Material.addMaterial(materialName, id, item.getMaxStackSize(new ItemStack((ItemLike)item)), false, resourceLocation);
            CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
            CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
            MohistMC.LOGGER.debug("Save-ITEM: " + material.name() + " - " + materialName);
        }
    }

    public static void addEnumMaterialsInBlocks() {
        IForgeRegistry<Block> registry = ForgeRegistries.BLOCKS;
        for (Block block : registry) {
            ResourceLocation resourceLocation = registry.getKey(block);
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String materialName = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int id = Item.m_41393_((Item)block.m_5456_());
            Item item = Item.m_41445_((int)id);
            Material material = Material.addMaterial(materialName, id, item.getMaxStackSize(new ItemStack((ItemLike)item)), true, resourceLocation);
            CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
            CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
            MohistMC.LOGGER.debug("Save-BLOCK:" + material.name() + " - " + materialName);
        }
    }

    public static void addEnumEnchantment() {
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            org.bukkit.enchantments.Enchantment.registerEnchantment(new CraftEnchantment(enchantment));
        }
        org.bukkit.enchantments.Enchantment.stopAcceptingRegistrations();
    }

    public static void addEnumEffectAndPotion() {
        int maxId = ForgeRegistries.MOB_EFFECTS.getValues().stream().mapToInt(MobEffect::m_19459_).max().orElse(0);
        PotionEffectType.byId = new PotionEffectType[maxId + 1];
        for (MobEffect effect : ForgeRegistries.MOB_EFFECTS) {
            CraftPotionEffectType pet = new CraftPotionEffectType(effect);
            PotionEffectType.registerPotionEffectType(pet);
        }
        PotionEffectType.stopAcceptingRegistrations();
        IForgeRegistry<Potion> registry = ForgeRegistries.POTIONS;
        for (Potion potion : ForgeRegistries.POTIONS) {
            ResourceLocation resourceLocation = registry.getKey(potion);
            if (CraftPotionUtil.toBukkit(resourceLocation.toString()).getType() != PotionType.UNCRAFTABLE || potion == Potions.f_43598_) continue;
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            MobEffectInstance effectInstance = potion.m_43488_().isEmpty() ? null : (MobEffectInstance)potion.m_43488_().get(0);
            PotionType potionType = (PotionType)((Object)MohistDynamEnum.addEnum(PotionType.class, (String)name, Arrays.asList(PotionEffectType.class, Boolean.TYPE, Boolean.TYPE), Arrays.asList(effectInstance == null ? null : PotionEffectType.getById(MobEffect.m_19459_((MobEffect)effectInstance.m_19544_())), false, false)));
            if (potionType == null) continue;
            MohistMC.LOGGER.debug("Save-PotionType:" + name + " - " + potionType.name());
        }
    }

    public static void addEnumParticle() {
        IForgeRegistry<ParticleType<?>> registry = ForgeRegistries.PARTICLE_TYPES;
        for (ParticleType particleType : ForgeRegistries.PARTICLE_TYPES) {
            Particle particle;
            ResourceLocation resourceLocation = registry.getKey(particleType);
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            if (resourceLocation.m_135827_().equals("minecraft") || (particle = (Particle)((Object)MohistDynamEnum.addEnum(Particle.class, (String)name))) == null) continue;
            CraftParticle.putParticles(particle, resourceLocation);
            MohistMC.LOGGER.debug("Save-ParticleType:" + name + " - " + particle.name());
        }
    }

    public static void addEnumBiome() {
        ArrayList<String> map = new ArrayList<String>();
        IForgeRegistry<net.minecraft.world.level.biome.Biome> registry = ForgeRegistries.BIOMES;
        for (net.minecraft.world.level.biome.Biome biome : registry) {
            ResourceLocation resourceLocation = registry.getKey(biome);
            String biomeName = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation) || map.contains(biomeName)) continue;
            map.add(biomeName);
            Biome biomeCB = (Biome)MohistDynamEnum.addEnum(Biome.class, (String)biomeName);
            biomeBiomeMap.put(biome, biomeCB);
            MohistMC.LOGGER.debug("Save-BIOME:" + biomeCB.name() + " - " + biomeName);
        }
        map.clear();
    }

    public static void addEnumEnvironment() {
        int i = World.Environment.values().length;
        Registry registry = ServerAPI.getNMSServer().m_206579_().m_175515_(Registries.f_256862_);
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            World.Environment environment1 = (World.Environment)((Object)environment.get((Object)key));
            if (environment1 != null) continue;
            String name = ForgeInjectBukkit.normalizeName(key.m_135782_().toString());
            int id = i - 1;
            environment1 = (World.Environment)((Object)MohistDynamEnum.addEnum(World.Environment.class, (String)name, List.of(Integer.TYPE), List.of(Integer.valueOf(id))));
            environment.put((Object)key, (Object)environment1);
            MohistMC.LOGGER.debug("Registered forge DimensionType as environment {}", (Object)environment1);
            ++i;
        }
    }

    public static WorldType addEnumWorldType(String name) {
        WorldType worldType = (WorldType)((Object)MohistDynamEnum.addEnum(WorldType.class, (String)name, List.of(String.class), List.of(name)));
        Map BY_NAME = (Map)ObfuscationReflectionHelper.getPrivateValue(WorldType.class, null, (String)"BY_NAME");
        BY_NAME.put(name.toUpperCase(), worldType);
        return worldType;
    }

    public static void addEnumEntity() {
        IForgeRegistry<net.minecraft.world.entity.EntityType<?>> registry = ForgeRegistries.ENTITY_TYPES;
        for (net.minecraft.world.entity.EntityType entityType : registry) {
            ResourceLocation resourceLocation = registry.getKey(entityType);
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String entityType2 = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            int typeId = entityType2.hashCode();
            EntityType bukkitType = (EntityType)MohistDynamEnum.addEnum(EntityType.class, (String)entityType2, List.of(String.class, Class.class, Integer.TYPE, Boolean.TYPE), List.of(entityType2.toLowerCase(), MohistModsEntity.class, Integer.valueOf(typeId), Boolean.valueOf(false)));
            EntityType.NAME_MAP.put(entityType2.toLowerCase(), bukkitType);
            EntityType.ID_MAP.put((short)typeId, bukkitType);
            ServerAPI.entityTypeMap.put(entityType, entityType2);
        }
    }

    public static void addEnumVillagerProfession() {
        IForgeRegistry<VillagerProfession> registry = ForgeRegistries.VILLAGER_PROFESSIONS;
        for (VillagerProfession villagerProfession : registry) {
            ResourceLocation resourceLocation = registry.getKey(villagerProfession);
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.toString());
            Villager.Profession vp = (Villager.Profession)MohistDynamEnum.addEnum(Villager.Profession.class, (String)name);
            profession.put(vp, resourceLocation);
            MohistMC.LOGGER.debug("Registered forge VillagerProfession as Profession {}", (Object)vp.name());
        }
    }

    public static void addEnumAttribute() {
        IForgeRegistry<net.minecraft.world.entity.ai.attributes.Attribute> registry = ForgeRegistries.ATTRIBUTES;
        for (net.minecraft.world.entity.ai.attributes.Attribute attribute : registry) {
            ResourceLocation resourceLocation = registry.getKey(attribute);
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.m_135815_());
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            Attribute ab = (Attribute)MohistDynamEnum.addEnum(Attribute.class, (String)name, List.of(String.class), List.of());
            attributemap.put(ab, resourceLocation);
            MohistMC.LOGGER.debug("Registered forge Attribute as Attribute(Bukkit) {}", (Object)ab.name());
        }
    }

    public static void addFluid() {
        IForgeRegistry<Fluid> registry = ForgeRegistries.FLUIDS;
        for (Fluid fluidType : registry) {
            ResourceLocation resourceLocation = registry.getKey(fluidType);
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.m_135815_());
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            org.bukkit.Fluid fluid = (org.bukkit.Fluid)MohistDynamEnum.addEnum(org.bukkit.Fluid.class, (String)name);
            CraftMagicNumbers.FLUIDTYPE_FLUID.put((Object)fluidType, (Object)fluid);
            MohistMC.LOGGER.debug("Registered forge Fluid as Fluid(Bukkit) {}", (Object)fluid.name());
        }
    }

    public static void addStatistic() {
        IForgeRegistry<StatType<?>> registry = ForgeRegistries.STAT_TYPES;
        for (StatType statType : registry) {
            ResourceLocation resourceLocation = registry.getKey(statType);
            String name = ForgeInjectBukkit.normalizeName(resourceLocation.m_135815_());
            if (ForgeInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            Statistic statistic = (Statistic)MohistDynamEnum.addEnum(Statistic.class, (String)name);
            statisticMap.put(statType, statistic);
            MohistMC.LOGGER.debug("Registered forge StatType as Statistic(Bukkit) {}", (Object)statistic.name());
        }
    }

    private static void loadSpawnCategory() {
        for (MobCategory category : MobCategory.values()) {
            try {
                CraftSpawnCategory.toBukkit(category);
            }
            catch (Exception e) {
                String name = category.name();
                SpawnCategory spawnCategory = (SpawnCategory)((Object)MohistDynamEnum.addEnum(SpawnCategory.class, (String)name));
                MohistMC.LOGGER.debug("Registered forge MobCategory as SpawnCategory(Bukkit) {}", (Object)spawnCategory);
            }
        }
    }

    public static String normalizeName(String name) {
        return name.toUpperCase(Locale.ENGLISH).replaceAll("(:|\\s)", "_").replaceAll("\\W", "");
    }

    public static boolean isMINECRAFT(ResourceLocation resourceLocation) {
        return resourceLocation.m_135827_().equals("minecraft");
    }
}

