/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.inventory;

import com.mohistmc.inventory.CraftCustomInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockEntityState;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class InventoryOwner {
    public static InventoryHolder get(BlockEntity te) {
        return InventoryOwner.get(te.m_58904_(), te.m_58899_());
    }

    public static InventoryHolder get(Container inventory) {
        try {
            return inventory.getOwner();
        }
        catch (AbstractMethodError e) {
            InventoryHolder inventoryHolder;
            if (inventory instanceof BlockEntity) {
                BlockEntity blockEntity = (BlockEntity)inventory;
                inventoryHolder = InventoryOwner.get(blockEntity);
            } else {
                inventoryHolder = null;
            }
            return inventoryHolder;
        }
    }

    public static InventoryHolder get(Level world, BlockPos pos) {
        CraftBlockEntityState blockEntityState;
        Object te;
        if (world == null) {
            return null;
        }
        Block block = world.getWorld().getBlockAt(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        if (block == null) {
            return null;
        }
        BlockState state = block.getState();
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)((Object)state);
        }
        if (state instanceof CraftBlockEntityState && (te = (blockEntityState = (CraftBlockEntityState)state).getTileEntity()) instanceof Container) {
            Container container = (Container)te;
            return new CraftCustomInventory(container);
        }
        return null;
    }

    @Nullable
    public static InventoryHolder get(IItemHandler handler) {
        if (handler == null) {
            return null;
        }
        if (handler instanceof ItemStackHandler) {
            return new CraftCustomInventory((ItemStackHandler)handler);
        }
        if (handler instanceof SlotItemHandler) {
            return new CraftCustomInventory(((SlotItemHandler)((Object)handler)).f_40218_);
        }
        if (handler instanceof InvWrapper) {
            return new CraftCustomInventory(((InvWrapper)handler).getInv());
        }
        if (handler instanceof SidedInvWrapper) {
            return new CraftCustomInventory((Container)((SidedInvWrapper)handler).getInv());
        }
        if (handler instanceof PlayerInvWrapper) {
            IItemHandlerModifiable[] piw;
            for (IItemHandlerModifiable itemHandler : piw = (IItemHandlerModifiable[])ObfuscationReflectionHelper.getPrivateValue(CombinedInvWrapper.class, (Object)((PlayerInvWrapper)handler), (String)"itemHandler")) {
                if (itemHandler instanceof PlayerMainInvWrapper) {
                    return new CraftCustomInventory(((PlayerMainInvWrapper)itemHandler).getInventoryPlayer());
                }
                if (!(itemHandler instanceof PlayerArmorInvWrapper)) continue;
                return new CraftCustomInventory(((PlayerArmorInvWrapper)itemHandler).getInventoryPlayer());
            }
        }
        return null;
    }

    @Nullable
    public static Inventory inventoryFromForge(IItemHandler handler) {
        InventoryHolder holder = InventoryOwner.get(handler);
        return holder != null ? holder.getInventory() : null;
    }
}

