/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import com.mohistmc.MohistMC;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void zipFolder(Path sourceFolderPath, Path zipPath) throws Exception {
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));
             Stream<Path> paths = Files.walk(sourceFolderPath, new FileVisitOption[0]);){
            paths.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(sourceFolderPath.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    MohistMC.LOGGER.error((Object)e);
                }
            });
        }
    }
}

