/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CreativeModeTabEvent
extends Event
implements IModBusEvent {
    private static final List<Object> DEFAULT_AFTER_ENTRIES = List.of(CreativeModeTabs.f_256731_);

    @ApiStatus.Internal
    public CreativeModeTabEvent() {
    }

    public static final class BuildContents
    extends CreativeModeTabEvent
    implements CreativeModeTab.Output {
        private final CreativeModeTab tab;
        private final CreativeModeTab.ItemDisplayParameters parameters;
        private final MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries;

        @ApiStatus.Internal
        public BuildContents(CreativeModeTab tab, CreativeModeTab.ItemDisplayParameters parameters, MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries) {
            this.tab = tab;
            this.parameters = parameters;
            this.entries = entries;
        }

        public CreativeModeTab getTab() {
            return this.tab;
        }

        public FeatureFlagSet getFlags() {
            return this.parameters.f_268709_();
        }

        public CreativeModeTab.ItemDisplayParameters getParameters() {
            return this.parameters;
        }

        public boolean hasPermissions() {
            return this.parameters.f_268429_();
        }

        public MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> getEntries() {
            return this.entries;
        }

        public void m_246267_(ItemStack stack, CreativeModeTab.TabVisibility visibility) {
            this.getEntries().put(stack, visibility);
        }

        public void accept(Supplier<? extends ItemLike> item, CreativeModeTab.TabVisibility visibility) {
            this.m_245282_(item.get(), visibility);
        }

        public void accept(Supplier<? extends ItemLike> item) {
            this.m_246326_(item.get());
        }
    }

    public static final class Register
    extends CreativeModeTabEvent {
        private final Registrar registrar;

        @ApiStatus.Internal
        public Register(Registrar registrar) {
            this.registrar = registrar;
        }

        public CreativeModeTab registerCreativeModeTab(ResourceLocation name, List<Object> beforeEntries, List<Object> afterEntries, Consumer<CreativeModeTab.Builder> configurator) {
            return this.registrar.registerCreativeModeTab(configurator, name, afterEntries, beforeEntries);
        }

        public CreativeModeTab registerCreativeModeTab(ResourceLocation name, Consumer<CreativeModeTab.Builder> configurator) {
            return this.registrar.registerCreativeModeTab(configurator, name, DEFAULT_AFTER_ENTRIES, List.of());
        }
    }

    @FunctionalInterface
    public static interface Registrar {
        @NotNull
        public CreativeModeTab registerCreativeModeTab(@NotNull Consumer<CreativeModeTab.Builder> var1, @NotNull ResourceLocation var2, @NotNull List<Object> var3, @NotNull List<Object> var4);
    }
}

