/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Chest;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftLootable;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventoryDoubleChest;
import org.bukkit.inventory.Inventory;

public class CraftChest
extends CraftLootable<ChestBlockEntity>
implements Chest {
    public CraftChest(World world, ChestBlockEntity te) {
        super(world, te);
    }

    @Override
    public Inventory getSnapshotInventory() {
        return new CraftInventory((Container)this.getSnapshot());
    }

    @Override
    public Inventory getBlockInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventory((Container)this.getTileEntity());
    }

    @Override
    public Inventory getInventory() {
        CraftInventory inventory = (CraftInventory)this.getBlockInventory();
        if (!this.isPlaced() || this.isWorldGeneration()) {
            return inventory;
        }
        CraftWorld world = (CraftWorld)this.getWorld();
        ChestBlock blockChest = (ChestBlock)(this.getType() == Material.CHEST ? Blocks.f_50087_ : Blocks.f_50325_);
        MenuProvider nms = blockChest.getMenuProvider(this.data, (Level)world.getHandle(), this.getPosition(), true);
        if (nms instanceof ChestBlock.DoubleInventory) {
            inventory = new CraftInventoryDoubleChest((ChestBlock.DoubleInventory)nms);
        }
        return inventory;
    }

    @Override
    public void open() {
        this.requirePlaced();
        if (!((ChestBlockEntity)this.getTileEntity()).f_155324_.opened && this.getWorldHandle() instanceof Level) {
            BlockState block = ((ChestBlockEntity)this.getTileEntity()).m_58900_();
            ((ChestBlockEntity)this.getTileEntity()).m_58904_().m_7696_(this.getPosition(), block.m_60734_(), 1, ((ChestBlockEntity)this.getTileEntity()).f_155324_.m_155450_() + 1);
            ChestBlockEntity.m_155338_((Level)((ChestBlockEntity)this.getTileEntity()).m_58904_(), (BlockPos)this.getPosition(), (BlockState)block, (SoundEvent)SoundEvents.f_11749_);
        }
        ((ChestBlockEntity)this.getTileEntity()).f_155324_.opened = true;
    }

    @Override
    public void close() {
        this.requirePlaced();
        if (((ChestBlockEntity)this.getTileEntity()).f_155324_.opened && this.getWorldHandle() instanceof Level) {
            BlockState block = ((ChestBlockEntity)this.getTileEntity()).m_58900_();
            ((ChestBlockEntity)this.getTileEntity()).m_58904_().m_7696_(this.getPosition(), block.m_60734_(), 1, 0);
            ChestBlockEntity.m_155338_((Level)((ChestBlockEntity)this.getTileEntity()).m_58904_(), (BlockPos)this.getPosition(), (BlockState)block, (SoundEvent)SoundEvents.f_11747_);
        }
        ((ChestBlockEntity)this.getTileEntity()).f_155324_.opened = false;
    }
}

