/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.block;

import com.google.common.base.Preconditions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_19_R3.block.sign.CraftSignSide;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CraftSign<T extends SignBlockEntity>
extends CraftBlockEntityState<T>
implements Sign {
    private final CraftSignSide front = new CraftSignSide((SignBlockEntity)this.getSnapshot());

    public CraftSign(World world, T tileEntity) {
        super(world, tileEntity);
    }

    public static void openSign(Sign sign, Player player) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"sign == null");
        Preconditions.checkArgument((boolean)sign.isPlaced(), (Object)"Sign must be placed");
        Preconditions.checkArgument((sign.getWorld() == player.getWorld() ? 1 : 0) != 0, (Object)"Sign must be in same world as Player");
        SignBlockEntity handle = (SignBlockEntity)((CraftSign)sign).getTileEntity();
        handle.f_59721_ = true;
        ((CraftPlayer)player).getHandle().m_7739_(handle);
    }

    @Override
    public String[] getLines() {
        return this.front.getLines();
    }

    @Override
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.front.getLine(index);
    }

    @Override
    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.front.setLine(index, line);
    }

    @Override
    public boolean isEditable() {
        return ((SignBlockEntity)this.getSnapshot()).f_59721_;
    }

    @Override
    public void setEditable(boolean editable) {
        ((SignBlockEntity)this.getSnapshot()).f_59721_ = editable;
    }

    @Override
    public boolean isGlowingText() {
        return this.front.isGlowingText();
    }

    @Override
    public void setGlowingText(boolean glowing) {
        this.front.setGlowingText(glowing);
    }

    @Override
    @NotNull
    public SignSide getSide(Side side) {
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        return this.front;
    }

    @Override
    public DyeColor getColor() {
        return this.front.getColor();
    }

    @Override
    public void setColor(DyeColor color) {
        this.front.setColor(color);
    }

    @Override
    public void applyTo(T sign) {
        this.front.applyLegacyStringToSignSide();
        super.applyTo(sign);
    }

    public static Component[] sanitizeLines(String[] lines) {
        Component[] components = new Component[4];
        for (int i = 0; i < 4; ++i) {
            components[i] = i < lines.length && lines[i] != null ? CraftChatMessage.fromString(lines[i])[0] : Component.m_237119_();
        }
        return components;
    }

    public static String[] revertComponents(Component[] components) {
        String[] lines = new String[components.length];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = CraftSign.revertComponent(components[i]);
        }
        return lines;
    }

    private static String revertComponent(Component component) {
        return CraftChatMessage.fromComponent(component);
    }
}

