/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.block.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BaseCoralFanBlock;
import net.minecraft.world.level.block.BaseCoralPlantBlock;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.CherryLeavesBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.ConduitBlock;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.InfestedRotatedPillarBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.MangroveLeavesBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.PiglinWallSkullBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.PlayerWallHeadBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.PowderSnowCauldronBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SuspiciousSandBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.TwistingVinesBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.WeepingVinesBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.WitherWallSkullBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockSupport;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_19_R3.CraftSoundGroup;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockSupport;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftAmethystCluster;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftAnvil;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBamboo;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBanner;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBannerWall;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBarrel;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBed;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBeehive;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBeetroot;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBell;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBigDripleaf;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBigDripleafStem;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftBubbleColumn;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftButtonAbstract;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCactus;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCake;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCampfire;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCandle;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCandleCake;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCarrots;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCaveVines;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCaveVinesPlant;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCeilingHangingSign;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftChain;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCherryLeaves;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftChest;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftChestTrapped;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftChiseledBookShelf;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftChorusFlower;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftChorusFruit;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCobbleWall;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCocoa;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCommand;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftComposter;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftConduit;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCoralDead;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCoralFan;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCoralFanAbstract;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCoralFanWall;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCoralFanWallAbstract;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCoralPlant;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftCrops;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftDirtSnow;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftDispenser;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftDoor;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftDropper;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftEndRod;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftEnderChest;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftEnderPortalFrame;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftFence;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftFenceGate;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftFire;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftFloorSign;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftFluids;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftFurnaceFurace;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftGlazedTerracotta;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftGlowLichen;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftGrass;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftGrindstone;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftHangingRoots;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftHay;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftHopper;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftHugeMushroom;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftIceFrost;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftInfestedRotatedPillar;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftIronBars;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftJigsaw;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftJukeBox;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftKelp;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLadder;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLantern;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLayeredCauldron;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLeaves;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLectern;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLever;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLight;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLightningRod;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftLoom;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftMangroveLeaves;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftMangrovePropagule;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftMangroveRoots;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftMinecartDetector;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftMinecartTrack;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftMycel;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftNetherWart;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftNote;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftObserver;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPiglinWallSkull;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPinkPetals;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPiston;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPistonExtension;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPistonMoving;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPointedDripstone;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPortal;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPotatoes;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPowderSnowCauldron;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPoweredRail;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPressurePlateBinary;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPressurePlateWeighted;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftPumpkinCarved;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRedstoneComparator;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRedstoneLamp;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRedstoneOre;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRedstoneTorch;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRedstoneTorchWall;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRedstoneWire;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftReed;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRepeater;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRespawnAnchor;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftRotatable;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSapling;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftScaffolding;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSculkVein;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSeaPickle;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSkull;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSkullPlayer;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSkullPlayerWall;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSkullWall;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSmallDripleaf;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSmoker;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSnow;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSoil;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftStainedGlassPane;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftStairs;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftStem;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftStemAttached;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftStepAbstract;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftStonecutter;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftStructure;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSuspiciousSand;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftSweetBerryBush;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTNT;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTallPlant;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTallPlantFlower;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTallSeagrass;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTarget;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTorchWall;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTorchflowerCrop;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTrapdoor;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTripwire;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTripwireHook;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTurtleEgg;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftTwistingVines;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftVine;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftWallHangingSign;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftWallSign;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftWeatheringCopperSlab;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftWeatheringCopperStair;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftWeepingVines;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_19_R3.block.impl.CraftWitherSkullWall;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;

public class CraftBlockData
implements BlockData {
    private BlockState state;
    private Map<Property<?>, Comparable<?>> parsedStates;
    private static final Map<Class<? extends Enum<?>>, Enum<?>[]> ENUM_VALUES = new HashMap();
    private static final Map<Class<? extends Block>, Function<BlockState, CraftBlockData>> MAP = new HashMap<Class<? extends Block>, Function<BlockState, CraftBlockData>>();

    protected CraftBlockData() {
        throw new AssertionError((Object)"Template Constructor");
    }

    protected CraftBlockData(BlockState state) {
        this.state = state;
    }

    @Override
    public Material getMaterial() {
        return CraftMagicNumbers.getMaterial(this.state.m_60734_());
    }

    public BlockState getState() {
        return this.state;
    }

    protected <B extends Enum<B>> B get(EnumProperty<?> nms, Class<B> bukkit) {
        return CraftBlockData.toBukkit((Enum)((Object)this.state.m_61143_(nms)), bukkit);
    }

    protected <B extends Enum<B>> Set<B> getValues(EnumProperty<?> nms, Class<B> bukkit) {
        ImmutableSet.Builder values = ImmutableSet.builder();
        for (Enum e : nms.m_6908_()) {
            values.add(CraftBlockData.toBukkit(e, bukkit));
        }
        return values.build();
    }

    protected <B extends Enum<B>, N extends Enum<N>> void set(EnumProperty<N> nms, Enum<B> bukkit) {
        this.parsedStates = null;
        this.state = (BlockState)this.state.m_61124_(nms, CraftBlockData.toNMS(bukkit, nms.m_61709_()));
    }

    @Override
    public BlockData merge(BlockData data) {
        CraftBlockData craft = (CraftBlockData)data;
        Preconditions.checkArgument((craft.parsedStates != null ? 1 : 0) != 0, (Object)"Data not created via string parsing");
        Preconditions.checkArgument((this.state.m_60734_() == craft.state.m_60734_() ? 1 : 0) != 0, (String)"States have different types (got %s, expected %s)", (Object)data, (Object)this);
        CraftBlockData clone = (CraftBlockData)this.clone();
        clone.parsedStates = null;
        for (Property<?> parsed : craft.parsedStates.keySet()) {
            clone.state = (BlockState)clone.state.m_61124_(parsed, craft.state.m_61143_(parsed));
        }
        return clone;
    }

    @Override
    public boolean matches(BlockData data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof CraftBlockData)) {
            return false;
        }
        CraftBlockData craft = (CraftBlockData)data;
        if (this.state.m_60734_() != craft.state.m_60734_()) {
            return false;
        }
        boolean exactMatch = this.equals(data);
        if (!exactMatch && craft.parsedStates != null) {
            return this.merge(data).equals(this);
        }
        return exactMatch;
    }

    private static <B extends Enum<B>> B toBukkit(Enum<?> nms, Class<B> bukkit) {
        if (nms instanceof Direction) {
            return (B)((Object)CraftBlock.notchToBlockFace((Direction)nms));
        }
        return (B)ENUM_VALUES.computeIfAbsent(bukkit, Class::getEnumConstants)[nms.ordinal()];
    }

    private static <N extends Enum<N>> N toNMS(Enum<?> bukkit, Class<N> nms) {
        if (bukkit instanceof BlockFace) {
            return (N)CraftBlock.blockFaceToNotch((BlockFace)bukkit);
        }
        return (N)ENUM_VALUES.computeIfAbsent(nms, Class::getEnumConstants)[bukkit.ordinal()];
    }

    protected <T extends Comparable<T>> T get(Property<T> ibs) {
        return (T)this.state.m_61143_(ibs);
    }

    public <T extends Comparable<T>, V extends T> void set(Property<T> ibs, V v) {
        this.parsedStates = null;
        this.state = (BlockState)this.state.m_61124_(ibs, v);
    }

    @Override
    public String getAsString() {
        return this.toString((Map<Property<?>, Comparable<?>>)this.state.m_61148_());
    }

    @Override
    public String getAsString(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? this.toString(this.parsedStates) : this.getAsString();
    }

    @Override
    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Clone not supported", ex);
        }
    }

    public String toString() {
        return "CraftBlockData{" + this.getAsString() + "}";
    }

    public String toString(Map<Property<?>, Comparable<?>> states) {
        StringBuilder stateString = new StringBuilder(BuiltInRegistries.f_256975_.m_7981_((Object)this.state.m_60734_()).toString());
        if (!states.isEmpty()) {
            stateString.append('[');
            stateString.append(states.entrySet().stream().map(StateHolder.f_61110_).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    public CompoundTag toStates() {
        CompoundTag compound = new CompoundTag();
        for (Map.Entry entry : this.state.m_61148_().entrySet()) {
            Property iblockstate = (Property)entry.getKey();
            compound.m_128359_(iblockstate.m_61708_(), iblockstate.m_6940_((Comparable)entry.getValue()));
        }
        return compound;
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftBlockData && this.state.equals(((CraftBlockData)obj).state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    protected static BooleanProperty getBoolean(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BooleanProperty getBoolean(String name, boolean optional) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static EnumProperty<?> getEnum(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static IntegerProperty getInteger(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BooleanProperty getBoolean(Class<? extends Block> block, String name) {
        return (BooleanProperty)CraftBlockData.getState(block, name, false);
    }

    protected static BooleanProperty getBoolean(Class<? extends Block> block, String name, boolean optional) {
        return (BooleanProperty)CraftBlockData.getState(block, name, optional);
    }

    protected static EnumProperty<?> getEnum(Class<? extends Block> block, String name) {
        return (EnumProperty)CraftBlockData.getState(block, name, false);
    }

    protected static IntegerProperty getInteger(Class<? extends Block> block, String name) {
        return (IntegerProperty)CraftBlockData.getState(block, name, false);
    }

    private static Property<?> getState(Class<? extends Block> block, String name, boolean optional) {
        Property state = null;
        for (Block instance : BuiltInRegistries.f_256975_) {
            if (instance.getClass() != block) continue;
            if (state == null) {
                state = instance.m_49965_().m_61081_(name);
                continue;
            }
            Property newState = instance.m_49965_().m_61081_(name);
            Preconditions.checkState((state == newState ? 1 : 0) != 0, (String)"State mistmatch %s,%s", (Object)state, (Object)newState);
        }
        Preconditions.checkState((optional || state != null ? 1 : 0) != 0, (String)"Null state for %s,%s", block, (Object)name);
        return state;
    }

    protected static int getMin(IntegerProperty state) {
        return state.f_223000_;
    }

    protected static int getMax(IntegerProperty state) {
        return state.f_223001_;
    }

    private static void register(Class<? extends Block> nms, Function<BlockState, CraftBlockData> bukkit) {
        Preconditions.checkState((MAP.put(nms, bukkit) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", nms, bukkit);
    }

    public static CraftBlockData newData(Material material, String data) {
        BlockState blockData;
        Preconditions.checkArgument((material == null || material.isBlock() ? 1 : 0) != 0, (String)"Cannot get data for not block %s", (Object)material);
        Block block = CraftMagicNumbers.getBlock(material);
        Map parsed = null;
        if (data != null) {
            try {
                if (block != null) {
                    data = BuiltInRegistries.f_256975_.m_7981_((Object)block) + (String)data;
                }
                StringReader reader = new StringReader((String)data);
                BlockStateParser.BlockResult arg = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)reader, (boolean)false);
                Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + (String)data));
                blockData = arg.f_234748_();
                parsed = arg.f_234749_();
            }
            catch (CommandSyntaxException ex) {
                throw new IllegalArgumentException("Could not parse data: " + (String)data, ex);
            }
        } else {
            blockData = block.m_49966_();
        }
        CraftBlockData craft = CraftBlockData.fromData(blockData);
        craft.parsedStates = parsed;
        return craft;
    }

    public static CraftBlockData fromData(BlockState data) {
        return (CraftBlockData)MAP.getOrDefault(data.m_60734_().getClass(), (Function<BlockState, CraftBlockData>)((Function)CraftBlockData::new)).apply((Object)data);
    }

    @Override
    public SoundGroup getSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.state.m_60827_());
    }

    @Override
    public int getLightEmission() {
        return this.state.m_60791_();
    }

    @Override
    public boolean isOccluding() {
        return this.state.m_60815_();
    }

    @Override
    public boolean requiresCorrectToolForDrops() {
        return this.state.m_60834_();
    }

    @Override
    public boolean isPreferredTool(org.bukkit.inventory.ItemStack tool) {
        Preconditions.checkArgument((tool != null ? 1 : 0) != 0, (Object)"tool must not be null");
        ItemStack nms = CraftItemStack.asNMSCopy(tool);
        return CraftBlockData.isPreferredTool(this.state, nms);
    }

    public static boolean isPreferredTool(BlockState iblockdata, ItemStack nmsItem) {
        return !iblockdata.m_60834_() || nmsItem.m_41735_(iblockdata);
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.state.m_60811_().ordinal());
    }

    @Override
    public boolean isSupported(org.bukkit.block.Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        CraftBlock craftBlock = (CraftBlock)block;
        return this.state.m_60710_((LevelReader)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition());
    }

    @Override
    public boolean isSupported(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location must not be null");
        CraftWorld world = (CraftWorld)location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"location must not have a null world");
        BlockPos position = CraftLocation.toBlockPosition(location);
        return this.state.m_60710_((LevelReader)world.getHandle(), position);
    }

    @Override
    public boolean isFaceSturdy(BlockFace face, BlockSupport support) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((support != null ? 1 : 0) != 0, (Object)"support must not be null");
        return this.state.m_60659_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_, CraftBlock.blockFaceToNotch(face), CraftBlockSupport.toNMS(support));
    }

    @Override
    public Material getPlacementMaterial() {
        return CraftMagicNumbers.getMaterial(this.state.m_60734_().m_5456_());
    }

    @Override
    public void rotate(StructureRotation rotation) {
        this.state = this.state.m_60717_(Rotation.valueOf((String)rotation.name()));
    }

    @Override
    public void mirror(org.bukkit.block.structure.Mirror mirror) {
        this.state = this.state.m_60715_(Mirror.valueOf((String)mirror.name()));
    }

    static {
        CraftBlockData.register(AmethystClusterBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftAmethystCluster::new));
        CraftBlockData.register(BigDripleafBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBigDripleaf::new));
        CraftBlockData.register(BigDripleafStemBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBigDripleafStem::new));
        CraftBlockData.register(AnvilBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftAnvil::new));
        CraftBlockData.register(BambooStalkBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBamboo::new));
        CraftBlockData.register(BannerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBanner::new));
        CraftBlockData.register(WallBannerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBannerWall::new));
        CraftBlockData.register(BarrelBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBarrel::new));
        CraftBlockData.register(BedBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBed::new));
        CraftBlockData.register(BeehiveBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBeehive::new));
        CraftBlockData.register(BeetrootBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBeetroot::new));
        CraftBlockData.register(BellBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBell::new));
        CraftBlockData.register(BlastFurnaceBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBlastFurnace::new));
        CraftBlockData.register(BrewingStandBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBrewingStand::new));
        CraftBlockData.register(BubbleColumnBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftBubbleColumn::new));
        CraftBlockData.register(ButtonBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftButtonAbstract::new));
        CraftBlockData.register(CactusBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCactus::new));
        CraftBlockData.register(CakeBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCake::new));
        CraftBlockData.register(CampfireBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCampfire::new));
        CraftBlockData.register(CarrotBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCarrots::new));
        CraftBlockData.register(ChainBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChain::new));
        CraftBlockData.register(ChestBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChest::new));
        CraftBlockData.register(TrappedChestBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChestTrapped::new));
        CraftBlockData.register(ChorusFlowerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChorusFlower::new));
        CraftBlockData.register(ChorusPlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChorusFruit::new));
        CraftBlockData.register(WallBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCobbleWall::new));
        CraftBlockData.register(CocoaBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCocoa::new));
        CraftBlockData.register(CommandBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCommand::new));
        CraftBlockData.register(ComposterBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftComposter::new));
        CraftBlockData.register(ConduitBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftConduit::new));
        CraftBlockData.register(BaseCoralPlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralDead::new));
        CraftBlockData.register(CoralFanBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralFan::new));
        CraftBlockData.register(BaseCoralFanBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralFanAbstract::new));
        CraftBlockData.register(CoralWallFanBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralFanWall::new));
        CraftBlockData.register(BaseCoralWallFanBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralFanWallAbstract::new));
        CraftBlockData.register(CoralPlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCoralPlant::new));
        CraftBlockData.register(CropBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCrops::new));
        CraftBlockData.register(DaylightDetectorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDaylightDetector::new));
        CraftBlockData.register(SnowyDirtBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDirtSnow::new));
        CraftBlockData.register(DispenserBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDispenser::new));
        CraftBlockData.register(DoorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDoor::new));
        CraftBlockData.register(DropperBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDropper::new));
        CraftBlockData.register(EndRodBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftEndRod::new));
        CraftBlockData.register(EnderChestBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftEnderChest::new));
        CraftBlockData.register(EndPortalFrameBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftEnderPortalFrame::new));
        CraftBlockData.register(FenceBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFence::new));
        CraftBlockData.register(FenceGateBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFenceGate::new));
        CraftBlockData.register(FireBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFire::new));
        CraftBlockData.register(StandingSignBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFloorSign::new));
        CraftBlockData.register(LiquidBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFluids::new));
        CraftBlockData.register(FurnaceBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftFurnaceFurace::new));
        CraftBlockData.register(GlazedTerracottaBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftGlazedTerracotta::new));
        CraftBlockData.register(GrassBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftGrass::new));
        CraftBlockData.register(GrindstoneBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftGrindstone::new));
        CraftBlockData.register(HayBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftHay::new));
        CraftBlockData.register(HopperBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftHopper::new));
        CraftBlockData.register(HugeMushroomBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftHugeMushroom::new));
        CraftBlockData.register(FrostedIceBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftIceFrost::new));
        CraftBlockData.register(IronBarsBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftIronBars::new));
        CraftBlockData.register(JigsawBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftJigsaw::new));
        CraftBlockData.register(JukeboxBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftJukeBox::new));
        CraftBlockData.register(KelpBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftKelp::new));
        CraftBlockData.register(LadderBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLadder::new));
        CraftBlockData.register(LanternBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLantern::new));
        CraftBlockData.register(LeavesBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLeaves::new));
        CraftBlockData.register(LecternBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLectern::new));
        CraftBlockData.register(LeverBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLever::new));
        CraftBlockData.register(LoomBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLoom::new));
        CraftBlockData.register(DetectorRailBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMinecartDetector::new));
        CraftBlockData.register(RailBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMinecartTrack::new));
        CraftBlockData.register(MyceliumBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMycel::new));
        CraftBlockData.register(NetherWartBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftNetherWart::new));
        CraftBlockData.register(NoteBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftNote::new));
        CraftBlockData.register(ObserverBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftObserver::new));
        CraftBlockData.register(NetherPortalBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPortal::new));
        CraftBlockData.register(PotatoBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPotatoes::new));
        CraftBlockData.register(PoweredRailBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPoweredRail::new));
        CraftBlockData.register(PressurePlateBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPressurePlateBinary::new));
        CraftBlockData.register(WeightedPressurePlateBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPressurePlateWeighted::new));
        CraftBlockData.register(CarvedPumpkinBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPumpkinCarved::new));
        CraftBlockData.register(ComparatorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneComparator::new));
        CraftBlockData.register(RedstoneLampBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneLamp::new));
        CraftBlockData.register(RedStoneOreBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneOre::new));
        CraftBlockData.register(RedstoneTorchBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneTorch::new));
        CraftBlockData.register(RedstoneWallTorchBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneTorchWall::new));
        CraftBlockData.register(RedStoneWireBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRedstoneWire::new));
        CraftBlockData.register(SugarCaneBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftReed::new));
        CraftBlockData.register(RepeaterBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRepeater::new));
        CraftBlockData.register(RespawnAnchorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRespawnAnchor::new));
        CraftBlockData.register(RotatedPillarBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftRotatable::new));
        CraftBlockData.register(SaplingBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSapling::new));
        CraftBlockData.register(ScaffoldingBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftScaffolding::new));
        CraftBlockData.register(SeaPickleBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSeaPickle::new));
        CraftBlockData.register(ShulkerBoxBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftShulkerBox::new));
        CraftBlockData.register(SkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSkull::new));
        CraftBlockData.register(PlayerHeadBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSkullPlayer::new));
        CraftBlockData.register(PlayerWallHeadBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSkullPlayerWall::new));
        CraftBlockData.register(WallSkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSkullWall::new));
        CraftBlockData.register(SmokerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSmoker::new));
        CraftBlockData.register(SnowLayerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSnow::new));
        CraftBlockData.register(FarmBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSoil::new));
        CraftBlockData.register(StainedGlassPaneBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStainedGlassPane::new));
        CraftBlockData.register(StairBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStairs::new));
        CraftBlockData.register(StemBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStem::new));
        CraftBlockData.register(AttachedStemBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStemAttached::new));
        CraftBlockData.register(SlabBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStepAbstract::new));
        CraftBlockData.register(StonecutterBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStonecutter::new));
        CraftBlockData.register(StructureBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftStructure::new));
        CraftBlockData.register(SweetBerryBushBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSweetBerryBush::new));
        CraftBlockData.register(TntBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTNT::new));
        CraftBlockData.register(DoublePlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTallPlant::new));
        CraftBlockData.register(TallFlowerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTallPlantFlower::new));
        CraftBlockData.register(TargetBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTarget::new));
        CraftBlockData.register(WallTorchBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTorchWall::new));
        CraftBlockData.register(TrapDoorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTrapdoor::new));
        CraftBlockData.register(TripWireBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTripwire::new));
        CraftBlockData.register(TripWireHookBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTripwireHook::new));
        CraftBlockData.register(TurtleEggBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTurtleEgg::new));
        CraftBlockData.register(TwistingVinesBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTwistingVines::new));
        CraftBlockData.register(VineBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftVine::new));
        CraftBlockData.register(WallSignBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWallSign::new));
        CraftBlockData.register(WeepingVinesBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWeepingVines::new));
        CraftBlockData.register(WitherSkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWitherSkull::new));
        CraftBlockData.register(WitherWallSkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWitherSkullWall::new));
        CraftBlockData.register(CandleBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCandle::new));
        CraftBlockData.register(CandleCakeBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCandleCake::new));
        CraftBlockData.register(CaveVinesBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCaveVines::new));
        CraftBlockData.register(CaveVinesPlantBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCaveVinesPlant::new));
        CraftBlockData.register(CeilingHangingSignBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCeilingHangingSign::new));
        CraftBlockData.register(CherryLeavesBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftCherryLeaves::new));
        CraftBlockData.register(ChiseledBookShelfBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftChiseledBookShelf::new));
        CraftBlockData.register(DecoratedPotBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftDecoratedPot::new));
        CraftBlockData.register(GlowLichenBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftGlowLichen::new));
        CraftBlockData.register(HangingRootsBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftHangingRoots::new));
        CraftBlockData.register(InfestedRotatedPillarBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftInfestedRotatedPillar::new));
        CraftBlockData.register(LayeredCauldronBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLayeredCauldron::new));
        CraftBlockData.register(LightBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLight::new));
        CraftBlockData.register(LightningRodBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftLightningRod::new));
        CraftBlockData.register(MangroveLeavesBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMangroveLeaves::new));
        CraftBlockData.register(MangrovePropaguleBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMangrovePropagule::new));
        CraftBlockData.register(MangroveRootsBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftMangroveRoots::new));
        CraftBlockData.register(PiglinWallSkullBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPiglinWallSkull::new));
        CraftBlockData.register(PinkPetalsBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPinkPetals::new));
        CraftBlockData.register(PointedDripstoneBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPointedDripstone::new));
        CraftBlockData.register(PowderSnowCauldronBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPowderSnowCauldron::new));
        CraftBlockData.register(SculkCatalystBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSculkCatalyst::new));
        CraftBlockData.register(SculkSensorBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSculkSensor::new));
        CraftBlockData.register(SculkShriekerBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSculkShrieker::new));
        CraftBlockData.register(SculkVeinBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSculkVein::new));
        CraftBlockData.register(SmallDripleafBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSmallDripleaf::new));
        CraftBlockData.register(SuspiciousSandBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftSuspiciousSand::new));
        CraftBlockData.register(TallSeagrassBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTallSeagrass::new));
        CraftBlockData.register(TorchflowerCropBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftTorchflowerCrop::new));
        CraftBlockData.register(WallHangingSignBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWallHangingSign::new));
        CraftBlockData.register(WeatheringCopperSlabBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWeatheringCopperSlab::new));
        CraftBlockData.register(WeatheringCopperStairBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftWeatheringCopperStair::new));
        CraftBlockData.register(PistonBaseBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPiston::new));
        CraftBlockData.register(PistonHeadBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPistonExtension::new));
        CraftBlockData.register(MovingPistonBlock.class, (Function<BlockState, CraftBlockData>)((Function)CraftPistonMoving::new));
    }
}

