/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Fence;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;

public final class CraftIronBars
extends CraftBlockData
implements Fence,
MultipleFacing,
Waterlogged {
    private static final BooleanProperty[] FACES = new BooleanProperty[]{CraftIronBars.getBoolean(IronBarsBlock.class, "north", true), CraftIronBars.getBoolean(IronBarsBlock.class, "east", true), CraftIronBars.getBoolean(IronBarsBlock.class, "south", true), CraftIronBars.getBoolean(IronBarsBlock.class, "west", true), CraftIronBars.getBoolean(IronBarsBlock.class, "up", true), CraftIronBars.getBoolean(IronBarsBlock.class, "down", true)};
    private static final BooleanProperty WATERLOGGED = CraftIronBars.getBoolean(IronBarsBlock.class, "waterlogged");

    public CraftIronBars() {
    }

    public CraftIronBars(BlockState state) {
        super(state);
    }

    @Override
    public boolean hasFace(BlockFace face) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + face + ". Check MultipleFacing.getAllowedFaces.");
        }
        return (Boolean)this.get(state);
    }

    @Override
    public void setFace(BlockFace face, boolean has) {
        BooleanProperty state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + face + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    @Override
    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null || !((Boolean)this.get(FACES[i])).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }

    @Override
    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i = 0; i < FACES.length; ++i) {
            if (FACES[i] == null) continue;
            faces.add((Object)BlockFace.values()[i]);
        }
        return faces.build();
    }

    @Override
    public boolean isWaterlogged() {
        return (Boolean)this.get(WATERLOGGED);
    }

    @Override
    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

