/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.block.sign;

import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.bukkit.DyeColor;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftSign;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftSignSide
implements SignSide {
    private String[] originalLines = null;
    private String[] lines = null;
    private final SignBlockEntity signText;

    public CraftSignSide(SignBlockEntity signText) {
        this.signText = signText;
    }

    @Override
    @NotNull
    public String[] getLines() {
        if (this.lines == null) {
            this.lines = new String[this.signText.f_59720_.length];
            System.arraycopy(CraftSign.revertComponents(this.signText.f_59720_), 0, this.lines, 0, this.lines.length);
            this.originalLines = new String[this.lines.length];
            System.arraycopy(this.lines, 0, this.originalLines, 0, this.originalLines.length);
        }
        return this.lines;
    }

    @Override
    @NotNull
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.getLines()[index];
    }

    @Override
    public void setLine(int index, @NotNull String line) throws IndexOutOfBoundsException {
        this.getLines()[index] = line;
    }

    @Override
    public boolean isGlowingText() {
        return this.signText.m_155727_();
    }

    @Override
    public void setGlowingText(boolean glowing) {
        this.signText.m_155722_(glowing);
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)this.signText.m_59753_().m_41060_());
    }

    @Override
    public void setColor(@NotNull DyeColor color) {
        this.signText.m_59739_(net.minecraft.world.item.DyeColor.m_41053_((int)color.getWoolData()));
    }

    public void applyLegacyStringToSignSide() {
        if (this.lines != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                String line;
                String string = line = this.lines[i] == null ? "" : this.lines[i];
                if (line.equals(this.originalLines[i])) continue;
                this.signText.m_59732_(i, CraftChatMessage.fromString(line)[0]);
            }
        }
    }
}

