/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftAnimals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Rabbit;

public class CraftRabbit
extends CraftAnimals
implements Rabbit {
    public CraftRabbit(CraftServer server, net.minecraft.world.entity.animal.Rabbit entity) {
        super(server, (Animal)entity);
    }

    public net.minecraft.world.entity.animal.Rabbit getHandle() {
        return (net.minecraft.world.entity.animal.Rabbit)this.entity;
    }

    @Override
    public String toString() {
        return "CraftRabbit{RabbitType=" + this.getRabbitType() + "}";
    }

    @Override
    public EntityType getType() {
        return EntityType.RABBIT;
    }

    @Override
    public Rabbit.Type getRabbitType() {
        return Rabbit.Type.values()[this.getHandle().m_28554_().ordinal()];
    }

    @Override
    public void setRabbitType(Rabbit.Type type) {
        net.minecraft.world.entity.animal.Rabbit entity = this.getHandle();
        if (this.getRabbitType() == Rabbit.Type.THE_KILLER_BUNNY) {
            ServerLevel world = ((CraftWorld)this.getWorld()).getHandle();
            entity.f_21345_ = new GoalSelector(world.m_46658_());
            entity.f_21346_ = new GoalSelector(world.m_46658_());
            entity.m_8099_();
            entity.m_29725_(0.0);
        }
        entity.m_28464_(Rabbit.Variant.values()[type.ordinal()]);
    }

    private static class CraftMagicMapping {
        private static final int[] types = new int[Rabbit.Type.values().length];
        private static final Rabbit.Type[] reverse = new Rabbit.Type[Rabbit.Type.values().length];

        private CraftMagicMapping() {
        }

        private static void set(Rabbit.Type type, int value) {
            CraftMagicMapping.types[type.ordinal()] = value;
            if (value < reverse.length) {
                CraftMagicMapping.reverse[value] = type;
            }
        }

        public static Rabbit.Type fromMagic(int magic) {
            if (magic >= 0 && magic < reverse.length) {
                return reverse[magic];
            }
            if (magic == 99) {
                return Rabbit.Type.THE_KILLER_BUNNY;
            }
            return null;
        }

        public static int toMagic(Rabbit.Type type) {
            return types[type.ordinal()];
        }

        static {
            CraftMagicMapping.set(Rabbit.Type.BROWN, 0);
            CraftMagicMapping.set(Rabbit.Type.WHITE, 1);
            CraftMagicMapping.set(Rabbit.Type.BLACK, 2);
            CraftMagicMapping.set(Rabbit.Type.BLACK_AND_WHITE, 3);
            CraftMagicMapping.set(Rabbit.Type.GOLD, 4);
            CraftMagicMapping.set(Rabbit.Type.SALT_AND_PEPPER, 5);
            CraftMagicMapping.set(Rabbit.Type.THE_KILLER_BUNNY, 99);
        }
    }
}

