/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.inventory.tags;

import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_19_R3.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.tags.DeprecatedItemAdapterContext;
import org.bukkit.craftbukkit.v1_19_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public final class DeprecatedContainerTagType<Z>
implements PersistentDataType<PersistentDataContainer, Z> {
    private final ItemTagType<CustomItemTagContainer, Z> deprecated;

    DeprecatedContainerTagType(ItemTagType<CustomItemTagContainer, Z> deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @Override
    public Class<Z> getComplexType() {
        return this.deprecated.getComplexType();
    }

    @Override
    public PersistentDataContainer toPrimitive(Z complex, PersistentDataAdapterContext context) {
        CustomItemTagContainer deprecated = this.deprecated.toPrimitive(complex, new DeprecatedItemAdapterContext(context));
        Validate.isInstanceOf(DeprecatedCustomTagContainer.class, (Object)deprecated, (String)"Could not wrap deprecated API due to foreign CustomItemTagContainer implementation %s", (Object[])new Object[]{deprecated.getClass().getSimpleName()});
        DeprecatedCustomTagContainer tagContainer = (DeprecatedCustomTagContainer)deprecated;
        PersistentDataContainer wrapped = tagContainer.getWrapped();
        Validate.isInstanceOf(CraftPersistentDataContainer.class, (Object)wrapped, (String)"Could not wrap deprecated API due to wrong deprecation wrapper %s", (Object[])new Object[]{deprecated.getClass().getSimpleName()});
        CraftPersistentDataContainer craftTagContainer = (CraftPersistentDataContainer)wrapped;
        return new CraftPersistentDataContainer(craftTagContainer.getRaw(), craftTagContainer.getDataTagTypeRegistry());
    }

    @Override
    public Z fromPrimitive(PersistentDataContainer primitive, PersistentDataAdapterContext context) {
        Validate.isInstanceOf(CraftPersistentDataContainer.class, (Object)primitive, (String)"Could not wrap deprecated API due to foreign PersistentMetadataContainer implementation %s", (Object[])new Object[]{primitive.getClass().getSimpleName()});
        return this.deprecated.fromPrimitive(new DeprecatedCustomTagContainer(primitive), new DeprecatedItemAdapterContext(context));
    }
}

