/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.mohistmc.MohistMC;
import com.mohistmc.bukkit.remapping.RemappingURLClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryLoader {
    @Nullable
    public ClassLoader createLoader(@NotNull PluginDescriptionFile desc) {
        if (desc.getLibraries().isEmpty()) {
            return null;
        }
        MohistMC.LOGGER.info("[{}] Loading {} libraries... please wait", (Object)desc.getName(), (Object)desc.getLibraries().size());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String string : desc.getLibraries()) {
            String[] args = string.split(":");
            if (args.length <= 1) continue;
            Dependency dependency = new Dependency(args[0], args[1], args[2]);
            dependencies.add(dependency);
        }
        ArrayList<File> libraries = new ArrayList<File>();
        for (Dependency dependency : dependencies) {
            String group = dependency.group().replaceAll("\\.", "/");
            String fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
            String mavenUrl = "https://repo.maven.apache.org/maven2/%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName);
            File file = new File(new File("libraries", "spigot-lib"), "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName));
            if (file.exists()) {
                MohistMC.LOGGER.info("[{}] Found libraries {}", (Object)desc.getName(), (Object)file);
                libraries.add(file);
                continue;
            }
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                InputStream inputStream = new URL(mavenUrl).openStream();
                try (FileOutputStream outputStream = new FileOutputStream(file);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                libraries.add(file);
            }
            catch (IOException e) {
                MohistMC.LOGGER.error((Object)e);
            }
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : libraries) {
            try {
                arrayList.add(file.toURI().toURL());
                MohistMC.LOGGER.info("[{}] Loaded libraries {}", (Object)desc.getName(), (Object)file);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return new RemappingURLClassLoader(arrayList.toArray(new URL[0]), this.getClass().getClassLoader());
    }

    public record Dependency(String group, String name, String version) {
    }
}

