/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.registries;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Instruments;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.BiomeSources;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGenerators;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class BuiltInRegistries {
    private static final Logger f_256744_ = LogUtils.getLogger();
    private static final Map<ResourceLocation, Supplier<?>> f_256751_ = Maps.newLinkedHashMap();
    public static final ResourceLocation f_256779_ = new ResourceLocation("root");
    private static final WritableRegistry<WritableRegistry<?>> f_256935_ = new MappedRegistry(ResourceKey.m_135788_(f_256779_), Lifecycle.stable());
    public static final DefaultedRegistry<GameEvent> f_256726_ = BuiltInRegistries.m_257834_(Registries.f_256827_, "step", p_260052_ -> GameEvent.f_157785_);
    public static final Registry<SoundEvent> f_256894_ = BuiltInRegistries.m_258002_(Registries.f_256840_, p_260167_ -> SoundEvents.f_12019_);
    public static final DefaultedRegistry<Fluid> f_257020_ = BuiltInRegistries.m_257834_(Registries.f_256808_, "empty", p_259453_ -> Fluids.f_76191_);
    public static final Registry<MobEffect> f_256974_ = BuiltInRegistries.m_258002_(Registries.f_256929_, p_259689_ -> MobEffects.f_19621_);
    public static final DefaultedRegistry<Block> f_256975_ = BuiltInRegistries.m_257834_(Registries.f_256747_, "air", p_259909_ -> Blocks.f_50016_);
    public static final Registry<Enchantment> f_256876_ = BuiltInRegistries.m_258002_(Registries.f_256762_, p_259104_ -> Enchantments.f_44987_);
    public static final DefaultedRegistry<EntityType<?>> f_256780_ = BuiltInRegistries.m_257834_(Registries.f_256939_, "pig", p_259175_ -> EntityType.f_20510_);
    public static final DefaultedRegistry<Item> f_257033_ = BuiltInRegistries.m_257834_(Registries.f_256913_, "air", p_260227_ -> Items.f_41852_);
    public static final DefaultedRegistry<Potion> f_256980_ = BuiltInRegistries.m_257988_(Registries.f_256973_, "empty", p_259869_ -> Potions.f_43598_);
    public static final Registry<ParticleType<?>> f_257034_ = BuiltInRegistries.m_258002_(Registries.f_256890_, p_260266_ -> ParticleTypes.f_123794_);
    public static final Registry<BlockEntityType<?>> f_257049_ = BuiltInRegistries.m_258002_(Registries.f_256922_, p_259434_ -> BlockEntityType.f_58917_);
    public static final DefaultedRegistry<PaintingVariant> f_257051_ = BuiltInRegistries.m_257988_(Registries.f_256836_, "kebab", PaintingVariants::m_218942_);
    public static final Registry<ResourceLocation> f_256771_ = BuiltInRegistries.m_258002_(Registries.f_256887_, p_259833_ -> Stats.f_12926_);
    public static final DefaultedRegistry<ChunkStatus> f_256940_ = BuiltInRegistries.m_257988_(Registries.f_256755_, "empty", p_259971_ -> ChunkStatus.f_62314_);
    public static final Registry<RuleTestType<?>> f_256978_ = BuiltInRegistries.m_258002_(Registries.f_256947_, p_259641_ -> RuleTestType.f_74312_);
    public static final Registry<PosRuleTestType<?>> f_256957_ = BuiltInRegistries.m_258002_(Registries.f_257009_, p_259262_ -> PosRuleTestType.f_74205_);
    public static final Registry<MenuType<?>> f_256818_ = BuiltInRegistries.m_258002_(Registries.f_256798_, p_259341_ -> MenuType.f_39964_);
    public static final Registry<RecipeType<?>> f_256990_ = BuiltInRegistries.m_258002_(Registries.f_256954_, p_259086_ -> RecipeType.f_44107_);
    public static final Registry<RecipeSerializer<?>> f_256769_ = BuiltInRegistries.m_258002_(Registries.f_256764_, p_260230_ -> RecipeSerializer.f_44077_);
    public static final Registry<Attribute> f_256951_ = BuiltInRegistries.m_258002_(Registries.f_256728_, p_260300_ -> Attributes.f_22286_);
    public static final Registry<PositionSourceType<?>> f_256972_ = BuiltInRegistries.m_258002_(Registries.f_256792_, p_259113_ -> PositionSourceType.f_157871_);
    public static final Registry<ArgumentTypeInfo<?, ?>> f_256979_ = BuiltInRegistries.m_258002_(Registries.f_256982_, ArgumentTypeInfos::m_235384_);
    public static final Registry<StatType<?>> f_256899_ = BuiltInRegistries.m_258002_(Registries.f_256849_, p_259967_ -> Stats.f_12982_);
    public static final DefaultedRegistry<VillagerType> f_256934_ = BuiltInRegistries.m_257988_(Registries.f_257019_, "plains", p_259473_ -> VillagerType.f_35821_);
    public static final DefaultedRegistry<VillagerProfession> f_256735_ = BuiltInRegistries.m_257988_(Registries.f_256749_, "none", p_259037_ -> VillagerProfession.f_35585_);
    public static final Registry<PoiType> f_256941_ = BuiltInRegistries.m_258002_(Registries.f_256805_, PoiTypes::m_218082_);
    public static final DefaultedRegistry<MemoryModuleType<?>> f_256784_ = BuiltInRegistries.m_257988_(Registries.f_257023_, "dummy", p_259248_ -> MemoryModuleType.f_26349_);
    public static final DefaultedRegistry<SensorType<?>> f_256733_ = BuiltInRegistries.m_257988_(Registries.f_256937_, "dummy", p_259757_ -> SensorType.f_26809_);
    public static final Registry<Schedule> f_256962_ = BuiltInRegistries.m_258002_(Registries.f_256723_, p_259540_ -> Schedule.f_38012_);
    public static final Registry<Activity> f_256785_ = BuiltInRegistries.m_258002_(Registries.f_257025_, p_260197_ -> Activity.f_37979_);
    public static final Registry<LootPoolEntryType> f_257035_ = BuiltInRegistries.m_258002_(Registries.f_257032_, p_260042_ -> LootPoolEntries.f_79619_);
    public static final Registry<LootItemFunctionType> f_256753_ = BuiltInRegistries.m_258002_(Registries.f_257015_, p_259836_ -> LootItemFunctions.f_80736_);
    public static final Registry<LootItemConditionType> f_256991_ = BuiltInRegistries.m_258002_(Registries.f_256976_, p_259742_ -> LootItemConditions.f_81811_);
    public static final Registry<LootNumberProviderType> f_257029_ = BuiltInRegistries.m_258002_(Registries.f_256829_, p_259329_ -> NumberProviders.f_165731_);
    public static final Registry<LootNbtProviderType> f_256736_ = BuiltInRegistries.m_258002_(Registries.f_256871_, p_259862_ -> NbtProviders.f_165624_);
    public static final Registry<LootScoreProviderType> f_256719_ = BuiltInRegistries.m_258002_(Registries.f_256924_, p_259313_ -> ScoreboardNameProviders.f_165869_);
    public static final Registry<FloatProviderType<?>> f_256926_ = BuiltInRegistries.m_258002_(Registries.f_256892_, p_260093_ -> FloatProviderType.f_146519_);
    public static final Registry<IntProviderType<?>> f_256942_ = BuiltInRegistries.m_258002_(Registries.f_256949_, p_259607_ -> IntProviderType.f_146550_);
    public static final Registry<HeightProviderType<?>> f_256870_ = BuiltInRegistries.m_258002_(Registries.f_256757_, p_259663_ -> HeightProviderType.f_161981_);
    public static final Registry<BlockPredicateType<?>> f_256906_ = BuiltInRegistries.m_258002_(Registries.f_256774_, p_260006_ -> BlockPredicateType.f_190444_);
    public static final Registry<WorldCarver<?>> f_257001_ = BuiltInRegistries.m_258002_(Registries.f_256812_, p_260200_ -> WorldCarver.f_64974_);
    public static final Registry<Feature<?>> f_256810_ = BuiltInRegistries.m_258002_(Registries.f_256833_, p_259143_ -> Feature.f_65731_);
    public static final Registry<StructurePlacementType<?>> f_256950_ = BuiltInRegistries.m_258002_(Registries.f_256888_, p_259179_ -> StructurePlacementType.f_205041_);
    public static final Registry<StructurePieceType> f_257014_ = BuiltInRegistries.m_258002_(Registries.f_256786_, p_259722_ -> StructurePieceType.f_210127_);
    public static final Registry<StructureType<?>> f_256763_ = BuiltInRegistries.m_258002_(Registries.f_256938_, p_259466_ -> StructureType.f_226867_);
    public static final Registry<PlacementModifierType<?>> f_256986_ = BuiltInRegistries.m_258002_(Registries.f_256843_, p_260335_ -> PlacementModifierType.f_191853_);
    public static final Registry<BlockStateProviderType<?>> f_256760_ = BuiltInRegistries.m_258002_(Registries.f_256891_, p_259345_ -> BlockStateProviderType.f_68752_);
    public static final Registry<FoliagePlacerType<?>> f_256861_ = BuiltInRegistries.m_258002_(Registries.f_256905_, p_260329_ -> FoliagePlacerType.f_68591_);
    public static final Registry<TrunkPlacerType<?>> f_256920_ = BuiltInRegistries.m_258002_(Registries.f_256963_, p_259690_ -> TrunkPlacerType.f_70315_);
    public static final Registry<RootPlacerType<?>> f_256742_ = BuiltInRegistries.m_258002_(Registries.f_256768_, p_259493_ -> RootPlacerType.f_225898_);
    public static final Registry<TreeDecoratorType<?>> f_256987_ = BuiltInRegistries.m_258002_(Registries.f_256845_, p_259122_ -> TreeDecoratorType.f_70043_);
    public static final Registry<FeatureSizeType<?>> f_256958_ = BuiltInRegistries.m_258002_(Registries.f_256720_, p_259370_ -> FeatureSizeType.f_68296_);
    public static final Registry<Codec<? extends BiomeSource>> f_256737_ = BuiltInRegistries.m_258073_(Registries.f_256826_, Lifecycle.stable(), BiomeSources::m_220586_);
    public static final Registry<Codec<? extends ChunkGenerator>> f_256914_ = BuiltInRegistries.m_258073_(Registries.f_256783_, Lifecycle.stable(), ChunkGenerators::m_223242_);
    public static final Registry<Codec<? extends SurfaceRules.ConditionSource>> f_256885_ = BuiltInRegistries.m_258002_(Registries.f_256793_, SurfaceRules.ConditionSource::m_204624_);
    public static final Registry<Codec<? extends SurfaceRules.RuleSource>> f_256898_ = BuiltInRegistries.m_258002_(Registries.f_256815_, SurfaceRules.RuleSource::m_204630_);
    public static final Registry<Codec<? extends DensityFunction>> f_257002_ = BuiltInRegistries.m_258002_(Registries.f_256746_, DensityFunctions::m_208342_);
    public static final Registry<StructureProcessorType<?>> f_256897_ = BuiltInRegistries.m_258002_(Registries.f_256983_, p_259305_ -> StructureProcessorType.f_74456_);
    public static final Registry<StructurePoolElementType<?>> f_256846_ = BuiltInRegistries.m_258002_(Registries.f_257024_, p_259361_ -> StructurePoolElementType.f_210545_);
    public static final Registry<CatVariant> f_256754_ = BuiltInRegistries.m_258002_(Registries.f_257006_, CatVariant::m_255364_);
    public static final Registry<FrogVariant> f_256770_ = BuiltInRegistries.m_258002_(Registries.f_256732_, p_259261_ -> FrogVariant.f_218185_);
    public static final Registry<BannerPattern> f_256878_ = BuiltInRegistries.m_258002_(Registries.f_256969_, BannerPatterns::m_222754_);
    public static final Registry<Instrument> f_256896_ = BuiltInRegistries.m_258002_(Registries.f_257010_, Instruments::m_220148_);
    public static final Registry<String> f_271353_ = BuiltInRegistries.m_258002_(Registries.f_271200_, DecoratedPotPatterns::m_271825_);
    public static final Registry<? extends Registry<?>> f_257047_ = f_256935_;

    private static <T> Registry<T> m_258002_(ResourceKey<? extends Registry<T>> p_260095_, RegistryBootstrap<T> p_259057_) {
        return BuiltInRegistries.m_258073_(p_260095_, Lifecycle.stable(), p_259057_);
    }

    private static <T> DefaultedRegistry<T> m_257988_(ResourceKey<? extends Registry<T>> p_259887_, String p_259325_, RegistryBootstrap<T> p_259759_) {
        return BuiltInRegistries.m_257600_(p_259887_, p_259325_, Lifecycle.stable(), p_259759_);
    }

    private static <T> DefaultedRegistry<T> m_257834_(ResourceKey<? extends Registry<T>> p_259296_, String p_259101_, RegistryBootstrap<T> p_259485_) {
        return BuiltInRegistries.m_257762_(p_259296_, p_259101_, Lifecycle.stable(), p_259485_);
    }

    private static <T> Registry<T> m_258073_(ResourceKey<? extends Registry<T>> p_259121_, Lifecycle p_259977_, RegistryBootstrap<T> p_259874_) {
        return BuiltInRegistries.m_257895_(p_259121_, new MappedRegistry(p_259121_, p_259977_, false), p_259874_, p_259977_);
    }

    private static <T> DefaultedRegistry<T> m_257600_(ResourceKey<? extends Registry<T>> p_259400_, String p_259678_, Lifecycle p_259157_, RegistryBootstrap<T> p_259806_) {
        return BuiltInRegistries.m_257895_(p_259400_, new DefaultedMappedRegistry(p_259678_, p_259400_, p_259157_, false), p_259806_, p_259157_);
    }

    private static <T> DefaultedRegistry<T> m_257762_(ResourceKey<? extends Registry<T>> p_260010_, String p_260220_, Lifecycle p_260139_, RegistryBootstrap<T> p_260185_) {
        return BuiltInRegistries.m_257895_(p_260010_, new DefaultedMappedRegistry(p_260220_, p_260010_, p_260139_, true), p_260185_, p_260139_);
    }

    private static <T, R extends WritableRegistry<T>> R m_257895_(ResourceKey<? extends Registry<T>> p_259230_, R p_260327_, RegistryBootstrap<T> p_259210_, Lifecycle p_259258_) {
        ResourceLocation $$4 = p_259230_.m_135782_();
        f_256751_.put($$4, () -> p_259210_.m_257957_(p_260327_));
        f_256935_.m_255290_(p_259230_, p_260327_, p_259258_);
        return p_260327_;
    }

    public static void m_257498_() {
        BuiltInRegistries.m_257453_();
        BuiltInRegistries.m_257604_();
        BuiltInRegistries.m_257864_(f_257047_);
    }

    private static void m_257453_() {
        f_256751_.forEach((p_259863_, p_259387_) -> {
            if (p_259387_.get() == null) {
                f_256744_.error("Unable to bootstrap registry '{}'", p_259863_);
            }
        });
    }

    private static void m_257604_() {
        f_257047_.m_203521_();
        for (Registry registry : f_257047_) {
            registry.m_203521_();
        }
    }

    private static <T extends Registry<?>> void m_257864_(Registry<T> p_260209_) {
        p_260209_.forEach(p_259410_ -> {
            if (p_259410_.m_6566_().isEmpty()) {
                Util.m_143785_("Registry '" + p_260209_.m_7981_(p_259410_) + "' was empty after loading");
            }
            if (p_259410_ instanceof DefaultedRegistry) {
                ResourceLocation $$2 = ((DefaultedRegistry)p_259410_).m_122315_();
                Validate.notNull(p_259410_.m_7745_($$2), (String)("Missing default of DefaultedMappedRegistry: " + $$2), (Object[])new Object[0]);
            }
        });
    }

    @FunctionalInterface
    static interface RegistryBootstrap<T> {
        public T m_257957_(Registry<T> var1);
    }
}

